/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.internal.zzart;
import com.google.android.gms.internal.zzwb;
import com.google.android.gms.internal.zzwc;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.measurement.internal.AppMetadata;
import com.google.android.gms.measurement.internal.EventParams;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzr;
import com.google.android.gms.measurement.internal.zzs;
import com.google.android.gms.measurement.internal.zzt;
import com.google.android.gms.measurement.internal.zzu;
import com.google.android.gms.measurement.internal.zzv;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzz;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class zzx {
    private static volatile zzx atW;
    private final Context mContext;
    private final zzd atX;
    private final zzt atY;
    private final zzq atZ;
    private final zzw aua;
    private final zzag aub;
    private final zzv auc;
    private final AppMeasurement aud;
    private final FirebaseAnalytics aue;
    private final zzal auf;
    private final zze aug;
    private final zzo auh;
    private final zzr aui;
    private final com.google.android.gms.common.util.zze zzaql;
    private final zzad auj;
    private final zzae auk;
    private final zzg aul;
    private final zzac aum;
    private final zzn aun;
    private final zzs auo;
    private final zzai aup;
    private final zzc auq;
    private final boolean cR;
    private boolean aur;
    private Boolean aus;
    private long aut;
    private FileLock auu;
    private FileChannel auv;
    private List<Long> auw;
    private int aux;
    private int auy;
    private long auz;

    zzx(zzab zzab2) {
        Object object;
        com.google.android.gms.common.internal.zzaa.zzy((Object)zzab2);
        this.mContext = zzab2.mContext;
        this.auz = -1L;
        this.zzaql = zzab2.zzn(this);
        this.atX = zzab2.zza(this);
        zzt zzt2 = zzab2.zzb(this);
        zzt2.initialize();
        this.atY = zzt2;
        zzq zzq2 = zzab2.zzc(this);
        zzq2.initialize();
        this.atZ = zzq2;
        this.zzbwb().zzbxc().zzj("App measurement is starting up, version", this.zzbwd().zzbto());
        this.zzbwb().zzbxc().log("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        this.zzbwb().zzbxd().log("Debug-level message logging enabled");
        this.zzbwb().zzbxd().zzj("AppMeasurement singleton hash", System.identityHashCode(this));
        this.auf = zzab2.zzj(this);
        zzg zzg2 = zzab2.zzq(this);
        zzg2.initialize();
        this.aul = zzg2;
        zzn zzn2 = zzab2.zzr(this);
        zzn2.initialize();
        this.aun = zzn2;
        if (!this.zzbwd().zzayi()) {
            object = zzn2.zzup();
            if (this.zzbvx().zznf((String)object)) {
                this.zzbwb().zzbxc().log("Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop firebase.analytics.debug-mode .none.");
            } else {
                String string = String.valueOf(object);
                this.zzbwb().zzbxc().log(string.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop firebase.analytics.debug-mode ".concat(string) : new String("To enable faster debug mode event logging run:\n  adb shell setprop firebase.analytics.debug-mode "));
            }
        }
        object = zzab2.zzk(this);
        ((zzaa)object).initialize();
        this.aug = object;
        zzo zzo2 = zzab2.zzl(this);
        zzo2.initialize();
        this.auh = zzo2;
        zzc zzc2 = zzab2.zzu(this);
        zzc2.initialize();
        this.auq = zzc2;
        zzr zzr2 = zzab2.zzm(this);
        zzr2.initialize();
        this.aui = zzr2;
        zzad zzad2 = zzab2.zzo(this);
        zzad2.initialize();
        this.auj = zzad2;
        zzae zzae2 = zzab2.zzp(this);
        zzae2.initialize();
        this.auk = zzae2;
        zzac zzac2 = zzab2.zzi(this);
        zzac2.initialize();
        this.aum = zzac2;
        zzai zzai2 = zzab2.zzt(this);
        zzai2.initialize();
        this.aup = zzai2;
        this.auo = zzab2.zzs(this);
        this.aud = zzab2.zzh(this);
        this.aue = zzab2.zzg(this);
        zzag zzag2 = zzab2.zze(this);
        zzag2.initialize();
        this.aub = zzag2;
        zzv zzv2 = zzab2.zzf(this);
        zzv2.initialize();
        this.auc = zzv2;
        zzw zzw2 = zzab2.zzd(this);
        zzw2.initialize();
        this.aua = zzw2;
        if (this.aux != this.auy) {
            this.zzbwb().zzbwy().zze("Not all components initialized", this.aux, this.auy);
        }
        this.cR = true;
        if (!this.atX.zzayi()) {
            if (!false) {
                if (this.mContext.getApplicationContext() instanceof Application) {
                    if (Build.VERSION.SDK_INT >= 14) {
                        this.zzbvq().zzbyp();
                    } else {
                        this.zzbwb().zzbxd().log("Not tracking deep linking pre-ICS");
                    }
                } else {
                    this.zzbwb().zzbxa().log("Application context is not an Application");
                }
            }
        }
        this.aua.zzm(new Runnable(){

            @Override
            public void run() {
                zzx.this.start();
            }
        });
    }

    void zzacj() {
        if (!this.cR) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    @WorkerThread
    protected boolean zzbxq() {
        this.zzacj();
        this.zzzx();
        if (this.aus == null || this.aut == 0L || this.aus != null && !this.aus.booleanValue() && Math.abs(this.zzabz().elapsedRealtime() - this.aut) > 1000L) {
            this.aut = this.zzabz().elapsedRealtime();
            this.zzbwd().zzayi();
            this.aus = this.zzbvx().zzez("android.permission.INTERNET") && this.zzbvx().zzez("android.permission.ACCESS_NETWORK_STATE") && zzu.zzh(this.getContext(), false) && zzaf.zzi(this.getContext(), false);
            if (this.aus.booleanValue()) {
                this.aus = this.zzbvx().zznb(this.zzbvr().zzbth());
            }
        }
        return this.aus;
    }

    @WorkerThread
    protected void start() {
        this.zzzx();
        this.zzbvw().zzbwg();
        if (this.zzbwc().asZ.get() == 0L) {
            this.zzbwc().asZ.set(this.zzabz().currentTimeMillis());
        }
        if (!this.zzbxq()) {
            if (this.isEnabled()) {
                if (!this.zzbvx().zzez("android.permission.INTERNET")) {
                    this.zzbwb().zzbwy().log("App is missing INTERNET permission");
                }
                if (!this.zzbvx().zzez("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzbwb().zzbwy().log("App is missing ACCESS_NETWORK_STATE permission");
                }
                if (!this.zzbwd().zzayi()) {
                    if (!zzu.zzh(this.getContext(), false)) {
                        this.zzbwb().zzbwy().log("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzaf.zzi(this.getContext(), false)) {
                        this.zzbwb().zzbwy().log("AppMeasurementService not registered/enabled");
                    }
                }
                if (!false) {
                    this.zzbwb().zzbwy().log("Uploading is not possible. App measurement disabled");
                }
            }
        } else {
            if (!this.zzbwd().zzayi() && !TextUtils.isEmpty((CharSequence)this.zzbvr().zzbth())) {
                String string = this.zzbwc().zzbxk();
                if (string == null) {
                    this.zzbwc().zzmm(this.zzbvr().zzbth());
                } else if (!string.equals(this.zzbvr().zzbth())) {
                    this.zzbwb().zzbxc().log("Rechecking which service to use due to a GMP App Id change");
                    this.zzbwc().zzbxm();
                    this.auk.disconnect();
                    this.auk.zzadl();
                    this.zzbwc().zzmm(this.zzbvr().zzbth());
                }
            }
            if (!this.zzbwd().zzayi()) {
                if (!false && !TextUtils.isEmpty((CharSequence)this.zzbvr().zzbth())) {
                    this.zzbvq().zzbyq();
                }
            }
        }
        this.zzbyg();
    }

    public zzd zzbwd() {
        return this.atX;
    }

    public zzt zzbwc() {
        this.zza((zzz)this.atY);
        return this.atY;
    }

    public zzq zzbwb() {
        this.zza(this.atZ);
        return this.atZ;
    }

    public zzq zzbxr() {
        return this.atZ != null && this.atZ.isInitialized() ? this.atZ : null;
    }

    public zzw zzbwa() {
        this.zza(this.aua);
        return this.aua;
    }

    public zzag zzbvz() {
        this.zza(this.aub);
        return this.aub;
    }

    public zzv zzbvy() {
        this.zza(this.auc);
        return this.auc;
    }

    zzw zzbxs() {
        return this.aua;
    }

    public zzac zzbvq() {
        this.zza(this.aum);
        return this.aum;
    }

    public AppMeasurement zzbxt() {
        return this.aud;
    }

    public FirebaseAnalytics zzbxu() {
        return this.aue;
    }

    public zzal zzbvx() {
        this.zza(this.auf);
        return this.auf;
    }

    public zze zzbvw() {
        this.zza(this.aug);
        return this.aug;
    }

    public zzo zzbvv() {
        this.zza(this.auh);
        return this.auh;
    }

    public zzr zzbxv() {
        this.zza(this.aui);
        return this.aui;
    }

    public Context getContext() {
        return this.mContext;
    }

    public com.google.android.gms.common.util.zze zzabz() {
        return this.zzaql;
    }

    public zzad zzbvu() {
        this.zza(this.auj);
        return this.auj;
    }

    public zzae zzbvt() {
        this.zza(this.auk);
        return this.auk;
    }

    public zzg zzbvs() {
        this.zza(this.aul);
        return this.aul;
    }

    public zzn zzbvr() {
        this.zza(this.aun);
        return this.aun;
    }

    public zzs zzbxw() {
        if (this.auo == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.auo;
    }

    public zzai zzbxx() {
        this.zza(this.aup);
        return this.aup;
    }

    public zzc zzbvp() {
        this.zza(this.auq);
        return this.auq;
    }

    @WorkerThread
    public void zzzx() {
        this.zzbwa().zzzx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzx zzdq(Context context) {
        com.google.android.gms.common.internal.zzaa.zzy((Object)context);
        com.google.android.gms.common.internal.zzaa.zzy((Object)context.getApplicationContext());
        if (atW != null) return atW;
        Class<zzx> clazz = zzx.class;
        synchronized (zzx.class) {
            if (atW != null) return atW;
            zzab zzab2 = null;
            boolean bl = false;
            zzab2 = new zzab(context);
            atW = zzab2.zzbyo();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return atW;
        }
    }

    FileChannel zzbxy() {
        return this.auv;
    }

    private void zza(zzaa zzaa2) {
        if (zzaa2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzaa2.isInitialized()) {
            throw new IllegalStateException("Component not initialized");
        }
    }

    private void zza(zzz zzz2) {
        if (zzz2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    void zzbxz() {
        this.zzzx();
        this.zzacj();
        if (this.zzbyk() && this.zzbya()) {
            int n = this.zza(this.zzbxy());
            int n2 = this.zzbvr().zzbwx();
            this.zzv(n, n2);
        }
    }

    @WorkerThread
    boolean zzbya() {
        this.zzzx();
        String string = this.aug.zzade();
        File file = this.getContext().getFilesDir();
        File file2 = new File(file, string);
        try {
            this.auv = new RandomAccessFile(file2, "rw").getChannel();
            this.auu = this.auv.tryLock();
            if (this.auu != null) {
                this.zzbwb().zzbxe().log("Storage concurrent access okay");
                return true;
            }
            this.zzbwb().zzbwy().log("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzbwb().zzbwy().zzj("Failed to acquire storage lock", fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzbwb().zzbwy().zzj("Failed to access storage lock file", iOException);
        }
        return false;
    }

    @WorkerThread
    boolean zzv(int n, int n2) {
        this.zzzx();
        if (n > n2) {
            this.zzbwb().zzbwy().zze("Panic: can't downgrade version. Previous, current version", n, n2);
            return false;
        }
        if (n < n2) {
            if (this.zza(n2, this.zzbxy())) {
                this.zzbwb().zzbxe().zze("Storage version upgraded. Previous, current version", n, n2);
            } else {
                this.zzbwb().zzbwy().zze("Storage version upgrade failed. Previous, current version", n, n2);
                return false;
            }
        }
        return true;
    }

    @WorkerThread
    int zza(FileChannel fileChannel) {
        this.zzzx();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzbwb().zzbwy().log("Bad chanel to read from");
            return 0;
        }
        int n = 0;
        int n2 = 4;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n3 = fileChannel.read(byteBuffer);
            if (n3 != 4) {
                if (n3 != -1) {
                    this.zzbwb().zzbxa().zzj("Unexpected data length. Bytes read", n3);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzbwb().zzbwy().zzj("Failed to read from channel", iOException);
        }
        return n;
    }

    @WorkerThread
    boolean zza(int n, FileChannel fileChannel) {
        this.zzzx();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzbwb().zzbwy().log("Bad chanel to read from");
            return false;
        }
        int n2 = 4;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzbwb().zzbwy().zzj("Error writing to channel. Bytes written", fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzbwb().zzbwy().zzj("Failed to write to channel", iOException);
            return false;
        }
    }

    @WorkerThread
    public boolean isEnabled() {
        this.zzzx();
        this.zzacj();
        if (this.zzbwd().zzbut()) {
            return false;
        }
        Boolean bl = this.zzbwd().zzbuu();
        boolean bl2 = bl != null ? bl : !this.zzbwd().zzatu();
        return this.zzbwc().zzch(bl2);
    }

    void zzc(AppMetadata appMetadata) {
        this.zzzx();
        this.zzacj();
        com.google.android.gms.common.internal.zzaa.zzib((String)appMetadata.packageName);
        this.zze(appMetadata);
    }

    @WorkerThread
    void zzb(EventParcel eventParcel, String string) {
        Object object;
        com.google.android.gms.measurement.internal.zza zza2;
        block4: {
            zza2 = this.zzbvw().zzlz(string);
            if (zza2 == null || TextUtils.isEmpty((CharSequence)zza2.zzaaf())) {
                this.zzbwb().zzbxd().zzj("No app data available; dropping event", string);
                return;
            }
            try {
                object = this.getContext().getPackageManager().getPackageInfo((String)string, (int)0).versionName;
                if (zza2.zzaaf() != null && !zza2.zzaaf().equals(object)) {
                    this.zzbwb().zzbxa().zzj("App version does not match; dropping event", string);
                    return;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                if ("_ui".equals(eventParcel.name)) break block4;
                this.zzbwb().zzbxa().zzj("Could not find package", string);
            }
        }
        object = new AppMetadata(string, zza2.zzbth(), zza2.zzaaf(), zza2.zzbtm(), zza2.zzbtn(), zza2.zzbto(), zza2.zzbtp(), null, zza2.zzbtq(), false, zza2.zzbtj());
        this.zzb(eventParcel, (AppMetadata)((Object)object));
    }

    long zzbyb() {
        long l = this.zzabz().currentTimeMillis() + this.zzbwc().zzbxi();
        return l / 1000L / 60L / 60L / 24L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(EventParcel eventParcel, AppMetadata appMetadata) {
        long l = System.nanoTime();
        this.zzzx();
        this.zzacj();
        String string = appMetadata.packageName;
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        if (!zzal.zzc(eventParcel, appMetadata)) {
            return;
        }
        if (!appMetadata.are && !"_in".equals(eventParcel.name)) {
            this.zze(appMetadata);
            return;
        }
        if (this.zzbvy().zzax(string, eventParcel.name)) {
            com.google.android.gms.measurement.internal.zza zza2;
            boolean bl;
            this.zzbwb().zzbxa().zzj("Dropping blacklisted event", eventParcel.name);
            boolean bl2 = bl = this.zzbvx().zznh(string) || this.zzbvx().zzni(string);
            if (!bl && !"_err".equals(eventParcel.name)) {
                this.zzbvx().zza(11, "_ev", eventParcel.name, 0);
            }
            if (bl && (zza2 = this.zzbvw().zzlz(string)) != null) {
                long l2 = Math.max(zza2.zzbtt(), zza2.zzbts());
                long l3 = this.zzabz().currentTimeMillis();
                if (Math.abs(l3 - l2) > this.zzbwd().zzbux()) {
                    this.zzbwb().zzbxd().log("Fetching config for blacklisted app");
                    this.zzb(zza2);
                }
            }
            return;
        }
        if (this.zzbwb().zzbi(2)) {
            this.zzbwb().zzbxe().zzj("Logging event", (Object)eventParcel);
        }
        this.zzbvw().beginTransaction();
        try {
            zzi zzi2;
            long l4;
            Bundle bundle = eventParcel.arJ.zzbww();
            this.zze(appMetadata);
            if ("_iap".equals(eventParcel.name) || "ecommerce_purchase".equals(eventParcel.name)) {
                String string2 = bundle.getString("currency");
                long l5 = 0L;
                if ("ecommerce_purchase".equals(eventParcel.name)) {
                    double d = bundle.getDouble("value") * 1000000.0;
                    if (d == 0.0) {
                        d = (double)bundle.getLong("value") * 1000000.0;
                    }
                    if (!(d <= 9.223372036854776E18) || !(d >= -9.223372036854776E18)) {
                        this.zzbwb().zzbxa().zzj("Data lost. Currency value is too big", d);
                        this.zzbvw().setTransactionSuccessful();
                        return;
                    }
                    l5 = Math.round(d);
                } else {
                    l5 = bundle.getLong("value");
                }
                if (!TextUtils.isEmpty((CharSequence)string2) && (string2 = string2.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                    String string3 = String.valueOf("_ltv_");
                    String string4 = String.valueOf(string2);
                    String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
                    zzak zzak2 = this.zzbvw().zzar(string, string5);
                    if (zzak2 == null || !(zzak2.zzcyd instanceof Long)) {
                        this.zzbvw().zzz(string, this.zzbwd().zzls(string) - 1);
                        zzak2 = new zzak(string, string5, this.zzabz().currentTimeMillis(), l5);
                    } else {
                        l4 = (Long)zzak2.zzcyd;
                        zzak2 = new zzak(string, string5, this.zzabz().currentTimeMillis(), l4 + l5);
                    }
                    if (!this.zzbvw().zza(zzak2)) {
                        this.zzbwb().zzbwy().zze("Too many unique user properties are set. Ignoring user property.", zzak2.mName, zzak2.zzcyd);
                        this.zzbvx().zza(9, null, null, 0);
                    }
                }
            }
            boolean bl = zzal.zzmu(eventParcel.name);
            boolean bl3 = "_err".equals(eventParcel.name);
            zze.zza zza3 = this.zzbvw().zza(this.zzbyb(), string, true, bl, false, bl3, false);
            long l6 = zza3.arq - this.zzbwd().zzbul();
            if (l6 > 0L) {
                if (l6 % 1000L == 1L) {
                    this.zzbwb().zzbwy().zzj("Data loss. Too many events logged. count", zza3.arq);
                }
                this.zzbvx().zza(16, "_ev", eventParcel.name, 0);
                this.zzbvw().setTransactionSuccessful();
                return;
            }
            if (bl && (l6 = zza3.arp - this.zzbwd().zzbum()) > 0L) {
                if (l6 % 1000L == 1L) {
                    this.zzbwb().zzbwy().zzj("Data loss. Too many public events logged. count", zza3.arp);
                }
                this.zzbvx().zza(16, "_ev", eventParcel.name, 0);
                this.zzbvw().setTransactionSuccessful();
                return;
            }
            if (bl3 && (l6 = zza3.ars - (long)this.zzbwd().zzlo(appMetadata.packageName)) > 0L) {
                if (l6 == 1L) {
                    this.zzbwb().zzbwy().zzj("Too many error events logged. count", zza3.ars);
                }
                this.zzbvw().setTransactionSuccessful();
                return;
            }
            this.zzbvx().zza(bundle, "_o", eventParcel.arK);
            if (this.zzbvx().zznf(string)) {
                this.zzbvx().zza(bundle, "_dbg", 1L);
                this.zzbvx().zza(bundle, "_r", 1L);
            }
            if ((l4 = this.zzbvw().zzma(string)) > 0L) {
                this.zzbwb().zzbxa().zzj("Data lost. Too many events stored on disk, deleted", l4);
            }
            zzh zzh2 = new zzh(this, eventParcel.arK, string, eventParcel.name, eventParcel.arL, 0L, bundle);
            zzi zzi3 = this.zzbvw().zzap(string, zzh2.mName);
            if (zzi3 == null) {
                long l7 = this.zzbvw().zzmh(string);
                this.zzbwd().zzbuk();
                if (l7 >= 500L) {
                    this.zzbwb().zzbwy().zze("Too many event names used, ignoring event. name, supported count", zzh2.mName, this.zzbwd().zzbuk());
                    this.zzbvx().zza(8, null, null, 0);
                    return;
                }
                zzi2 = new zzi(string, zzh2.mName, 0L, 0L, zzh2.vO);
            } else {
                zzh2 = zzh2.zza(this, zzi3.arF);
                zzi2 = zzi3.zzbl(zzh2.vO);
            }
            this.zzbvw().zza(zzi2);
            this.zza(zzh2, appMetadata);
            this.zzbvw().setTransactionSuccessful();
            if (this.zzbwb().zzbi(2)) {
                this.zzbwb().zzbxe().zzj("Event recorded", zzh2);
            }
        }
        finally {
            this.zzbvw().endTransaction();
        }
        this.zzbyg();
        this.zzbwb().zzbxe().zzj("Background event processing time, ms", (System.nanoTime() - l + 500000L) / 1000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public byte[] zza(@NonNull EventParcel eventParcel, @Size(min=1L) String string) {
        Object object;
        zzart zzart2;
        Object object2;
        this.zzacj();
        this.zzzx();
        this.zzbyc();
        com.google.android.gms.common.internal.zzaa.zzy((Object)((Object)eventParcel));
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        zzwc.zzd zzd2 = new zzwc.zzd();
        this.zzbvw().beginTransaction();
        try {
            zzi zzi2;
            long l;
            Object object3;
            com.google.android.gms.measurement.internal.zza zza2 = this.zzbvw().zzlz(string);
            if (zza2 == null) {
                this.zzbwb().zzbxd().zzj("Log and bundle not available. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zza2.zzbtq()) {
                this.zzbwb().zzbxd().zzj("Log and bundle disabled. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            object2 = new zzwc.zze();
            zzd2.awS = new zzwc.zze[]{object2};
            object2.awU = 1;
            object2.axc = "android";
            object2.zzcs = zza2.zzup();
            object2.ara = zza2.zzbtn();
            object2.aii = zza2.zzaaf();
            object2.axp = (int)zza2.zzbtm();
            object2.axg = zza2.zzbto();
            object2.aqZ = zza2.zzbth();
            object2.axl = zza2.zzbtp();
            zzart2 = this.zzbwc().zzmk(zza2.zzup());
            if (zzart2 != null && !TextUtils.isEmpty((CharSequence)((CharSequence)zzart2.first))) {
                object2.axi = (String)zzart2.first;
                object2.axj = (Boolean)zzart2.second;
            }
            object2.axd = this.zzbvs().zzvt();
            object2.zzdb = this.zzbvs().zzbws();
            object2.axf = (int)this.zzbvs().zzbwt();
            object2.axe = this.zzbvs().zzbwu();
            object2.axk = zza2.zzazn();
            object2.arh = zza2.zzbtj();
            object = this.zzbvw().zzly(zza2.zzup());
            object2.awW = new zzwc.zzg[object.size()];
            for (int i = 0; i < object.size(); ++i) {
                object3 = new zzwc.zzg();
                object2.awW[i] = object3;
                ((zzwc.zzg)((Object)object3)).name = object.get((int)i).mName;
                ((zzwc.zzg)((Object)object3)).axx = object.get((int)i).avX;
                this.zzbvx().zza((zzwc.zzg)((Object)object3), object.get((int)i).zzcyd);
            }
            Bundle bundle = eventParcel.arJ.zzbww();
            if ("_iap".equals(eventParcel.name)) {
                bundle.putLong("_c", 1L);
                this.zzbwb().zzbxd().log("Marking in-app purchase as real-time");
                bundle.putLong("_r", 1L);
            }
            bundle.putString("_o", eventParcel.arK);
            if (this.zzbvx().zznf(object2.zzcs)) {
                this.zzbvx().zza(bundle, "_dbg", 1L);
                this.zzbvx().zza(bundle, "_r", 1L);
            }
            if ((object3 = this.zzbvw().zzap(string, eventParcel.name)) == null) {
                l = 0L;
                zzi2 = new zzi(string, eventParcel.name, 1L, 0L, eventParcel.arL);
                this.zzbvw().zza(zzi2);
            } else {
                l = ((zzi)object3).arF;
                zzi2 = ((zzi)object3).zzbl(eventParcel.arL);
                zzi2 = zzi2.zzbwv();
                this.zzbvw().zza(zzi2);
            }
            zzh zzh2 = new zzh(this, eventParcel.arK, string, eventParcel.name, eventParcel.arL, l, bundle);
            zzwc.zzb zzb2 = new zzwc.zzb();
            object2.awV = new zzwc.zzb[]{zzb2};
            zzb2.awO = zzh2.vO;
            zzb2.name = zzh2.mName;
            zzb2.awP = zzh2.arB;
            zzb2.awN = new zzwc.zzc[zzh2.arC.size()];
            int n = 0;
            for (String string2 : zzh2.arC) {
                zzwc.zzc zzc2 = new zzwc.zzc();
                zzb2.awN[n++] = zzc2;
                zzc2.name = string2;
                Object object4 = zzh2.arC.get(string2);
                this.zzbvx().zza(zzc2, object4);
            }
            object2.axo = this.zza(zza2.zzup(), object2.awW, object2.awV);
            object2.awY = zzb2.awO;
            object2.awZ = zzb2.awO;
            long l2 = zza2.zzbtl();
            object2.axb = l2 != 0L ? Long.valueOf(l2) : null;
            long l3 = zza2.zzbtk();
            if (l3 == 0L) {
                l3 = l2;
            }
            object2.axa = l3 != 0L ? Long.valueOf(l3) : null;
            zza2.zzbtu();
            object2.axm = (int)zza2.zzbtr();
            object2.axh = this.zzbwd().zzbto();
            object2.awX = this.zzabz().currentTimeMillis();
            object2.axn = Boolean.TRUE;
            zza2.zzav(object2.awY);
            zza2.zzaw(object2.awZ);
            this.zzbvw().zza(zza2);
            this.zzbvw().setTransactionSuccessful();
        }
        finally {
            this.zzbvw().endTransaction();
        }
        try {
            int n = zzd2.cz();
            object2 = new byte[n];
            zzart2 = zzart.zzbe((byte[])object2);
            zzd2.zza(zzart2);
            zzart2.cm();
            object = this.zzbvx().zzk((byte[])object2);
            return object;
        }
        catch (IOException iOException) {
            this.zzbwb().zzbwy().zzj("Data loss. Failed to bundle and serialize", iOException);
            return null;
        }
    }

    void zza(zzh zzh2, AppMetadata appMetadata) {
        Object object;
        this.zzzx();
        this.zzacj();
        com.google.android.gms.common.internal.zzaa.zzy((Object)zzh2);
        com.google.android.gms.common.internal.zzaa.zzy((Object)((Object)appMetadata));
        com.google.android.gms.common.internal.zzaa.zzib((String)zzh2.zzctj);
        com.google.android.gms.common.internal.zzaa.zzbt((boolean)zzh2.zzctj.equals(appMetadata.packageName));
        zzwc.zze zze2 = new zzwc.zze();
        zze2.awU = 1;
        zze2.axc = "android";
        zze2.zzcs = appMetadata.packageName;
        zze2.ara = appMetadata.ara;
        zze2.aii = appMetadata.aii;
        zze2.axp = (int)appMetadata.arg;
        zze2.axg = appMetadata.arb;
        zze2.aqZ = appMetadata.aqZ;
        zze2.axl = appMetadata.arc == 0L ? null : Long.valueOf(appMetadata.arc);
        Pair<String, Boolean> pair = this.zzbwc().zzmk(appMetadata.packageName);
        if (pair != null && !TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            zze2.axi = (String)pair.first;
            zze2.axj = (Boolean)pair.second;
        } else if (!this.zzbvs().zzdp(this.mContext)) {
            object = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
            if (object == null) {
                this.zzbwb().zzbxa().log("null secure ID");
                object = "null";
            } else if (((String)object).isEmpty()) {
                this.zzbwb().zzbxa().log("empty secure ID");
            }
            zze2.axs = object;
        }
        zze2.axd = this.zzbvs().zzvt();
        zze2.zzdb = this.zzbvs().zzbws();
        zze2.axf = (int)this.zzbvs().zzbwt();
        zze2.axe = this.zzbvs().zzbwu();
        zze2.axh = null;
        zze2.awX = null;
        zze2.awY = null;
        zze2.awZ = null;
        object = this.zzbvw().zzlz(appMetadata.packageName);
        if (object == null) {
            object = new com.google.android.gms.measurement.internal.zza(this, appMetadata.packageName);
            ((com.google.android.gms.measurement.internal.zza)object).zzlj(this.zzbwc().zzbxh());
            ((com.google.android.gms.measurement.internal.zza)object).zzlm(appMetadata.arh);
            ((com.google.android.gms.measurement.internal.zza)object).zzlk(appMetadata.aqZ);
            ((com.google.android.gms.measurement.internal.zza)object).zzll(this.zzbwc().zzml(appMetadata.packageName));
            ((com.google.android.gms.measurement.internal.zza)object).zzba(0L);
            ((com.google.android.gms.measurement.internal.zza)object).zzav(0L);
            ((com.google.android.gms.measurement.internal.zza)object).zzaw(0L);
            ((com.google.android.gms.measurement.internal.zza)object).setAppVersion(appMetadata.aii);
            ((com.google.android.gms.measurement.internal.zza)object).zzax(appMetadata.arg);
            ((com.google.android.gms.measurement.internal.zza)object).zzln(appMetadata.ara);
            ((com.google.android.gms.measurement.internal.zza)object).zzay(appMetadata.arb);
            ((com.google.android.gms.measurement.internal.zza)object).zzaz(appMetadata.arc);
            ((com.google.android.gms.measurement.internal.zza)object).setMeasurementEnabled(appMetadata.are);
            this.zzbvw().zza((com.google.android.gms.measurement.internal.zza)object);
        }
        zze2.axk = ((com.google.android.gms.measurement.internal.zza)object).zzazn();
        zze2.arh = ((com.google.android.gms.measurement.internal.zza)object).zzbtj();
        List<zzak> list = this.zzbvw().zzly(appMetadata.packageName);
        zze2.awW = new zzwc.zzg[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            zzwc.zzg zzg2;
            zze2.awW[i] = zzg2 = new zzwc.zzg();
            zzg2.name = list.get((int)i).mName;
            zzg2.axx = list.get((int)i).avX;
            this.zzbvx().zza(zzg2, list.get((int)i).zzcyd);
        }
        long l = 0L;
        try {
            l = this.zzbvw().zza(zze2);
        }
        catch (IOException iOException) {
            this.zzbwb().zzbwy().zzj("Data loss. Failed to insert raw event metadata", iOException);
            return;
        }
        this.zzbvw().zza(zzh2, l, this.zza(zzh2));
    }

    private boolean zza(zzh zzh2) {
        Object object2;
        if (zzh2.arC == null) {
            return false;
        }
        for (Object object2 : zzh2.arC) {
            if (!"_r".equals(object2)) continue;
            return true;
        }
        boolean bl = this.zzbvy().zzay(zzh2.zzctj, zzh2.mName);
        object2 = this.zzbvw().zza(this.zzbyb(), zzh2.zzctj, false, false, false, false, false);
        return bl && ((zze.zza)object2).art < (long)this.zzbwd().zzlq(zzh2.zzctj);
    }

    void zzaby() {
        this.zzbwd().zzayi();
    }

    void zzbyc() {
        if (!this.zzbwd().zzayi()) {
            throw new IllegalStateException("Unexpected call on client side");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(UserAttributeParcel userAttributeParcel, AppMetadata appMetadata) {
        this.zzzx();
        this.zzacj();
        if (TextUtils.isEmpty((CharSequence)appMetadata.aqZ)) {
            return;
        }
        if (!appMetadata.are) {
            this.zze(appMetadata);
            return;
        }
        int n = this.zzbvx().zzmy(userAttributeParcel.name);
        if (n != 0) {
            String string = this.zzbvx().zza(userAttributeParcel.name, this.zzbwd().zzbue(), true);
            int n2 = userAttributeParcel.name != null ? userAttributeParcel.name.length() : 0;
            this.zzbvx().zza(n, "_ev", string, n2);
            return;
        }
        n = this.zzbvx().zzm(userAttributeParcel.name, userAttributeParcel.getValue());
        if (n != 0) {
            String string = this.zzbvx().zza(userAttributeParcel.name, this.zzbwd().zzbue(), true);
            Object object = userAttributeParcel.getValue();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                String string2 = String.valueOf(object);
                n3 = string2.length();
            }
            this.zzbvx().zza(n, "_ev", string, n3);
            return;
        }
        Object object = this.zzbvx().zzn(userAttributeParcel.name, userAttributeParcel.getValue());
        if (object == null) {
            return;
        }
        zzak zzak2 = new zzak(appMetadata.packageName, userAttributeParcel.name, userAttributeParcel.avT, object);
        this.zzbwb().zzbxd().zze("Setting user property", zzak2.mName, object);
        this.zzbvw().beginTransaction();
        try {
            this.zze(appMetadata);
            boolean bl = this.zzbvw().zza(zzak2);
            this.zzbvw().setTransactionSuccessful();
            if (bl) {
                this.zzbwb().zzbxd().zze("User property set", zzak2.mName, zzak2.zzcyd);
            } else {
                this.zzbwb().zzbwy().zze("Too many unique user properties are set. Ignoring user property.", zzak2.mName, zzak2.zzcyd);
                this.zzbvx().zza(9, null, null, 0);
            }
        }
        finally {
            this.zzbvw().endTransaction();
        }
    }

    @WorkerThread
    void zzc(UserAttributeParcel userAttributeParcel, AppMetadata appMetadata) {
        this.zzzx();
        this.zzacj();
        if (TextUtils.isEmpty((CharSequence)appMetadata.aqZ)) {
            return;
        }
        if (!appMetadata.are) {
            this.zze(appMetadata);
            return;
        }
        this.zzbwb().zzbxd().zzj("Removing user property", userAttributeParcel.name);
        this.zzbvw().beginTransaction();
        try {
            this.zze(appMetadata);
            this.zzbvw().zzaq(appMetadata.packageName, userAttributeParcel.name);
            this.zzbvw().setTransactionSuccessful();
            this.zzbwb().zzbxd().zzj("User property removed", userAttributeParcel.name);
        }
        finally {
            this.zzbvw().endTransaction();
        }
    }

    @WorkerThread
    protected boolean zzbyd() {
        this.zzzx();
        return this.auw != null;
    }

    protected void zzag(List<Long> list) {
        com.google.android.gms.common.internal.zzaa.zzbt((!list.isEmpty() ? 1 : 0) != 0);
        if (this.auw != null) {
            this.zzbwb().zzbwy().log("Set uploading progress before finishing the previous upload");
        } else {
            this.auw = new ArrayList<Long>(list);
        }
    }

    @WorkerThread
    public void zzbye() {
        String string;
        this.zzzx();
        this.zzacj();
        if (!this.zzbwd().zzayi()) {
            Boolean bl = this.zzbwc().zzbxl();
            if (bl == null) {
                this.zzbwb().zzbxa().log("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzbwb().zzbwy().log("Upload called in the client side when service should be used");
                return;
            }
        }
        if (this.zzbyd()) {
            this.zzbwb().zzbxa().log("Uploading requested multiple times");
            return;
        }
        if (!this.zzbxv().zzagk()) {
            this.zzbwb().zzbxa().log("Network not connected, ignoring upload request");
            this.zzbyg();
            return;
        }
        long l = this.zzabz().currentTimeMillis();
        this.zzbm(l - this.zzbwd().zzbvd());
        long l2 = this.zzbwc().asZ.get();
        if (l2 != 0L) {
            this.zzbwb().zzbxd().zzj("Uploading events. Elapsed time since last upload attempt (ms)", Math.abs(l - l2));
        }
        if (!TextUtils.isEmpty((CharSequence)(string = this.zzbvw().zzbwe()))) {
            if (this.auz == -1L) {
                this.auz = this.zzbvw().zzbwm();
            }
            int n = this.zzbwd().zzlv(string);
            int n2 = this.zzbwd().zzlw(string);
            List<Pair<zzwc.zze, Long>> list = this.zzbvw().zzn(string, n, n2);
            if (!list.isEmpty()) {
                String string2 = null;
                for (Pair<zzwc.zze, Long> object2 : list) {
                    zzwc.zze zze2 = (zzwc.zze)((Object)object2.first);
                    if (TextUtils.isEmpty((CharSequence)zze2.axi)) continue;
                    string2 = zze2.axi;
                    break;
                }
                if (string2 != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        zzwc.zze zze3 = (zzwc.zze)((Object)list.get((int)i).first);
                        if (TextUtils.isEmpty((CharSequence)zze3.axi) || zze3.axi.equals(string2)) continue;
                        list = list.subList(0, i);
                        break;
                    }
                }
                Object object3 = new zzwc.zzd();
                ((zzwc.zzd)((Object)object3)).awS = new zzwc.zze[list.size()];
                ArrayList<Long> arrayList = new ArrayList<Long>(list.size());
                for (int i = 0; i < ((zzwc.zzd)((Object)object3)).awS.length; ++i) {
                    ((zzwc.zzd)((Object)object3)).awS[i] = (zzwc.zze)((Object)list.get((int)i).first);
                    arrayList.add((Long)list.get((int)i).second);
                    ((zzwc.zzd)((Object)object3)).awS[i].axh = this.zzbwd().zzbto();
                    ((zzwc.zzd)((Object)object3)).awS[i].awX = l;
                    ((zzwc.zzd)((Object)object3)).awS[i].axn = this.zzbwd().zzayi();
                }
                String string3 = null;
                if (this.zzbwb().zzbi(2)) {
                    string3 = zzal.zzb(object3);
                }
                byte[] byArray = this.zzbvx().zza((zzwc.zzd)((Object)object3));
                String string4 = this.zzbwd().zzbvc();
                try {
                    URL uRL = new URL(string4);
                    this.zzag(arrayList);
                    this.zzbwc().ata.set(l);
                    String string5 = "?";
                    if (((zzwc.zzd)((Object)object3)).awS.length > 0) {
                        string5 = ((zzwc.zzd)((Object)object3)).awS[0].zzcs;
                    }
                    this.zzbwb().zzbxe().zzd("Uploading data. app, uncompressed size, data", string5, byArray.length, string3);
                    this.zzbxv().zza(string, uRL, byArray, null, new zzr.zza(){

                        @Override
                        public void zza(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
                            zzx.this.zza(n, throwable, byArray);
                        }
                    });
                }
                catch (MalformedURLException malformedURLException) {
                    this.zzbwb().zzbwy().zzj("Failed to parse upload URL. Not uploading", string4);
                }
            }
        } else {
            com.google.android.gms.measurement.internal.zza zza2;
            this.auz = -1L;
            String string6 = this.zzbvw().zzbk(l - this.zzbwd().zzbvd());
            if (!TextUtils.isEmpty((CharSequence)string6) && (zza2 = this.zzbvw().zzlz(string6)) != null) {
                this.zzb(zza2);
            }
        }
    }

    void zzb(com.google.android.gms.measurement.internal.zza zza2) {
        String string = this.zzbwd().zzao(zza2.zzbth(), zza2.zzazn());
        try {
            URL uRL = new URL(string);
            this.zzbwb().zzbxe().zzj("Fetching remote configuration", zza2.zzup());
            zzwb.zzb zzb2 = this.zzbvy().zzmo(zza2.zzup());
            ArrayMap arrayMap = null;
            String string2 = this.zzbvy().zzmp(zza2.zzup());
            if (zzb2 != null && !TextUtils.isEmpty((CharSequence)string2)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string2);
            }
            this.zzbxv().zza(zza2.zzup(), uRL, (Map<String, String>)arrayMap, new zzr.zza(){

                @Override
                public void zza(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
                    zzx.this.zzb(string, n, throwable, byArray, map);
                }
            });
        }
        catch (MalformedURLException malformedURLException) {
            this.zzbwb().zzbwy().zzj("Failed to parse config URL. Not fetching", string);
        }
    }

    boolean zzbm(long l) {
        return this.zzh(null, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zzh(String string, long l) {
        this.zzbvw().beginTransaction();
        try {
            zza zza2 = new zza();
            this.zzbvw().zza(string, l, this.auz, zza2);
            if (!zza2.isEmpty()) {
                int n;
                boolean bl = false;
                zzwc.zze zze2 = zza2.auB;
                zze2.awV = new zzwc.zzb[zza2.zzani.size()];
                int n2 = 0;
                for (n = 0; n < zza2.zzani.size(); ++n) {
                    boolean bl2;
                    boolean bl3 = bl;
                    if (this.zzbvy().zzax(zza2.auB.zzcs, zza2.zzani.get((int)n).name)) {
                        this.zzbwb().zzbxa().zzj("Dropping blacklisted raw event", zza2.zzani.get((int)n).name);
                        boolean bl4 = bl2 = this.zzbvx().zznh(zza2.auB.zzcs) || this.zzbvx().zzni(zza2.auB.zzcs);
                        if (bl2 || "_err".equals(zza2.zzani.get((int)n).name)) continue;
                        this.zzbvx().zza(11, "_ev", zza2.zzani.get((int)n).name, 0);
                        continue;
                    }
                    if (this.zzbvy().zzay(zza2.auB.zzcs, zza2.zzani.get((int)n).name)) {
                        Object object;
                        zzwc.zzc[] zzcArray;
                        bl2 = false;
                        boolean bl5 = false;
                        if (zza2.zzani.get((int)n).awN == null) {
                            zza2.zzani.get((int)n).awN = new zzwc.zzc[0];
                        }
                        for (zzwc.zzc zzc2 : zza2.zzani.get((int)n).awN) {
                            if ("_c".equals(zzc2.name)) {
                                zzc2.awR = 1L;
                                bl2 = true;
                                continue;
                            }
                            if (!"_r".equals(zzc2.name)) continue;
                            zzc2.awR = 1L;
                            bl5 = true;
                        }
                        if (!bl2) {
                            this.zzbwb().zzbxe().zzj("Marking event as conversion", zza2.zzani.get((int)n).name);
                            zzcArray = Arrays.copyOf(zza2.zzani.get((int)n).awN, zza2.zzani.get((int)n).awN.length + 1);
                            zzwc.zzc zzc3 = new zzwc.zzc();
                            zzc3.name = "_c";
                            zzc3.awR = 1L;
                            zzcArray[zzcArray.length - 1] = zzc3;
                            zza2.zzani.get((int)n).awN = zzcArray;
                        }
                        if (!bl5) {
                            this.zzbwb().zzbxe().zzj("Marking event as real-time", zza2.zzani.get((int)n).name);
                            zzcArray = Arrays.copyOf(zza2.zzani.get((int)n).awN, zza2.zzani.get((int)n).awN.length + 1);
                            zzwc.zzc zzc4 = new zzwc.zzc();
                            zzc4.name = "_r";
                            zzc4.awR = 1L;
                            zzcArray[zzcArray.length - 1] = zzc4;
                            zza2.zzani.get((int)n).awN = zzcArray;
                        }
                        bl = true;
                        boolean bl6 = zzal.zzmu(zza2.zzani.get((int)n).name);
                        zze.zza zza3 = this.zzbvw().zza(this.zzbyb(), zza2.auB.zzcs, false, false, false, false, true);
                        if (zza3.art > (long)this.zzbwd().zzlq(zza2.auB.zzcs)) {
                            zzwc.zzb zzb2 = zza2.zzani.get(n);
                            for (int i = 0; i < zzb2.awN.length; ++i) {
                                if (!"_r".equals(zzb2.awN[i].name)) continue;
                                object = new zzwc.zzc[zzb2.awN.length - 1];
                                if (i > 0) {
                                    System.arraycopy(zzb2.awN, 0, object, 0, i);
                                }
                                if (i < ((zzwc.zzc[])object).length) {
                                    System.arraycopy(zzb2.awN, i + 1, object, i, ((zzwc.zzc[])object).length - i);
                                }
                                zzb2.awN = object;
                                break;
                            }
                            bl = bl3;
                        }
                        if (bl6) {
                            zza3 = this.zzbvw().zza(this.zzbyb(), zza2.auB.zzcs, false, false, true, false, false);
                            if (zza3.arr > (long)this.zzbwd().zzlp(zza2.auB.zzcs)) {
                                this.zzbwb().zzbxa().log("Too many conversions. Not logging as conversion.");
                                zzwc.zzb zzb3 = zza2.zzani.get(n);
                                boolean bl7 = false;
                                object = null;
                                for (zzwc.zzc zzc5 : zzb3.awN) {
                                    if ("_c".equals(zzc5.name)) {
                                        object = zzc5;
                                        continue;
                                    }
                                    if (!"_err".equals(zzc5.name)) continue;
                                    bl7 = true;
                                }
                                if (bl7 && object != null) {
                                    zzwc.zzc[] zzcArray2 = new zzwc.zzc[zzb3.awN.length - 1];
                                    int n3 = 0;
                                    for (zzwc.zzc zzc6 : zzb3.awN) {
                                        if (zzc6 == object) continue;
                                        zzcArray2[n3++] = zzc6;
                                    }
                                    zzb3.awN = zzcArray2;
                                } else if (object != null) {
                                    object.name = "_err";
                                    object.awR = 10L;
                                } else {
                                    this.zzbwb().zzbwy().log("Did not find conversion parameter. Error not tracked");
                                }
                            }
                        }
                    }
                    zze2.awV[n2++] = zza2.zzani.get(n);
                }
                if (n2 < zza2.zzani.size()) {
                    zze2.awV = Arrays.copyOf(zze2.awV, n2);
                }
                zze2.axo = this.zza(zza2.auB.zzcs, zza2.auB.awW, zze2.awV);
                zze2.awY = Long.MAX_VALUE;
                zze2.awZ = Long.MIN_VALUE;
                for (n = 0; n < zze2.awV.length; ++n) {
                    zzwc.zzb zzb4 = zze2.awV[n];
                    if (zzb4.awO < zze2.awY) {
                        zze2.awY = zzb4.awO;
                    }
                    if (zzb4.awO <= zze2.awZ) continue;
                    zze2.awZ = zzb4.awO;
                }
                String string2 = zza2.auB.zzcs;
                com.google.android.gms.measurement.internal.zza zza4 = this.zzbvw().zzlz(string2);
                if (zza4 == null) {
                    this.zzbwb().zzbwy().log("Bundling raw events w/o app info");
                } else if (zze2.awV.length > 0) {
                    long l2 = zza4.zzbtl();
                    zze2.axb = l2 != 0L ? Long.valueOf(l2) : null;
                    long l3 = zza4.zzbtk();
                    if (l3 == 0L) {
                        l3 = l2;
                    }
                    zze2.axa = l3 != 0L ? Long.valueOf(l3) : null;
                    zza4.zzbtu();
                    zze2.axm = (int)zza4.zzbtr();
                    zza4.zzav(zze2.awY);
                    zza4.zzaw(zze2.awZ);
                    this.zzbvw().zza(zza4);
                }
                if (zze2.awV.length > 0) {
                    zze2.ard = this.zzbwb().zzbxf();
                    zzwb.zzb zzb5 = this.zzbvy().zzmo(zza2.auB.zzcs);
                    if (zzb5 == null || zzb5.awC == null) {
                        this.zzbwb().zzbxa().log("Did not find measurement config or missing version info");
                    } else {
                        zze2.axt = zzb5.awC;
                    }
                    this.zzbvw().zza(zze2, bl);
                }
                this.zzbvw().zzaf(zza2.auC);
                this.zzbvw().zzmg(string2);
                this.zzbvw().setTransactionSuccessful();
                boolean bl8 = zze2.awV.length > 0;
                return bl8;
            }
            this.zzbvw().setTransactionSuccessful();
            boolean bl = false;
            return false;
        }
        finally {
            this.zzbvw().endTransaction();
        }
    }

    private zzwc.zza[] zza(String string, zzwc.zzg[] zzgArray, zzwc.zzb[] zzbArray) {
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        return this.zzbvp().zza(string, zzbArray, zzgArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        this.zzzx();
        this.zzacj();
        com.google.android.gms.common.internal.zzaa.zzib((String)string);
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this.zzbvw().beginTransaction();
        try {
            boolean bl;
            com.google.android.gms.measurement.internal.zza zza2 = this.zzbvw().zzlz(string);
            boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
            if (zza2 == null) {
                this.zzbwb().zzbxa().zzj("App does not exist in onConfigFetched", string);
            } else if (bl || n == 404) {
                String string2;
                List<String> list = map != null ? map.get("Last-Modified") : null;
                String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                if (n == 404 || n == 304 ? this.zzbvy().zzmo(string) == null && !this.zzbvy().zzb(string, null, null) : !this.zzbvy().zzb(string, byArray, string2)) {
                    return;
                }
                zza2.zzbb(this.zzabz().currentTimeMillis());
                this.zzbvw().zza(zza2);
                if (n == 404) {
                    this.zzbwb().zzbxa().log("Config not found. Using empty config");
                } else {
                    this.zzbwb().zzbxe().zze("Successfully fetched config. Got network response. code, size", n, byArray.length);
                }
                if (this.zzbxv().zzagk() && this.zzbyf()) {
                    this.zzbye();
                } else {
                    this.zzbyg();
                }
            } else {
                boolean bl3;
                zza2.zzbc(this.zzabz().currentTimeMillis());
                this.zzbvw().zza(zza2);
                this.zzbwb().zzbxe().zze("Fetching config failed. code, error", n, throwable);
                this.zzbvy().zzmq(string);
                this.zzbwc().ata.set(this.zzabz().currentTimeMillis());
                boolean bl4 = bl3 = n == 503 || n == 429;
                if (bl3) {
                    this.zzbwc().atb.set(this.zzabz().currentTimeMillis());
                }
                this.zzbyg();
            }
            this.zzbvw().setTransactionSuccessful();
        }
        finally {
            this.zzbvw().endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    protected void zza(int n, Throwable throwable, byte[] byArray) {
        this.zzzx();
        this.zzacj();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        List<Long> list = this.auw;
        this.auw = null;
        if ((n == 200 || n == 204) && throwable == null) {
            this.zzbwc().asZ.set(this.zzabz().currentTimeMillis());
            this.zzbwc().ata.set(0L);
            this.zzbyg();
            this.zzbwb().zzbxe().zze("Successful upload. Got network response. code, size", n, byArray.length);
            this.zzbvw().beginTransaction();
            try {
                for (Long l : list) {
                    this.zzbvw().zzbj(l);
                }
                this.zzbvw().setTransactionSuccessful();
            }
            finally {
                this.zzbvw().endTransaction();
            }
            if (this.zzbxv().zzagk() && this.zzbyf()) {
                this.zzbye();
            } else {
                this.auz = -1L;
                this.zzbyg();
            }
        } else {
            boolean bl;
            this.zzbwb().zzbxe().zze("Network upload failed. Will retry later. code, error", n, throwable);
            this.zzbwc().ata.set(this.zzabz().currentTimeMillis());
            boolean bl2 = bl = n == 503 || n == 429;
            if (bl) {
                this.zzbwc().atb.set(this.zzabz().currentTimeMillis());
            }
            this.zzbyg();
        }
    }

    private boolean zzbyf() {
        this.zzzx();
        this.zzacj();
        boolean bl = this.zzbvw().zzbwk();
        return bl || !TextUtils.isEmpty((CharSequence)this.zzbvw().zzbwe());
    }

    @WorkerThread
    private void zzbyg() {
        this.zzzx();
        this.zzacj();
        if (!this.zzbyk()) {
            return;
        }
        if (!this.zzbxq() || !this.zzbyf()) {
            this.zzbxw().unregister();
            this.zzbxx().cancel();
            return;
        }
        long l = this.zzbyh();
        if (l == 0L) {
            this.zzbxw().unregister();
            this.zzbxx().cancel();
            return;
        }
        if (!this.zzbxv().zzagk()) {
            this.zzbxw().zzagh();
            this.zzbxx().cancel();
            return;
        }
        long l2 = this.zzbwc().atb.get();
        long l3 = this.zzbwd().zzbve();
        if (!this.zzbvx().zzf(l2, l3)) {
            l = Math.max(l, l2 + l3);
        }
        this.zzbxw().unregister();
        long l4 = l - this.zzabz().currentTimeMillis();
        if (l4 <= 0L) {
            l4 = this.zzbwd().zzbvh();
            this.zzbwc().asZ.set(this.zzabz().currentTimeMillis());
        }
        this.zzbwb().zzbxe().zzj("Upload scheduled in approximately ms", l4);
        this.zzbxx().zzx(l4);
    }

    private long zzbyh() {
        long l;
        long l2 = this.zzabz().currentTimeMillis();
        long l3 = this.zzbwd().zzbvk();
        boolean bl = this.zzbvw().zzbwl() || this.zzbvw().zzbwf();
        long l4 = bl ? this.zzbwd().zzbvg() : this.zzbwd().zzbvf();
        long l5 = this.zzbwc().asZ.get();
        long l6 = this.zzbwc().ata.get();
        long l7 = this.zzbvw().zzbwi();
        long l8 = Math.max(l7, l = this.zzbvw().zzbwj());
        if (l8 == 0L) {
            return 0L;
        }
        l8 = l2 - Math.abs(l8 - l2);
        l5 = l2 - Math.abs(l5 - l2);
        l6 = l2 - Math.abs(l6 - l2);
        long l9 = Math.max(l5, l6);
        long l10 = l8 + l3;
        if (bl && l9 > 0L) {
            l10 = Math.min(l8, l9) + l4;
        }
        if (!this.zzbvx().zzf(l9, l4)) {
            l10 = l9 + l4;
        }
        if (l6 != 0L && l6 >= l8) {
            long l11 = l10;
            for (int i = 0; i < this.zzbwd().zzbvm(); ++i) {
                long l12 = 1 << i;
                if ((l11 += this.zzbwd().zzbvl() * l12) <= l6) continue;
                return l11;
            }
            return 0L;
        }
        return l10;
    }

    public void zzaw(boolean bl) {
        this.zzbyg();
    }

    void zzb(zzaa zzaa2) {
        ++this.aux;
    }

    void zzbyi() {
        ++this.auy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void zzd(AppMetadata appMetadata) {
        this.zzzx();
        this.zzacj();
        com.google.android.gms.common.internal.zzaa.zzy((Object)((Object)appMetadata));
        com.google.android.gms.common.internal.zzaa.zzib((String)appMetadata.packageName);
        if (TextUtils.isEmpty((CharSequence)appMetadata.aqZ)) {
            return;
        }
        if (!appMetadata.are) {
            this.zze(appMetadata);
            return;
        }
        long l = this.zzabz().currentTimeMillis();
        this.zzbvw().beginTransaction();
        try {
            this.zza(appMetadata, l);
            this.zze(appMetadata);
            zzi zzi2 = this.zzbvw().zzap(appMetadata.packageName, "_f");
            if (zzi2 == null) {
                long l2 = (1L + l / 3600000L) * 3600000L;
                UserAttributeParcel userAttributeParcel = new UserAttributeParcel("_fot", l, l2, "auto");
                this.zzb(userAttributeParcel, appMetadata);
                this.zzb(appMetadata, l);
                this.zzc(appMetadata, l);
            } else if (appMetadata.arf) {
                this.zzd(appMetadata, l);
            }
            this.zzbvw().setTransactionSuccessful();
        }
        finally {
            this.zzbvw().endTransaction();
        }
    }

    @WorkerThread
    void zza(AppMetadata appMetadata, long l) {
        com.google.android.gms.measurement.internal.zza zza2 = this.zzbvw().zzlz(appMetadata.packageName);
        if (zza2 != null && zza2.zzbth() != null && !zza2.zzbth().equals(appMetadata.aqZ)) {
            this.zzbwb().zzbxa().log("New GMP App Id passed in. Removing cached database data.");
            this.zzbvw().zzme(zza2.zzup());
            zza2 = null;
        }
        if (zza2 != null && zza2.zzaaf() != null && !zza2.zzaaf().equals(appMetadata.aii)) {
            Bundle bundle = new Bundle();
            bundle.putString("_pv", zza2.zzaaf());
            EventParcel eventParcel = new EventParcel("_au", new EventParams(bundle), "auto", l);
            this.zzb(eventParcel, appMetadata);
        }
    }

    @WorkerThread
    void zzb(AppMetadata appMetadata, long l) {
        this.zzzx();
        this.zzacj();
        Bundle bundle = new Bundle();
        bundle.putLong("_c", 1L);
        bundle.putLong("_r", 1L);
        bundle.putLong("_uwa", 0L);
        bundle.putLong("_pfo", 0L);
        bundle.putLong("_sys", 0L);
        bundle.putLong("_sysu", 0L);
        PackageManager packageManager = this.getContext().getPackageManager();
        if (packageManager == null) {
            this.zzbwb().zzbwy().log("PackageManager is null, first open report might be inaccurate");
        } else {
            PackageInfo packageInfo = null;
            try {
                packageInfo = packageManager.getPackageInfo(appMetadata.packageName, 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                this.zzbwb().zzbwy().zzj("Package info is null, first open report might be inaccurate", (Object)nameNotFoundException);
            }
            if (packageInfo != null && packageInfo.firstInstallTime != 0L && packageInfo.firstInstallTime != packageInfo.lastUpdateTime) {
                bundle.putLong("_uwa", 1L);
            }
            ApplicationInfo applicationInfo = null;
            try {
                applicationInfo = packageManager.getApplicationInfo(appMetadata.packageName, 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                this.zzbwb().zzbwy().zzj("Application info is null, first open report might be inaccurate", (Object)nameNotFoundException);
            }
            if (applicationInfo != null) {
                if ((applicationInfo.flags & 1) != 0) {
                    bundle.putLong("_sys", 1L);
                }
                if ((applicationInfo.flags & 0x80) != 0) {
                    bundle.putLong("_sysu", 1L);
                }
            }
        }
        long l2 = this.zzbvw().zzmf(appMetadata.packageName);
        if (l2 >= 0L) {
            bundle.putLong("_pfo", l2);
        }
        EventParcel eventParcel = new EventParcel("_f", new EventParams(bundle), "auto", l);
        this.zzb(eventParcel, appMetadata);
    }

    @WorkerThread
    void zzc(AppMetadata appMetadata, long l) {
        Bundle bundle = new Bundle();
        bundle.putLong("_et", 1L);
        EventParcel eventParcel = new EventParcel("_e", new EventParams(bundle), "auto", l);
        this.zzb(eventParcel, appMetadata);
    }

    @WorkerThread
    void zzd(AppMetadata appMetadata, long l) {
        Bundle bundle = new Bundle();
        EventParcel eventParcel = new EventParcel("_cd", new EventParams(bundle), "auto", l);
        this.zzb(eventParcel, appMetadata);
    }

    @WorkerThread
    private void zze(AppMetadata appMetadata) {
        this.zzzx();
        this.zzacj();
        com.google.android.gms.common.internal.zzaa.zzy((Object)((Object)appMetadata));
        com.google.android.gms.common.internal.zzaa.zzib((String)appMetadata.packageName);
        com.google.android.gms.measurement.internal.zza zza2 = this.zzbvw().zzlz(appMetadata.packageName);
        String string = this.zzbwc().zzml(appMetadata.packageName);
        boolean bl = false;
        if (zza2 == null) {
            zza2 = new com.google.android.gms.measurement.internal.zza(this, appMetadata.packageName);
            zza2.zzlj(this.zzbwc().zzbxh());
            zza2.zzll(string);
            bl = true;
        } else if (!string.equals(zza2.zzbti())) {
            zza2.zzll(string);
            zza2.zzlj(this.zzbwc().zzbxh());
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)appMetadata.aqZ) && !appMetadata.aqZ.equals(zza2.zzbth())) {
            zza2.zzlk(appMetadata.aqZ);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)appMetadata.arh) && !appMetadata.arh.equals(zza2.zzbtj())) {
            zza2.zzlm(appMetadata.arh);
            bl = true;
        }
        if (appMetadata.arb != 0L && appMetadata.arb != zza2.zzbto()) {
            zza2.zzay(appMetadata.arb);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)appMetadata.aii) && !appMetadata.aii.equals(zza2.zzaaf())) {
            zza2.setAppVersion(appMetadata.aii);
            bl = true;
        }
        if (appMetadata.arg != zza2.zzbtm()) {
            zza2.zzax(appMetadata.arg);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)appMetadata.ara) && !appMetadata.ara.equals(zza2.zzbtn())) {
            zza2.zzln(appMetadata.ara);
            bl = true;
        }
        if (appMetadata.arc != zza2.zzbtp()) {
            zza2.zzaz(appMetadata.arc);
            bl = true;
        }
        if (appMetadata.are != zza2.zzbtq()) {
            zza2.setMeasurementEnabled(appMetadata.are);
            bl = true;
        }
        if (bl) {
            this.zzbvw().zza(zza2);
        }
    }

    @WorkerThread
    void zzbyj() {
        this.zzzx();
        this.zzacj();
        if (!this.aur) {
            this.zzbwb().zzbxc().log("This instance being marked as an uploader");
            this.zzbxz();
        }
        this.aur = true;
    }

    @WorkerThread
    boolean zzbyk() {
        this.zzzx();
        this.zzacj();
        return this.aur;
    }

    private class zza
    implements zze.zzb {
        zzwc.zze auB;
        List<Long> auC;
        List<zzwc.zzb> zzani;
        long auD;

        private zza() {
        }

        @Override
        public void zzb(zzwc.zze zze2) {
            com.google.android.gms.common.internal.zzaa.zzy((Object)((Object)zze2));
            this.auB = zze2;
        }

        @Override
        public boolean zza(long l, zzwc.zzb zzb2) {
            com.google.android.gms.common.internal.zzaa.zzy((Object)((Object)zzb2));
            if (this.zzani == null) {
                this.zzani = new ArrayList<zzwc.zzb>();
            }
            if (this.auC == null) {
                this.auC = new ArrayList<Long>();
            }
            if (this.zzani.size() > 0 && this.zza(this.zzani.get(0)) != this.zza(zzb2)) {
                return false;
            }
            long l2 = this.auD + (long)zzb2.cz();
            if (l2 >= (long)zzx.this.zzbwd().zzbuz()) {
                return false;
            }
            this.auD = l2;
            this.zzani.add(zzb2);
            this.auC.add(l);
            return this.zzani.size() < zzx.this.zzbwd().zzbva();
        }

        private long zza(zzwc.zzb zzb2) {
            return zzb2.awO / 1000L / 60L / 60L;
        }

        boolean isEmpty() {
            return this.zzani == null || this.zzani.isEmpty();
        }
    }
}

