/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.Context;
import android.os.Binder;
import android.support.annotation.BinderThread;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzeb;
import com.google.android.gms.internal.measurement.zzef;
import com.google.android.gms.internal.measurement.zzex;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzfb;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzgq;
import com.google.android.gms.internal.measurement.zzgr;
import com.google.android.gms.internal.measurement.zzgs;
import com.google.android.gms.internal.measurement.zzgt;
import com.google.android.gms.internal.measurement.zzgu;
import com.google.android.gms.internal.measurement.zzgv;
import com.google.android.gms.internal.measurement.zzgw;
import com.google.android.gms.internal.measurement.zzgx;
import com.google.android.gms.internal.measurement.zzgy;
import com.google.android.gms.internal.measurement.zzgz;
import com.google.android.gms.internal.measurement.zzha;
import com.google.android.gms.internal.measurement.zzhb;
import com.google.android.gms.internal.measurement.zzhc;
import com.google.android.gms.internal.measurement.zzhd;
import com.google.android.gms.internal.measurement.zzhe;
import com.google.android.gms.internal.measurement.zzhf;
import com.google.android.gms.internal.measurement.zzhg;
import com.google.android.gms.internal.measurement.zzhh;
import com.google.android.gms.internal.measurement.zzjt;
import com.google.android.gms.internal.measurement.zzka;
import com.google.android.gms.internal.measurement.zzkc;
import com.google.android.gms.internal.measurement.zzkd;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzgp
extends zzfb {
    private final zzjt zzalo;
    private Boolean zzapb;
    @Nullable
    private String zzapc;

    public zzgp(zzjt zzjt2) {
        this(zzjt2, null);
    }

    private zzgp(zzjt zzjt2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zzjt2);
        this.zzalo = zzjt2;
        this.zzapc = null;
    }

    @BinderThread
    public final void zzb(zzeb zzeb2) {
        this.zzb(zzeb2, false);
        this.zze(new zzgq(this, zzeb2));
    }

    @BinderThread
    public final void zza(zzex zzex2, zzeb zzeb2) {
        Preconditions.checkNotNull((Object)zzex2);
        this.zzb(zzeb2, false);
        this.zze(new zzha(this, zzex2, zzeb2));
    }

    @BinderThread
    public final void zza(zzex zzex2, String string, String string2) {
        Preconditions.checkNotNull((Object)zzex2);
        Preconditions.checkNotEmpty((String)string);
        this.zzc(string, true);
        this.zze(new zzhb(this, zzex2, string));
    }

    @BinderThread
    public final byte[] zza(zzex zzex2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzex2);
        this.zzc(string, true);
        this.zzalo.zzgi().zzjb().zzg("Log and bundle. event", (Object)this.zzalo.zzgf().zzbm(zzex2.name));
        long l = this.zzalo.zzbt().nanoTime() / 1000000L;
        Future future = this.zzalo.zzgh().zzc((Callable)new zzhc(this, zzex2, string));
        try {
            byte[] byArray = (byte[])future.get();
            if (byArray == null) {
                this.zzalo.zzgi().zziv().zzg("Log and bundle returned null. appId", zzfi.zzbp((String)string));
                byArray = new byte[]{};
            }
            long l2 = this.zzalo.zzbt().nanoTime() / 1000000L;
            this.zzalo.zzgi().zzjb().zzd("Log and bundle processed. event, size, time_ms", (Object)this.zzalo.zzgf().zzbm(zzex2.name), (Object)byArray.length, (Object)(l2 - l));
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzalo.zzgi().zziv().zzd("Failed to log and bundle. appId, event, error", zzfi.zzbp((String)string), (Object)this.zzalo.zzgf().zzbm(zzex2.name), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzka zzka2, zzeb zzeb2) {
        Preconditions.checkNotNull((Object)zzka2);
        this.zzb(zzeb2, false);
        if (zzka2.getValue() == null) {
            this.zze(new zzhd(this, zzka2, zzeb2));
            return;
        }
        this.zze(new zzhe(this, zzka2, zzeb2));
    }

    @BinderThread
    public final List<zzka> zza(zzeb zzeb2, boolean bl) {
        this.zzb(zzeb2, false);
        Future future = this.zzalo.zzgh().zzb((Callable)new zzhf(this, zzeb2));
        try {
            List list = (List)future.get();
            ArrayList<zzka> arrayList = new ArrayList<zzka>(list.size());
            for (zzkc zzkc2 : list) {
                if (!bl && zzkd.zzcm((String)zzkc2.name)) continue;
                arrayList.add(new zzka(zzkc2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzalo.zzgi().zziv().zze("Failed to get user attributes. appId", zzfi.zzbp((String)zzeb2.packageName), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzeb zzeb2) {
        this.zzb(zzeb2, false);
        this.zze(new zzhg(this, zzeb2));
    }

    @BinderThread
    private final void zzb(zzeb zzeb2, boolean bl) {
        Preconditions.checkNotNull((Object)zzeb2);
        this.zzc(zzeb2.packageName, false);
        this.zzalo.zzgg().zzck(zzeb2.zzafa);
    }

    @BinderThread
    private final void zzc(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzalo.zzgi().zziv().log("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzgp zzgp2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzgp2 = this;
                    if (!bl2) break block9;
                    if (zzgp2.zzapb == null) {
                        zzgp2.zzapb = "com.google.android.gms".equals(zzgp2.zzapc) || UidVerifier.isGooglePlayServicesUid((Context)zzgp2.zzalo.getContext(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzgp2.zzalo.getContext()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzgp2.zzapb.booleanValue()) break block10;
                }
                if (zzgp2.zzapc == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzgp2.zzalo.getContext(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzgp2.zzapc = string2;
                }
                if (!string2.equals(zzgp2.zzapc)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zzalo.zzgi().zziv().zzg("Measurement Service called with invalid calling package. appId", zzfi.zzbp((String)string));
            throw securityException;
        }
    }

    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zze(new zzhh(this, string2, string3, string, l));
    }

    @BinderThread
    public final String zzc(zzeb zzeb2) {
        this.zzb(zzeb2, false);
        return this.zzalo.zzh(zzeb2);
    }

    @BinderThread
    public final void zza(zzef zzef2, zzeb zzeb2) {
        Preconditions.checkNotNull((Object)zzef2);
        Preconditions.checkNotNull((Object)zzef2.zzage);
        this.zzb(zzeb2, false);
        zzef zzef3 = new zzef(zzef2);
        new zzef(zzef2).packageName = zzeb2.packageName;
        if (zzef2.zzage.getValue() == null) {
            this.zze(new zzgr(this, zzef3, zzeb2));
            return;
        }
        this.zze(new zzgs(this, zzef3, zzeb2));
    }

    @BinderThread
    public final void zzb(zzef zzef2) {
        Preconditions.checkNotNull((Object)zzef2);
        Preconditions.checkNotNull((Object)zzef2.zzage);
        this.zzc(zzef2.packageName, true);
        zzef zzef3 = new zzef(zzef2);
        if (zzef2.zzage.getValue() == null) {
            this.zze(new zzgt(this, zzef3));
            return;
        }
        this.zze(new zzgu(this, zzef3));
    }

    @BinderThread
    public final List<zzka> zza(String string, String string2, boolean bl, zzeb zzeb2) {
        this.zzb(zzeb2, false);
        Future future = this.zzalo.zzgh().zzb((Callable)new zzgv(this, zzeb2, string, string2));
        try {
            List list = (List)future.get();
            ArrayList<zzka> arrayList = new ArrayList<zzka>(list.size());
            for (zzkc zzkc2 : list) {
                if (!bl && zzkd.zzcm((String)zzkc2.name)) continue;
                arrayList.add(new zzka(zzkc2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzalo.zzgi().zziv().zze("Failed to get user attributes. appId", zzfi.zzbp((String)zzeb2.packageName), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzka> zza(String string, String string2, String string3, boolean bl) {
        this.zzc(string, true);
        Future future = this.zzalo.zzgh().zzb((Callable)new zzgw(this, string, string2, string3));
        try {
            List list = (List)future.get();
            ArrayList<zzka> arrayList = new ArrayList<zzka>(list.size());
            for (zzkc zzkc2 : list) {
                if (!bl && zzkd.zzcm((String)zzkc2.name)) continue;
                arrayList.add(new zzka(zzkc2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzalo.zzgi().zziv().zze("Failed to get user attributes. appId", zzfi.zzbp((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzef> zza(String string, String string2, zzeb zzeb2) {
        this.zzb(zzeb2, false);
        Future future = this.zzalo.zzgh().zzb((Callable)new zzgx(this, zzeb2, string, string2));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzalo.zzgi().zziv().zzg("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzef> zze(String string, String string2, String string3) {
        this.zzc(string, true);
        Future future = this.zzalo.zzgh().zzb((Callable)new zzgy(this, string, string2, string3));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzalo.zzgi().zziv().zzg("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final void zzd(zzeb zzeb2) {
        this.zzc(zzeb2.packageName, false);
        this.zze(new zzgz(this, zzeb2));
    }

    @VisibleForTesting
    private final void zze(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (((Boolean)zzez.zzajw.get()).booleanValue() && this.zzalo.zzgh().zzju()) {
            runnable.run();
            return;
        }
        this.zzalo.zzgh().zzc(runnable);
    }

    static /* synthetic */ zzjt zza(zzgp zzgp2) {
        return zzgp2.zzalo;
    }
}

