/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzaca;
import com.google.android.gms.internal.measurement.zzacb;
import com.google.android.gms.internal.measurement.zzea;
import com.google.android.gms.internal.measurement.zzeb;
import com.google.android.gms.internal.measurement.zzed;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzef;
import com.google.android.gms.internal.measurement.zzeh;
import com.google.android.gms.internal.measurement.zzej;
import com.google.android.gms.internal.measurement.zzek;
import com.google.android.gms.internal.measurement.zzem;
import com.google.android.gms.internal.measurement.zzes;
import com.google.android.gms.internal.measurement.zzet;
import com.google.android.gms.internal.measurement.zzeu;
import com.google.android.gms.internal.measurement.zzex;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzfm;
import com.google.android.gms.internal.measurement.zzfq;
import com.google.android.gms.internal.measurement.zzfr;
import com.google.android.gms.internal.measurement.zzft;
import com.google.android.gms.internal.measurement.zzgh;
import com.google.android.gms.internal.measurement.zzgi;
import com.google.android.gms.internal.measurement.zzgn;
import com.google.android.gms.internal.measurement.zzhk;
import com.google.android.gms.internal.measurement.zzjp;
import com.google.android.gms.internal.measurement.zzjs;
import com.google.android.gms.internal.measurement.zzju;
import com.google.android.gms.internal.measurement.zzjv;
import com.google.android.gms.internal.measurement.zzjw;
import com.google.android.gms.internal.measurement.zzjx;
import com.google.android.gms.internal.measurement.zzjy;
import com.google.android.gms.internal.measurement.zzjz;
import com.google.android.gms.internal.measurement.zzka;
import com.google.android.gms.internal.measurement.zzkc;
import com.google.android.gms.internal.measurement.zzkd;
import com.google.android.gms.internal.measurement.zzkn;
import com.google.android.gms.internal.measurement.zzkp;
import com.google.android.gms.internal.measurement.zzkr;
import com.google.android.gms.internal.measurement.zzks;
import com.google.android.gms.internal.measurement.zzkt;
import com.google.android.gms.internal.measurement.zzku;
import com.google.android.gms.internal.measurement.zzkx;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzjt
implements zzhk {
    private static volatile zzjt zzarr;
    private zzgh zzars;
    private zzfm zzart;
    private zzek zzaru;
    private zzfr zzarv;
    private zzjp zzarw;
    private zzed zzarx;
    private final zzjz zzary;
    private final zzgn zzacv;
    private boolean zzvn = false;
    private boolean zzarz;
    @VisibleForTesting
    private long zzasa;
    private List<Runnable> zzasb;
    private int zzasc;
    private int zzasd;
    private boolean zzase;
    private boolean zzasf;
    private boolean zzasg;
    private FileLock zzash;
    private FileChannel zzasi;
    private List<Long> zzasj;
    private List<Long> zzask;
    private long zzasl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzjt zzg(Context context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzarr != null) return zzarr;
        Class<zzjt> clazz = zzjt.class;
        synchronized (zzjt.class) {
            if (zzarr != null) return zzarr;
            zzjy zzjy2 = new zzjy(context);
            zzarr = new zzjt(zzjy2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzarr;
        }
    }

    private zzjt(zzjy zzjy2) {
        this(zzjy2, null);
    }

    private zzjt(zzjy zzjy2, zzgn zzgn2) {
        Preconditions.checkNotNull((Object)zzjy2);
        this.zzacv = zzgn2 = zzgn.zza((Context)zzjy2.zzqx, null, null);
        this.zzasl = -1L;
        zzjt zzjt2 = this;
        zzjz zzjz2 = new zzjz(zzjt2);
        zzjz2.zzm();
        this.zzary = zzjz2;
        zzjt2 = this;
        zzfm zzfm2 = new zzfm(zzjt2);
        zzfm2.zzm();
        this.zzart = zzfm2;
        zzjt2 = this;
        zzgh zzgh2 = new zzgh(zzjt2);
        zzgh2.zzm();
        this.zzars = zzgh2;
        this.zzacv.zzgh().zzc((Runnable)new zzju(this, zzjy2));
    }

    @WorkerThread
    private final void zza(zzjy zzjy2) {
        this.zzacv.zzgh().zzab();
        zzjt zzjt2 = this;
        zzek zzek2 = new zzek(zzjt2);
        zzek2.zzm();
        this.zzaru = zzek2;
        this.zzacv.zzgk().zza((zzej)this.zzars);
        zzjt2 = this;
        zzed zzed2 = new zzed(zzjt2);
        zzed2.zzm();
        this.zzarx = zzed2;
        zzjt2 = this;
        zzjp zzjp2 = new zzjp(zzjt2);
        zzjp2.zzm();
        this.zzarw = zzjp2;
        zzjt2 = this;
        this.zzarv = new zzfr(zzjt2);
        if (this.zzasc != this.zzasd) {
            this.zzacv.zzgi().zziv().zze("Not all upload components initialized", (Object)this.zzasc, (Object)this.zzasd);
        }
        this.zzvn = true;
    }

    @WorkerThread
    protected final void start() {
        this.zzacv.zzgh().zzab();
        this.zzjh().zzhx();
        if (this.zzacv.zzgj().zzalt.get() == 0L) {
            this.zzacv.zzgj().zzalt.set(this.zzacv.zzbt().currentTimeMillis());
        }
        this.zzlg();
    }

    public final zzee zzgl() {
        return this.zzacv.zzgl();
    }

    public final zzeh zzgk() {
        return this.zzacv.zzgk();
    }

    public final zzfi zzgi() {
        return this.zzacv.zzgi();
    }

    public final zzgi zzgh() {
        return this.zzacv.zzgh();
    }

    private final zzgh zzky() {
        zzjt.zza(this.zzars);
        return this.zzars;
    }

    public final zzfm zzkz() {
        zzjt.zza(this.zzart);
        return this.zzart;
    }

    public final zzek zzjh() {
        zzjt.zza(this.zzaru);
        return this.zzaru;
    }

    private final zzfr zzla() {
        if (this.zzarv == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzarv;
    }

    private final zzjp zzlb() {
        zzjt.zza(this.zzarw);
        return this.zzarw;
    }

    public final zzed zzjg() {
        zzjt.zza(this.zzarx);
        return this.zzarx;
    }

    public final zzjz zzjf() {
        zzjt.zza(this.zzary);
        return this.zzary;
    }

    public final zzfg zzgf() {
        return this.zzacv.zzgf();
    }

    public final Context getContext() {
        return this.zzacv.getContext();
    }

    public final Clock zzbt() {
        return this.zzacv.zzbt();
    }

    public final zzkd zzgg() {
        return this.zzacv.zzgg();
    }

    @WorkerThread
    private final void zzab() {
        this.zzacv.zzgh().zzab();
    }

    final void zzlc() {
        if (!this.zzvn) {
            throw new IllegalStateException("UploadController is not initialized");
        }
    }

    private static void zza(zzjs zzjs2) {
        if (zzjs2 == null) {
            throw new IllegalStateException("Upload Component not created");
        }
        if (!zzjs2.isInitialized()) {
            String string = String.valueOf(((Object)((Object)zzjs2)).getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    final void zze(zzeb zzeb2) {
        this.zzab();
        this.zzlc();
        Preconditions.checkNotEmpty((String)zzeb2.packageName);
        this.zzg(zzeb2);
    }

    private final long zzld() {
        long l = this.zzacv.zzbt().currentTimeMillis();
        zzft zzft2 = this.zzacv.zzgj();
        zzft2.zzch();
        zzft2.zzab();
        long l2 = zzft2.zzalx.get();
        if (l2 == 0L) {
            l2 = 1L + (long)zzft2.zzgg().zzlo().nextInt(86400000);
            zzft2.zzalx.set(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    final void zzc(zzex zzex2, String string) {
        zzea zzea2 = this.zzjh().zzbf(string);
        if (zzea2 == null || TextUtils.isEmpty((CharSequence)zzea2.zzag())) {
            this.zzacv.zzgi().zzjb().zzg("No app data available; dropping event", (Object)string);
            return;
        }
        Boolean bl = this.zzc(zzea2);
        if (bl == null) {
            if (!"_ui".equals(zzex2.name)) {
                this.zzacv.zzgi().zziy().zzg("Could not find package. appId", zzfi.zzbp((String)string));
            }
        } else if (!bl.booleanValue()) {
            this.zzacv.zzgi().zziv().zzg("App version does not match; dropping event. appId", zzfi.zzbp((String)string));
            return;
        }
        zzeb zzeb2 = new zzeb(string, zzea2.getGmpAppId(), zzea2.zzag(), zzea2.zzgu(), zzea2.zzgv(), zzea2.zzgw(), zzea2.zzgx(), null, zzea2.isMeasurementEnabled(), false, zzea2.zzgr(), zzea2.zzhk(), 0L, 0, zzea2.zzhl(), zzea2.zzhm(), false);
        this.zzb(zzex2, zzeb2);
    }

    @WorkerThread
    final void zzb(zzex zzex2, zzeb zzeb2) {
        Preconditions.checkNotNull((Object)zzeb2);
        Preconditions.checkNotEmpty((String)zzeb2.packageName);
        this.zzab();
        this.zzlc();
        String string = zzeb2.packageName;
        long l = zzex2.zzahr;
        if (!this.zzjf().zzd(zzex2, zzeb2)) {
            return;
        }
        if (!zzeb2.zzafk) {
            this.zzg(zzeb2);
            return;
        }
        this.zzjh().beginTransaction();
        try {
            zzef zzef2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string2;
            List list3;
            long l2 = l;
            String string3 = string;
            zzek zzek2 = this.zzjh();
            Preconditions.checkNotEmpty((String)string3);
            zzek2.zzab();
            zzek2.zzch();
            if (l2 < 0L) {
                zzek2.zzgi().zziy().zze("Invalid time querying timed out conditional properties", zzfi.zzbp((String)string3), (Object)l2);
                list3 = Collections.emptyList();
            } else {
                string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string3, String.valueOf(l2)};
                list3 = zzek2.zzb(string2, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzacv.zzgi().zzjb().zzd("User property timed out", (Object)((zzef)object22).packageName, (Object)this.zzacv.zzgf().zzbo(((zzef)object22).zzage.name), ((zzef)object22).zzage.getValue());
                if (((zzef)object22).zzagf != null) {
                    this.zzc(new zzex(((zzef)object22).zzagf, l), zzeb2);
                }
                this.zzjh().zzj(string, ((zzef)object22).zzage.name);
            }
            l2 = l;
            string3 = string;
            zzek2 = this.zzjh();
            Preconditions.checkNotEmpty((String)string3);
            zzek2.zzab();
            zzek2.zzch();
            if (l2 < 0L) {
                zzek2.zzgi().zziy().zze("Invalid time querying expired conditional properties", zzfi.zzbp((String)string3), (Object)l2);
                list2 = Collections.emptyList();
            } else {
                string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string3, String.valueOf(l2)};
                list2 = zzek2.zzb(string2, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzef)object4.next();
                if (object == null) continue;
                this.zzacv.zzgi().zzjb().zzd("User property expired", (Object)((zzef)object).packageName, (Object)this.zzacv.zzgf().zzbo(((zzef)object).zzage.name), ((zzef)object).zzage.getValue());
                this.zzjh().zzg(string, ((zzef)object).zzage.name);
                if (((zzef)object).zzagh != null) {
                    object22.add(((zzef)object).zzagh);
                }
                this.zzjh().zzj(string, ((zzef)object).zzage.name);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzex)e;
                this.zzc(new zzex((zzex)object, l), zzeb2);
            }
            long l3 = l;
            String string4 = zzex2.name;
            string3 = string;
            zzek2 = this.zzjh();
            Preconditions.checkNotEmpty((String)string3);
            Preconditions.checkNotEmpty((String)string4);
            zzek2.zzab();
            zzek2.zzch();
            if (l3 < 0L) {
                zzek2.zzgi().zziy().zzd("Invalid time querying triggered conditional properties", zzfi.zzbp((String)string3), (Object)zzek2.zzgf().zzbm(string4), (Object)l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string3, string4, String.valueOf(l3)};
                list = zzek2.zzb((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzef2 = (zzef)iterator.next();
                if (zzef2 == null) continue;
                zzka zzka2 = zzef2.zzage;
                zzkc zzkc2 = new zzkc(zzef2.packageName, zzef2.origin, zzka2.name, l, zzka2.getValue());
                if (this.zzjh().zza(zzkc2)) {
                    this.zzacv.zzgi().zzjb().zzd("User property triggered", (Object)zzef2.packageName, (Object)this.zzacv.zzgf().zzbo(zzkc2.name), zzkc2.value);
                } else {
                    this.zzacv.zzgi().zziv().zzd("Too many active user properties, ignoring", zzfi.zzbp((String)zzef2.packageName), (Object)this.zzacv.zzgf().zzbo(zzkc2.name), zzkc2.value);
                }
                if (zzef2.zzagg != null) {
                    object.add(zzef2.zzagg);
                }
                zzef2.zzage = new zzka(zzkc2);
                zzef2.active = true;
                this.zzjh().zza(zzef2);
            }
            this.zzc(zzex2, zzeb2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzef2 = (zzex)e;
                this.zzc(new zzex((zzex)zzef2, l), zzeb2);
            }
            this.zzjh().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzjh().endTransaction();
        }
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    private final void zzc(zzex var1_1, zzeb var2_2) {
        Preconditions.checkNotNull((Object)var2_2);
        Preconditions.checkNotEmpty((String)var2_2.packageName);
        var3_3 = System.nanoTime();
        this.zzab();
        this.zzlc();
        var5_4 = var2_2.packageName;
        if (!this.zzjf().zzd(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzafk) {
            this.zzg(var2_2);
            return;
        }
        if (this.zzky().zzn(var5_4, var1_1.name)) {
            this.zzacv.zzgi().zziy().zze("Dropping blacklisted event. appId", zzfi.zzbp((String)var5_4), (Object)this.zzacv.zzgf().zzbm(var1_1.name));
            var6_5 = this.zzky().zzcb(var5_4) != false || this.zzky().zzcc(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.name)) {
                this.zzacv.zzgg().zza(var5_4, 11, "_ev", var1_1.name, 0);
            }
            if (var6_5 && (var7_7 = this.zzjh().zzbf(var5_4)) != null) {
                var8_9 = Math.max(var7_7.zzha(), var7_7.zzgz());
                if (Math.abs(this.zzacv.zzbt().currentTimeMillis() - var8_9) > (Long)zzez.zzajd.get()) {
                    this.zzacv.zzgi().zzjb().log("Fetching config for blacklisted app");
                    this.zzb(var7_7);
                }
            }
            return;
        }
        if (this.zzacv.zzgi().isLoggable(2)) {
            this.zzacv.zzgi().zzjc().zzg("Logging event", (Object)this.zzacv.zzgf().zzb(var1_1));
        }
        this.zzjh().beginTransaction();
        try {
            block45: {
                block46: {
                    this.zzg(var2_2);
                    if (("_iap".equals(var1_1.name) || "ecommerce_purchase".equals(var1_1.name)) && !this.zza(var5_4, var1_1)) {
                        this.zzjh().setTransactionSuccessful();
                        return;
                    }
                    var6_6 = zzkd.zzcg((String)var1_1.name);
                    var7_8 = "_err".equals(var1_1.name);
                    var8_10 = this.zzjh().zza(this.zzld(), var5_4, true, var6_6, false, var7_8, false);
                    var9_11 = var8_10.zzagu - (long)((Integer)zzez.zzaio.get()).intValue();
                    if (var9_11 > 0L) {
                        if (var9_11 % 1000L == 1L) {
                            this.zzacv.zzgi().zziv().zze("Data loss. Too many events logged. appId, count", zzfi.zzbp((String)var5_4), (Object)var8_10.zzagu);
                        }
                        this.zzjh().setTransactionSuccessful();
                        return;
                    }
                    if (var6_6 && (var9_11 = var8_10.zzagt - (long)((Integer)zzez.zzaiq.get()).intValue()) > 0L) {
                        if (var9_11 % 1000L == 1L) {
                            this.zzacv.zzgi().zziv().zze("Data loss. Too many public events logged. appId, count", zzfi.zzbp((String)var5_4), (Object)var8_10.zzagt);
                        }
                        this.zzacv.zzgg().zza(var5_4, 16, "_ev", var1_1.name, 0);
                        this.zzjh().setTransactionSuccessful();
                        return;
                    }
                    if (var7_8) {
                        var19_12 = var2_2.packageName;
                        var20_13 = this.zzacv.zzgk().zzb(var19_12, zzez.zzaip);
                        var9_11 = var8_10.zzagw - (long)Math.max(0, var20_13 = Math.min(1000000, var20_13));
                        if (var9_11 > 0L) {
                            if (var9_11 == 1L) {
                                this.zzacv.zzgi().zziv().zze("Too many error events logged. appId, count", zzfi.zzbp((String)var5_4), (Object)var8_10.zzagw);
                            }
                            this.zzjh().setTransactionSuccessful();
                            return;
                        }
                    }
                    var11_15 = var1_1.zzahg.zzin();
                    this.zzacv.zzgg().zza(var11_15, "_o", (Object)var1_1.origin);
                    if (this.zzacv.zzgg().zzcn(var5_4)) {
                        this.zzacv.zzgg().zza(var11_15, "_dbg", (Object)1L);
                        this.zzacv.zzgg().zza(var11_15, "_r", (Object)1L);
                    }
                    if ((var12_16 = this.zzjh().zzbg(var5_4)) > 0L) {
                        this.zzacv.zzgi().zziy().zze("Data lost. Too many events stored on disk, deleted. appId", zzfi.zzbp((String)var5_4), (Object)var12_16);
                    }
                    var14_17 = new zzes(this.zzacv, var1_1.origin, var5_4, var1_1.name, var1_1.zzahr, 0L, var11_15);
                    var15_18 = this.zzjh().zzf(var5_4, var14_17.name);
                    if (var15_18 == null) {
                        if (this.zzjh().zzbj(var5_4) >= 500L && var6_6) {
                            this.zzacv.zzgi().zziv().zzd("Too many event names used, ignoring event. appId, name, supported count", zzfi.zzbp((String)var5_4), (Object)this.zzacv.zzgf().zzbm(var14_17.name), (Object)500);
                            this.zzacv.zzgg().zza(var5_4, 8, null, null, 0);
                            return;
                        }
                        var16_19 = new zzet(var5_4, var14_17.name, 0L, 0L, var14_17.timestamp, 0L, null, null, null);
                    } else {
                        var14_17 = var14_17.zza(this.zzacv, var15_18.zzahj);
                        var16_19 = var15_18.zzah(var14_17.timestamp);
                    }
                    this.zzjh().zza(var16_19);
                    var20_14 = var2_2;
                    var19_12 = var14_17;
                    var18_20 = this;
                    var18_20.zzab();
                    var18_20.zzlc();
                    Preconditions.checkNotNull((Object)var19_12);
                    Preconditions.checkNotNull((Object)var20_14);
                    Preconditions.checkNotEmpty((String)var19_12.zzth);
                    Preconditions.checkArgument((boolean)var19_12.zzth.equals(var20_14.packageName));
                    var21_21 = new zzku();
                    new zzku().zzavh = 1;
                    var21_21.zzavp = "android";
                    var21_21.zzth = var20_14.packageName;
                    var21_21.zzafh = var20_14.zzafh;
                    var21_21.zztg = var20_14.zztg;
                    var21_21.zzawb = var20_14.zzafg == -2147483648L ? null : Integer.valueOf((int)var20_14.zzafg);
                    var21_21.zzavt = var20_14.zzafi;
                    var21_21.zzafa = var20_14.zzafa;
                    var21_21.zzavx = var20_14.zzafj == 0L ? null : Long.valueOf(var20_14.zzafj);
                    var22_22 = var18_20.zzacv.zzgj().zzbr(var20_14.packageName);
                    if (var22_22 != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var22_22.first))) {
                        if (var20_14.zzafm) {
                            var21_21.zzavv = (String)var22_22.first;
                            var21_21.zzavw = (Boolean)var22_22.second;
                        }
                    } else if (!var18_20.zzacv.zzge().zzf(var18_20.zzacv.getContext()) && var20_14.zzafn) {
                        var23_23 = Settings.Secure.getString((ContentResolver)var18_20.zzacv.getContext().getContentResolver(), (String)"android_id");
                        if (var23_23 == null) {
                            var18_20.zzacv.zzgi().zziy().zzg("null secure ID. appId", zzfi.zzbp((String)var21_21.zzth));
                            var23_23 = "null";
                        } else if (var23_23.isEmpty()) {
                            var18_20.zzacv.zzgi().zziy().zzg("empty secure ID. appId", zzfi.zzbp((String)var21_21.zzth));
                        }
                        var21_21.zzawe = var23_23;
                    }
                    var18_20.zzacv.zzge().zzch();
                    var21_21.zzavr = Build.MODEL;
                    var18_20.zzacv.zzge().zzch();
                    var21_21.zzavq = Build.VERSION.RELEASE;
                    var21_21.zzavs = (int)var18_20.zzacv.zzge().zzik();
                    var21_21.zzahd = var18_20.zzacv.zzge().zzil();
                    var21_21.zzavu = null;
                    var21_21.zzavk = null;
                    var21_21.zzavl = null;
                    var21_21.zzavm = null;
                    var21_21.zzawg = var20_14.zzafl;
                    if (var18_20.zzacv.isEnabled() && zzeh.zzht()) {
                        var21_21.zzawh = null;
                    }
                    if ((var23_23 = var18_20.zzjh().zzbf(var20_14.packageName)) == null) {
                        var23_23 = new zzea(var18_20.zzacv, var20_14.packageName);
                        var23_23.zzam(var18_20.zzacv.zzfz().zzir());
                        var23_23.zzap(var20_14.zzafc);
                        var23_23.zzan(var20_14.zzafa);
                        var23_23.zzao(var18_20.zzacv.zzgj().zzbs(var20_14.packageName));
                        var23_23.zzw(0L);
                        var23_23.zzr(0L);
                        var23_23.zzs(0L);
                        var23_23.setAppVersion(var20_14.zztg);
                        var23_23.zzt(var20_14.zzafg);
                        var23_23.zzaq(var20_14.zzafh);
                        var23_23.zzu(var20_14.zzafi);
                        var23_23.zzv(var20_14.zzafj);
                        var23_23.setMeasurementEnabled(var20_14.zzafk);
                        var23_23.zzaf(var20_14.zzafl);
                        var18_20.zzjh().zza((zzea)var23_23);
                    }
                    var21_21.zzaez = var23_23.getAppInstanceId();
                    var21_21.zzafc = var23_23.zzgr();
                    var24_24 = var18_20.zzjh().zzbe(var20_14.packageName);
                    var21_21.zzavj = new zzkx[var24_24.size()];
                    for (var25_25 = 0; var25_25 < var24_24.size(); ++var25_25) {
                        var21_21.zzavj[var25_25] = var26_27 = new zzkx();
                        var26_27.name = var24_24.get((int)var25_25).name;
                        var26_27.zzaws = var24_24.get((int)var25_25).zzast;
                        var18_20.zzjf().zza(var26_27, var24_24.get((int)var25_25).value);
                    }
                    try {
                        var25_26 = var18_20.zzjh().zza(var21_21);
                    }
                    catch (IOException var27_28) {
                        var18_20.zzacv.zzgi().zziv().zze("Data loss. Failed to insert raw event metadata. appId", zzfi.zzbp((String)var21_21.zzth), (Object)var27_28);
                        break block45;
                    }
                    v0 = var18_20.zzjh();
                    var29_29 = var19_12;
                    var28_30 = var18_20;
                    if (var29_29.zzahg == null) ** GOTO lbl-1000
                    for (Object var31_33 : var29_29.zzahg) {
                        if (!"_r".equals(var31_33)) continue;
                        v1 = true;
                        break block46;
                    }
                    var30_32 = var28_30.zzky().zzo(var29_29.zzth, var29_29.name);
                    var31_33 = var28_30.zzjh().zza(var28_30.zzld(), var29_29.zzth, false, false, false, false, false);
                    if (var30_32 && var31_33.zzagx < (long)var28_30.zzacv.zzgk().zzas(var29_29.zzth)) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                }
                if (v0.zza((zzes)var19_12, var25_26, v1)) {
                    var18_20.zzasa = 0L;
                }
            }
            this.zzjh().setTransactionSuccessful();
            if (this.zzacv.zzgi().isLoggable(2)) {
                this.zzacv.zzgi().zzjc().zzg("Event recorded", (Object)this.zzacv.zzgf().zza(var14_17));
            }
        }
        finally {
            this.zzjh().endTransaction();
        }
        this.zzlg();
        this.zzacv.zzgi().zzjc().zzg("Background event processing time, ms", (Object)((System.nanoTime() - var3_3 + 500000L) / 1000000L));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean zza(String string, zzex zzex2) {
        long l;
        String string2;
        block10: {
            string2 = zzex2.zzahg.getString("currency");
            if ("ecommerce_purchase".equals(zzex2.name)) {
                double d = zzex2.zzahg.zzbk("value") * 1000000.0;
                if (d == 0.0) {
                    d = (double)zzex2.zzahg.getLong("value").longValue() * 1000000.0;
                }
                if (d <= 9.223372036854776E18 && d >= -9.223372036854776E18) {
                    l = Math.round(d);
                    break block10;
                } else {
                    this.zzacv.zzgi().zziy().zze("Data lost. Currency value is too big. appId", zzfi.zzbp((String)string), (Object)d);
                    return false;
                }
            }
            l = zzex2.zzahg.getLong("value");
        }
        if (!TextUtils.isEmpty((CharSequence)string2) && (string2 = string2.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
            String string3 = String.valueOf("_ltv_");
            String string4 = String.valueOf(string2);
            String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            zzkc zzkc2 = this.zzjh().zzh(string, string5);
            if (zzkc2 == null || !(zzkc2.value instanceof Long)) {
                String string6 = string;
                int n = this.zzacv.zzgk().zzb(string6, zzez.zzaji) - 1;
                string6 = string;
                zzek zzek2 = this.zzjh();
                Preconditions.checkNotEmpty((String)string6);
                zzek2.zzab();
                zzek2.zzch();
                try {
                    zzek2.getWritableDatabase().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{string6, string6, String.valueOf(n)});
                }
                catch (SQLiteException sQLiteException) {
                    zzek2.zzgi().zziv().zze("Error pruning currencies. appId", zzfi.zzbp((String)string6), (Object)sQLiteException);
                }
                zzkc2 = new zzkc(string, zzex2.origin, string5, this.zzacv.zzbt().currentTimeMillis(), (Object)l);
            } else {
                long l2 = (Long)zzkc2.value;
                zzkc2 = new zzkc(string, zzex2.origin, string5, this.zzacv.zzbt().currentTimeMillis(), (Object)(l2 + l));
            }
            if (!this.zzjh().zza(zzkc2)) {
                this.zzacv.zzgi().zziv().zzd("Too many unique user properties are set. Ignoring user property. appId", zzfi.zzbp((String)string), (Object)this.zzacv.zzgf().zzbo(zzkc2.name), zzkc2.value);
                this.zzacv.zzgg().zza(string, 9, null, null, 0);
            }
        }
        return true;
    }

    @WorkerThread
    final void zzle() {
        this.zzab();
        this.zzlc();
        this.zzasg = true;
        try {
            String string;
            zzee zzee2 = this.zzacv.zzgl();
            Boolean bl = this.zzacv.zzga().zzkr();
            if (bl == null) {
                this.zzacv.zzgi().zziy().log("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzacv.zzgi().zziv().log("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzasa > 0L) {
                this.zzlg();
                return;
            }
            zzhk zzhk2 = this;
            zzhk2.zzab();
            if (zzhk2.zzasj != null) {
                this.zzacv.zzgi().zzjc().log("Uploading requested multiple times");
                return;
            }
            if (!this.zzkz().zzex()) {
                this.zzacv.zzgi().zzjc().log("Network not connected, ignoring upload request");
                this.zzlg();
                return;
            }
            long l = this.zzacv.zzbt().currentTimeMillis();
            long l2 = l - zzeh.zzhr();
            this.zzd(null, l2);
            long l3 = this.zzacv.zzgj().zzalt.get();
            if (l3 != 0L) {
                this.zzacv.zzgi().zzjb().zzg("Uploading events. Elapsed time since last upload attempt (ms)", (Object)Math.abs(l - l3));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzjh().zzhv()))) {
                if (this.zzasl == -1L) {
                    this.zzasl = this.zzjh().zzic();
                }
                Object object = string;
                int n = this.zzacv.zzgk().zzb((String)object, zzez.zzaik);
                object = string;
                zzhk2 = this.zzacv.zzgk();
                int n2 = Math.max(0, zzhk2.zzb((String)object, zzez.zzail));
                List<Pair<zzku, Long>> list = this.zzjh().zzb(string, n, n2);
                if (!list.isEmpty()) {
                    Object object2;
                    String string2 = null;
                    Object object3 = list.iterator();
                    while (object3.hasNext()) {
                        zzku zzku2 = (zzku)((Object)object3.next().first);
                        if (TextUtils.isEmpty((CharSequence)zzku2.zzavv)) continue;
                        string2 = zzku2.zzavv;
                        break;
                    }
                    if (string2 != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            object2 = (zzku)((Object)list.get((int)i).first);
                            if (TextUtils.isEmpty((CharSequence)((zzku)((Object)object2)).zzavv) || ((zzku)((Object)object2)).zzavv.equals(string2)) continue;
                            list = list.subList(0, i);
                            break;
                        }
                    }
                    object3 = new zzkt();
                    new zzkt().zzavf = new zzku[list.size()];
                    object2 = new ArrayList(list.size());
                    boolean bl2 = zzeh.zzht() && this.zzacv.zzgk().zzau(string);
                    for (int i = 0; i < ((zzkt)((Object)object3)).zzavf.length; ++i) {
                        ((zzkt)((Object)object3)).zzavf[i] = (zzku)((Object)list.get((int)i).first);
                        object2.add((Long)list.get((int)i).second);
                        ((zzkt)((Object)object3)).zzavf[i].zzavu = this.zzacv.zzgk().zzgw();
                        ((zzkt)((Object)object3)).zzavf[i].zzavk = l;
                        zzee2 = this.zzacv.zzgl();
                        ((zzkt)((Object)object3)).zzavf[i].zzavz = false;
                        if (bl2) continue;
                        ((zzkt)((Object)object3)).zzavf[i].zzawh = null;
                    }
                    String string3 = null;
                    if (this.zzacv.zzgi().isLoggable(2)) {
                        string3 = this.zzjf().zzb((zzkt)((Object)object3));
                    }
                    byte[] byArray = this.zzjf().zza((zzkt)((Object)object3));
                    String string4 = (String)zzez.zzaiu.get();
                    try {
                        URL uRL = new URL(string4);
                        object = object2;
                        zzhk2 = this;
                        Preconditions.checkArgument((!object.isEmpty() ? 1 : 0) != 0);
                        if (zzhk2.zzasj != null) {
                            zzhk2.zzacv.zzgi().zziv().log("Set uploading progress before finishing the previous upload");
                        } else {
                            zzhk2.zzasj = new ArrayList<Long>((Collection<Long>)object);
                        }
                        this.zzacv.zzgj().zzalu.set(l);
                        String string5 = "?";
                        if (((zzkt)((Object)object3)).zzavf.length > 0) {
                            string5 = ((zzkt)((Object)object3)).zzavf[0].zzth;
                        }
                        this.zzacv.zzgi().zzjc().zzd("Uploading data. app, uncompressed size, data", (Object)string5, (Object)byArray.length, (Object)string3);
                        this.zzasf = true;
                        zzjv zzjv2 = new zzjv(this, string);
                        byte[] byArray2 = byArray;
                        URL uRL2 = uRL;
                        object = string;
                        zzhk2 = this.zzkz();
                        zzhk2.zzab();
                        zzhk2.zzch();
                        Preconditions.checkNotNull((Object)uRL2);
                        Preconditions.checkNotNull((Object)byArray2);
                        Preconditions.checkNotNull((Object)zzjv2);
                        zzhk2.zzgh().zzd((Runnable)new zzfq((zzfm)zzhk2, (String)object, uRL2, byArray2, null, zzjv2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzacv.zzgi().zziv().zze("Failed to parse upload URL. Not uploading. appId", zzfi.zzbp((String)string), (Object)string4);
                    }
                }
            } else {
                zzea zzea2;
                this.zzasl = -1L;
                String string6 = this.zzjh().zzag(l - zzeh.zzhr());
                if (!TextUtils.isEmpty((CharSequence)string6) && (zzea2 = this.zzjh().zzbf(string6)) != null) {
                    this.zzb(zzea2);
                }
            }
            return;
        }
        finally {
            this.zzasg = false;
            this.zzlh();
        }
    }

    @WorkerThread
    private final boolean zzd(String string, long l) {
        this.zzjh().beginTransaction();
        try {
            block109: {
                zzks[] zzksArray;
                zzks zzks2;
                int sQLiteException;
                int n3;
                int n4;
                Object object;
                Object object2;
                Object object3;
                zza zza2;
                block107: {
                    zza zza3 = zza2 = new zza(null);
                    long l2 = this.zzasl;
                    long l3 = l;
                    object3 = null;
                    object2 = this.zzjh();
                    Preconditions.checkNotNull((Object)zza3);
                    object2.zzab();
                    object2.zzch();
                    object = null;
                    try {
                        String[] stringArray;
                        String string2;
                        String string3;
                        String string4;
                        String[] stringArray2;
                        SQLiteDatabase sQLiteDatabase = object2.getWritableDatabase();
                        if (TextUtils.isEmpty(null)) {
                            stringArray2 = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            string4 = l2 != -1L ? "rowid <= ? and " : "";
                            object = sQLiteDatabase.rawQuery(new StringBuilder(148 + String.valueOf(string4).length()).append("select app_id, metadata_fingerprint from raw_events where ").append(string4).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), stringArray2);
                            if (!object.moveToFirst()) break block107;
                            object3 = object.getString(0);
                            string3 = object.getString(1);
                            object.close();
                        } else {
                            stringArray2 = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            string4 = l2 != -1L ? " and rowid <= ?" : "";
                            object = sQLiteDatabase.rawQuery(new StringBuilder(84 + String.valueOf(string4).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append(string4).append(" order by rowid limit 1;").toString(), stringArray2);
                            if (!object.moveToFirst()) break block107;
                            string3 = object.getString(0);
                            object.close();
                        }
                        object = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{object3, string3}, null, null, "rowid", "2");
                        if (!object.moveToFirst()) {
                            object2.zzgi().zziv().zzg("Raw event metadata record is missing. appId", zzfi.zzbp((String)object3));
                            break block107;
                        }
                        byte[] byArray = object.getBlob(0);
                        string4 = zzaca.zza((byte[])byArray, (int)0, (int)byArray.length);
                        zzku zzku2 = new zzku();
                        try {
                            zzku2.zzb((zzaca)string4);
                        }
                        catch (IOException iOException) {
                            object2.zzgi().zziv().zze("Data loss. Failed to merge raw event metadata. appId", zzfi.zzbp((String)object3), (Object)iOException);
                            if (object != null) {
                                object.close();
                            }
                            break block107;
                        }
                        if (object.moveToNext()) {
                            object2.zzgi().zziy().zzg("Get multiple raw event metadata records, expected one. appId", zzfi.zzbp((String)object3));
                        }
                        object.close();
                        zza3.zzb(zzku2);
                        if (l2 != -1L) {
                            string2 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            stringArray = new String[]{object3, string3, String.valueOf(l2)};
                        } else {
                            string2 = "app_id = ? and metadata_fingerprint = ?";
                            stringArray = new String[]{object3, string3};
                        }
                        object = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string2, stringArray, null, null, "rowid", null);
                        if (!object.moveToFirst()) {
                            object2.zzgi().zziy().zzg("Raw event data disappeared while in transaction. appId", zzfi.zzbp((String)object3));
                            break block107;
                        }
                        do {
                            long l4 = object.getLong(0);
                            byArray = object.getBlob(3);
                            string4 = zzaca.zza((byte[])byArray, (int)0, (int)byArray.length);
                            zzkr zzkr2 = new zzkr();
                            try {
                                zzkr2.zzb((zzaca)string4);
                            }
                            catch (IOException iOException) {
                                object2.zzgi().zziv().zze("Data loss. Failed to merge raw event. appId", zzfi.zzbp((String)object3), (Object)iOException);
                                continue;
                            }
                            zzkr2.name = object.getString(1);
                            zzkr2.zzavb = object.getLong(2);
                            if (!zza3.zza(l4, zzkr2)) break;
                        } while (object.moveToNext());
                    }
                    catch (SQLiteException sQLiteException2) {
                        object2.zzgi().zziv().zze("Data loss. Error selecting raw event. appId", zzfi.zzbp(object3), (Object)sQLiteException2);
                    }
                    finally {
                        if (object != null) {
                            object.close();
                        }
                    }
                }
                object2 = zza2;
                if (((zza)object2).zzasr == null || ((zza)object2).zzasr.isEmpty()) break block109;
                boolean bl = false;
                zzku zzku3 = zza2.zzasp;
                zza2.zzasp.zzavi = new zzkr[zza2.zzasr.size()];
                int n5 = 0;
                long l5 = 0L;
                boolean bl2 = this.zzacv.zzgk().zzaw(zzku3.zzth);
                for (n4 = 0; n4 < zza2.zzasr.size(); ++n4) {
                    zzkr zzkr3;
                    block111: {
                        int zzksArray3;
                        boolean bl3;
                        block110: {
                            boolean bl4;
                            bl3 = bl;
                            zzkr3 = zza2.zzasr.get(n4);
                            if (this.zzky().zzn(zza2.zzasp.zzth, zzkr3.name)) {
                                this.zzacv.zzgi().zziy().zze("Dropping blacklisted raw event. appId", zzfi.zzbp((String)zza2.zzasp.zzth), (Object)this.zzacv.zzgf().zzbm(zzkr3.name));
                                if (this.zzky().zzcb(zza2.zzasp.zzth) || this.zzky().zzcc(zza2.zzasp.zzth) || "_err".equals(zzkr3.name)) continue;
                                this.zzacv.zzgg().zza(zza2.zzasp.zzth, 11, "_ev", zzkr3.name, 0);
                                continue;
                            }
                            n3 = this.zzky().zzo(zza2.zzasp.zzth, zzkr3.name);
                            if (n3 != 0) break block110;
                            this.zzjf();
                            object2 = zzkr3.name;
                            Preconditions.checkNotEmpty((String)object2);
                            zzek zzek2 = object2;
                            sQLiteException = -1;
                            switch (((String)((Object)zzek2)).hashCode()) {
                                case 94660: {
                                    if (!((String)((Object)zzek2)).equals("_in")) break;
                                    sQLiteException = 0;
                                    break;
                                }
                                case 95027: {
                                    if (!((String)((Object)zzek2)).equals("_ui")) break;
                                    sQLiteException = 1;
                                    break;
                                }
                                case 95025: {
                                    if (!((String)((Object)zzek2)).equals("_ug")) break;
                                    sQLiteException = 2;
                                }
                            }
                            switch (sQLiteException) {
                                case 0: 
                                case 1: 
                                case 2: {
                                    bl4 = true;
                                    break;
                                }
                                default: {
                                    bl4 = false;
                                }
                            }
                            if (!bl4) break block111;
                        }
                        boolean bl5 = false;
                        boolean n = false;
                        if (zzkr3.zzava == null) {
                            zzkr3.zzava = new zzks[0];
                        }
                        zzks[] i = zzkr3.zzava;
                        int zzks3 = zzkr3.zzava.length;
                        for (zzksArray3 = 0; zzksArray3 < zzks3; ++zzksArray3) {
                            zzks2 = i[zzksArray3];
                            if ("_c".equals(zzks2.name)) {
                                zzks2.zzave = 1L;
                                bl5 = true;
                                continue;
                            }
                            if (!"_r".equals(zzks2.name)) continue;
                            zzks2.zzave = 1L;
                            n = true;
                        }
                        if (!bl5 && n3 != 0) {
                            this.zzacv.zzgi().zzjc().zzg("Marking event as conversion", (Object)this.zzacv.zzgf().zzbm(zzkr3.name));
                            i = Arrays.copyOf(zzkr3.zzava, zzkr3.zzava.length + 1);
                            zzks zzks4 = new zzks();
                            new zzks().name = "_c";
                            zzks4.zzave = 1L;
                            i[i.length - 1] = zzks4;
                            zzkr3.zzava = i;
                        }
                        if (!n) {
                            this.zzacv.zzgi().zzjc().zzg("Marking event as real-time", (Object)this.zzacv.zzgf().zzbm(zzkr3.name));
                            i = Arrays.copyOf(zzkr3.zzava, zzkr3.zzava.length + 1);
                            zzks zzkr4 = new zzks();
                            new zzks().name = "_r";
                            zzkr4.zzave = 1L;
                            i[i.length - 1] = zzkr4;
                            zzkr3.zzava = i;
                        }
                        bl = true;
                        if (this.zzjh().zza((long)this.zzld(), (String)zza2.zzasp.zzth, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zzagx > (long)this.zzacv.zzgk().zzas(zza2.zzasp.zzth)) {
                            for (zzks3 = 0; zzks3 < zzkr3.zzava.length; ++zzks3) {
                                if (!"_r".equals(zzkr3.zzava[zzks3].name)) continue;
                                zzks[] string5 = new zzks[zzkr3.zzava.length - 1];
                                if (zzks3 > 0) {
                                    System.arraycopy(zzkr3.zzava, 0, string5, 0, zzks3);
                                }
                                if (zzks3 < string5.length) {
                                    System.arraycopy(zzkr3.zzava, zzks3 + 1, string5, zzks3, string5.length - zzks3);
                                }
                                zzkr3.zzava = string5;
                                break;
                            }
                            bl = bl3;
                        }
                        if (zzkd.zzcg((String)zzkr3.name) && n3 != 0) {
                            object3 = zza2.zzasp.zzth;
                            if (this.zzjh().zza((long)this.zzld(), (String)zza2.zzasp.zzth, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zzagv > (long)this.zzacv.zzgk().zzb((String)object3, zzez.zzair)) {
                                this.zzacv.zzgi().zziy().zzg("Too many conversions. Not logging as conversion. appId", zzfi.zzbp((String)zza2.zzasp.zzth));
                                zzksArray3 = 0;
                                zzks2 = null;
                                zzksArray = zzkr3.zzava;
                                int bl8 = zzkr3.zzava.length;
                                for (int j = 0; j < bl8; ++j) {
                                    zzks zzks4 = zzksArray[j];
                                    if ("_c".equals(zzks4.name)) {
                                        zzks2 = zzks4;
                                        continue;
                                    }
                                    if (!"_err".equals(zzks4.name)) continue;
                                    zzksArray3 = 1;
                                }
                                if (zzksArray3 != 0 && zzks2 != null) {
                                    zzkr3.zzava = (zzks[])ArrayUtils.removeAll((Object[])zzkr3.zzava, (Object[])new zzks[]{zzks2});
                                } else if (zzks2 != null) {
                                    zzks2.name = "_err";
                                    zzks2.zzave = 10L;
                                } else {
                                    this.zzacv.zzgi().zziv().zzg("Did not find conversion parameter. appId", zzfi.zzbp((String)zza2.zzasp.zzth));
                                }
                            }
                        }
                    }
                    if (bl2 && "_e".equals(zzkr3.name)) {
                        if (zzkr3.zzava == null || zzkr3.zzava.length == 0) {
                            this.zzacv.zzgi().zziy().zzg("Engagement event does not contain any parameters. appId", zzfi.zzbp((String)zza2.zzasp.zzth));
                        } else {
                            this.zzjf();
                            Long l6 = (Long)zzjz.zzb(zzkr3, "_et");
                            if (l6 == null) {
                                this.zzacv.zzgi().zziy().zzg("Engagement event does not include duration. appId", zzfi.zzbp((String)zza2.zzasp.zzth));
                            } else {
                                l5 += l6.longValue();
                            }
                        }
                    }
                    zzku3.zzavi[n5++] = zzkr3;
                }
                if (n5 < zza2.zzasr.size()) {
                    zzku3.zzavi = Arrays.copyOf(zzku3.zzavi, n5);
                }
                if (bl2) {
                    zzkc zzkc2 = this.zzjh().zzh(zzku3.zzth, "_lte");
                    zzkc2 = zzkc2 == null || zzkc2.value == null ? new zzkc(zzku3.zzth, "auto", "_lte", this.zzacv.zzbt().currentTimeMillis(), (Object)l5) : new zzkc(zzku3.zzth, "auto", "_lte", this.zzacv.zzbt().currentTimeMillis(), (Object)((Long)zzkc2.value + l5));
                    zzkx zzkx2 = new zzkx();
                    new zzkx().name = "_lte";
                    zzkx2.zzaws = this.zzacv.zzbt().currentTimeMillis();
                    zzkx2.zzave = (Long)zzkc2.value;
                    boolean bl6 = false;
                    for (n3 = 0; n3 < zzku3.zzavj.length; ++n3) {
                        if (!"_lte".equals(zzku3.zzavj[n3].name)) continue;
                        zzku3.zzavj[n3] = zzkx2;
                        bl6 = true;
                        break;
                    }
                    if (!bl6) {
                        zzku3.zzavj = Arrays.copyOf(zzku3.zzavj, zzku3.zzavj.length + 1);
                        zzku3.zzavj[zza2.zzasp.zzavj.length - 1] = zzkx2;
                    }
                    if (l5 > 0L) {
                        this.zzjh().zza(zzkc2);
                        this.zzacv.zzgi().zzjb().zzg("Updated lifetime engagement user property with value. Value", zzkc2.value);
                    }
                }
                zzku3.zzawa = this.zza(zzku3.zzth, zzku3.zzavj, zzku3.zzavi);
                if (this.zzacv.zzgk().zzav(zza2.zzasp.zzth)) {
                    HashMap<String, zzks> hashMap = new HashMap<String, zzks>();
                    zzkr[] zzkrArray = new zzkr[zzku3.zzavi.length];
                    int n9 = 0;
                    SecureRandom secureRandom = this.zzacv.zzgg().zzlo();
                    zzkr[] zzkrArray2 = zzku3.zzavi;
                    int n = zzku3.zzavi.length;
                    for (int i = 0; i < n; ++i) {
                        boolean bl5;
                        int n2;
                        zzkr zzkr2;
                        block108: {
                            zzkr2 = zzkrArray2[i];
                            if (zzkr2.name.equals("_ep")) {
                                this.zzjf();
                                String n10 = (String)zzjz.zzb(zzkr2, "_en");
                                zzks2 = (zzet)hashMap.get(n10);
                                if (zzks2 == null) {
                                    zzks2 = this.zzjh().zzf(zza2.zzasp.zzth, n10);
                                    hashMap.put(n10, zzks2);
                                }
                                if (((zzet)zzks2).zzahl != null) continue;
                                if (((zzet)zzks2).zzahm > 1L) {
                                    this.zzjf();
                                    zzkr2.zzava = zzjz.zza(zzkr2.zzava, "_sr", ((zzet)zzks2).zzahm);
                                }
                                if (((zzet)zzks2).zzahn != null && ((zzet)zzks2).zzahn.booleanValue()) {
                                    this.zzjf();
                                    zzkr2.zzava = zzjz.zza(zzkr2.zzava, "_efs", 1L);
                                }
                                zzkrArray[n9++] = zzkr2;
                                continue;
                            }
                            n2 = 1;
                            Long l7 = 1L;
                            object3 = "_dbg";
                            object2 = zzkr2;
                            if (TextUtils.isEmpty((CharSequence)object3) || l7 == null) {
                                bl5 = false;
                            } else {
                                zzks[] zzksArray4 = ((zzkr)((Object)((Object)object2))).zzava;
                                int n6 = ((zzkr)((Object)((Object)object2))).zzava.length;
                                for (int j = 0; j < n6; ++j) {
                                    object = zzksArray4[j];
                                    if (!((String)object3).equals(object.name)) continue;
                                    bl5 = l7 instanceof Long && ((Object)l7).equals(object.zzave) || l7 instanceof String && ((Object)l7).equals(object.zzale) || l7 instanceof Double && ((Object)l7).equals(object.zzasw);
                                    break block108;
                                }
                                bl5 = false;
                            }
                        }
                        if (!bl5) {
                            n2 = this.zzky().zzp(zza2.zzasp.zzth, zzkr2.name);
                        }
                        if (n2 <= 0) {
                            this.zzacv.zzgi().zziy().zze("Sample rate must be positive. event, rate", (Object)zzkr2.name, (Object)n2);
                            zzkrArray[n9++] = zzkr2;
                            continue;
                        }
                        zzks2 = (zzet)hashMap.get(zzkr2.name);
                        if (zzks2 == null && (zzks2 = this.zzjh().zzf(zza2.zzasp.zzth, zzkr2.name)) == null) {
                            this.zzacv.zzgi().zziy().zze("Event being bundled has no eventAggregate. appId, eventName", (Object)zza2.zzasp.zzth, (Object)zzkr2.name);
                            zzks2 = new zzet(zza2.zzasp.zzth, zzkr2.name, 1L, 1L, zzkr2.zzavb.longValue(), 0L, null, null, null);
                        }
                        this.zzjf();
                        zzksArray = (zzks[])zzjz.zzb(zzkr2, "_eid");
                        Boolean bl6 = zzksArray != null;
                        if (n2 == 1) {
                            zzkrArray[n9++] = zzkr2;
                            if (!bl6.booleanValue() || ((zzet)zzks2).zzahl == null && ((zzet)zzks2).zzahm == null && ((zzet)zzks2).zzahn == null) continue;
                            zzks2 = zzks2.zza(null, null, null);
                            hashMap.put(zzkr2.name, zzks2);
                            continue;
                        }
                        if (secureRandom.nextInt(n2) == 0) {
                            this.zzjf();
                            zzkr2.zzava = zzjz.zza(zzkr2.zzava, "_sr", n2);
                            zzkrArray[n9++] = zzkr2;
                            if (bl6.booleanValue()) {
                                zzks2 = zzks2.zza(null, Long.valueOf(n2), null);
                            }
                            hashMap.put(zzkr2.name, (zzks)zzks2.zzai(zzkr2.zzavb));
                            continue;
                        }
                        long l2 = ((zzet)zzks2).zzahk;
                        if (Math.abs(zzkr2.zzavb - l2) >= 86400000L) {
                            this.zzjf();
                            zzkr2.zzava = zzjz.zza(zzkr2.zzava, "_efs", 1L);
                            this.zzjf();
                            zzkr2.zzava = zzjz.zza(zzkr2.zzava, "_sr", n2);
                            zzkrArray[n9++] = zzkr2;
                            if (bl6.booleanValue()) {
                                zzks2 = zzks2.zza(null, Long.valueOf(n2), true);
                            }
                            hashMap.put(zzkr2.name, (zzks)zzks2.zzai(zzkr2.zzavb));
                            continue;
                        }
                        if (!bl6.booleanValue()) continue;
                        hashMap.put(zzkr2.name, (zzks)zzks2.zza((Long)zzksArray, null, null));
                    }
                    if (n9 < zzku3.zzavi.length) {
                        zzku3.zzavi = Arrays.copyOf(zzkrArray, n9);
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        this.zzjh().zza((zzet)entry.getValue());
                    }
                }
                zzku3.zzavl = Long.MAX_VALUE;
                zzku3.zzavm = Long.MIN_VALUE;
                for (n4 = 0; n4 < zzku3.zzavi.length; ++n4) {
                    zzkr zzkr5 = zzku3.zzavi[n4];
                    if (zzkr5.zzavb < zzku3.zzavl) {
                        zzku3.zzavl = zzkr5.zzavb;
                    }
                    if (zzkr5.zzavb <= zzku3.zzavm) continue;
                    zzku3.zzavm = zzkr5.zzavb;
                }
                String string6 = zza2.zzasp.zzth;
                zzea zzea2 = this.zzjh().zzbf(string6);
                if (zzea2 == null) {
                    this.zzacv.zzgi().zziv().zzg("Bundling raw events w/o app info. appId", zzfi.zzbp((String)zza2.zzasp.zzth));
                } else if (zzku3.zzavi.length > 0) {
                    long l9 = zzea2.zzgt();
                    zzku3.zzavo = l9 != 0L ? Long.valueOf(l9) : null;
                    long l10 = zzea2.zzgs();
                    if (l10 == 0L) {
                        l10 = l9;
                    }
                    zzku3.zzavn = l10 != 0L ? Long.valueOf(l10) : null;
                    zzea2.zzhb();
                    zzku3.zzavy = (int)zzea2.zzgy();
                    zzea2.zzr(zzku3.zzavl.longValue());
                    zzea2.zzs(zzku3.zzavm.longValue());
                    zzku3.zzafy = zzea2.zzhj();
                    this.zzjh().zza(zzea2);
                }
                if (zzku3.zzavi.length > 0) {
                    zzee zzee2 = this.zzacv.zzgl();
                    zzkn zzkn2 = this.zzky().zzbx(zza2.zzasp.zzth);
                    if (zzkn2 == null || zzkn2.zzaum == null) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zzasp.zzafa)) {
                            zzku3.zzawf = -1L;
                        } else {
                            this.zzacv.zzgi().zziy().zzg("Did not find measurement config or missing version info. appId", zzfi.zzbp((String)zza2.zzasp.zzth));
                        }
                    } else {
                        zzku3.zzawf = zzkn2.zzaum;
                    }
                    this.zzjh().zza(zzku3, bl);
                }
                object3 = zza2.zzasq;
                object2 = this.zzjh();
                Preconditions.checkNotNull((Object)object3);
                object2.zzab();
                object2.zzch();
                StringBuilder stringBuilder = new StringBuilder("rowid in (");
                for (sQLiteException = 0; sQLiteException < object3.size(); ++sQLiteException) {
                    if (sQLiteException != 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append((Long)object3.get(sQLiteException));
                }
                stringBuilder.append(")");
                int n12 = object2.getWritableDatabase().delete("raw_events", stringBuilder.toString(), null);
                if (n12 != object3.size()) {
                    object2.zzgi().zziv().zze("Deleted fewer rows from raw events table than expected", (Object)n12, (Object)object3.size());
                }
                object3 = string6;
                object2 = this.zzjh();
                stringBuilder = object2.getWritableDatabase();
                try {
                    stringBuilder.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", new String[]{object3, object3});
                }
                catch (SQLiteException sQLiteException3) {
                    object2.zzgi().zziv().zze("Failed to remove unused event metadata. appId", zzfi.zzbp((String)object3), (Object)sQLiteException3);
                }
                this.zzjh().setTransactionSuccessful();
                return true;
            }
            this.zzjh().setTransactionSuccessful();
            return false;
        }
        finally {
            this.zzjh().endTransaction();
        }
    }

    private final zzkp[] zza(String string, zzkx[] zzkxArray, zzkr[] zzkrArray) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzjg().zza(string, zzkrArray, zzkxArray);
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(int n, Throwable throwable, byte[] byArray, String string) {
        this.zzab();
        this.zzlc();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List<Long> list = this.zzasj;
            this.zzasj = null;
            if ((n == 200 || n == 204) && throwable == null) {
                try {
                    this.zzacv.zzgj().zzalt.set(this.zzacv.zzbt().currentTimeMillis());
                    this.zzacv.zzgj().zzalu.set(0L);
                    this.zzlg();
                    this.zzacv.zzgi().zzjc().zze("Successful upload. Got network response. code, size", (Object)n, (Object)byArray.length);
                    this.zzjh().beginTransaction();
                    try {
                        for (Long l : list) {
                            try {
                                long l2 = l;
                                zzek zzek2 = this.zzjh();
                                zzek2.zzab();
                                zzek2.zzch();
                                SQLiteDatabase sQLiteDatabase = zzek2.getWritableDatabase();
                                String[] stringArray = new String[]{String.valueOf(l2)};
                                try {
                                    if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                    throw new SQLiteException("Deleted fewer rows from queue than expected");
                                }
                                catch (SQLiteException sQLiteException) {
                                    zzek2.zzgi().zziv().zzg("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                    throw sQLiteException;
                                }
                            }
                            catch (SQLiteException sQLiteException) {
                                if (this.zzask != null && this.zzask.contains(l)) continue;
                                throw sQLiteException;
                            }
                        }
                        this.zzjh().setTransactionSuccessful();
                    }
                    finally {
                        this.zzjh().endTransaction();
                    }
                    this.zzask = null;
                    if (this.zzkz().zzex() && this.zzlf()) {
                        this.zzle();
                    } else {
                        this.zzasl = -1L;
                        this.zzlg();
                    }
                    this.zzasa = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzacv.zzgi().zziv().zzg("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzasa = this.zzacv.zzbt().elapsedRealtime();
                    this.zzacv.zzgi().zzjc().zzg("Disable upload, time", (Object)this.zzasa);
                }
            } else {
                this.zzacv.zzgi().zzjc().zze("Network upload failed. Will retry later. code, error", (Object)n, (Object)throwable);
                this.zzacv.zzgj().zzalu.set(this.zzacv.zzbt().currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzacv.zzgj().zzalv.set(this.zzacv.zzbt().currentTimeMillis());
                }
                if (this.zzacv.zzgk().zzay(string)) {
                    this.zzjh().zzc(list);
                }
                this.zzlg();
            }
            return;
        }
        finally {
            this.zzasf = false;
            this.zzlh();
        }
    }

    private final boolean zzlf() {
        this.zzab();
        this.zzlc();
        return this.zzjh().zzia() || !TextUtils.isEmpty((CharSequence)this.zzjh().zzhv());
    }

    @WorkerThread
    private final void zzb(zzea zzea2) {
        this.zzab();
        if (TextUtils.isEmpty((CharSequence)zzea2.getGmpAppId())) {
            this.zzb(zzea2.zzah(), 204, null, null, null);
            return;
        }
        Object object = zzea2.getAppInstanceId();
        String string = zzea2.getGmpAppId();
        Object object2 = this.zzacv.zzgk();
        Uri.Builder builder = new Uri.Builder();
        String string2 = String.valueOf(string);
        builder.scheme((String)zzez.zzaii.get()).encodedAuthority((String)zzez.zzaij.get()).path(string2.length() != 0 ? "config/app/".concat(string2) : new String("config/app/")).appendQueryParameter("app_instance_id", (String)object).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", String.valueOf(object2.zzgw()));
        String string3 = builder.build().toString();
        try {
            URL uRL = new URL(string3);
            this.zzacv.zzgi().zzjc().zzg("Fetching remote configuration", (Object)zzea2.zzah());
            zzkn zzkn2 = this.zzky().zzbx(zzea2.zzah());
            ArrayMap arrayMap = null;
            String string4 = this.zzky().zzby(zzea2.zzah());
            if (zzkn2 != null && !TextUtils.isEmpty((CharSequence)string4)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string4);
            }
            this.zzase = true;
            zzjw zzjw2 = new zzjw(this);
            builder = arrayMap;
            object = uRL;
            string = zzea2.zzah();
            object2 = this.zzkz();
            object2.zzab();
            ((zzjs)((Object)object2)).zzch();
            Preconditions.checkNotNull((Object)object);
            Preconditions.checkNotNull((Object)zzjw2);
            object2.zzgh().zzd((Runnable)new zzfq((zzfm)((Object)object2), string, (URL)object, null, (Map)builder, zzjw2));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzacv.zzgi().zziv().zze("Failed to parse config URL. Not fetching. appId", zzfi.zzbp((String)zzea2.zzah()), (Object)string3);
            return;
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        this.zzab();
        this.zzlc();
        Preconditions.checkNotEmpty((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzacv.zzgi().zzjc().zzg("onConfigFetched. Response size", (Object)byArray.length);
            this.zzjh().beginTransaction();
            try {
                boolean bl;
                zzea zzea2 = this.zzjh().zzbf(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzea2 == null) {
                    this.zzacv.zzgi().zziy().zzg("App does not exist in onConfigFetched. appId", zzfi.zzbp((String)string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzky().zzbx(string) == null && !this.zzky().zza(string, null, null) : !this.zzky().zza(string, byArray, string2)) {
                        return;
                    }
                    zzea2.zzx(this.zzacv.zzbt().currentTimeMillis());
                    this.zzjh().zza(zzea2);
                    if (n == 404) {
                        this.zzacv.zzgi().zziz().zzg("Config not found. Using empty config. appId", (Object)string);
                    } else {
                        this.zzacv.zzgi().zzjc().zze("Successfully fetched config. Got network response. code, size", (Object)n, (Object)byArray.length);
                    }
                    if (this.zzkz().zzex() && this.zzlf()) {
                        this.zzle();
                    } else {
                        this.zzlg();
                    }
                } else {
                    zzea2.zzy(this.zzacv.zzbt().currentTimeMillis());
                    this.zzjh().zza(zzea2);
                    this.zzacv.zzgi().zzjc().zze("Fetching config failed. code, error", (Object)n, (Object)throwable);
                    this.zzky().zzbz(string);
                    this.zzacv.zzgj().zzalu.set(this.zzacv.zzbt().currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzacv.zzgj().zzalv.set(this.zzacv.zzbt().currentTimeMillis());
                    }
                    this.zzlg();
                }
                this.zzjh().setTransactionSuccessful();
            }
            finally {
                this.zzjh().endTransaction();
            }
            return;
        }
        finally {
            this.zzase = false;
            this.zzlh();
        }
    }

    @WorkerThread
    private final void zzlg() {
        long l;
        long l2;
        long l3;
        block15: {
            String string;
            this.zzab();
            this.zzlc();
            if (!this.zzlk()) {
                return;
            }
            if (this.zzasa > 0L) {
                l3 = this.zzacv.zzbt().elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzasa);
                if (l2 > 0L) {
                    this.zzacv.zzgi().zzjc().zzg("Upload has been suspended. Will update scheduling later in approximately ms", (Object)l2);
                    this.zzla().unregister();
                    this.zzlb().cancel();
                    return;
                }
                this.zzasa = 0L;
            }
            if (!this.zzacv.zzkg() || !this.zzlf()) {
                this.zzacv.zzgi().zzjc().log("Nothing to upload or uploading impossible");
                this.zzla().unregister();
                this.zzlb().cancel();
                return;
            }
            zzjt zzjt2 = this;
            long l4 = zzjt2.zzacv.zzbt().currentTimeMillis();
            long l5 = Math.max(0L, (Long)zzez.zzaje.get());
            boolean bl = zzjt2.zzjh().zzib() || zzjt2.zzjh().zzhw();
            long l6 = bl ? (!TextUtils.isEmpty((CharSequence)(string = zzjt2.zzacv.zzgk().zzhs())) && !".none.".equals(string) ? Math.max(0L, (Long)zzez.zzaiz.get()) : Math.max(0L, (Long)zzez.zzaiy.get())) : Math.max(0L, (Long)zzez.zzaix.get());
            long l7 = zzjt2.zzacv.zzgj().zzalt.get();
            long l8 = zzjt2.zzacv.zzgj().zzalu.get();
            long l9 = zzjt2.zzjh().zzhy();
            long l10 = zzjt2.zzjh().zzhz();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l4 - Math.abs(l11 - l4);
                l7 = l4 - Math.abs(l7 - l4);
                l8 = l4 - Math.abs(l8 - l4);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l5;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l6;
                }
                if (!zzjt2.zzjf().zza(l12, l6)) {
                    l13 = l12 + l6;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    for (int i = 0; i < Math.min(20, Math.max(0, (Integer)zzez.zzajg.get())); ++i) {
                        long l15 = 1L << i;
                        if ((l14 += Math.max(0L, (Long)zzez.zzajf.get()) * l15) <= l8) continue;
                        l = l14;
                        break block15;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzacv.zzgi().zzjc().log("Next upload time is 0");
            this.zzla().unregister();
            this.zzlb().cancel();
            return;
        }
        if (!this.zzkz().zzex()) {
            this.zzacv.zzgi().zzjc().log("No network");
            this.zzla().zzeu();
            this.zzlb().cancel();
            return;
        }
        l2 = this.zzacv.zzgj().zzalv.get();
        long l16 = Math.max(0L, (Long)zzez.zzaiv.get());
        if (!this.zzjf().zza(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzla().unregister();
        long l17 = l3 - this.zzacv.zzbt().currentTimeMillis();
        if (l17 <= 0L) {
            l17 = Math.max(0L, (Long)zzez.zzaja.get());
            this.zzacv.zzgj().zzalt.set(this.zzacv.zzbt().currentTimeMillis());
        }
        this.zzacv.zzgi().zzjc().zzg("Upload scheduled in approximately ms", (Object)l17);
        this.zzlb().zzh(l17);
    }

    @WorkerThread
    final void zzg(Runnable runnable) {
        this.zzab();
        if (this.zzasb == null) {
            this.zzasb = new ArrayList<Runnable>();
        }
        this.zzasb.add(runnable);
    }

    @WorkerThread
    private final void zzlh() {
        this.zzab();
        if (this.zzase || this.zzasf || this.zzasg) {
            this.zzacv.zzgi().zzjc().zzd("Not stopping services. fetch, network, upload", (Object)this.zzase, (Object)this.zzasf, (Object)this.zzasg);
            return;
        }
        this.zzacv.zzgi().zzjc().log("Stopping uploading service(s)");
        if (this.zzasb == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzasb.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.zzasb.clear();
    }

    @WorkerThread
    private final Boolean zzc(zzea zzea2) {
        try {
            if (zzea2.zzgu() != Integer.MIN_VALUE) {
                int n = Wrappers.packageManager((Context)this.zzacv.getContext()).getPackageInfo((String)zzea2.zzah(), (int)0).versionCode;
                if (zzea2.zzgu() == (long)n) {
                    return true;
                }
            } else {
                String string = Wrappers.packageManager((Context)this.zzacv.getContext()).getPackageInfo((String)zzea2.zzah(), (int)0).versionName;
                if (zzea2.zzag() != null && zzea2.zzag().equals(string)) {
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zzli() {
        this.zzab();
        String string = "google_app_measurement.db";
        File file = this.zzacv.getContext().getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzasi = new RandomAccessFile(file2, "rw").getChannel();
            this.zzash = this.zzasi.tryLock();
            if (this.zzash != null) {
                this.zzacv.zzgi().zzjc().log("Storage concurrent access okay");
                return true;
            }
            this.zzacv.zzgi().zziv().log("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzacv.zzgi().zziv().zzg("Failed to acquire storage lock", (Object)fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzacv.zzgi().zziv().zzg("Failed to access storage lock file", (Object)iOException);
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final int zza(FileChannel fileChannel) {
        this.zzab();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzacv.zzgi().zziv().log("Bad channel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzacv.zzgi().zziy().zzg("Unexpected data length. Bytes read", (Object)n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzacv.zzgi().zziv().zzg("Failed to read from channel", (Object)iOException);
        }
        return n;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zza(int n, FileChannel fileChannel) {
        this.zzab();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzacv.zzgi().zziv().log("Bad channel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzacv.zzgi().zziv().zzg("Error writing to channel. Bytes written", (Object)fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzacv.zzgi().zziv().zzg("Failed to write to channel", (Object)iOException);
            return false;
        }
    }

    @WorkerThread
    final void zzlj() {
        this.zzab();
        this.zzlc();
        if (!this.zzarz) {
            this.zzacv.zzgi().zzja().log("This instance being marked as an uploader");
            zzjt zzjt2 = this;
            zzjt2.zzab();
            zzjt2.zzlc();
            if (zzjt2.zzlk() && zzjt2.zzli()) {
                int n;
                int n2 = zzjt2.zza(zzjt2.zzasi);
                int n3 = n = zzjt2.zzacv.zzfz().zzis();
                int n4 = n2;
                zzjt zzjt3 = zzjt2;
                zzjt3.zzab();
                if (n4 > n3) {
                    zzjt3.zzacv.zzgi().zziv().zze("Panic: can't downgrade version. Previous, current version", (Object)n4, (Object)n3);
                } else if (n4 < n3) {
                    if (zzjt3.zza(n3, zzjt3.zzasi)) {
                        zzjt3.zzacv.zzgi().zzjc().zze("Storage version upgraded. Previous, current version", (Object)n4, (Object)n3);
                    } else {
                        zzjt3.zzacv.zzgi().zziv().zze("Storage version upgrade failed. Previous, current version", (Object)n4, (Object)n3);
                    }
                }
            }
            this.zzarz = true;
            this.zzlg();
        }
    }

    @WorkerThread
    private final boolean zzlk() {
        this.zzab();
        this.zzlc();
        return this.zzarz;
    }

    @VisibleForTesting
    @WorkerThread
    final void zzd(zzeb zzeb2) {
        if (this.zzasj != null) {
            this.zzask = new ArrayList<Long>();
            this.zzask.addAll(this.zzasj);
        }
        String string = zzeb2.packageName;
        zzek zzek2 = this.zzjh();
        Preconditions.checkNotEmpty((String)string);
        zzek2.zzab();
        zzek2.zzch();
        try {
            SQLiteDatabase sQLiteDatabase = zzek2.getWritableDatabase();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray) + sQLiteDatabase.delete("main_event_params", "app_id=?", stringArray);
            if (n > 0) {
                zzek2.zzgi().zzjc().zze("Reset analytics data. app, records", (Object)string, (Object)n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzek2.zzgi().zziv().zze("Error resetting analytics data. appId, error", zzfi.zzbp((String)string), (Object)sQLiteException);
        }
        zzeb zzeb3 = this.zza(this.zzacv.getContext(), zzeb2.packageName, zzeb2.zzafa, zzeb2.zzafk, zzeb2.zzafm, zzeb2.zzafn, zzeb2.zzaga);
        if (!this.zzacv.zzgk().zzbc(zzeb2.packageName) || zzeb2.zzafk) {
            this.zzf(zzeb3);
        }
    }

    private final zzeb zza(Context context, String string, String string2, boolean bl, boolean bl2, boolean bl3, long l) {
        String string3 = "Unknown";
        String string4 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string5 = "Unknown";
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            this.zzacv.zzgi().zziv().log("PackageManager is null, can not log app install information");
            return null;
        }
        try {
            string3 = packageManager.getInstallerPackageName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzacv.zzgi().zziv().zzg("Error retrieving installer package name. appId", zzfi.zzbp((String)string));
        }
        if (string3 == null) {
            string3 = "manual_install";
        } else if ("com.android.vending".equals(string3)) {
            string3 = "";
        }
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(string, 0);
            if (packageInfo != null) {
                CharSequence charSequence = Wrappers.packageManager((Context)context).getApplicationLabel(string);
                if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                    string5 = charSequence.toString();
                }
                string4 = packageInfo.versionName;
                n = packageInfo.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzacv.zzgi().zziv().zze("Error retrieving newly installed package info. appId, appName", zzfi.zzbp((String)string), (Object)string5);
            return null;
        }
        long l2 = 0L;
        zzee zzee2 = this.zzacv.zzgl();
        long l3 = 0L;
        if (this.zzacv.zzgk().zzbd(string)) {
            l3 = l;
        }
        return new zzeb(string, string2, string4, (long)n, string3, this.zzacv.zzgk().zzgw(), this.zzacv.zzgg().zzd(context, string), null, bl, false, "", l2, l3, 0, bl2, bl3, false);
    }

    @WorkerThread
    final void zzb(zzka zzka2, zzeb zzeb2) {
        this.zzab();
        this.zzlc();
        if (TextUtils.isEmpty((CharSequence)zzeb2.zzafa)) {
            return;
        }
        if (!zzeb2.zzafk) {
            this.zzg(zzeb2);
            return;
        }
        int n = this.zzacv.zzgg().zzcj(zzka2.name);
        if (n != 0) {
            this.zzacv.zzgg();
            String string = zzkd.zza((String)zzka2.name, (int)24, (boolean)true);
            int n2 = zzka2.name != null ? zzka2.name.length() : 0;
            this.zzacv.zzgg().zza(zzeb2.packageName, n, "_ev", string, n2);
            return;
        }
        n = this.zzacv.zzgg().zzi(zzka2.name, zzka2.getValue());
        if (n != 0) {
            this.zzacv.zzgg();
            String string = zzkd.zza((String)zzka2.name, (int)24, (boolean)true);
            Object object = zzka2.getValue();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzacv.zzgg().zza(zzeb2.packageName, n, "_ev", string, n3);
            return;
        }
        Object object = this.zzacv.zzgg().zzj(zzka2.name, zzka2.getValue());
        if (object == null) {
            return;
        }
        zzkc zzkc2 = new zzkc(zzeb2.packageName, zzka2.origin, zzka2.name, zzka2.zzast, object);
        this.zzacv.zzgi().zzjb().zze("Setting user property", (Object)this.zzacv.zzgf().zzbo(zzkc2.name), object);
        this.zzjh().beginTransaction();
        try {
            this.zzg(zzeb2);
            boolean bl = this.zzjh().zza(zzkc2);
            this.zzjh().setTransactionSuccessful();
            if (bl) {
                this.zzacv.zzgi().zzjb().zze("User property set", (Object)this.zzacv.zzgf().zzbo(zzkc2.name), zzkc2.value);
            } else {
                this.zzacv.zzgi().zziv().zze("Too many unique user properties are set. Ignoring user property", (Object)this.zzacv.zzgf().zzbo(zzkc2.name), zzkc2.value);
                this.zzacv.zzgg().zza(zzeb2.packageName, 9, null, null, 0);
            }
            return;
        }
        finally {
            this.zzjh().endTransaction();
        }
    }

    @WorkerThread
    final void zzc(zzka zzka2, zzeb zzeb2) {
        this.zzab();
        this.zzlc();
        if (TextUtils.isEmpty((CharSequence)zzeb2.zzafa)) {
            return;
        }
        if (!zzeb2.zzafk) {
            this.zzg(zzeb2);
            return;
        }
        this.zzacv.zzgi().zzjb().zzg("Removing user property", (Object)this.zzacv.zzgf().zzbo(zzka2.name));
        this.zzjh().beginTransaction();
        try {
            this.zzg(zzeb2);
            this.zzjh().zzg(zzeb2.packageName, zzka2.name);
            this.zzjh().setTransactionSuccessful();
            this.zzacv.zzgi().zzjb().zzg("User property removed", (Object)this.zzacv.zzgf().zzbo(zzka2.name));
            return;
        }
        finally {
            this.zzjh().endTransaction();
        }
    }

    final void zzb(zzjs zzjs2) {
        ++this.zzasc;
    }

    final void zzll() {
        ++this.zzasd;
    }

    final zzgn zzlm() {
        return this.zzacv;
    }

    @WorkerThread
    final void zzf(zzeb zzeb2) {
        int n;
        this.zzab();
        this.zzlc();
        Preconditions.checkNotNull((Object)zzeb2);
        Preconditions.checkNotEmpty((String)zzeb2.packageName);
        if (TextUtils.isEmpty((CharSequence)zzeb2.zzafa)) {
            return;
        }
        zzea zzea2 = this.zzjh().zzbf(zzeb2.packageName);
        if (zzea2 != null && TextUtils.isEmpty((CharSequence)zzea2.getGmpAppId()) && !TextUtils.isEmpty((CharSequence)zzeb2.zzafa)) {
            zzea2.zzx(0L);
            this.zzjh().zza(zzea2);
            this.zzky().zzca(zzeb2.packageName);
        }
        if (!zzeb2.zzafk) {
            this.zzg(zzeb2);
            return;
        }
        long l = zzeb2.zzaga;
        if (l == 0L) {
            l = this.zzacv.zzbt().currentTimeMillis();
        }
        if ((n = zzeb2.zzagb) != 0 && n != 1) {
            this.zzacv.zzgi().zziy().zze("Incorrect app type, assuming installed app. appId, appType", zzfi.zzbp((String)zzeb2.packageName), (Object)n);
            n = 0;
        }
        this.zzjh().beginTransaction();
        try {
            zzex zzex2;
            Bundle bundle;
            long l2 = l;
            zzeb zzeb3 = zzeb2;
            zzjt zzjt2 = this;
            zzea zzea3 = zzjt2.zzjh().zzbf(zzeb3.packageName);
            if (zzea3 != null && zzea3.getGmpAppId() != null && !zzea3.getGmpAppId().equals(zzeb3.zzafa)) {
                zzjt2.zzacv.zzgi().zziy().zzg("New GMP App Id passed in. Removing cached database data. appId", zzfi.zzbp((String)zzea3.zzah()));
                String string = zzea3.zzah();
                zzek zzek2 = zzjt2.zzjh();
                zzek2.zzch();
                zzek2.zzab();
                Preconditions.checkNotEmpty((String)string);
                try {
                    SQLiteDatabase sQLiteDatabase = zzek2.getWritableDatabase();
                    String[] stringArray = new String[]{string};
                    int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("event_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("property_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
                    if (n2 > 0) {
                        zzek2.zzgi().zzjc().zze("Deleted application data. app, records", (Object)string, (Object)n2);
                    }
                }
                catch (SQLiteException sQLiteException) {
                    zzek2.zzgi().zziv().zze("Error deleting application data. appId, error", zzfi.zzbp((String)string), (Object)sQLiteException);
                }
                zzea3 = null;
            }
            if (zzea3 != null) {
                if (zzea3.zzgu() != Integer.MIN_VALUE) {
                    if (zzea3.zzgu() != zzeb3.zzafg) {
                        bundle = new Bundle();
                        bundle.putString("_pv", zzea3.zzag());
                        zzex2 = new zzex("_au", new zzeu(bundle), "auto", l2);
                        zzjt2.zzb(zzex2, zzeb3);
                    }
                } else if (zzea3.zzag() != null && !zzea3.zzag().equals(zzeb3.zztg)) {
                    bundle = new Bundle();
                    bundle.putString("_pv", zzea3.zzag());
                    zzex2 = new zzex("_au", new zzeu(bundle), "auto", l2);
                    zzjt2.zzb(zzex2, zzeb3);
                }
            }
            this.zzg(zzeb2);
            zzet zzet2 = null;
            if (n == 0) {
                zzet2 = this.zzjh().zzf(zzeb2.packageName, "_f");
            } else if (n == 1) {
                zzet2 = this.zzjh().zzf(zzeb2.packageName, "_v");
            }
            if (zzet2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    zzka zzka2;
                    zzka zzka3 = new zzka("_fot", l, (Object)l3, "auto");
                    this.zzb(zzka3, zzeb2);
                    l2 = l;
                    zzeb3 = zzeb2;
                    zzjt2 = this;
                    zzjt2.zzab();
                    zzjt2.zzlc();
                    zzea3 = new Bundle();
                    zzea3.putLong("_c", 1L);
                    zzea3.putLong("_r", 1L);
                    zzea3.putLong("_uwa", 0L);
                    zzea3.putLong("_pfo", 0L);
                    zzea3.putLong("_sys", 0L);
                    zzea3.putLong("_sysu", 0L);
                    if (zzjt2.zzacv.zzgk().zzbc(zzeb3.packageName) && zzeb3.zzagc) {
                        zzea3.putLong("_dac", 1L);
                    }
                    if (zzjt2.zzacv.getContext().getPackageManager() == null) {
                        zzjt2.zzacv.zzgi().zziv().zzg("PackageManager is null, first open report might be inaccurate. appId", zzfi.zzbp((String)zzeb3.packageName));
                    } else {
                        zzex2 = null;
                        try {
                            zzex2 = Wrappers.packageManager((Context)zzjt2.zzacv.getContext()).getPackageInfo(zzeb3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzjt2.zzacv.zzgi().zziv().zze("Package info is null, first open report might be inaccurate. appId", zzfi.zzbp((String)zzeb3.packageName), (Object)nameNotFoundException);
                        }
                        if (zzex2 != null && zzex2.firstInstallTime != 0L) {
                            boolean bl = false;
                            if (zzex2.firstInstallTime != zzex2.lastUpdateTime) {
                                zzea3.putLong("_uwa", 1L);
                            } else {
                                bl = true;
                            }
                            zzka2 = new zzka("_fi", l2, (Object)(bl ? 1L : 0L), "auto");
                            zzjt2.zzb(zzka2, zzeb3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = Wrappers.packageManager((Context)zzjt2.zzacv.getContext()).getApplicationInfo(zzeb3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzjt2.zzacv.zzgi().zziv().zze("Application info is null, first open report might be inaccurate. appId", zzfi.zzbp((String)zzeb3.packageName), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                zzea3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                zzea3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    String string = zzeb3.packageName;
                    zzek zzek3 = zzjt2.zzjh();
                    Preconditions.checkNotEmpty((String)string);
                    zzek3.zzab();
                    zzek3.zzch();
                    long l4 = zzek3.zzm(string, "first_open_count");
                    if (l4 >= 0L) {
                        zzea3.putLong("_pfo", l4);
                    }
                    zzka2 = new zzex("_f", new zzeu((Bundle)zzea3), "auto", l2);
                    zzjt2.zzb((zzex)zzka2, zzeb3);
                } else if (n == 1) {
                    zzka zzka4 = new zzka("_fvt", l, (Object)l3, "auto");
                    this.zzb(zzka4, zzeb2);
                    l2 = l;
                    zzeb3 = zzeb2;
                    zzjt2 = this;
                    zzjt2.zzab();
                    zzjt2.zzlc();
                    zzea3 = new Bundle();
                    zzea3.putLong("_c", 1L);
                    zzea3.putLong("_r", 1L);
                    if (zzjt2.zzacv.zzgk().zzbc(zzeb3.packageName) && zzeb3.zzagc) {
                        zzea3.putLong("_dac", 1L);
                    }
                    bundle = new zzex("_v", new zzeu((Bundle)zzea3), "auto", l2);
                    zzjt2.zzb((zzex)bundle, zzeb3);
                }
                l2 = l;
                zzeb3 = zzeb2;
                zzjt2 = this;
                zzea3 = new Bundle();
                zzea3.putLong("_et", 1L);
                bundle = new zzex("_e", new zzeu((Bundle)zzea3), "auto", l2);
                zzjt2.zzb((zzex)bundle, zzeb3);
            } else if (zzeb2.zzafz) {
                l2 = l;
                zzeb3 = zzeb2;
                zzjt2 = this;
                zzea3 = new Bundle();
                bundle = new zzex("_cd", new zzeu((Bundle)zzea3), "auto", l2);
                zzjt2.zzb((zzex)bundle, zzeb3);
            }
            this.zzjh().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzjh().endTransaction();
        }
    }

    @WorkerThread
    private final zzeb zzce(String string) {
        zzea zzea2 = this.zzjh().zzbf(string);
        if (zzea2 == null || TextUtils.isEmpty((CharSequence)zzea2.zzag())) {
            this.zzacv.zzgi().zzjb().zzg("No app data available; dropping", (Object)string);
            return null;
        }
        Boolean bl = this.zzc(zzea2);
        if (bl != null && !bl.booleanValue()) {
            this.zzacv.zzgi().zziv().zzg("App version does not match; dropping. appId", zzfi.zzbp((String)string));
            return null;
        }
        return new zzeb(string, zzea2.getGmpAppId(), zzea2.zzag(), zzea2.zzgu(), zzea2.zzgv(), zzea2.zzgw(), zzea2.zzgx(), null, zzea2.isMeasurementEnabled(), false, zzea2.zzgr(), zzea2.zzhk(), 0L, 0, zzea2.zzhl(), zzea2.zzhm(), false);
    }

    @WorkerThread
    final void zze(zzef zzef2) {
        zzeb zzeb2 = this.zzce(zzef2.packageName);
        if (zzeb2 != null) {
            this.zzb(zzef2, zzeb2);
        }
    }

    @WorkerThread
    final void zzb(zzef zzef2, zzeb zzeb2) {
        Preconditions.checkNotNull((Object)zzef2);
        Preconditions.checkNotEmpty((String)zzef2.packageName);
        Preconditions.checkNotNull((Object)zzef2.origin);
        Preconditions.checkNotNull((Object)zzef2.zzage);
        Preconditions.checkNotEmpty((String)zzef2.zzage.name);
        this.zzab();
        this.zzlc();
        if (TextUtils.isEmpty((CharSequence)zzeb2.zzafa)) {
            return;
        }
        if (!zzeb2.zzafk) {
            this.zzg(zzeb2);
            return;
        }
        zzef zzef3 = new zzef(zzef2);
        new zzef(zzef2).active = false;
        this.zzjh().beginTransaction();
        try {
            boolean bl = false;
            zzef zzef4 = this.zzjh().zzi(zzef3.packageName, zzef3.zzage.name);
            if (zzef4 != null && !zzef4.origin.equals(zzef3.origin)) {
                this.zzacv.zzgi().zziy().zzd("Updating a conditional user property with different origin. name, origin, origin (from DB)", (Object)this.zzacv.zzgf().zzbo(zzef3.zzage.name), (Object)zzef3.origin, (Object)zzef4.origin);
            }
            if (zzef4 != null && zzef4.active) {
                zzef3.origin = zzef4.origin;
                zzef3.creationTimestamp = zzef4.creationTimestamp;
                zzef3.triggerTimeout = zzef4.triggerTimeout;
                zzef3.triggerEventName = zzef4.triggerEventName;
                zzef3.zzagg = zzef4.zzagg;
                zzef3.active = zzef4.active;
                zzef3.zzage = new zzka(zzef3.zzage.name, zzef4.zzage.zzast, zzef3.zzage.getValue(), zzef4.zzage.origin);
            } else if (TextUtils.isEmpty((CharSequence)zzef3.triggerEventName)) {
                zzef3.zzage = new zzka(zzef3.zzage.name, zzef3.creationTimestamp, zzef3.zzage.getValue(), zzef3.zzage.origin);
                zzef3.active = true;
                bl = true;
            }
            if (zzef3.active) {
                zzka zzka2 = zzef3.zzage;
                zzkc zzkc2 = new zzkc(zzef3.packageName, zzef3.origin, zzka2.name, zzka2.zzast, zzka2.getValue());
                if (this.zzjh().zza(zzkc2)) {
                    this.zzacv.zzgi().zzjb().zzd("User property updated immediately", (Object)zzef3.packageName, (Object)this.zzacv.zzgf().zzbo(zzkc2.name), zzkc2.value);
                } else {
                    this.zzacv.zzgi().zziv().zzd("(2)Too many active user properties, ignoring", zzfi.zzbp((String)zzef3.packageName), (Object)this.zzacv.zzgf().zzbo(zzkc2.name), zzkc2.value);
                }
                if (bl && zzef3.zzagg != null) {
                    zzex zzex2 = new zzex(zzef3.zzagg, zzef3.creationTimestamp);
                    this.zzc(zzex2, zzeb2);
                }
            }
            if (this.zzjh().zza(zzef3)) {
                this.zzacv.zzgi().zzjb().zzd("Conditional property added", (Object)zzef3.packageName, (Object)this.zzacv.zzgf().zzbo(zzef3.zzage.name), zzef3.zzage.getValue());
            } else {
                this.zzacv.zzgi().zziv().zzd("Too many conditional properties, ignoring", zzfi.zzbp((String)zzef3.packageName), (Object)this.zzacv.zzgf().zzbo(zzef3.zzage.name), zzef3.zzage.getValue());
            }
            this.zzjh().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzjh().endTransaction();
        }
    }

    @WorkerThread
    final void zzf(zzef zzef2) {
        zzeb zzeb2 = this.zzce(zzef2.packageName);
        if (zzeb2 != null) {
            this.zzc(zzef2, zzeb2);
        }
    }

    @WorkerThread
    final void zzc(zzef zzef2, zzeb zzeb2) {
        Preconditions.checkNotNull((Object)zzef2);
        Preconditions.checkNotEmpty((String)zzef2.packageName);
        Preconditions.checkNotNull((Object)zzef2.zzage);
        Preconditions.checkNotEmpty((String)zzef2.zzage.name);
        this.zzab();
        this.zzlc();
        if (TextUtils.isEmpty((CharSequence)zzeb2.zzafa)) {
            return;
        }
        if (!zzeb2.zzafk) {
            this.zzg(zzeb2);
            return;
        }
        this.zzjh().beginTransaction();
        try {
            this.zzg(zzeb2);
            zzef zzef3 = this.zzjh().zzi(zzef2.packageName, zzef2.zzage.name);
            if (zzef3 != null) {
                this.zzacv.zzgi().zzjb().zze("Removing conditional user property", (Object)zzef2.packageName, (Object)this.zzacv.zzgf().zzbo(zzef2.zzage.name));
                this.zzjh().zzj(zzef2.packageName, zzef2.zzage.name);
                if (zzef3.active) {
                    this.zzjh().zzg(zzef2.packageName, zzef2.zzage.name);
                }
                if (zzef2.zzagh != null) {
                    Bundle bundle = null;
                    if (zzef2.zzagh.zzahg != null) {
                        bundle = zzef2.zzagh.zzahg.zzin();
                    }
                    zzex zzex2 = this.zzacv.zzgg().zza(zzef2.packageName, zzef2.zzagh.name, bundle, zzef3.origin, zzef2.zzagh.zzahr, true, false);
                    this.zzc(zzex2, zzeb2);
                }
            } else {
                this.zzacv.zzgi().zziy().zze("Conditional user property doesn't exist", zzfi.zzbp((String)zzef2.packageName), (Object)this.zzacv.zzgf().zzbo(zzef2.zzage.name));
            }
            this.zzjh().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzjh().endTransaction();
        }
    }

    @WorkerThread
    private final zzea zzg(zzeb zzeb2) {
        this.zzab();
        this.zzlc();
        Preconditions.checkNotNull((Object)zzeb2);
        Preconditions.checkNotEmpty((String)zzeb2.packageName);
        zzea zzea2 = this.zzjh().zzbf(zzeb2.packageName);
        String string = this.zzacv.zzgj().zzbs(zzeb2.packageName);
        boolean bl = false;
        if (zzea2 == null) {
            zzea2 = new zzea(this.zzacv, zzeb2.packageName);
            zzea2.zzam(this.zzacv.zzfz().zzir());
            zzea2.zzao(string);
            bl = true;
        } else if (!string.equals(zzea2.zzgq())) {
            zzea2.zzao(string);
            zzea2.zzam(this.zzacv.zzfz().zzir());
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzeb2.zzafa) && !zzeb2.zzafa.equals(zzea2.getGmpAppId())) {
            zzea2.zzan(zzeb2.zzafa);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzeb2.zzafc) && !zzeb2.zzafc.equals(zzea2.zzgr())) {
            zzea2.zzap(zzeb2.zzafc);
            bl = true;
        }
        if (zzeb2.zzafi != 0L && zzeb2.zzafi != zzea2.zzgw()) {
            zzea2.zzu(zzeb2.zzafi);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzeb2.zztg) && !zzeb2.zztg.equals(zzea2.zzag())) {
            zzea2.setAppVersion(zzeb2.zztg);
            bl = true;
        }
        if (zzeb2.zzafg != zzea2.zzgu()) {
            zzea2.zzt(zzeb2.zzafg);
            bl = true;
        }
        if (zzeb2.zzafh != null && !zzeb2.zzafh.equals(zzea2.zzgv())) {
            zzea2.zzaq(zzeb2.zzafh);
            bl = true;
        }
        if (zzeb2.zzafj != zzea2.zzgx()) {
            zzea2.zzv(zzeb2.zzafj);
            bl = true;
        }
        if (zzeb2.zzafk != zzea2.isMeasurementEnabled()) {
            zzea2.setMeasurementEnabled(zzeb2.zzafk);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzeb2.zzafy) && !zzeb2.zzafy.equals(zzea2.zzhi())) {
            zzea2.zzar(zzeb2.zzafy);
            bl = true;
        }
        if (zzeb2.zzafl != zzea2.zzhk()) {
            zzea2.zzaf(zzeb2.zzafl);
            bl = true;
        }
        if (zzeb2.zzafm != zzea2.zzhl()) {
            zzea2.zzd(zzeb2.zzafm);
            bl = true;
        }
        if (zzeb2.zzafn != zzea2.zzhm()) {
            zzea2.zze(zzeb2.zzafn);
            bl = true;
        }
        if (bl) {
            this.zzjh().zza(zzea2);
        }
        return zzea2;
    }

    @WorkerThread
    public final byte[] zza(@NonNull zzex zzex2, @Size(min=1L) String string) {
        Long l;
        this.zzlc();
        this.zzab();
        this.zzacv.zzfu();
        Preconditions.checkNotNull((Object)zzex2);
        Preconditions.checkNotEmpty((String)string);
        zzkt zzkt2 = new zzkt();
        this.zzjh().beginTransaction();
        try {
            zzet zzet2;
            long l2;
            zzkx zzkx2;
            zzea zzea2 = this.zzjh().zzbf(string);
            if (zzea2 == null) {
                this.zzacv.zzgi().zzjb().zzg("Log and bundle not available. package_name", (Object)string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zzea2.isMeasurementEnabled()) {
                this.zzacv.zzgi().zzjb().zzg("Log and bundle disabled. package_name", (Object)string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (("_iap".equals(zzex2.name) || "ecommerce_purchase".equals(zzex2.name)) && !this.zza(string, zzex2)) {
                this.zzacv.zzgi().zziy().zzg("Failed to handle purchase event at single event bundle creation. appId", zzfi.zzbp((String)string));
            }
            boolean bl = this.zzacv.zzgk().zzaw(string);
            l = 0L;
            if (bl && "_e".equals(zzex2.name)) {
                if (zzex2.zzahg == null || zzex2.zzahg.size() == 0) {
                    this.zzacv.zzgi().zziy().zzg("The engagement event does not contain any parameters. appId", zzfi.zzbp((String)string));
                } else if (zzex2.zzahg.getLong("_et") == null) {
                    this.zzacv.zzgi().zziy().zzg("The engagement event does not include duration. appId", zzfi.zzbp((String)string));
                } else {
                    l = zzex2.zzahg.getLong("_et");
                }
            }
            zzku zzku2 = new zzku();
            zzkt2.zzavf = new zzku[]{zzku2};
            zzku2.zzavh = 1;
            zzku2.zzavp = "android";
            zzku2.zzth = zzea2.zzah();
            zzku2.zzafh = zzea2.zzgv();
            zzku2.zztg = zzea2.zzag();
            long l3 = zzea2.zzgu();
            zzku2.zzawb = l3 == Integer.MIN_VALUE ? null : Integer.valueOf((int)l3);
            zzku2.zzavt = zzea2.zzgw();
            zzku2.zzafa = zzea2.getGmpAppId();
            zzku2.zzavx = zzea2.zzgx();
            if (this.zzacv.isEnabled() && zzeh.zzht() && this.zzacv.zzgk().zzau(zzku2.zzth)) {
                zzku2.zzawh = null;
            }
            Pair pair = this.zzacv.zzgj().zzbr(zzea2.zzah());
            if (zzea2.zzhl() && pair != null && !TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
                zzku2.zzavv = (String)pair.first;
                zzku2.zzavw = (Boolean)pair.second;
            }
            this.zzacv.zzge().zzch();
            zzku2.zzavr = Build.MODEL;
            this.zzacv.zzge().zzch();
            zzku2.zzavq = Build.VERSION.RELEASE;
            zzku2.zzavs = (int)this.zzacv.zzge().zzik();
            zzku2.zzahd = this.zzacv.zzge().zzil();
            zzku2.zzaez = zzea2.getAppInstanceId();
            zzku2.zzafc = zzea2.zzgr();
            List<zzkc> list = this.zzjh().zzbe(zzea2.zzah());
            zzku2.zzavj = new zzkx[list.size()];
            zzkc zzkc2 = null;
            if (bl) {
                zzkc2 = this.zzjh().zzh(zzku2.zzth, "_lte");
                if (zzkc2 == null || zzkc2.value == null) {
                    zzkc2 = new zzkc(zzku2.zzth, "auto", "_lte", this.zzacv.zzbt().currentTimeMillis(), (Object)l);
                } else if (l > 0L) {
                    zzkc2 = new zzkc(zzku2.zzth, "auto", "_lte", this.zzacv.zzbt().currentTimeMillis(), (Object)((Long)zzkc2.value + l));
                }
            }
            zzkx zzkx3 = null;
            for (int i = 0; i < list.size(); ++i) {
                zzku2.zzavj[i] = zzkx2 = new zzkx();
                zzkx2.name = list.get((int)i).name;
                zzkx2.zzaws = list.get((int)i).zzast;
                this.zzjf().zza(zzkx2, list.get((int)i).value);
                if (!bl || !"_lte".equals(zzkx2.name)) continue;
                zzkx3 = zzkx2;
                zzkx2.zzave = (Long)zzkc2.value;
                zzkx3.zzaws = this.zzacv.zzbt().currentTimeMillis();
            }
            if (bl && zzkx3 == null) {
                zzkx3 = new zzkx();
                new zzkx().name = "_lte";
                zzkx3.zzaws = this.zzacv.zzbt().currentTimeMillis();
                zzkx3.zzave = (Long)zzkc2.value;
                zzku2.zzavj = Arrays.copyOf(zzku2.zzavj, zzku2.zzavj.length + 1);
                zzku2.zzavj[zzku2.zzavj.length - 1] = zzkx3;
            }
            if (l > 0L) {
                this.zzjh().zza(zzkc2);
            }
            Bundle bundle = zzex2.zzahg.zzin();
            if ("_iap".equals(zzex2.name)) {
                bundle.putLong("_c", 1L);
                this.zzacv.zzgi().zzjb().log("Marking in-app purchase as real-time");
                bundle.putLong("_r", 1L);
            }
            bundle.putString("_o", zzex2.origin);
            if (this.zzacv.zzgg().zzcn(zzku2.zzth)) {
                this.zzacv.zzgg().zza(bundle, "_dbg", (Object)1L);
                this.zzacv.zzgg().zza(bundle, "_r", (Object)1L);
            }
            if ((zzkx2 = this.zzjh().zzf(string, zzex2.name)) == null) {
                l2 = 0L;
                zzet2 = new zzet(string, zzex2.name, 1L, 0L, zzex2.zzahr, 0L, null, null, null);
                this.zzjh().zza(zzet2);
            } else {
                l2 = ((zzet)zzkx2).zzahj;
                zzet2 = zzkx2.zzah(zzex2.zzahr).zzim();
                this.zzjh().zza(zzet2);
            }
            zzes zzes2 = new zzes(this.zzacv, zzex2.origin, string, zzex2.name, zzex2.zzahr, l2, bundle);
            zzkr zzkr2 = new zzkr();
            zzku2.zzavi = new zzkr[]{zzkr2};
            zzkr2.zzavb = zzes2.timestamp;
            zzkr2.name = zzes2.name;
            zzkr2.zzavc = zzes2.zzahf;
            zzkr2.zzava = new zzks[zzes2.zzahg.size()];
            int n = 0;
            for (String string2 : zzes2.zzahg) {
                zzks zzks2 = new zzks();
                zzkr2.zzava[n++] = zzks2;
                zzks2.name = string2;
                Object object = zzes2.zzahg.get(string2);
                this.zzjf().zza(zzks2, object);
            }
            zzku2.zzawa = this.zza(zzea2.zzah(), zzku2.zzavj, zzku2.zzavi);
            zzku2.zzavl = zzkr2.zzavb;
            zzku2.zzavm = zzkr2.zzavb;
            long l4 = zzea2.zzgt();
            zzku2.zzavo = l4 != 0L ? Long.valueOf(l4) : null;
            long l5 = zzea2.zzgs();
            if (l5 == 0L) {
                l5 = l4;
            }
            zzku2.zzavn = l5 != 0L ? Long.valueOf(l5) : null;
            zzea2.zzhb();
            zzku2.zzavy = (int)zzea2.zzgy();
            zzku2.zzavu = this.zzacv.zzgk().zzgw();
            zzku2.zzavk = this.zzacv.zzbt().currentTimeMillis();
            zzku2.zzavz = Boolean.TRUE;
            zzea2.zzr(zzku2.zzavl.longValue());
            zzea2.zzs(zzku2.zzavm.longValue());
            this.zzjh().zza(zzea2);
            this.zzjh().setTransactionSuccessful();
        }
        finally {
            this.zzjh().endTransaction();
        }
        try {
            byte[] byArray;
            byte[] byArray2 = byArray = new byte[zzkt2.zzwb()];
            l = zzacb.zzb((byte[])byArray, (int)0, (int)byArray2.length);
            zzkt2.zza((zzacb)l);
            l.zzvt();
            return this.zzjf().zzb(byArray);
        }
        catch (IOException iOException) {
            this.zzacv.zzgi().zziv().zze("Data loss. Failed to bundle and serialize. appId", zzfi.zzbp((String)string), (Object)iOException);
            return null;
        }
    }

    final String zzh(zzeb zzeb2) {
        Future future = this.zzacv.zzgh().zzb((Callable)new zzjx(this, zzeb2));
        try {
            return (String)future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzacv.zzgi().zziv().zze("Failed to get app instance id. appId", zzfi.zzbp((String)zzeb2.packageName), (Object)exception);
            return null;
        }
    }

    final void zzm(boolean bl) {
        this.zzlg();
    }

    static /* synthetic */ void zza(zzjt zzjt2, zzjy zzjy2) {
        zzjt2.zza(zzjy2);
    }

    static /* synthetic */ zzea zza(zzjt zzjt2, zzeb zzeb2) {
        return zzjt2.zzg(zzeb2);
    }

    final class zza
    implements zzem {
        zzku zzasp;
        List<Long> zzasq;
        List<zzkr> zzasr;
        private long zzass;

        private zza() {
        }

        @Override
        public final void zzb(zzku zzku2) {
            Preconditions.checkNotNull((Object)((Object)zzku2));
            this.zzasp = zzku2;
        }

        @Override
        public final boolean zza(long l, zzkr zzkr2) {
            Preconditions.checkNotNull((Object)((Object)zzkr2));
            if (this.zzasr == null) {
                this.zzasr = new ArrayList<zzkr>();
            }
            if (this.zzasq == null) {
                this.zzasq = new ArrayList<Long>();
            }
            if (this.zzasr.size() > 0 && zza.zza(this.zzasr.get(0)) != zza.zza(zzkr2)) {
                return false;
            }
            long l2 = this.zzass + (long)zzkr2.zzwb();
            if (l2 >= (long)Math.max(0, (Integer)zzez.zzaim.get())) {
                return false;
            }
            this.zzass = l2;
            this.zzasr.add(zzkr2);
            this.zzasq.add(l);
            return this.zzasr.size() < Math.max(1, (Integer)zzez.zzain.get());
        }

        private static long zza(zzkr zzkr2) {
            return zzkr2.zzavb / 1000L / 60L / 60L;
        }

        /* synthetic */ zza(zzju zzju2) {
            this();
        }
    }
}

