/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.support.annotation.BinderThread;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzbw;
import com.google.android.gms.measurement.internal.zzbx;
import com.google.android.gms.measurement.internal.zzby;
import com.google.android.gms.measurement.internal.zzbz;
import com.google.android.gms.measurement.internal.zzca;
import com.google.android.gms.measurement.internal.zzcb;
import com.google.android.gms.measurement.internal.zzcc;
import com.google.android.gms.measurement.internal.zzcd;
import com.google.android.gms.measurement.internal.zzce;
import com.google.android.gms.measurement.internal.zzcf;
import com.google.android.gms.measurement.internal.zzcg;
import com.google.android.gms.measurement.internal.zzch;
import com.google.android.gms.measurement.internal.zzci;
import com.google.android.gms.measurement.internal.zzcj;
import com.google.android.gms.measurement.internal.zzck;
import com.google.android.gms.measurement.internal.zzcl;
import com.google.android.gms.measurement.internal.zzcm;
import com.google.android.gms.measurement.internal.zzcn;
import com.google.android.gms.measurement.internal.zzfa;
import com.google.android.gms.measurement.internal.zzfh;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzbv
extends zzah {
    private final zzfa zzamz;
    private Boolean zzaql;
    @Nullable
    private String zzaqm;

    public zzbv(zzfa zzfa2) {
        this(zzfa2, null);
    }

    private zzbv(zzfa zzfa2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zzfa2);
        this.zzamz = zzfa2;
        this.zzaqm = null;
    }

    @BinderThread
    public final void zzb(zzh zzh2) {
        this.zzb(zzh2, false);
        this.zze(new zzbw(this, zzh2));
    }

    @BinderThread
    public final void zza(zzad zzad2, zzh zzh2) {
        Preconditions.checkNotNull((Object)zzad2);
        this.zzb(zzh2, false);
        this.zze(new zzcg(this, zzad2, zzh2));
    }

    @VisibleForTesting
    final zzad zzb(zzad zzad2, zzh zzh2) {
        String string;
        zzh zzh3 = zzh2;
        zzad zzad3 = zzad2;
        zzbv zzbv2 = this;
        if (!"_cmp".equals(zzad3.name) || zzad3.zzaid == null || zzad3.zzaid.size() == 0 ? false : !TextUtils.isEmpty((CharSequence)(string = zzad3.zzaid.getString("_cis"))) && ("referrer broadcast".equals(string) || "referrer API".equals(string)) && zzbv2.zzamz.zzgq().zzbg(zzh3.packageName)) {
            this.zzamz.zzgo().zzjj().zzg("Event has been filtered ", (Object)zzad2.toString());
            return new zzad("_cmpx", zzad2.zzaid, zzad2.origin, zzad2.zzaip);
        }
        return zzad2;
    }

    @BinderThread
    public final void zza(zzad zzad2, String string, String string2) {
        Preconditions.checkNotNull((Object)zzad2);
        Preconditions.checkNotEmpty((String)string);
        this.zzc(string, true);
        this.zze(new zzch(this, zzad2, string));
    }

    @BinderThread
    public final byte[] zza(zzad zzad2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzad2);
        this.zzc(string, true);
        this.zzamz.zzgo().zzjk().zzg("Log and bundle. event", (Object)this.zzamz.zzgl().zzbs(zzad2.name));
        long l = this.zzamz.zzbx().nanoTime() / 1000000L;
        Future future = this.zzamz.zzgn().zzc((Callable)new zzci(this, zzad2, string));
        try {
            byte[] byArray = (byte[])future.get();
            if (byArray == null) {
                this.zzamz.zzgo().zzjd().zzg("Log and bundle returned null. appId", zzap.zzbv((String)string));
                byArray = new byte[]{};
            }
            long l2 = this.zzamz.zzbx().nanoTime() / 1000000L;
            this.zzamz.zzgo().zzjk().zzd("Log and bundle processed. event, size, time_ms", (Object)this.zzamz.zzgl().zzbs(zzad2.name), (Object)byArray.length, (Object)(l2 - l));
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzamz.zzgo().zzjd().zzd("Failed to log and bundle. appId, event, error", zzap.zzbv((String)string), (Object)this.zzamz.zzgl().zzbs(zzad2.name), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzfh zzfh2, zzh zzh2) {
        Preconditions.checkNotNull((Object)zzfh2);
        this.zzb(zzh2, false);
        if (zzfh2.getValue() == null) {
            this.zze(new zzcj(this, zzfh2, zzh2));
            return;
        }
        this.zze(new zzck(this, zzfh2, zzh2));
    }

    @BinderThread
    public final List<zzfh> zza(zzh zzh2, boolean bl) {
        this.zzb(zzh2, false);
        Future future = this.zzamz.zzgn().zzb((Callable)new zzcl(this, zzh2));
        try {
            List list = (List)future.get();
            ArrayList<zzfh> arrayList = new ArrayList<zzfh>(list.size());
            for (zzfj zzfj2 : list) {
                if (!bl && zzfk.zzcv((String)zzfj2.name)) continue;
                arrayList.add(new zzfh(zzfj2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzamz.zzgo().zzjd().zze("Failed to get user attributes. appId", zzap.zzbv((String)zzh2.packageName), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzh zzh2) {
        this.zzb(zzh2, false);
        this.zze(new zzcm(this, zzh2));
    }

    @BinderThread
    private final void zzb(zzh zzh2, boolean bl) {
        Preconditions.checkNotNull((Object)zzh2);
        this.zzc(zzh2.packageName, false);
        this.zzamz.zzgm().zzt(zzh2.zzafx, zzh2.zzagk);
    }

    @BinderThread
    private final void zzc(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzamz.zzgo().zzjd().zzbx("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzbv zzbv2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzbv2 = this;
                    if (!bl2) break block9;
                    if (zzbv2.zzaql == null) {
                        zzbv2.zzaql = "com.google.android.gms".equals(zzbv2.zzaqm) || UidVerifier.isGooglePlayServicesUid((Context)zzbv2.zzamz.getContext(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzbv2.zzamz.getContext()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzbv2.zzaql.booleanValue()) break block10;
                }
                if (zzbv2.zzaqm == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzbv2.zzamz.getContext(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzbv2.zzaqm = string2;
                }
                if (!string2.equals(zzbv2.zzaqm)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zzamz.zzgo().zzjd().zzg("Measurement Service called with invalid calling package. appId", zzap.zzbv((String)string));
            throw securityException;
        }
    }

    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zze(new zzcn(this, string2, string3, string, l));
    }

    @BinderThread
    public final String zzc(zzh zzh2) {
        this.zzb(zzh2, false);
        return this.zzamz.zzh(zzh2);
    }

    @BinderThread
    public final void zza(zzl zzl2, zzh zzh2) {
        Preconditions.checkNotNull((Object)zzl2);
        Preconditions.checkNotNull((Object)zzl2.zzahb);
        this.zzb(zzh2, false);
        zzl zzl3 = new zzl(zzl2);
        new zzl(zzl2).packageName = zzh2.packageName;
        if (zzl2.zzahb.getValue() == null) {
            this.zze(new zzbx(this, zzl3, zzh2));
            return;
        }
        this.zze(new zzby(this, zzl3, zzh2));
    }

    @BinderThread
    public final void zzb(zzl zzl2) {
        Preconditions.checkNotNull((Object)zzl2);
        Preconditions.checkNotNull((Object)zzl2.zzahb);
        this.zzc(zzl2.packageName, true);
        zzl zzl3 = new zzl(zzl2);
        if (zzl2.zzahb.getValue() == null) {
            this.zze(new zzbz(this, zzl3));
            return;
        }
        this.zze(new zzca(this, zzl3));
    }

    @BinderThread
    public final List<zzfh> zza(String string, String string2, boolean bl, zzh zzh2) {
        this.zzb(zzh2, false);
        Future future = this.zzamz.zzgn().zzb((Callable)new zzcb(this, zzh2, string, string2));
        try {
            List list = (List)future.get();
            ArrayList<zzfh> arrayList = new ArrayList<zzfh>(list.size());
            for (zzfj zzfj2 : list) {
                if (!bl && zzfk.zzcv((String)zzfj2.name)) continue;
                arrayList.add(new zzfh(zzfj2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzamz.zzgo().zzjd().zze("Failed to get user attributes. appId", zzap.zzbv((String)zzh2.packageName), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzfh> zza(String string, String string2, String string3, boolean bl) {
        this.zzc(string, true);
        Future future = this.zzamz.zzgn().zzb((Callable)new zzcc(this, string, string2, string3));
        try {
            List list = (List)future.get();
            ArrayList<zzfh> arrayList = new ArrayList<zzfh>(list.size());
            for (zzfj zzfj2 : list) {
                if (!bl && zzfk.zzcv((String)zzfj2.name)) continue;
                arrayList.add(new zzfh(zzfj2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzamz.zzgo().zzjd().zze("Failed to get user attributes. appId", zzap.zzbv((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzl> zza(String string, String string2, zzh zzh2) {
        this.zzb(zzh2, false);
        Future future = this.zzamz.zzgn().zzb((Callable)new zzcd(this, zzh2, string, string2));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzamz.zzgo().zzjd().zzg("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzl> zze(String string, String string2, String string3) {
        this.zzc(string, true);
        Future future = this.zzamz.zzgn().zzb((Callable)new zzce(this, string, string2, string3));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzamz.zzgo().zzjd().zzg("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final void zzd(zzh zzh2) {
        this.zzc(zzh2.packageName, false);
        this.zze(new zzcf(this, zzh2));
    }

    @VisibleForTesting
    private final void zze(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (((Boolean)zzaf.zzakv.get()).booleanValue() && this.zzamz.zzgn().zzkb()) {
            runnable.run();
            return;
        }
        this.zzamz.zzgn().zzc(runnable);
    }

    static /* synthetic */ zzfa zza(zzbv zzbv2) {
        return zzbv2.zzamz;
    }
}

