/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Parcelable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzfu;
import com.google.android.gms.internal.measurement.zzfv;
import com.google.android.gms.internal.measurement.zzfy;
import com.google.android.gms.internal.measurement.zzgf;
import com.google.android.gms.internal.measurement.zzgg;
import com.google.android.gms.internal.measurement.zzgi;
import com.google.android.gms.internal.measurement.zzgj;
import com.google.android.gms.internal.measurement.zzyx;
import com.google.android.gms.internal.measurement.zzyy;
import com.google.android.gms.internal.measurement.zzza;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzev;
import com.google.android.gms.measurement.internal.zzez;
import com.google.android.gms.measurement.internal.zzfa;
import com.google.android.gms.measurement.internal.zzfh;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzl;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzr;
import com.google.android.gms.measurement.internal.zzt;
import com.google.android.gms.measurement.internal.zzy;
import com.google.android.gms.measurement.internal.zzz;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

final class zzq
extends zzez {
    private static final String[] zzahi = new String[]{"last_bundled_timestamp", "ALTER TABLE events ADD COLUMN last_bundled_timestamp INTEGER;", "last_bundled_day", "ALTER TABLE events ADD COLUMN last_bundled_day INTEGER;", "last_sampled_complex_event_id", "ALTER TABLE events ADD COLUMN last_sampled_complex_event_id INTEGER;", "last_sampling_rate", "ALTER TABLE events ADD COLUMN last_sampling_rate INTEGER;", "last_exempt_from_sampling", "ALTER TABLE events ADD COLUMN last_exempt_from_sampling INTEGER;"};
    private static final String[] zzahj = new String[]{"origin", "ALTER TABLE user_attributes ADD COLUMN origin TEXT;"};
    private static final String[] zzahk = new String[]{"app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;", "app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;", "gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;", "dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;", "measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;", "last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;", "day", "ALTER TABLE apps ADD COLUMN day INTEGER;", "daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;", "daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;", "daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;", "remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;", "config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;", "failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;", "app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;", "firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;", "daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;", "daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;", "health_monitor_sample", "ALTER TABLE apps ADD COLUMN health_monitor_sample TEXT;", "android_id", "ALTER TABLE apps ADD COLUMN android_id INTEGER;", "adid_reporting_enabled", "ALTER TABLE apps ADD COLUMN adid_reporting_enabled INTEGER;", "ssaid_reporting_enabled", "ALTER TABLE apps ADD COLUMN ssaid_reporting_enabled INTEGER;", "admob_app_id", "ALTER TABLE apps ADD COLUMN admob_app_id TEXT;", "linked_admob_app_id", "ALTER TABLE apps ADD COLUMN linked_admob_app_id TEXT;"};
    private static final String[] zzahl = new String[]{"realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;"};
    private static final String[] zzahm = new String[]{"has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;", "retry_count", "ALTER TABLE queue ADD COLUMN retry_count INTEGER;"};
    private static final String[] zzahn = new String[]{"previous_install_count", "ALTER TABLE app2 ADD COLUMN previous_install_count INTEGER;"};
    private final zzt zzaho;
    private final zzev zzahp = new zzev(this.zzbx());

    zzq(zzfa zzfa2) {
        super(zzfa2);
        String string = "google_app_measurement.db";
        this.zzaho = new zzt(this, this.getContext(), string);
    }

    @Override
    protected final boolean zzgt() {
        return false;
    }

    @WorkerThread
    public final void beginTransaction() {
        this.zzcl();
        this.getWritableDatabase().beginTransaction();
    }

    @WorkerThread
    public final void setTransactionSuccessful() {
        this.zzcl();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    @WorkerThread
    public final void endTransaction() {
        this.zzcl();
        this.getWritableDatabase().endTransaction();
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzgo().zzjd().zze("Database error", (Object)string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray, long l) {
        long l2;
        block7: {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery(string, stringArray);
                if (cursor.moveToFirst()) {
                    long l3 = cursor.getLong(0);
                    return l3;
                }
                l2 = l;
                if (cursor == null) break block7;
            }
            cursor.close();
        }
        return l2;
    }

    @VisibleForTesting
    @WorkerThread
    final SQLiteDatabase getWritableDatabase() {
        this.zzaf();
        try {
            return this.zzaho.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzgo().zzjg().zzg("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    @WorkerThread
    public final zzz zzg(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzaf();
        this.zzcl();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("events", new String[]{"lifetime_count", "current_bundle_count", "last_fire_timestamp", "last_bundled_timestamp", "last_bundled_day", "last_sampled_complex_event_id", "last_sampling_rate", "last_exempt_from_sampling"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            long l4 = cursor.isNull(3) ? 0L : cursor.getLong(3);
            Long l5 = cursor.isNull(4) ? null : Long.valueOf(cursor.getLong(4));
            Long l6 = cursor.isNull(5) ? null : Long.valueOf(cursor.getLong(5));
            Long l7 = cursor.isNull(6) ? null : Long.valueOf(cursor.getLong(6));
            Boolean bl = null;
            if (!cursor.isNull(7)) {
                bl = cursor.getLong(7) == 1L;
            }
            zzz zzz2 = new zzz(string, string2, l, l2, l3, l4, l5, l6, l7, bl);
            if (cursor.moveToNext()) {
                this.zzgo().zzjd().zzg("Got multiple records for event aggregates, expected one. appId", zzap.zzbv((String)string));
            }
            zzz zzz3 = zzz2;
            return zzz3;
        }
    }

    @WorkerThread
    public final void zza(zzz zzz2) {
        Preconditions.checkNotNull((Object)zzz2);
        this.zzaf();
        this.zzcl();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzz2.zztt);
        contentValues.put("name", zzz2.name);
        contentValues.put("lifetime_count", Long.valueOf(zzz2.zzaie));
        contentValues.put("current_bundle_count", Long.valueOf(zzz2.zzaif));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzz2.zzaig));
        contentValues.put("last_bundled_timestamp", Long.valueOf(zzz2.zzaih));
        contentValues.put("last_bundled_day", zzz2.zzaii);
        contentValues.put("last_sampled_complex_event_id", zzz2.zzaij);
        contentValues.put("last_sampling_rate", zzz2.zzaik);
        Long l = null;
        if (zzz2.zzail != null && zzz2.zzail.booleanValue()) {
            l = 1L;
        }
        contentValues.put("last_exempt_from_sampling", l);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("events", null, contentValues, 5) == -1L) {
                this.zzgo().zzjd().zzg("Failed to insert/update event aggregates (got -1). appId", zzap.zzbv((String)zzz2.zztt));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzgo().zzjd().zze("Error storing event aggregates. appId", zzap.zzbv((String)zzz2.zztt), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final void zzh(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzaf();
        this.zzcl();
        try {
            int n = this.getWritableDatabase().delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            this.zzgo().zzjl().zzg("Deleted user attribute rows", (Object)n);
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzgo().zzjd().zzd("Error deleting user attribute. appId", zzap.zzbv((String)string), (Object)this.zzgl().zzbu(string2), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final boolean zza(zzfj zzfj2) {
        Preconditions.checkNotNull((Object)zzfj2);
        this.zzaf();
        this.zzcl();
        if (this.zzi(zzfj2.zztt, zzfj2.name) == null) {
            if (zzfk.zzcq((String)zzfj2.name)) {
                if (this.zza("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzfj2.zztt}) >= 25L) {
                    return false;
                }
            } else {
                long l = this.zza("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{zzfj2.zztt, zzfj2.origin});
                if (this.zzgq().zze(zzfj2.zztt, zzaf.zzalj) ? !"_ap".equals(zzfj2.name) && l >= 25L : l >= 25L) {
                    return false;
                }
            }
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzfj2.zztt);
        contentValues.put("origin", zzfj2.origin);
        contentValues.put("name", zzfj2.name);
        contentValues.put("set_timestamp", Long.valueOf(zzfj2.zzaue));
        zzq.zza(contentValues, "value", zzfj2.value);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("user_attributes", null, contentValues, 5) == -1L) {
                this.zzgo().zzjd().zzg("Failed to insert/update user property (got -1). appId", zzap.zzbv((String)zzfj2.zztt));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgo().zzjd().zze("Error storing user property. appId", zzap.zzbv((String)zzfj2.zztt), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzfj zzi(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzaf();
        this.zzcl();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"set_timestamp", "value", "origin"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zza(cursor, 1);
            String string3 = cursor.getString(2);
            zzfj zzfj2 = new zzfj(string, string3, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzgo().zzjd().zzg("Got multiple records for user property, expected one. appId", zzap.zzbv((String)string));
            }
            zzfj zzfj3 = zzfj2;
            return zzfj3;
        }
    }

    @WorkerThread
    public final List<zzfj> zzbk(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzaf();
        this.zzcl();
        ArrayList<zzfj> arrayList = new ArrayList<zzfj>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "origin", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", "1000");
            if (!cursor.moveToFirst()) {
                ArrayList<zzfj> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                if (string2 == null) {
                    string2 = "";
                }
                long l = cursor.getLong(2);
                Object object2 = this.zza(cursor, 3);
                if (object2 == null) {
                    this.zzgo().zzjd().zzg("Read invalid user property value, ignoring it. appId", zzap.zzbv((String)string));
                    continue;
                }
                zzfj zzfj2 = new zzfj(string, string2, (String)object, l, object2);
                arrayList.add(zzfj2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final List<zzfj> zzb(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        this.zzaf();
        this.zzcl();
        ArrayList<zzfj> arrayList = new ArrayList<zzfj>();
        try (Cursor cursor = null;){
            Object object;
            ArrayList<String> arrayList2 = new ArrayList<String>(3);
            arrayList2.add(string);
            StringBuilder stringBuilder = new StringBuilder("app_id=?");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                arrayList2.add(string2);
                stringBuilder.append(" and origin=?");
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                arrayList2.add(String.valueOf(string3).concat("*"));
                stringBuilder.append(" and name glob ?");
            }
            String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "set_timestamp", "value", "origin"}, stringBuilder.toString(), stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzfj> arrayList3 = arrayList;
                return arrayList3;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzgo().zzjd().zzg("Read more than the max allowed user properties, ignoring excess", (Object)1000);
                    break;
                }
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zza(cursor, 2);
                string2 = cursor.getString(3);
                if (object2 == null) {
                    this.zzgo().zzjd().zzd("(2)Read invalid user property value, ignoring it", zzap.zzbv((String)string), (Object)string2, (Object)string3);
                    continue;
                }
                zzfj zzfj2 = new zzfj(string, string2, (String)object, l, object2);
                arrayList.add(zzfj2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final boolean zza(zzl zzl2) {
        Preconditions.checkNotNull((Object)zzl2);
        this.zzaf();
        this.zzcl();
        if (this.zzi(zzl2.packageName, zzl2.zzahb.name) == null && this.zza("SELECT COUNT(1) FROM conditional_properties WHERE app_id=?", new String[]{zzl2.packageName}) >= 1000L) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzl2.packageName);
        contentValues.put("origin", zzl2.origin);
        contentValues.put("name", zzl2.zzahb.name);
        zzq.zza(contentValues, "value", zzl2.zzahb.getValue());
        contentValues.put("active", Boolean.valueOf(zzl2.active));
        contentValues.put("trigger_event_name", zzl2.triggerEventName);
        contentValues.put("trigger_timeout", Long.valueOf(zzl2.triggerTimeout));
        this.zzgm();
        contentValues.put("timed_out_event", zzfk.zza((Parcelable)zzl2.zzahc));
        contentValues.put("creation_timestamp", Long.valueOf(zzl2.creationTimestamp));
        this.zzgm();
        contentValues.put("triggered_event", zzfk.zza((Parcelable)zzl2.zzahd));
        contentValues.put("triggered_timestamp", Long.valueOf(zzl2.zzahb.zzaue));
        contentValues.put("time_to_live", Long.valueOf(zzl2.timeToLive));
        this.zzgm();
        contentValues.put("expired_event", zzfk.zza((Parcelable)zzl2.zzahe));
        try {
            if (this.getWritableDatabase().insertWithOnConflict("conditional_properties", null, contentValues, 5) == -1L) {
                this.zzgo().zzjd().zzg("Failed to insert/update conditional user property (got -1)", zzap.zzbv((String)zzl2.packageName));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgo().zzjd().zze("Error storing conditional user property", zzap.zzbv((String)zzl2.packageName), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzl zzj(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzaf();
        this.zzcl();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"origin", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            String string3 = cursor.getString(0);
            Object object = this.zza(cursor, 1);
            boolean bl = cursor.getInt(2) != 0;
            String string4 = cursor.getString(3);
            long l = cursor.getLong(4);
            zzad zzad2 = (zzad)this.zzjo().zza(cursor.getBlob(5), zzad.CREATOR);
            long l2 = cursor.getLong(6);
            zzad zzad3 = (zzad)this.zzjo().zza(cursor.getBlob(7), zzad.CREATOR);
            long l3 = cursor.getLong(8);
            long l4 = cursor.getLong(9);
            zzad zzad4 = (zzad)this.zzjo().zza(cursor.getBlob(10), zzad.CREATOR);
            zzfh zzfh2 = new zzfh(string2, l3, object, string3);
            zzl zzl2 = new zzl(string, string3, zzfh2, l2, bl, string4, zzad2, l, zzad3, l4, zzad4);
            if (cursor.moveToNext()) {
                this.zzgo().zzjd().zze("Got multiple records for conditional property, expected one", zzap.zzbv((String)string), (Object)this.zzgl().zzbu(string2));
            }
            zzl zzl3 = zzl2;
            return zzl3;
        }
    }

    @WorkerThread
    public final int zzk(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzaf();
        this.zzcl();
        try {
            return this.getWritableDatabase().delete("conditional_properties", "app_id=? and name=?", new String[]{string, string2});
        }
        catch (SQLiteException sQLiteException) {
            this.zzgo().zzjd().zzd("Error deleting conditional property", zzap.zzbv((String)string), (Object)this.zzgl().zzbu(string2), (Object)sQLiteException);
            return 0;
        }
    }

    @WorkerThread
    public final List<zzl> zzc(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        this.zzaf();
        this.zzcl();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(string);
        StringBuilder stringBuilder = new StringBuilder("app_id=?");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
            stringBuilder.append(" and origin=?");
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            arrayList.add(String.valueOf(string3).concat("*"));
            stringBuilder.append(" and name glob ?");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return this.zzb(stringBuilder.toString(), stringArray);
    }

    public final List<zzl> zzb(String string, String[] stringArray) {
        this.zzaf();
        this.zzcl();
        ArrayList<zzl> arrayList = new ArrayList<zzl>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"app_id", "origin", "name", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, string, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzl> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzgo().zzjd().zzg("Read more than the max allowed conditional properties, ignoring extra", (Object)1000);
                    break;
                }
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                String string3 = cursor.getString(2);
                Object object2 = this.zza(cursor, 3);
                boolean bl = cursor.getInt(4) != 0;
                String string4 = cursor.getString(5);
                long l = cursor.getLong(6);
                zzad zzad2 = (zzad)this.zzjo().zza(cursor.getBlob(7), zzad.CREATOR);
                long l2 = cursor.getLong(8);
                zzad zzad3 = (zzad)this.zzjo().zza(cursor.getBlob(9), zzad.CREATOR);
                long l3 = cursor.getLong(10);
                long l4 = cursor.getLong(11);
                zzad zzad4 = (zzad)this.zzjo().zza(cursor.getBlob(12), zzad.CREATOR);
                zzfh zzfh2 = new zzfh(string3, l3, object2, string2);
                zzl zzl2 = new zzl((String)object, string2, zzfh2, l2, bl, string4, zzad2, l, zzad3, l4, zzad4);
                arrayList.add(zzl2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final zzg zzbl(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzaf();
        this.zzcl();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count", "daily_realtime_events_count", "health_monitor_sample", "android_id", "adid_reporting_enabled", "ssaid_reporting_enabled", "admob_app_id"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            zzg zzg2 = new zzg(this.zzamz.zzmb(), string);
            zzg2.zzam(cursor.getString(0));
            zzg2.zzan(cursor.getString(1));
            zzg2.zzap(cursor.getString(2));
            zzg2.zzx(cursor.getLong(3));
            zzg2.zzs(cursor.getLong(4));
            zzg2.zzt(cursor.getLong(5));
            zzg2.setAppVersion(cursor.getString(6));
            zzg2.zzar(cursor.getString(7));
            zzg2.zzv(cursor.getLong(8));
            zzg2.zzw(cursor.getLong(9));
            zzg2.setMeasurementEnabled(cursor.isNull(10) || cursor.getInt(10) != 0);
            zzg2.zzaa(cursor.getLong(11));
            zzg2.zzab(cursor.getLong(12));
            zzg2.zzac(cursor.getLong(13));
            zzg2.zzad(cursor.getLong(14));
            zzg2.zzy(cursor.getLong(15));
            zzg2.zzz(cursor.getLong(16));
            zzg2.zzu(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zzg2.zzaq(cursor.getString(18));
            zzg2.zzaf(cursor.getLong(19));
            zzg2.zzae(cursor.getLong(20));
            zzg2.zzas(cursor.getString(21));
            zzg2.zzag(cursor.isNull(22) ? 0L : cursor.getLong(22));
            zzg2.zze(cursor.isNull(23) || cursor.getInt(23) != 0);
            zzg2.zzf(cursor.isNull(24) || cursor.getInt(24) != 0);
            zzg2.zzao(cursor.getString(25));
            zzg2.zzgv();
            if (cursor.moveToNext()) {
                this.zzgo().zzjd().zzg("Got multiple records for app, expected one. appId", zzap.zzbv((String)string));
            }
            zzg zzg3 = zzg2;
            return zzg3;
        }
    }

    @WorkerThread
    public final void zza(zzg zzg2) {
        Preconditions.checkNotNull((Object)zzg2);
        this.zzaf();
        this.zzcl();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzg2.zzal());
        contentValues.put("app_instance_id", zzg2.getAppInstanceId());
        contentValues.put("gmp_app_id", zzg2.getGmpAppId());
        contentValues.put("resettable_device_id_hash", zzg2.zzgx());
        contentValues.put("last_bundle_index", Long.valueOf(zzg2.zzhe()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zzg2.zzgy()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zzg2.zzgz()));
        contentValues.put("app_version", zzg2.zzak());
        contentValues.put("app_store", zzg2.zzhb());
        contentValues.put("gmp_version", Long.valueOf(zzg2.zzhc()));
        contentValues.put("dev_cert_hash", Long.valueOf(zzg2.zzhd()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zzg2.isMeasurementEnabled()));
        contentValues.put("day", Long.valueOf(zzg2.zzhi()));
        contentValues.put("daily_public_events_count", Long.valueOf(zzg2.zzhj()));
        contentValues.put("daily_events_count", Long.valueOf(zzg2.zzhk()));
        contentValues.put("daily_conversions_count", Long.valueOf(zzg2.zzhl()));
        contentValues.put("config_fetched_time", Long.valueOf(zzg2.zzhf()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zzg2.zzhg()));
        contentValues.put("app_version_int", Long.valueOf(zzg2.zzha()));
        contentValues.put("firebase_instance_id", zzg2.getFirebaseInstanceId());
        contentValues.put("daily_error_events_count", Long.valueOf(zzg2.zzhn()));
        contentValues.put("daily_realtime_events_count", Long.valueOf(zzg2.zzhm()));
        contentValues.put("health_monitor_sample", zzg2.zzho());
        contentValues.put("android_id", Long.valueOf(zzg2.zzhq()));
        contentValues.put("adid_reporting_enabled", Boolean.valueOf(zzg2.zzhr()));
        contentValues.put("ssaid_reporting_enabled", Boolean.valueOf(zzg2.zzhs()));
        contentValues.put("admob_app_id", zzg2.zzgw());
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            if ((long)sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{zzg2.zzal()}) == 0L && sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5) == -1L) {
                this.zzgo().zzjd().zzg("Failed to insert/update app (got -1). appId", zzap.zzbv((String)zzg2.zzal()));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzgo().zzjd().zze("Error storing app. appId", zzap.zzbv((String)zzg2.zzal()), (Object)sQLiteException);
            return;
        }
    }

    public final long zzbm(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzaf();
        this.zzcl();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String string2 = string;
            int n = this.zzgq().zzb(string2, zzaf.zzajs);
            n = Math.min(1000000, n);
            String string3 = String.valueOf(Math.max(0, n));
            return sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string3});
        }
        catch (SQLiteException sQLiteException) {
            this.zzgo().zzjd().zze("Error deleting over the limit events. appId", zzap.zzbv((String)string), (Object)sQLiteException);
            return 0L;
        }
    }

    @WorkerThread
    public final zzr zza(long l, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        Preconditions.checkNotEmpty((String)string);
        this.zzaf();
        this.zzcl();
        String[] stringArray = new String[]{string};
        zzr zzr2 = new zzr();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzgo().zzjg().zzg("Not updating daily counts, app is not known. appId", zzap.zzbv((String)string));
                zzr zzr3 = zzr2;
                return zzr3;
            }
            if (cursor.getLong(0) == l) {
                zzr2.zzahr = cursor.getLong(1);
                zzr2.zzahq = cursor.getLong(2);
                zzr2.zzahs = cursor.getLong(3);
                zzr2.zzaht = cursor.getLong(4);
                zzr2.zzahu = cursor.getLong(5);
            }
            if (bl) {
                ++zzr2.zzahr;
            }
            if (bl2) {
                ++zzr2.zzahq;
            }
            if (bl3) {
                ++zzr2.zzahs;
            }
            if (bl4) {
                ++zzr2.zzaht;
            }
            if (bl5) {
                ++zzr2.zzahu;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zzr2.zzahq));
            contentValues.put("daily_events_count", Long.valueOf(zzr2.zzahr));
            contentValues.put("daily_conversions_count", Long.valueOf(zzr2.zzahs));
            contentValues.put("daily_error_events_count", Long.valueOf(zzr2.zzaht));
            contentValues.put("daily_realtime_events_count", Long.valueOf(zzr2.zzahu));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zzr zzr4 = zzr2;
            return zzr4;
        }
    }

    @WorkerThread
    public final byte[] zzbn(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzaf();
        this.zzcl();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"remote_config"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            if (cursor.moveToNext()) {
                this.zzgo().zzjd().zzg("Got multiple records for app config, expected one. appId", zzap.zzbv((String)string));
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @WorkerThread
    public final boolean zza(zzgi zzgi2, boolean bl) {
        byte[] byArray;
        this.zzaf();
        this.zzcl();
        Preconditions.checkNotNull((Object)((Object)zzgi2));
        Preconditions.checkNotEmpty((String)zzgi2.zztt);
        Preconditions.checkNotNull((Object)zzgi2.zzaxf);
        this.zzif();
        long l = this.zzbx().currentTimeMillis();
        if (zzgi2.zzaxf < l - zzn.zzhw() || zzgi2.zzaxf > l + zzn.zzhw()) {
            this.zzgo().zzjg().zzd("Storing bundle outside of the max uploading time span. appId, now, timestamp", zzap.zzbv((String)zzgi2.zztt), (Object)l, (Object)zzgi2.zzaxf);
        }
        try {
            byte[] byArray2;
            byte[] byArray3 = byArray2 = new byte[zzgi2.zzvu()];
            zzyy zzyy2 = zzyy.zzk((byte[])byArray2, (int)0, (int)byArray3.length);
            zzgi2.zza(zzyy2);
            zzyy2.zzyt();
            byArray = this.zzjo().zzb(byArray2);
        }
        catch (IOException iOException) {
            this.zzgo().zzjd().zze("Data loss. Failed to serialize bundle. appId", zzap.zzbv((String)zzgi2.zztt), (Object)iOException);
            return false;
        }
        this.zzgo().zzjl().zzg("Saving bundle, size", (Object)byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzgi2.zztt);
        contentValues.put("bundle_end_timestamp", zzgi2.zzaxf);
        contentValues.put("data", byArray);
        contentValues.put("has_realtime", Integer.valueOf(bl ? 1 : 0));
        if (zzgi2.zzayc != null) {
            contentValues.put("retry_count", zzgi2.zzayc);
        }
        try {
            if (this.getWritableDatabase().insert("queue", null, contentValues) == -1L) {
                this.zzgo().zzjd().zzg("Failed to insert bundle (got -1). appId", zzap.zzbv((String)zzgi2.zztt));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgo().zzjd().zze("Error storing bundle. appId", zzap.zzbv((String)zzgi2.zztt), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    public final String zzid() {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            String string = "select app_id from queue order by has_realtime desc, rowid asc limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
            return null;
        }
    }

    public final boolean zzie() {
        return this.zza("select count(1) > 0 from queue where has_realtime = 1", (String[])null) != 0L;
    }

    @WorkerThread
    public final List<Pair<zzgi, Long>> zzb(String string, int n, int n2) {
        this.zzaf();
        this.zzcl();
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((n2 > 0 ? 1 : 0) != 0);
        Preconditions.checkNotEmpty((String)string);
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("queue", new String[]{"rowid", "data", "retry_count"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzgi, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzgi, Long>> arrayList = new ArrayList<Pair<zzgi, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzjo().zza((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzgo().zzjd().zze("Failed to unzip queued bundle. appId", zzap.zzbv((String)string), (Object)iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                byte[] byArray2 = byArray;
                object = zzyx.zzj((byte[])byArray, (int)0, (int)byArray2.length);
                zzgi zzgi2 = new zzgi();
                try {
                    zzgi2.zza((zzyx)object);
                }
                catch (IOException iOException) {
                    this.zzgo().zzjd().zze("Failed to merge queued bundle. appId", zzap.zzbv((String)string), (Object)iOException);
                    continue;
                }
                if (!cursor.isNull(2)) {
                    zzgi2.zzayc = cursor.getInt(2);
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzgi, Long>)Pair.create((Object)((Object)zzgi2), (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzgi, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @WorkerThread
    final void zzif() {
        this.zzaf();
        this.zzcl();
        if (!this.zzil()) {
            return;
        }
        long l = this.zzgp().zzanh.get();
        long l2 = this.zzbx().elapsedRealtime();
        if (Math.abs(l2 - l) > (Long)zzaf.zzakb.get()) {
            this.zzgp().zzanh.set(l2);
            zzq zzq2 = this;
            zzq2.zzaf();
            zzq2.zzcl();
            if (zzq2.zzil()) {
                SQLiteDatabase sQLiteDatabase = zzq2.getWritableDatabase();
                String[] stringArray = new String[]{String.valueOf(zzq2.zzbx().currentTimeMillis()), String.valueOf(zzn.zzhw())};
                int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
                if (n > 0) {
                    zzq2.zzgo().zzjl().zzg("Deleted stale rows. rowsDeleted", (Object)n);
                }
            }
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zzc(List<Long> list) {
        this.zzaf();
        this.zzcl();
        Preconditions.checkNotNull(list);
        Preconditions.checkNotZero((int)list.size());
        if (!this.zzil()) {
            return;
        }
        String string = TextUtils.join((CharSequence)",", list);
        String string2 = new StringBuilder(2 + String.valueOf(string).length()).append("(").append(string).append(")").toString();
        if (this.zza(new StringBuilder(80 + String.valueOf(string2).length()).append("SELECT COUNT(1) FROM queue WHERE rowid IN ").append(string2).append(" AND retry_count =  2147483647 LIMIT 1").toString(), (String[])null) > 0L) {
            this.zzgo().zzjg().zzbx("The number of upload retries exceeds the limit. Will remain unchanged.");
        }
        try {
            this.getWritableDatabase().execSQL(new StringBuilder(127 + String.valueOf(string2).length()).append("UPDATE queue SET retry_count = IFNULL(retry_count, 0) + 1 WHERE rowid IN ").append(string2).append(" AND (retry_count IS NULL OR retry_count < 2147483647)").toString());
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzgo().zzjd().zzg("Error incrementing retry count. error", (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    final void zza(String string, zzfu[] zzfuArray) {
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzfuArray);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            int n;
            String string2 = string;
            zzq zzq2 = this;
            zzq2.zzcl();
            zzq2.zzaf();
            Preconditions.checkNotEmpty((String)string2);
            Object object = zzq2.getWritableDatabase();
            object.delete("property_filters", "app_id=?", new String[]{string2});
            object.delete("event_filters", "app_id=?", new String[]{string2});
            Object object2 = zzfuArray;
            int n2 = zzfuArray.length;
            block3: for (n = 0; n < n2; ++n) {
                zzfv zzfv2;
                int n3;
                int n4;
                zzfu zzfu2 = object2[n];
                object = zzfu2;
                string2 = string;
                zzq2 = this;
                zzq2.zzcl();
                zzq2.zzaf();
                Preconditions.checkNotEmpty((String)string2);
                Preconditions.checkNotNull((Object)object);
                Preconditions.checkNotNull((Object)object.zzava);
                Preconditions.checkNotNull((Object)object.zzauz);
                if (object.zzauy == null) {
                    zzq2.zzgo().zzjg().zzg("Audience with no ID. appId", zzap.zzbv((String)string2));
                    continue;
                }
                int n5 = object.zzauy;
                zzza[] zzzaArray = object.zzava;
                int n6 = object.zzava.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzzaArray[n4].zzave != null) continue;
                    zzq2.zzgo().zzjg().zze("Event filter with no ID. Audience definition ignored. appId, audienceId", zzap.zzbv((String)string2), (Object)object.zzauy);
                    continue block3;
                }
                zzzaArray = object.zzauz;
                n6 = object.zzauz.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzzaArray[n4].zzave != null) continue;
                    zzq2.zzgo().zzjg().zze("Property filter with no ID. Audience definition ignored. appId, audienceId", zzap.zzbv((String)string2), (Object)object.zzauy);
                    continue block3;
                }
                boolean bl = true;
                zzza[] zzzaArray2 = object.zzava;
                n4 = object.zzava.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    zzfv2 = zzzaArray2[n3];
                    if (zzq2.zza(string2, n5, zzfv2)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    zzzaArray2 = object.zzauz;
                    n4 = object.zzauz.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        zzfv2 = zzzaArray2[n3];
                        if (zzq2.zza(string2, n5, (zzfy)((Object)zzfv2))) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) continue;
                int n7 = n5;
                String string3 = string2;
                zzq zzq3 = zzq2;
                zzq3.zzcl();
                zzq3.zzaf();
                Preconditions.checkNotEmpty((String)string3);
                SQLiteDatabase sQLiteDatabase2 = zzq3.getWritableDatabase();
                sQLiteDatabase2.delete("property_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
                sQLiteDatabase2.delete("event_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
            }
            object2 = new ArrayList();
            zzfu[] zzfuArray2 = zzfuArray;
            n = zzfuArray.length;
            for (int i = 0; i < n; ++i) {
                zzfu zzfu3 = zzfuArray2[i];
                object2.add(zzfu3.zzauy);
            }
            this.zza(string, (List<Integer>)object2);
            sQLiteDatabase.setTransactionSuccessful();
            return;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzfv zzfv2) {
        byte[] byArray;
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zzfv2));
        if (TextUtils.isEmpty((CharSequence)zzfv2.zzavf)) {
            this.zzgo().zzjg().zzd("Event filter had no event name. Audience definition ignored. appId, audienceId, filterId", zzap.zzbv((String)string), (Object)n, (Object)String.valueOf(zzfv2.zzave));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzfv2.zzvu()];
            zzyy zzyy2 = zzyy.zzk((byte[])byArray, (int)0, (int)byArray2.length);
            zzfv2.zza(zzyy2);
            zzyy2.zzyt();
        }
        catch (IOException iOException) {
            this.zzgo().zzjd().zze("Configuration loss. Failed to serialize event filter. appId", zzap.zzbv((String)string), (Object)iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzfv2.zzave);
        contentValues.put("event_name", zzfv2.zzavf);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("event_filters", null, contentValues, 5) == -1L) {
                this.zzgo().zzjd().zzg("Failed to insert event filter (got -1). appId", zzap.zzbv((String)string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgo().zzjd().zze("Error storing event filter. appId", zzap.zzbv((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzfy zzfy2) {
        byte[] byArray;
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zzfy2));
        if (TextUtils.isEmpty((CharSequence)zzfy2.zzavu)) {
            this.zzgo().zzjg().zzd("Property filter had no property name. Audience definition ignored. appId, audienceId, filterId", zzap.zzbv((String)string), (Object)n, (Object)String.valueOf(zzfy2.zzave));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzfy2.zzvu()];
            zzyy zzyy2 = zzyy.zzk((byte[])byArray, (int)0, (int)byArray2.length);
            zzfy2.zza(zzyy2);
            zzyy2.zzyt();
        }
        catch (IOException iOException) {
            this.zzgo().zzjd().zze("Configuration loss. Failed to serialize property filter. appId", zzap.zzbv((String)string), (Object)iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzfy2.zzave);
        contentValues.put("property_name", zzfy2.zzavu);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("property_filters", null, contentValues, 5) == -1L) {
                this.zzgo().zzjd().zzg("Failed to insert property filter (got -1). appId", zzap.zzbv((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgo().zzjd().zze("Error storing property filter. appId", zzap.zzbv((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    final Map<Integer, List<zzfv>> zzl(String string, String string2) {
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzfv>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzyx zzyx2 = zzyx.zzj((byte[])byArray, (int)0, (int)byArray.length);
                zzfv zzfv2 = new zzfv();
                try {
                    zzfv2.zza(zzyx2);
                }
                catch (IOException iOException) {
                    this.zzgo().zzjd().zze("Failed to merge filter. appId", zzap.zzbv((String)string), (Object)iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzfv> arrayList = (ArrayList<zzfv>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzfv>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzfv2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<zzfy>> zzm(String string, String string2) {
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzfy>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzyx zzyx2 = zzyx.zzj((byte[])byArray, (int)0, (int)byArray.length);
                zzfy zzfy2 = new zzfy();
                try {
                    zzfy2.zza(zzyx2);
                }
                catch (IOException iOException) {
                    this.zzgo().zzjd().zze("Failed to merge filter", zzap.zzbv((String)string), (Object)iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzfy> arrayList = (ArrayList<zzfy>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzfy>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzfy2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    private final boolean zza(String string, List<Integer> list) {
        Object object;
        long l;
        Preconditions.checkNotEmpty((String)string);
        this.zzcl();
        this.zzaf();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            l = this.zza("select count(1) from audience_filter_values where app_id=?", new String[]{string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzgo().zzjd().zze("Database error querying filters. appId", zzap.zzbv((String)string), (Object)sQLiteException);
            return false;
        }
        String string2 = string;
        int n = this.zzgq().zzb(string2, zzaf.zzaki);
        n = Math.min(2000, n);
        int n2 = Math.max(0, n);
        if (l <= (long)n2) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            if (object == null || !(object instanceof Integer)) {
                return false;
            }
            arrayList.add(Integer.toString((Integer)object));
        }
        object = TextUtils.join((CharSequence)",", arrayList);
        String string3 = new StringBuilder(2 + String.valueOf(object).length()).append("(").append((String)object).append(")").toString();
        return sQLiteDatabase.delete("audience_filter_values", new StringBuilder(140 + String.valueOf(string3).length()).append("audience_id in (select audience_id from audience_filter_values where app_id=? and audience_id not in ").append(string3).append(" order by rowid desc limit -1 offset ?)").toString(), new String[]{string, Integer.toString(n2)}) > 0;
    }

    final Map<Integer, zzgj> zzbo(String string) {
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                zzyx zzyx2 = zzyx.zzj((byte[])byArray, (int)0, (int)byArray.length);
                zzgj zzgj2 = new zzgj();
                try {
                    zzgj2.zza(zzyx2);
                }
                catch (IOException iOException) {
                    this.zzgo().zzjd().zzd("Failed to merge filter results. appId, audienceId, error", zzap.zzbv((String)string), (Object)n, (Object)iOException);
                    continue;
                }
                arrayMap.put(n, zzgj2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    @WorkerThread
    private static void zza(ContentValues contentValues, String string, Object object) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
            return;
        }
        if (object instanceof Long) {
            contentValues.put(string, (Long)object);
            return;
        }
        if (object instanceof Double) {
            contentValues.put(string, (Double)object);
            return;
        }
        throw new IllegalArgumentException("Invalid value type");
    }

    @VisibleForTesting
    @WorkerThread
    private final Object zza(Cursor cursor, int n) {
        int n2 = n;
        Cursor cursor2 = cursor;
        int n3 = cursor2.getType(n2);
        switch (n3) {
            case 0: {
                this.zzgo().zzjd().zzbx("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzgo().zzjd().zzbx("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzgo().zzjd().zzg("Loaded invalid unknown value type, ignoring it", (Object)n3);
        return null;
    }

    @WorkerThread
    public final long zzig() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    @VisibleForTesting
    protected final long zzn(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzaf();
        this.zzcl();
        long l = 0L;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            ContentValues contentValues;
            l = this.zza(new StringBuilder(32 + String.valueOf(string2).length()).append("select ").append(string2).append(" from app2 where app_id=?").toString(), new String[]{string}, -1L);
            if (l == -1L) {
                l = 0L;
                contentValues = new ContentValues();
                contentValues.put("app_id", string);
                contentValues.put("first_open_count", Integer.valueOf(0));
                contentValues.put("previous_install_count", Integer.valueOf(0));
                if (sQLiteDatabase.insertWithOnConflict("app2", null, contentValues, 5) == -1L) {
                    this.zzgo().zzjd().zze("Failed to insert column (got -1). appId", zzap.zzbv((String)string), (Object)string2);
                    return -1L;
                }
            }
            contentValues = new ContentValues();
            contentValues.put("app_id", string);
            contentValues.put(string2, Long.valueOf(l + 1L));
            if ((long)sQLiteDatabase.update("app2", contentValues, "app_id = ?", new String[]{string}) == 0L) {
                this.zzgo().zzjd().zze("Failed to update column (got 0). appId", zzap.zzbv((String)string), (Object)string2);
                return -1L;
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zzgo().zzjd().zzd("Error inserting column. appId", zzap.zzbv((String)string), (Object)string2, (Object)sQLiteException);
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l;
    }

    @WorkerThread
    public final long zzih() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public final long zza(zzgi zzgi2) throws IOException {
        long l;
        Object object;
        byte[] byArray;
        this.zzaf();
        this.zzcl();
        Preconditions.checkNotNull((Object)((Object)zzgi2));
        Preconditions.checkNotEmpty((String)zzgi2.zztt);
        try {
            object = byArray = new byte[zzgi2.zzvu()];
            zzyy zzyy2 = zzyy.zzk((byte[])byArray, (int)0, (int)((byte[])object).length);
            zzgi2.zza(zzyy2);
            zzyy2.zzyt();
        }
        catch (IOException iOException) {
            this.zzgo().zzjd().zze("Data loss. Failed to serialize event metadata. appId", zzap.zzbv((String)zzgi2.zztt), (Object)iOException);
            throw iOException;
        }
        byte[] byArray2 = byArray;
        object = (Object)this.zzjo();
        Preconditions.checkNotNull((Object)byArray2);
        object.zzgm().zzaf();
        MessageDigest messageDigest = zzfk.getMessageDigest();
        if (messageDigest == null) {
            object.zzgo().zzjd().zzbx("Failed to get MD5");
            l = 0L;
        } else {
            l = zzfk.zzc((byte[])messageDigest.digest(byArray2));
        }
        long l2 = l;
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzgi2.zztt);
        contentValues.put("metadata_fingerprint", Long.valueOf(l2));
        contentValues.put("metadata", byArray);
        try {
            this.getWritableDatabase().insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzgo().zzjd().zze("Error storing raw event metadata. appId", zzap.zzbv((String)zzgi2.zztt), (Object)sQLiteException);
            throw sQLiteException;
        }
        return l2;
    }

    public final boolean zzii() {
        return this.zza("select count(1) > 0 from raw_events", (String[])null) != 0L;
    }

    public final boolean zzij() {
        return this.zza("select count(1) > 0 from raw_events where realtime = 1", (String[])null) != 0L;
    }

    public final long zzbp(String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    public final String zzah(long l) {
        this.zzaf();
        this.zzcl();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzgo().zzjl().zzbx("No expired configs for apps with pending events");
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    public final long zzik() {
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select rowid from raw_events order by rowid desc limit 1;", null);
            if (!cursor.moveToFirst()) {
                return -1L;
            }
            long l = cursor.getLong(0);
            return l;
        }
        return -1L;
    }

    public final Pair<zzgf, Long> zza(String string, Long l) {
        this.zzaf();
        this.zzcl();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select main_event, children_to_process from main_event_params where app_id=? and event_id=?", new String[]{string, String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzgo().zzjl().zzbx("Main event not found");
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            Long l2 = cursor.getLong(1);
            byte[] byArray2 = byArray;
            zzyx zzyx2 = zzyx.zzj((byte[])byArray, (int)0, (int)byArray2.length);
            zzgf zzgf2 = new zzgf();
            try {
                zzgf2.zza(zzyx2);
            }
            catch (IOException iOException) {
                this.zzgo().zzjd().zzd("Failed to merge main event. appId, eventId", zzap.zzbv((String)string), (Object)l, (Object)iOException);
                if (cursor != null) {
                    cursor.close();
                }
                return null;
            }
            Pair pair = Pair.create((Object)((Object)zzgf2), (Object)l2);
            return pair;
        }
        return null;
    }

    public final boolean zza(String string, Long l, long l2, zzgf zzgf2) {
        byte[] byArray;
        this.zzaf();
        this.zzcl();
        Preconditions.checkNotNull((Object)((Object)zzgf2));
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)l);
        try {
            byte[] byArray2 = byArray = new byte[zzgf2.zzvu()];
            zzyy zzyy2 = zzyy.zzk((byte[])byArray, (int)0, (int)byArray2.length);
            zzgf2.zza(zzyy2);
            zzyy2.zzyt();
        }
        catch (IOException iOException) {
            this.zzgo().zzjd().zzd("Data loss. Failed to serialize event params/data. appId, eventId", zzap.zzbv((String)string), (Object)l, (Object)iOException);
            return false;
        }
        this.zzgo().zzjl().zze("Saving complex main event, appId, data size", (Object)this.zzgl().zzbs(string), (Object)byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("event_id", l);
        contentValues.put("children_to_process", Long.valueOf(l2));
        contentValues.put("main_event", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("main_event_params", null, contentValues, 5) == -1L) {
                this.zzgo().zzjd().zzg("Failed to insert complex main event (got -1). appId", zzap.zzbv((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgo().zzjd().zze("Error storing complex main event. appId", zzap.zzbv((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    public final boolean zza(zzy zzy2, long l, boolean bl) {
        Object object;
        zzgg zzgg2;
        String string2;
        this.zzaf();
        this.zzcl();
        Preconditions.checkNotNull((Object)zzy2);
        Preconditions.checkNotEmpty((String)zzy2.zztt);
        zzgf zzgf2 = new zzgf();
        new zzgf().zzawv = zzy2.zzaic;
        zzgf2.zzawt = new zzgg[zzy2.zzaid.size()];
        int n = 0;
        for (String string2 : zzy2.zzaid) {
            zzgg2 = new zzgg();
            zzgf2.zzawt[n++] = zzgg2;
            zzgg2.name = string2;
            Object object2 = zzy2.zzaid.get(string2);
            this.zzjo().zza(zzgg2, object2);
        }
        try {
            byte[] byArray = new byte[zzgf2.zzvu()];
            object = byArray;
            byte[] byArray2 = byArray;
            zzgg2 = zzyy.zzk((byte[])byArray, (int)0, (int)byArray2.length);
            zzgf2.zza((zzyy)zzgg2);
            zzgg2.zzyt();
        }
        catch (IOException iOException) {
            this.zzgo().zzjd().zze("Data loss. Failed to serialize event params/data. appId", zzap.zzbv((String)zzy2.zztt), (Object)iOException);
            return false;
        }
        this.zzgo().zzjl().zze("Saving event, name, data size", (Object)this.zzgl().zzbs(zzy2.name), (Object)((Object)object).length);
        string2 = new ContentValues();
        string2.put("app_id", zzy2.zztt);
        string2.put("name", zzy2.name);
        string2.put("timestamp", Long.valueOf(zzy2.timestamp));
        string2.put("metadata_fingerprint", Long.valueOf(l));
        string2.put("data", (byte[])object);
        string2.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.getWritableDatabase().insert("raw_events", null, (ContentValues)string2) == -1L) {
                this.zzgo().zzjd().zzg("Failed to insert raw event (got -1). appId", zzap.zzbv((String)zzy2.zztt));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgo().zzjd().zze("Error storing raw event. appId", zzap.zzbv((String)zzy2.zztt), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    private final boolean zzil() {
        return this.getContext().getDatabasePath("google_app_measurement.db").exists();
    }

    static /* synthetic */ zzev zza(zzq zzq2) {
        return zzq2.zzahp;
    }

    static /* synthetic */ String[] zzim() {
        return zzahi;
    }

    static /* synthetic */ String[] zzin() {
        return zzahj;
    }

    static /* synthetic */ String[] zzio() {
        return zzahk;
    }

    static /* synthetic */ String[] zzip() {
        return zzahm;
    }

    static /* synthetic */ String[] zziq() {
        return zzahl;
    }

    static /* synthetic */ String[] zzir() {
        return zzahn;
    }
}

