/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.database.sqlite.SQLiteException;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzfu;
import com.google.android.gms.internal.measurement.zzfv;
import com.google.android.gms.internal.measurement.zzfw;
import com.google.android.gms.internal.measurement.zzfy;
import com.google.android.gms.internal.measurement.zzga;
import com.google.android.gms.internal.measurement.zzgb;
import com.google.android.gms.internal.measurement.zzgc;
import com.google.android.gms.internal.measurement.zzyx;
import com.google.android.gms.internal.measurement.zzyy;
import com.google.android.gms.internal.measurement.zzza;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzey;
import com.google.android.gms.measurement.internal.zzez;
import com.google.android.gms.measurement.internal.zzfa;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzj;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzq;
import java.io.IOException;
import java.util.Map;

public final class zzbn
extends zzez
implements zzp {
    @VisibleForTesting
    private static int zzaon = 65535;
    @VisibleForTesting
    private static int zzaoo = 2;
    private final Map<String, Map<String, String>> zzaop = new ArrayMap();
    private final Map<String, Map<String, Boolean>> zzaoq = new ArrayMap();
    private final Map<String, Map<String, Boolean>> zzaor = new ArrayMap();
    private final Map<String, zzgb> zzaos = new ArrayMap();
    private final Map<String, Map<String, Integer>> zzaot;
    private final Map<String, String> zzaou = new ArrayMap();

    zzbn(zzfa zzfa2) {
        super(zzfa2);
        this.zzaot = new ArrayMap();
    }

    @WorkerThread
    private final void zzce(String string) {
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzaos.get(string) == null) {
            byte[] byArray = ((zzey)this).zzjq().zzbn(string);
            if (byArray == null) {
                this.zzaop.put(string, null);
                this.zzaoq.put(string, null);
                this.zzaor.put(string, null);
                this.zzaos.put(string, null);
                this.zzaou.put(string, null);
                this.zzaot.put(string, null);
                return;
            }
            zzgb zzgb2 = this.zza(string, byArray);
            this.zzaop.put(string, zzbn.zza(zzgb2));
            this.zza(string, zzgb2);
            this.zzaos.put(string, zzgb2);
            this.zzaou.put(string, null);
        }
    }

    @WorkerThread
    protected final zzgb zzcf(String string) {
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        this.zzce(string);
        return this.zzaos.get(string);
    }

    @WorkerThread
    protected final String zzcg(String string) {
        this.zzaf();
        return this.zzaou.get(string);
    }

    @WorkerThread
    protected final void zzch(String string) {
        this.zzaf();
        this.zzaou.put(string, null);
    }

    @WorkerThread
    final void zzci(String string) {
        this.zzaf();
        this.zzaos.remove(string);
    }

    @WorkerThread
    public final String zzf(String string, String string2) {
        this.zzaf();
        this.zzce(string);
        Map<String, String> map = this.zzaop.get(string);
        if (map != null) {
            return map.get(string2);
        }
        return null;
    }

    private static Map<String, String> zza(zzgb zzgb2) {
        ArrayMap arrayMap = new ArrayMap();
        if (zzgb2 != null && zzgb2.zzawg != null) {
            zzgc[] zzgcArray = zzgb2.zzawg;
            int n = zzgb2.zzawg.length;
            for (int i = 0; i < n; ++i) {
                zzgc zzgc2 = zzgcArray[i];
                if (zzgc2 == null) continue;
                arrayMap.put(zzgc2.zzoj, zzgc2.value);
            }
        }
        return arrayMap;
    }

    private final void zza(String string, zzgb zzgb2) {
        ArrayMap arrayMap = new ArrayMap();
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        if (zzgb2 != null && zzgb2.zzawh != null) {
            zzga[] zzgaArray = zzgb2.zzawh;
            int n = zzgb2.zzawh.length;
            for (int i = 0; i < n; ++i) {
                zzga zzga2 = zzgaArray[i];
                if (TextUtils.isEmpty((CharSequence)zzga2.name)) {
                    this.zzgo().zzjg().zzbx("EventConfig contained null event name");
                    continue;
                }
                String string2 = AppMeasurement.Event.zzal((String)zzga2.name);
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    zzga2.name = string2;
                }
                arrayMap.put(zzga2.name, zzga2.zzawb);
                arrayMap2.put(zzga2.name, zzga2.zzawc);
                if (zzga2.zzawd == null) continue;
                if (zzga2.zzawd < zzaoo || zzga2.zzawd > zzaon) {
                    this.zzgo().zzjg().zze("Invalid sampling rate. Event name, sample rate", (Object)zzga2.name, (Object)zzga2.zzawd);
                    continue;
                }
                arrayMap3.put(zzga2.name, zzga2.zzawd);
            }
        }
        this.zzaoq.put(string, (Map<String, Boolean>)arrayMap);
        this.zzaor.put(string, (Map<String, Boolean>)arrayMap2);
        this.zzaot.put(string, (Map<String, Integer>)arrayMap3);
    }

    @WorkerThread
    protected final boolean zza(String string, byte[] byArray, String string2) {
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        zzgb zzgb2 = this.zza(string, byArray);
        if (zzgb2 == null) {
            return false;
        }
        this.zza(string, zzgb2);
        this.zzaos.put(string, zzgb2);
        this.zzaou.put(string, string2);
        this.zzaop.put(string, zzbn.zza(zzgb2));
        Object object = zzgb2.zzawi;
        String string3 = string;
        Object object2 = ((zzey)this).zzjp();
        Preconditions.checkNotNull((Object)object);
        for (zzfu zzfu2 : object) {
            String string4;
            zzfv zzfv2;
            int n;
            zzza[] zzzaArray = zzfu2.zzava;
            int n2 = zzfu2.zzava.length;
            for (n = 0; n < n2; ++n) {
                zzfv2 = zzzaArray[n];
                string4 = AppMeasurement.Event.zzal((String)zzfv2.zzavf);
                if (string4 != null) {
                    zzfv2.zzavf = string4;
                }
                zzfw[] zzfwArray = zzfv2.zzavg;
                int n3 = zzfv2.zzavg.length;
                for (int i = 0; i < n3; ++i) {
                    zzfw zzfw2 = zzfwArray[i];
                    String string5 = AppMeasurement.Param.zzal((String)zzfw2.zzavn);
                    if (string5 == null) continue;
                    zzfw2.zzavn = string5;
                }
            }
            zzzaArray = zzfu2.zzauz;
            n2 = zzfu2.zzauz.length;
            for (n = 0; n < n2; ++n) {
                zzfv2 = zzzaArray[n];
                string4 = AppMeasurement.UserProperty.zzal((String)((zzfy)((Object)zzfv2)).zzavu);
                if (string4 == null) continue;
                ((zzfy)((Object)zzfv2)).zzavu = string4;
            }
        }
        ((zzey)((Object)object2)).zzjq().zza(string3, (zzfu[])object);
        try {
            zzgb2.zzawi = null;
            byte[] byArray2 = new byte[zzgb2.zzvu()];
            object2 = byArray2;
            zzyy zzyy2 = zzyy.zzk((byte[])byArray2, (int)0, (int)((zzj)object2).length);
            zzgb2.zza(zzyy2);
            byArray = byArray2;
        }
        catch (IOException iOException) {
            this.zzgo().zzjg().zze("Unable to serialize reduced-size config. Storing full config instead. appId", zzap.zzbv((String)string), (Object)iOException);
        }
        object = byArray;
        string3 = string;
        object2 = ((zzey)this).zzjq();
        Preconditions.checkNotEmpty((String)string3);
        object2.zzaf();
        ((zzez)((Object)object2)).zzcl();
        ContentValues contentValues = new ContentValues();
        contentValues.put("remote_config", (byte[])object);
        try {
            if ((long)((zzq)((Object)object2)).getWritableDatabase().update("apps", contentValues, "app_id = ?", new String[]{string3}) == 0L) {
                object2.zzgo().zzjd().zzg("Failed to update remote config (got 0). appId", zzap.zzbv((String)string3));
            }
        }
        catch (SQLiteException sQLiteException) {
            object2.zzgo().zzjd().zze("Error storing remote config. appId", zzap.zzbv((String)string3), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    final boolean zzo(String string, String string2) {
        this.zzaf();
        this.zzce(string);
        if (this.zzck(string) && zzfk.zzcv((String)string2)) {
            return true;
        }
        if (this.zzcl(string) && zzfk.zzcq((String)string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zzaoq.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final boolean zzp(String string, String string2) {
        this.zzaf();
        this.zzce(string);
        if ("ecommerce_purchase".equals(string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zzaor.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final int zzq(String string, String string2) {
        this.zzaf();
        this.zzce(string);
        Map<String, Integer> map = this.zzaot.get(string);
        if (map != null) {
            Integer n = map.get(string2);
            if (n == null) {
                return 1;
            }
            return n;
        }
        return 1;
    }

    @WorkerThread
    final long zzcj(String string) {
        String string2 = this.zzf(string, "measurement.account.time_zone_offset_minutes");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.zzgo().zzjg().zze("Unable to parse timezone offset. appId", zzap.zzbv((String)string), (Object)numberFormatException);
            }
        }
        return 0L;
    }

    @WorkerThread
    private final zzgb zza(String string, byte[] byArray) {
        if (byArray == null) {
            return new zzgb();
        }
        byte[] byArray2 = byArray;
        zzyx zzyx2 = zzyx.zzj((byte[])byArray, (int)0, (int)byArray2.length);
        zzgb zzgb2 = new zzgb();
        try {
            zzgb2.zza(zzyx2);
            this.zzgo().zzjl().zze("Parsed config. version, gmp_app_id", (Object)zzgb2.zzawe, (Object)zzgb2.zzafx);
        }
        catch (IOException iOException) {
            this.zzgo().zzjg().zze("Unable to merge remote config. appId", zzap.zzbv((String)string), (Object)iOException);
            return new zzgb();
        }
        return zzgb2;
    }

    final boolean zzck(String string) {
        return "1".equals(this.zzf(string, "measurement.upload.blacklist_internal"));
    }

    final boolean zzcl(String string) {
        return "1".equals(this.zzf(string, "measurement.upload.blacklist_public"));
    }

    @Override
    protected final boolean zzgt() {
        return false;
    }
}

