/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzbt;
import com.google.android.gms.measurement.internal.zzbv;
import com.google.android.gms.measurement.internal.zzem;
import com.google.android.gms.measurement.internal.zzen;
import com.google.android.gms.measurement.internal.zzeo;
import com.google.android.gms.measurement.internal.zzep;
import com.google.android.gms.measurement.internal.zzfa;
import com.google.android.gms.measurement.internal.zzk;

public final class zzel<T extends Context> {
    private final T zzaby;

    public zzel(T t) {
        Preconditions.checkNotNull(t);
        this.zzaby = t;
    }

    @MainThread
    public final void onCreate() {
        zzbt zzbt2 = zzbt.zza(this.zzaby, null);
        zzap zzap2 = zzbt2.zzgo();
        zzk zzk2 = zzbt2.zzgr();
        zzap2.zzjl().zzbx("Local AppMeasurementService is starting up");
    }

    @MainThread
    public final void onDestroy() {
        zzbt zzbt2 = zzbt.zza(this.zzaby, null);
        zzap zzap2 = zzbt2.zzgo();
        zzk zzk2 = zzbt2.zzgr();
        zzap2.zzjl().zzbx("Local AppMeasurementService is shutting down");
    }

    @MainThread
    public final int onStartCommand(Intent intent, int n, int n2) {
        zzbt zzbt2 = zzbt.zza(this.zzaby, null);
        zzap zzap2 = zzbt2.zzgo();
        if (intent == null) {
            zzap2.zzjg().zzbx("AppMeasurementService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        zzk zzk2 = zzbt2.zzgr();
        zzap2.zzjl().zze("Local AppMeasurementService called. startId, action", (Object)n2, (Object)string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zzb(new zzem(this, n2, zzap2, intent));
        }
        return 2;
    }

    private final void zzb(Runnable runnable) {
        zzfa zzfa2 = zzfa.zzm(this.zzaby);
        zzfa2.zzgn().zzc((Runnable)new zzeo(this, zzfa2, runnable));
    }

    @MainThread
    public final IBinder onBind(Intent intent) {
        if (intent == null) {
            this.zzgo().zzjd().zzbx("onBind called with null intent");
            return null;
        }
        String string = intent.getAction();
        if ("com.google.android.gms.measurement.START".equals(string)) {
            return new zzbv(zzfa.zzm(this.zzaby));
        }
        this.zzgo().zzjg().zzg("onBind received unknown action", (Object)string);
        return null;
    }

    @MainThread
    public final boolean onUnbind(Intent intent) {
        if (intent == null) {
            this.zzgo().zzjd().zzbx("onUnbind called with null intent");
            return true;
        }
        String string = intent.getAction();
        this.zzgo().zzjl().zzg("onUnbind called for intent. action", (Object)string);
        return true;
    }

    @MainThread
    @TargetApi(value=24)
    public final boolean onStartJob(JobParameters jobParameters) {
        zzbt zzbt2 = zzbt.zza(this.zzaby, null);
        zzap zzap2 = zzbt2.zzgo();
        String string = jobParameters.getExtras().getString("action");
        zzk zzk2 = zzbt2.zzgr();
        zzap2.zzjl().zzg("Local AppMeasurementJobService called. action", (Object)string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zzb(new zzen(this, zzap2, jobParameters));
        }
        return true;
    }

    @MainThread
    public final void onRebind(Intent intent) {
        if (intent == null) {
            this.zzgo().zzjd().zzbx("onRebind called with null intent");
            return;
        }
        String string = intent.getAction();
        this.zzgo().zzjl().zzg("onRebind called. action", (Object)string);
    }

    private final zzap zzgo() {
        return zzbt.zza(this.zzaby, null).zzgo();
    }

    final /* synthetic */ void zza(zzap zzap2, JobParameters jobParameters) {
        zzap2.zzjl().zzbx("AppMeasurementJobService processed last upload request.");
        ((zzep)this.zzaby).zza(jobParameters, false);
    }

    final /* synthetic */ void zza(int n, zzap zzap2, Intent intent) {
        if (((zzep)this.zzaby).callServiceStopSelfResult(n)) {
            zzap2.zzjl().zzg("Local AppMeasurementService processed last upload request. StartId", (Object)n);
            this.zzgo().zzjl().zzbx("Completed wakeful intent.");
            ((zzep)this.zzaby).zzb(intent);
        }
    }
}

