/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Binder;
import android.support.annotation.BinderThread;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzbx;
import com.google.android.gms.measurement.internal.zzby;
import com.google.android.gms.measurement.internal.zzbz;
import com.google.android.gms.measurement.internal.zzca;
import com.google.android.gms.measurement.internal.zzcb;
import com.google.android.gms.measurement.internal.zzcc;
import com.google.android.gms.measurement.internal.zzcd;
import com.google.android.gms.measurement.internal.zzce;
import com.google.android.gms.measurement.internal.zzcf;
import com.google.android.gms.measurement.internal.zzcg;
import com.google.android.gms.measurement.internal.zzch;
import com.google.android.gms.measurement.internal.zzci;
import com.google.android.gms.measurement.internal.zzcj;
import com.google.android.gms.measurement.internal.zzck;
import com.google.android.gms.measurement.internal.zzcl;
import com.google.android.gms.measurement.internal.zzcm;
import com.google.android.gms.measurement.internal.zzcn;
import com.google.android.gms.measurement.internal.zzco;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zzm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzbw
extends zzai {
    private final zzfk zzang;
    private Boolean zzaqt;
    @Nullable
    private String zzaqu;

    public zzbw(zzfk zzfk2) {
        this(zzfk2, null);
    }

    private zzbw(zzfk zzfk2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zzfk2);
        this.zzang = zzfk2;
        this.zzaqu = null;
    }

    @BinderThread
    public final void zzb(zzi zzi2) {
        this.zzb(zzi2, false);
        this.zze(new zzbx(this, zzi2));
    }

    @BinderThread
    public final void zza(zzae zzae2, zzi zzi2) {
        Preconditions.checkNotNull((Object)zzae2);
        this.zzb(zzi2, false);
        this.zze(new zzch(this, zzae2, zzi2));
    }

    @VisibleForTesting
    final zzae zzb(zzae zzae2, zzi zzi2) {
        String string;
        zzi zzi3 = zzi2;
        zzae zzae3 = zzae2;
        zzbw zzbw2 = this;
        if (!"_cmp".equals(zzae3.name) || zzae3.zzaig == null || zzae3.zzaig.size() == 0 ? false : !TextUtils.isEmpty((CharSequence)(string = zzae3.zzaig.getString("_cis"))) && ("referrer broadcast".equals(string) || "referrer API".equals(string)) && zzbw2.zzang.zzgv().zzbg(zzi3.packageName)) {
            this.zzang.zzgt().zzjm().zzg("Event has been filtered ", (Object)zzae2.toString());
            return new zzae("_cmpx", zzae2.zzaig, zzae2.origin, zzae2.zzais);
        }
        return zzae2;
    }

    @BinderThread
    public final void zza(zzae zzae2, String string, String string2) {
        Preconditions.checkNotNull((Object)zzae2);
        Preconditions.checkNotEmpty((String)string);
        this.zzc(string, true);
        this.zze(new zzci(this, zzae2, string));
    }

    @BinderThread
    public final byte[] zza(zzae zzae2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzae2);
        this.zzc(string, true);
        this.zzang.zzgt().zzjn().zzg("Log and bundle. event", (Object)this.zzang.zzgq().zzbv(zzae2.name));
        long l = this.zzang.zzbx().nanoTime() / 1000000L;
        Future future = this.zzang.zzgs().zzc((Callable)new zzcj(this, zzae2, string));
        try {
            byte[] byArray = (byte[])future.get();
            if (byArray == null) {
                this.zzang.zzgt().zzjg().zzg("Log and bundle returned null. appId", zzaq.zzby((String)string));
                byArray = new byte[]{};
            }
            long l2 = this.zzang.zzbx().nanoTime() / 1000000L;
            this.zzang.zzgt().zzjn().zzd("Log and bundle processed. event, size, time_ms", (Object)this.zzang.zzgq().zzbv(zzae2.name), (Object)byArray.length, (Object)(l2 - l));
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzang.zzgt().zzjg().zzd("Failed to log and bundle. appId, event, error", zzaq.zzby((String)string), (Object)this.zzang.zzgq().zzbv(zzae2.name), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzfr zzfr2, zzi zzi2) {
        Preconditions.checkNotNull((Object)zzfr2);
        this.zzb(zzi2, false);
        if (zzfr2.getValue() == null) {
            this.zze(new zzck(this, zzfr2, zzi2));
            return;
        }
        this.zze(new zzcl(this, zzfr2, zzi2));
    }

    @BinderThread
    public final List<zzfr> zza(zzi zzi2, boolean bl) {
        this.zzb(zzi2, false);
        Future future = this.zzang.zzgs().zzb((Callable)new zzcm(this, zzi2));
        try {
            List list = (List)future.get();
            ArrayList<zzfr> arrayList = new ArrayList<zzfr>(list.size());
            for (zzft zzft2 : list) {
                if (!bl && zzfu.zzda((String)zzft2.name)) continue;
                arrayList.add(new zzfr(zzft2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzang.zzgt().zzjg().zze("Failed to get user attributes. appId", zzaq.zzby((String)zzi2.packageName), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final void zza(zzi zzi2) {
        this.zzb(zzi2, false);
        this.zze(new zzcn(this, zzi2));
    }

    @BinderThread
    private final void zzb(zzi zzi2, boolean bl) {
        Preconditions.checkNotNull((Object)zzi2);
        this.zzc(zzi2.packageName, false);
        this.zzang.zzgr().zzu(zzi2.zzafx, zzi2.zzagk);
    }

    @BinderThread
    private final void zzc(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzang.zzgt().zzjg().zzca("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzbw zzbw2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzbw2 = this;
                    if (!bl2) break block9;
                    if (zzbw2.zzaqt == null) {
                        zzbw2.zzaqt = "com.google.android.gms".equals(zzbw2.zzaqu) || UidVerifier.isGooglePlayServicesUid((Context)zzbw2.zzang.getContext(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzbw2.zzang.getContext()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzbw2.zzaqt.booleanValue()) break block10;
                }
                if (zzbw2.zzaqu == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzbw2.zzang.getContext(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzbw2.zzaqu = string2;
                }
                if (!string2.equals(zzbw2.zzaqu)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zzang.zzgt().zzjg().zzg("Measurement Service called with invalid calling package. appId", zzaq.zzby((String)string));
            throw securityException;
        }
    }

    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zze(new zzco(this, string2, string3, string, l));
    }

    @BinderThread
    public final String zzc(zzi zzi2) {
        this.zzb(zzi2, false);
        return this.zzang.zzh(zzi2);
    }

    @BinderThread
    public final void zza(zzm zzm2, zzi zzi2) {
        Preconditions.checkNotNull((Object)zzm2);
        Preconditions.checkNotNull((Object)zzm2.zzahe);
        this.zzb(zzi2, false);
        zzm zzm3 = new zzm(zzm2);
        new zzm(zzm2).packageName = zzi2.packageName;
        if (zzm2.zzahe.getValue() == null) {
            this.zze(new zzby(this, zzm3, zzi2));
            return;
        }
        this.zze(new zzbz(this, zzm3, zzi2));
    }

    @BinderThread
    public final void zzb(zzm zzm2) {
        Preconditions.checkNotNull((Object)zzm2);
        Preconditions.checkNotNull((Object)zzm2.zzahe);
        this.zzc(zzm2.packageName, true);
        zzm zzm3 = new zzm(zzm2);
        if (zzm2.zzahe.getValue() == null) {
            this.zze(new zzca(this, zzm3));
            return;
        }
        this.zze(new zzcb(this, zzm3));
    }

    @BinderThread
    public final List<zzfr> zza(String string, String string2, boolean bl, zzi zzi2) {
        this.zzb(zzi2, false);
        Future future = this.zzang.zzgs().zzb((Callable)new zzcc(this, zzi2, string, string2));
        try {
            List list = (List)future.get();
            ArrayList<zzfr> arrayList = new ArrayList<zzfr>(list.size());
            for (zzft zzft2 : list) {
                if (!bl && zzfu.zzda((String)zzft2.name)) continue;
                arrayList.add(new zzfr(zzft2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzang.zzgt().zzjg().zze("Failed to get user attributes. appId", zzaq.zzby((String)zzi2.packageName), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzfr> zza(String string, String string2, String string3, boolean bl) {
        this.zzc(string, true);
        Future future = this.zzang.zzgs().zzb((Callable)new zzcd(this, string, string2, string3));
        try {
            List list = (List)future.get();
            ArrayList<zzfr> arrayList = new ArrayList<zzfr>(list.size());
            for (zzft zzft2 : list) {
                if (!bl && zzfu.zzda((String)zzft2.name)) continue;
                arrayList.add(new zzfr(zzft2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzang.zzgt().zzjg().zze("Failed to get user attributes. appId", zzaq.zzby((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzm> zza(String string, String string2, zzi zzi2) {
        this.zzb(zzi2, false);
        Future future = this.zzang.zzgs().zzb((Callable)new zzce(this, zzi2, string, string2));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzang.zzgt().zzjg().zzg("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzm> zze(String string, String string2, String string3) {
        this.zzc(string, true);
        Future future = this.zzang.zzgs().zzb((Callable)new zzcf(this, string, string2, string3));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzang.zzgt().zzjg().zzg("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final void zzd(zzi zzi2) {
        this.zzc(zzi2.packageName, false);
        this.zze(new zzcg(this, zzi2));
    }

    @VisibleForTesting
    private final void zze(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (((Boolean)zzag.zzakz.get()).booleanValue() && this.zzang.zzgs().zzkf()) {
            runnable.run();
            return;
        }
        this.zzang.zzgs().zzc(runnable);
    }

    static /* synthetic */ zzfk zza(zzbw zzbw2) {
        return zzbw2.zzang;
    }
}

