/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.measurement.zzdx;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzbk;
import com.google.android.gms.measurement.internal.zzcr;
import com.google.android.gms.measurement.internal.zzfh;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzl;
import com.google.android.gms.measurement.internal.zzw;

public final class zzfg
extends zzfj {
    private final AlarmManager zzyt = (AlarmManager)this.getContext().getSystemService("alarm");
    private final zzw zzatr;
    private Integer zzyu;

    protected zzfg(zzfk zzfk2) {
        super(zzfk2);
        this.zzatr = new zzfh(this, (zzcr)zzfk2.zzmh(), zzfk2);
    }

    @Override
    protected final boolean zzgy() {
        this.zzyt.cancel(this.zzeo());
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzlr();
        }
        return false;
    }

    @TargetApi(value=24)
    private final void zzlr() {
        JobScheduler jobScheduler = (JobScheduler)this.getContext().getSystemService("jobscheduler");
        int n = this.getJobId();
        this.zzgt().zzjo().zzg("Cancelling job. JobID", (Object)n);
        jobScheduler.cancel(n);
    }

    public final void zzh(long l) {
        this.zzcl();
        zzl zzl2 = this.zzgw();
        Context context = this.getContext();
        if (!zzbk.zza((Context)context)) {
            this.zzgt().zzjn().zzca("Receiver not registered/enabled");
        }
        if (!zzfu.zza((Context)context, (boolean)false)) {
            this.zzgt().zzjn().zzca("Service not registered/enabled");
        }
        this.cancel();
        long l2 = this.zzbx().elapsedRealtime() + l;
        if (l < Math.max(0L, (Long)zzag.zzakd.get()) && !this.zzatr.zzej()) {
            this.zzgt().zzjo().zzca("Scheduling upload with DelayedRunnable");
            this.zzatr.zzh(l);
        }
        zzl2 = this.zzgw();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzgt().zzjo().zzca("Scheduling upload with JobScheduler");
            long l3 = l;
            zzfg zzfg2 = this;
            Context context2 = zzfg2.getContext();
            ComponentName componentName = new ComponentName(context2, "com.google.android.gms.measurement.AppMeasurementJobService");
            int n = zzfg2.getJobId();
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            JobInfo jobInfo = new JobInfo.Builder(n, componentName).setMinimumLatency(l3).setOverrideDeadline(l3 << 1).setExtras(persistableBundle).build();
            zzfg2.zzgt().zzjo().zzg("Scheduling job. JobID", (Object)n);
            zzdx.zza((Context)context2, (JobInfo)jobInfo, (String)"com.google.android.gms", (String)"UploadAlarm");
            return;
        }
        this.zzgt().zzjo().zzca("Scheduling upload with AlarmManager");
        this.zzyt.setInexactRepeating(2, l2, Math.max((Long)zzag.zzajy.get(), l), this.zzeo());
    }

    private final int getJobId() {
        if (this.zzyu == null) {
            String string = String.valueOf(this.getContext().getPackageName());
            this.zzyu = (string.length() != 0 ? "measurement".concat(string) : new String("measurement")).hashCode();
        }
        return this.zzyu;
    }

    public final void cancel() {
        this.zzcl();
        this.zzyt.cancel(this.zzeo());
        this.zzatr.cancel();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzlr();
        }
    }

    private final PendingIntent zzeo() {
        Context context = this.getContext();
        Intent intent = new Intent().setClassName(context, "com.google.android.gms.measurement.AppMeasurementReceiver").setAction("com.google.android.gms.measurement.UPLOAD");
        return PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0);
    }
}

