/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzfw;
import com.google.android.gms.internal.measurement.zzfz;
import com.google.android.gms.internal.measurement.zzxz;
import com.google.android.gms.internal.measurement.zzyc;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzaw;
import com.google.android.gms.measurement.internal.zzba;
import com.google.android.gms.measurement.internal.zzbb;
import com.google.android.gms.measurement.internal.zzbd;
import com.google.android.gms.measurement.internal.zzbq;
import com.google.android.gms.measurement.internal.zzbr;
import com.google.android.gms.measurement.internal.zzbw;
import com.google.android.gms.measurement.internal.zzct;
import com.google.android.gms.measurement.internal.zzdv;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzfq;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzs;
import com.google.android.gms.measurement.internal.zzt;
import com.google.android.gms.measurement.internal.zzv;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzfo
implements zzct {
    private static volatile zzfo zzatg;
    private zzbq zzath;
    private zzaw zzati;
    private zzt zzatj;
    private zzbb zzatk;
    private zzfk zzatl;
    private zzm zzatm;
    private final zzfu zzatn;
    private zzdv zzato;
    private final zzbw zzada;
    private boolean zzvz = false;
    private boolean zzatp;
    private boolean zzatq;
    @VisibleForTesting
    private long zzatr;
    private List<Runnable> zzats;
    private int zzatt;
    private int zzatu;
    private boolean zzatv;
    private boolean zzatw;
    private boolean zzatx;
    private FileLock zzaty;
    private FileChannel zzatz;
    private List<Long> zzaua;
    private List<Long> zzaub;
    private long zzauc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzfo zzn(Context context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzatg != null) return zzatg;
        Class<zzfo> clazz = zzfo.class;
        synchronized (zzfo.class) {
            if (zzatg != null) return zzatg;
            zzft zzft2 = new zzft(context);
            zzatg = new zzfo(zzft2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzatg;
        }
    }

    private zzfo(zzft zzft2) {
        this(zzft2, null);
    }

    private zzfo(zzft zzft2, zzbw zzbw2) {
        Preconditions.checkNotNull((Object)zzft2);
        this.zzada = zzbw2 = zzbw.zza((Context)zzft2.zzri, null);
        this.zzauc = -1L;
        zzfo zzfo2 = this;
        zzfu zzfu2 = new zzfu(zzfo2);
        zzfu2.zzq();
        this.zzatn = zzfu2;
        zzfo2 = this;
        zzaw zzaw2 = new zzaw(zzfo2);
        zzaw2.zzq();
        this.zzati = zzaw2;
        zzfo2 = this;
        zzbq zzbq2 = new zzbq(zzfo2);
        zzbq2.zzq();
        this.zzath = zzbq2;
        this.zzada.zzgs().zzc((Runnable)new zzfp(this, zzft2));
    }

    @WorkerThread
    private final void zza(zzft zzft2) {
        this.zzada.zzgs().zzaf();
        zzfo zzfo2 = this;
        zzt zzt2 = new zzt(zzfo2);
        zzt2.zzq();
        this.zzatj = zzt2;
        this.zzada.zzgv().zza((zzs)this.zzath);
        zzfo2 = this;
        zzm zzm2 = new zzm(zzfo2);
        zzm2.zzq();
        this.zzatm = zzm2;
        zzfo2 = this;
        zzdv zzdv2 = new zzdv(zzfo2);
        zzdv2.zzq();
        this.zzato = zzdv2;
        zzfo2 = this;
        zzfk zzfk2 = new zzfk(zzfo2);
        zzfk2.zzq();
        this.zzatl = zzfk2;
        zzfo2 = this;
        this.zzatk = new zzbb(zzfo2);
        if (this.zzatt != this.zzatu) {
            this.zzada.zzgt().zzjg().zze("Not all upload components initialized", (Object)this.zzatt, (Object)this.zzatu);
        }
        this.zzvz = true;
    }

    @WorkerThread
    protected final void start() {
        this.zzada.zzgs().zzaf();
        this.zzjt().zzij();
        if (this.zzada.zzgu().zzana.get() == 0L) {
            this.zzada.zzgu().zzana.set(this.zzada.zzbx().currentTimeMillis());
        }
        this.zzmb();
    }

    public final zzn zzgw() {
        return this.zzada.zzgw();
    }

    public final zzq zzgv() {
        return this.zzada.zzgv();
    }

    public final zzas zzgt() {
        return this.zzada.zzgt();
    }

    public final zzbr zzgs() {
        return this.zzada.zzgs();
    }

    private final zzbq zzls() {
        zzfo.zza(this.zzath);
        return this.zzath;
    }

    public final zzaw zzlt() {
        zzfo.zza(this.zzati);
        return this.zzati;
    }

    public final zzt zzjt() {
        zzfo.zza(this.zzatj);
        return this.zzatj;
    }

    private final zzbb zzlu() {
        if (this.zzatk == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzatk;
    }

    private final zzfk zzlv() {
        zzfo.zza(this.zzatl);
        return this.zzatl;
    }

    public final zzm zzjs() {
        zzfo.zza(this.zzatm);
        return this.zzatm;
    }

    public final zzdv zzlw() {
        zzfo.zza(this.zzato);
        return this.zzato;
    }

    public final zzfu zzjr() {
        zzfo.zza(this.zzatn);
        return this.zzatn;
    }

    public final zzaq zzgq() {
        return this.zzada.zzgq();
    }

    public final Context getContext() {
        return this.zzada.getContext();
    }

    public final Clock zzbx() {
        return this.zzada.zzbx();
    }

    public final zzfy zzgr() {
        return this.zzada.zzgr();
    }

    @WorkerThread
    private final void zzaf() {
        this.zzada.zzgs().zzaf();
    }

    final void zzlx() {
        if (!this.zzvz) {
            throw new IllegalStateException("UploadController is not initialized");
        }
    }

    private static void zza(zzfn zzfn2) {
        if (zzfn2 == null) {
            throw new IllegalStateException("Upload Component not created");
        }
        if (!zzfn2.isInitialized()) {
            String string = String.valueOf(((Object)((Object)zzfn2)).getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    final void zze(zzk zzk2) {
        this.zzaf();
        this.zzlx();
        Preconditions.checkNotEmpty((String)zzk2.packageName);
        this.zzg(zzk2);
    }

    private final long zzly() {
        long l = this.zzada.zzbx().currentTimeMillis();
        zzbd zzbd2 = this.zzada.zzgu();
        zzbd2.zzcl();
        zzbd2.zzaf();
        long l2 = zzbd2.zzane.get();
        if (l2 == 0L) {
            l2 = 1L + (long)zzbd2.zzgr().zzmk().nextInt(86400000);
            zzbd2.zzane.set(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    final void zzd(zzag zzag2, String string) {
        zzg zzg2 = this.zzjt().zzbm(string);
        if (zzg2 == null || TextUtils.isEmpty((CharSequence)zzg2.zzak())) {
            this.zzada.zzgt().zzjn().zzg("No app data available; dropping event", (Object)string);
            return;
        }
        Boolean bl = this.zzc(zzg2);
        if (bl == null) {
            if (!"_ui".equals(zzag2.name)) {
                this.zzada.zzgt().zzjj().zzg("Could not find package. appId", zzas.zzbw((String)string));
            }
        } else if (!bl.booleanValue()) {
            this.zzada.zzgt().zzjg().zzg("App version does not match; dropping event. appId", zzas.zzbw((String)string));
            return;
        }
        zzk zzk2 = new zzk(string, zzg2.getGmpAppId(), zzg2.zzak(), zzg2.zzhf(), zzg2.zzhg(), zzg2.zzhh(), zzg2.zzhi(), null, zzg2.isMeasurementEnabled(), false, zzg2.getFirebaseInstanceId(), zzg2.zzhv(), 0L, 0, zzg2.zzhw(), zzg2.zzhx(), false, zzg2.zzhb());
        this.zzc(zzag2, zzk2);
    }

    @WorkerThread
    final void zzc(zzag zzag2, zzk zzk2) {
        Preconditions.checkNotNull((Object)zzk2);
        Preconditions.checkNotEmpty((String)zzk2.packageName);
        this.zzaf();
        this.zzlx();
        String string = zzk2.packageName;
        long l = zzag2.zzaig;
        if (!this.zzjr().zze(zzag2, zzk2)) {
            return;
        }
        if (!zzk2.zzafr) {
            this.zzg(zzk2);
            return;
        }
        this.zzjt().beginTransaction();
        try {
            zzo zzo2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string2;
            List list3;
            long l2 = l;
            String string3 = string;
            zzt zzt2 = this.zzjt();
            Preconditions.checkNotEmpty((String)string3);
            zzt2.zzaf();
            zzt2.zzcl();
            if (l2 < 0L) {
                zzt2.zzgt().zzjj().zze("Invalid time querying timed out conditional properties", zzas.zzbw((String)string3), (Object)l2);
                list3 = Collections.emptyList();
            } else {
                string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string3, String.valueOf(l2)};
                list3 = zzt2.zzb(string2, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzada.zzgt().zzjn().zzd("User property timed out", (Object)((zzo)object22).packageName, (Object)this.zzada.zzgq().zzbv(((zzo)object22).zzags.name), ((zzo)object22).zzags.getValue());
                if (((zzo)object22).zzagt != null) {
                    this.zzd(new zzag(((zzo)object22).zzagt, l), zzk2);
                }
                this.zzjt().zzk(string, ((zzo)object22).zzags.name);
            }
            l2 = l;
            string3 = string;
            zzt2 = this.zzjt();
            Preconditions.checkNotEmpty((String)string3);
            zzt2.zzaf();
            zzt2.zzcl();
            if (l2 < 0L) {
                zzt2.zzgt().zzjj().zze("Invalid time querying expired conditional properties", zzas.zzbw((String)string3), (Object)l2);
                list2 = Collections.emptyList();
            } else {
                string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string3, String.valueOf(l2)};
                list2 = zzt2.zzb(string2, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzo)object4.next();
                if (object == null) continue;
                this.zzada.zzgt().zzjn().zzd("User property expired", (Object)((zzo)object).packageName, (Object)this.zzada.zzgq().zzbv(((zzo)object).zzags.name), ((zzo)object).zzags.getValue());
                this.zzjt().zzh(string, ((zzo)object).zzags.name);
                if (((zzo)object).zzagv != null) {
                    object22.add(((zzo)object).zzagv);
                }
                this.zzjt().zzk(string, ((zzo)object).zzags.name);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzag)e;
                this.zzd(new zzag((zzag)object, l), zzk2);
            }
            long l3 = l;
            String string4 = zzag2.name;
            string3 = string;
            zzt2 = this.zzjt();
            Preconditions.checkNotEmpty((String)string3);
            Preconditions.checkNotEmpty((String)string4);
            zzt2.zzaf();
            zzt2.zzcl();
            if (l3 < 0L) {
                zzt2.zzgt().zzjj().zzd("Invalid time querying triggered conditional properties", zzas.zzbw((String)string3), (Object)zzt2.zzgq().zzbt(string4), (Object)l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string3, string4, String.valueOf(l3)};
                list = zzt2.zzb((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzo2 = (zzo)iterator.next();
                if (zzo2 == null) continue;
                zzfv zzfv2 = zzo2.zzags;
                zzfx zzfx2 = new zzfx(zzo2.packageName, zzo2.origin, zzfv2.name, l, zzfv2.getValue());
                if (this.zzjt().zza(zzfx2)) {
                    this.zzada.zzgt().zzjn().zzd("User property triggered", (Object)zzo2.packageName, (Object)this.zzada.zzgq().zzbv(zzfx2.name), zzfx2.value);
                } else {
                    this.zzada.zzgt().zzjg().zzd("Too many active user properties, ignoring", zzas.zzbw((String)zzo2.packageName), (Object)this.zzada.zzgq().zzbv(zzfx2.name), zzfx2.value);
                }
                if (zzo2.zzagu != null) {
                    object.add(zzo2.zzagu);
                }
                zzo2.zzags = new zzfv(zzfx2);
                zzo2.active = true;
                this.zzjt().zza(zzo2);
            }
            this.zzd(zzag2, zzk2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzo2 = (zzag)e;
                this.zzd(new zzag((zzag)zzo2, l), zzk2);
            }
            this.zzjt().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzjt().endTransaction();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @WorkerThread
    private final void zzd(zzag var1_1, zzk var2_2) {
        Preconditions.checkNotNull((Object)var2_2);
        Preconditions.checkNotEmpty((String)var2_2.packageName);
        var3_3 = System.nanoTime();
        this.zzaf();
        this.zzlx();
        var5_4 = var2_2.packageName;
        if (!this.zzjr().zze(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzafr) {
            this.zzg(var2_2);
            return;
        }
        if (this.zzls().zzo(var5_4, var1_1.name)) {
            this.zzada.zzgt().zzjj().zze("Dropping blacklisted event. appId", zzas.zzbw((String)var5_4), (Object)this.zzada.zzgq().zzbt(var1_1.name));
            var6_5 = this.zzls().zzcl(var5_4) != false || this.zzls().zzcm(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.name)) {
                this.zzada.zzgr().zza(var5_4, 11, "_ev", var1_1.name, 0);
            }
            if (var6_5 && (var7_7 = this.zzjt().zzbm(var5_4)) != null) {
                var8_9 = Math.max(var7_7.zzhl(), var7_7.zzhk());
                if (Math.abs(this.zzada.zzbx().currentTimeMillis() - var8_9) > (Long)zzai.zzajt.get()) {
                    this.zzada.zzgt().zzjn().zzby("Fetching config for blacklisted app");
                    this.zzb(var7_7);
                }
            }
            return;
        }
        if (this.zzada.zzgt().isLoggable(2)) {
            this.zzada.zzgt().zzjo().zzg("Logging event", (Object)this.zzada.zzgq().zzb(var1_1));
        }
        this.zzjt().beginTransaction();
        try {
            block54: {
                block55: {
                    block57: {
                        block61: {
                            block60: {
                                block58: {
                                    block59: {
                                        this.zzg(var2_2);
                                        if (!"_iap".equals(var1_1.name) && !"ecommerce_purchase".equals(var1_1.name)) break block57;
                                        var20_11 = var1_1;
                                        var19_14 = var5_4;
                                        var18_15 = this;
                                        var21_16 /* !! */  = var20_11.zzahu.getString("currency");
                                        if (!"ecommerce_purchase".equals(var20_11.name)) break block58;
                                        var24_17 = var20_11.zzahu.zzbr("value") * 1000000.0;
                                        if (var24_17 == 0.0) {
                                            var24_17 = (double)var20_11.zzahu.getLong("value").longValue() * 1000000.0;
                                        }
                                        if (!(var24_17 <= 9.223372036854776E18) || !(var24_17 >= -9.223372036854776E18)) break block59;
                                        var22_20 = Math.round(var24_17);
                                        break block60;
                                    }
                                    var18_15.zzada.zzgt().zzjj().zze("Data lost. Currency value is too big. appId", zzas.zzbw((String)var19_14), (Object)var24_17);
                                    v0 = false;
                                    break block61;
                                }
                                var22_20 = var20_11.zzahu.getLong("value");
                            }
                            if (!TextUtils.isEmpty((CharSequence)var21_16 /* !! */ ) && (var21_16 /* !! */  = var21_16 /* !! */ .toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                                v1 = String.valueOf("_ltv_");
                                v2 = String.valueOf(var21_16 /* !! */ );
                                var24_18 = v2.length() != 0 ? v1.concat(v2) : new String(v1);
                                var25_22 = var18_15.zzjt().zzi(var19_14, var24_18);
                                if (var25_22 == null || !(var25_22.value instanceof Long)) {
                                    var29_25 = var19_14;
                                    var34_26 = var18_15.zzada.zzgv().zzb(var29_25, zzai.zzajy) - 1;
                                    var33_27 = var19_14;
                                    var32_28 = var18_15.zzjt();
                                    Preconditions.checkNotEmpty((String)var33_27);
                                    var32_28.zzaf();
                                    var32_28.zzcl();
                                    try {
                                        var32_28.getWritableDatabase().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{var33_27, var33_27, String.valueOf(var34_26)});
                                    }
                                    catch (SQLiteException var35_29) {
                                        var32_28.zzgt().zzjg().zze("Error pruning currencies. appId", zzas.zzbw((String)var33_27), (Object)var35_29);
                                    }
                                    var25_22 = new zzfx(var19_14, var20_11.origin, var24_18, var18_15.zzada.zzbx().currentTimeMillis(), (Object)var22_20);
                                } else {
                                    var26_30 = (Long)var25_22.value;
                                    var25_22 = new zzfx(var19_14, var20_11.origin, var24_18, var18_15.zzada.zzbx().currentTimeMillis(), (Object)(var26_30 + var22_20));
                                }
                                if (!var18_15.zzjt().zza(var25_22)) {
                                    var18_15.zzada.zzgt().zzjg().zzd("Too many unique user properties are set. Ignoring user property. appId", zzas.zzbw((String)var19_14), (Object)var18_15.zzada.zzgq().zzbv(var25_22.name), var25_22.value);
                                    var18_15.zzada.zzgr().zza(var19_14, 9, null, null, 0);
                                }
                            }
                            v0 = true;
                        }
                        if (!v0) {
                            this.zzjt().setTransactionSuccessful();
                            return;
                        }
                    }
                    var6_6 = zzfy.zzct((String)var1_1.name);
                    var7_8 = "_err".equals(var1_1.name);
                    var8_10 = this.zzjt().zza(this.zzly(), var5_4, true, var6_6, false, var7_8, false);
                    var9_32 = var8_10.zzahi - (long)((Integer)zzai.zzaje.get()).intValue();
                    if (var9_32 > 0L) {
                        if (var9_32 % 1000L == 1L) {
                            this.zzada.zzgt().zzjg().zze("Data loss. Too many events logged. appId, count", zzas.zzbw((String)var5_4), (Object)var8_10.zzahi);
                        }
                        this.zzjt().setTransactionSuccessful();
                        return;
                    }
                    if (var6_6 && (var9_32 = var8_10.zzahh - (long)((Integer)zzai.zzajg.get()).intValue()) > 0L) {
                        if (var9_32 % 1000L == 1L) {
                            this.zzada.zzgt().zzjg().zze("Data loss. Too many public events logged. appId, count", zzas.zzbw((String)var5_4), (Object)var8_10.zzahh);
                        }
                        this.zzada.zzgr().zza(var5_4, 16, "_ev", var1_1.name, 0);
                        this.zzjt().setTransactionSuccessful();
                        return;
                    }
                    if (var7_8) {
                        var19_14 = var2_2.packageName;
                        var20_12 = this.zzada.zzgv().zzb(var19_14, zzai.zzajf);
                        var9_32 = var8_10.zzahk - (long)Math.max(0, var20_12 = Math.min(1000000, var20_12));
                        if (var9_32 > 0L) {
                            if (var9_32 == 1L) {
                                this.zzada.zzgt().zzjg().zze("Too many error events logged. appId, count", zzas.zzbw((String)var5_4), (Object)var8_10.zzahk);
                            }
                            this.zzjt().setTransactionSuccessful();
                            return;
                        }
                    }
                    var11_33 = var1_1.zzahu.zziy();
                    this.zzada.zzgr().zza(var11_33, "_o", (Object)var1_1.origin);
                    if (this.zzada.zzgr().zzcz(var5_4)) {
                        this.zzada.zzgr().zza(var11_33, "_dbg", (Object)1L);
                        this.zzada.zzgr().zza(var11_33, "_r", (Object)1L);
                    }
                    if (this.zzada.zzgv().zzbh(var2_2.packageName) && "_s".equals(var1_1.name) && (var12_34 = this.zzjt().zzi(var2_2.packageName, "_sno")) != null && var12_34.value instanceof Long) {
                        this.zzada.zzgr().zza(var11_33, "_sno", var12_34.value);
                    }
                    if ((var12_35 = this.zzjt().zzbn(var5_4)) > 0L) {
                        this.zzada.zzgt().zzjj().zze("Data lost. Too many events stored on disk, deleted. appId", zzas.zzbw((String)var5_4), (Object)var12_35);
                    }
                    var14_36 = new zzab(this.zzada, var1_1.origin, var5_4, var1_1.name, var1_1.zzaig, 0L, var11_33);
                    var15_37 = this.zzjt().zzg(var5_4, var14_36.name);
                    if (var15_37 == null) {
                        if (this.zzjt().zzbq(var5_4) >= 500L && var6_6) {
                            this.zzada.zzgt().zzjg().zzd("Too many event names used, ignoring event. appId, name, supported count", zzas.zzbw((String)var5_4), (Object)this.zzada.zzgq().zzbt(var14_36.name), (Object)500);
                            this.zzada.zzgr().zza(var5_4, 8, null, null, 0);
                            return;
                        }
                        var16_38 = new zzac(var5_4, var14_36.name, 0L, 0L, var14_36.timestamp, 0L, null, null, null, null);
                    } else {
                        var14_36 = var14_36.zza(this.zzada, var15_37.zzahx);
                        var16_38 = var15_37.zzae(var14_36.timestamp);
                    }
                    this.zzjt().zza(var16_38);
                    var20_13 = var2_2;
                    var19_14 = var14_36;
                    var18_15 = this;
                    var18_15.zzaf();
                    var18_15.zzlx();
                    Preconditions.checkNotNull((Object)var19_14);
                    Preconditions.checkNotNull((Object)var20_13);
                    Preconditions.checkNotEmpty((String)var19_14.zztt);
                    Preconditions.checkArgument((boolean)var19_14.zztt.equals(var20_13.packageName));
                    var21_16 /* !! */  = new zzfw();
                    new zzfw().zzaxh = 1;
                    var21_16 /* !! */ .zzaxp = "android";
                    var21_16 /* !! */ .zztt = var20_13.packageName;
                    var21_16 /* !! */ .zzafp = var20_13.zzafp;
                    var21_16 /* !! */ .zzts = var20_13.zzts;
                    var21_16 /* !! */ .zzayb = var20_13.zzafo == -2147483648L ? null : Integer.valueOf((int)var20_13.zzafo);
                    var21_16 /* !! */ .zzaxt = var20_13.zzade;
                    var21_16 /* !! */ .zzafi = var20_13.zzafi;
                    var21_16 /* !! */ .zzawp = var20_13.zzafv;
                    v3 = var21_16 /* !! */ .zzaxx = var20_13.zzafq == 0L ? null : Long.valueOf(var20_13.zzafq);
                    if (var18_15.zzada.zzgv().zze(var20_13.packageName, zzai.zzale)) {
                        var21_16 /* !! */ .zzayl = var18_15.zzjr().zzmi();
                    }
                    if ((var22_21 = var18_15.zzada.zzgu().zzbz(var20_13.packageName)) != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var22_21.first))) {
                        if (var20_13.zzaft) {
                            var21_16 /* !! */ .zzaxv = (String)var22_21.first;
                            var21_16 /* !! */ .zzaxw = (Boolean)var22_21.second;
                        }
                    } else if (!var18_15.zzada.zzgp().zzl(var18_15.zzada.getContext()) && var20_13.zzafu) {
                        var23_39 = Settings.Secure.getString((ContentResolver)var18_15.zzada.getContext().getContentResolver(), (String)"android_id");
                        if (var23_39 == null) {
                            var18_15.zzada.zzgt().zzjj().zzg("null secure ID. appId", zzas.zzbw((String)var21_16 /* !! */ .zztt));
                            var23_39 = "null";
                        } else if (var23_39.isEmpty()) {
                            var18_15.zzada.zzgt().zzjj().zzg("empty secure ID. appId", zzas.zzbw((String)var21_16 /* !! */ .zztt));
                        }
                        var21_16 /* !! */ .zzaye = var23_39;
                    }
                    var18_15.zzada.zzgp().zzcl();
                    var21_16 /* !! */ .zzaxr = Build.MODEL;
                    var18_15.zzada.zzgp().zzcl();
                    var21_16 /* !! */ .zzaxq = Build.VERSION.RELEASE;
                    var21_16 /* !! */ .zzaxs = (int)var18_15.zzada.zzgp().zziw();
                    var21_16 /* !! */ .zzahr = var18_15.zzada.zzgp().zzix();
                    var21_16 /* !! */ .zzaxu = null;
                    var21_16 /* !! */ .zzaxk = null;
                    var21_16 /* !! */ .zzaxl = null;
                    var21_16 /* !! */ .zzaxm = null;
                    var21_16 /* !! */ .zzayg = var20_13.zzafs;
                    if (var18_15.zzada.isEnabled() && zzq.zzie()) {
                        var21_16 /* !! */ .zzayh = null;
                    }
                    if ((var23_39 = var18_15.zzjt().zzbm(var20_13.packageName)) == null) {
                        var23_39 = new zzg(var18_15.zzada, var20_13.packageName);
                        var23_39.zzaj(var18_15.zzada.zzgr().zzmm());
                        var23_39.zzan(var20_13.zzafk);
                        var23_39.zzak(var20_13.zzafi);
                        var23_39.zzam(var18_15.zzada.zzgu().zzca(var20_13.packageName));
                        var23_39.zzt(0L);
                        var23_39.zzo(0L);
                        var23_39.zzp(0L);
                        var23_39.setAppVersion(var20_13.zzts);
                        var23_39.zzq(var20_13.zzafo);
                        var23_39.zzao(var20_13.zzafp);
                        var23_39.zzr(var20_13.zzade);
                        var23_39.zzs(var20_13.zzafq);
                        var23_39.setMeasurementEnabled(var20_13.zzafr);
                        var23_39.zzac(var20_13.zzafs);
                        var18_15.zzjt().zza((zzg)var23_39);
                    }
                    var21_16 /* !! */ .zzafh = var23_39.getAppInstanceId();
                    var21_16 /* !! */ .zzafk = var23_39.getFirebaseInstanceId();
                    var24_19 = var18_15.zzjt().zzbl(var20_13.packageName);
                    var21_16 /* !! */ .zzaxj = new zzfz[var24_19.size()];
                    for (var25_23 = 0; var25_23 < var24_19.size(); ++var25_23) {
                        var21_16 /* !! */ .zzaxj[var25_23] = var26_31 = new zzfz();
                        var26_31.name = var24_19.get((int)var25_23).name;
                        var26_31.zzayu = var24_19.get((int)var25_23).zzauk;
                        var18_15.zzjr().zza(var26_31, var24_19.get((int)var25_23).value);
                    }
                    try {
                        var25_24 = var18_15.zzjt().zza((zzfw)var21_16 /* !! */ );
                    }
                    catch (IOException var27_40) {
                        var18_15.zzada.zzgt().zzjg().zze("Data loss. Failed to insert raw event metadata. appId", zzas.zzbw((String)var21_16 /* !! */ .zztt), (Object)var27_40);
                        break block54;
                    }
                    v4 = var18_15.zzjt();
                    var29_25 = var19_14;
                    var28_41 = var18_15;
                    if (var29_25.zzahu == null) ** GOTO lbl-1000
                    for (Object var31_44 : var29_25.zzahu) {
                        if (!"_r".equals(var31_44)) continue;
                        v5 = true;
                        break block55;
                    }
                    var30_43 = var28_41.zzls().zzp(var29_25.zztt, var29_25.name);
                    var31_44 = var28_41.zzjt().zza(var28_41.zzly(), var29_25.zztt, false, false, false, false, false);
                    if (var30_43 && var31_44.zzahl < (long)var28_41.zzada.zzgv().zzaq(var29_25.zztt)) {
                        v5 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = false;
                    }
                }
                if (v4.zza((zzab)var19_14, var25_24, v5)) {
                    var18_15.zzatr = 0L;
                }
            }
            this.zzjt().setTransactionSuccessful();
            if (this.zzada.zzgt().isLoggable(2)) {
                this.zzada.zzgt().zzjo().zzg("Event recorded", (Object)this.zzada.zzgq().zza(var14_36));
            }
        }
        finally {
            this.zzjt().endTransaction();
        }
        this.zzmb();
        this.zzada.zzgt().zzjo().zzg("Background event processing time, ms", (Object)((System.nanoTime() - var3_3 + 500000L) / 1000000L));
    }

    @WorkerThread
    final void zzlz() {
        this.zzaf();
        this.zzlx();
        this.zzatx = true;
        try {
            String string;
            zzn zzn2 = this.zzada.zzgw();
            Boolean bl = this.zzada.zzgl().zzli();
            if (bl == null) {
                this.zzada.zzgt().zzjj().zzby("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzada.zzgt().zzjg().zzby("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzatr > 0L) {
                this.zzmb();
                return;
            }
            zzct zzct2 = this;
            zzct2.zzaf();
            if (zzct2.zzaua != null) {
                this.zzada.zzgt().zzjo().zzby("Uploading requested multiple times");
                return;
            }
            if (!this.zzlt().zzfb()) {
                this.zzada.zzgt().zzjo().zzby("Network not connected, ignoring upload request");
                this.zzmb();
                return;
            }
            long l = this.zzada.zzbx().currentTimeMillis();
            long l2 = l - zzq.zzic();
            this.zzd(null, l2);
            long l3 = this.zzada.zzgu().zzana.get();
            if (l3 != 0L) {
                this.zzada.zzgt().zzjn().zzg("Uploading events. Elapsed time since last upload attempt (ms)", (Object)Math.abs(l - l3));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzjt().zzih()))) {
                if (this.zzauc == -1L) {
                    this.zzauc = this.zzjt().zzio();
                }
                Object object = string;
                int n = this.zzada.zzgv().zzb((String)object, zzai.zzaja);
                object = string;
                zzct2 = this.zzada.zzgv();
                int n2 = Math.max(0, zzct2.zzb((String)object, zzai.zzajb));
                List<Pair<zzfw, Long>> list = this.zzjt().zzb(string, n, n2);
                if (!list.isEmpty()) {
                    Object object2;
                    String string2 = null;
                    Object object3 = list.iterator();
                    while (object3.hasNext()) {
                        zzfw zzfw2 = (zzfw)((Object)object3.next().first);
                        if (TextUtils.isEmpty((CharSequence)zzfw2.zzaxv)) continue;
                        string2 = zzfw2.zzaxv;
                        break;
                    }
                    if (string2 != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            object2 = (zzfw)((Object)list.get((int)i).first);
                            if (TextUtils.isEmpty((CharSequence)((zzfw)((Object)object2)).zzaxv) || ((zzfw)((Object)object2)).zzaxv.equals(string2)) continue;
                            list = list.subList(0, i);
                            break;
                        }
                    }
                    object3 = new com.google.android.gms.internal.measurement.zzfv();
                    new com.google.android.gms.internal.measurement.zzfv().zzaxf = new zzfw[list.size()];
                    object2 = new ArrayList(list.size());
                    boolean bl2 = zzq.zzie() && this.zzada.zzgv().zzas(string);
                    for (int i = 0; i < ((com.google.android.gms.internal.measurement.zzfv)((Object)object3)).zzaxf.length; ++i) {
                        ((com.google.android.gms.internal.measurement.zzfv)((Object)object3)).zzaxf[i] = (zzfw)((Object)list.get((int)i).first);
                        object2.add((Long)list.get((int)i).second);
                        ((com.google.android.gms.internal.measurement.zzfv)((Object)object3)).zzaxf[i].zzaxu = this.zzada.zzgv().zzhh();
                        ((com.google.android.gms.internal.measurement.zzfv)((Object)object3)).zzaxf[i].zzaxk = l;
                        zzn2 = this.zzada.zzgw();
                        ((com.google.android.gms.internal.measurement.zzfv)((Object)object3)).zzaxf[i].zzaxz = false;
                        if (bl2) continue;
                        ((com.google.android.gms.internal.measurement.zzfv)((Object)object3)).zzaxf[i].zzayh = null;
                    }
                    String string3 = null;
                    if (this.zzada.zzgt().isLoggable(2)) {
                        string3 = this.zzjr().zzb((com.google.android.gms.internal.measurement.zzfv)((Object)object3));
                    }
                    byte[] byArray = this.zzjr().zza((com.google.android.gms.internal.measurement.zzfv)((Object)object3));
                    String string4 = (String)zzai.zzajk.get();
                    try {
                        URL uRL = new URL(string4);
                        object = object2;
                        zzct2 = this;
                        Preconditions.checkArgument((!object.isEmpty() ? 1 : 0) != 0);
                        if (zzct2.zzaua != null) {
                            zzct2.zzada.zzgt().zzjg().zzby("Set uploading progress before finishing the previous upload");
                        } else {
                            zzct2.zzaua = new ArrayList<Long>((Collection<Long>)object);
                        }
                        this.zzada.zzgu().zzanb.set(l);
                        String string5 = "?";
                        if (((com.google.android.gms.internal.measurement.zzfv)((Object)object3)).zzaxf.length > 0) {
                            string5 = ((com.google.android.gms.internal.measurement.zzfv)((Object)object3)).zzaxf[0].zztt;
                        }
                        this.zzada.zzgt().zzjo().zzd("Uploading data. app, uncompressed size, data", (Object)string5, (Object)byArray.length, (Object)string3);
                        this.zzatw = true;
                        zzfq zzfq2 = new zzfq(this, string);
                        byte[] byArray2 = byArray;
                        URL uRL2 = uRL;
                        object = string;
                        zzct2 = this.zzlt();
                        zzct2.zzaf();
                        zzct2.zzcl();
                        Preconditions.checkNotNull((Object)uRL2);
                        Preconditions.checkNotNull((Object)byArray2);
                        Preconditions.checkNotNull((Object)zzfq2);
                        zzct2.zzgs().zzd((Runnable)new zzba((zzaw)zzct2, (String)object, uRL2, byArray2, null, zzfq2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzada.zzgt().zzjg().zze("Failed to parse upload URL. Not uploading. appId", zzas.zzbw((String)string), (Object)string4);
                    }
                }
            } else {
                zzg zzg2;
                this.zzauc = -1L;
                String string6 = this.zzjt().zzad(l - zzq.zzic());
                if (!TextUtils.isEmpty((CharSequence)string6) && (zzg2 = this.zzjt().zzbm(string6)) != null) {
                    this.zzb(zzg2);
                }
            }
            return;
        }
        finally {
            this.zzatx = false;
            this.zzmc();
        }
    }

    @WorkerThread
    private final boolean zzd(String string, long l) {
        this.zzjt().beginTransaction();
        try {
            block143: {
                Object object;
                int n;
                com.google.android.gms.internal.measurement.zzfu zzfu2;
                zzyc zzyc2;
                int n3;
                Object object2;
                Object object3;
                zza zza2;
                block141: {
                    zza zza3 = zza2 = new zza(null);
                    long l2 = this.zzauc;
                    long l3 = l;
                    object3 = null;
                    object2 = this.zzjt();
                    Preconditions.checkNotNull((Object)zza3);
                    object2.zzaf();
                    object2.zzcl();
                    try (Cursor cursor = null;){
                        String[] stringArray;
                        String string2;
                        String string3;
                        String string4;
                        String[] stringArray2;
                        SQLiteDatabase sQLiteDatabase = object2.getWritableDatabase();
                        if (TextUtils.isEmpty(null)) {
                            stringArray2 = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            string4 = l2 != -1L ? "rowid <= ? and " : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(148 + String.valueOf(string4).length()).append("select app_id, metadata_fingerprint from raw_events where ").append(string4).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block141;
                            object3 = cursor.getString(0);
                            string3 = cursor.getString(1);
                            cursor.close();
                        } else {
                            stringArray2 = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            string4 = l2 != -1L ? " and rowid <= ?" : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(84 + String.valueOf(string4).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append(string4).append(" order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block141;
                            string3 = cursor.getString(0);
                            cursor.close();
                        }
                        cursor = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{object3, string3}, null, null, "rowid", "2");
                        if (!cursor.moveToFirst()) {
                            object2.zzgt().zzjg().zzg("Raw event metadata record is missing. appId", zzas.zzbw((String)object3));
                            break block141;
                        }
                        byte[] byArray = cursor.getBlob(0);
                        string4 = zzxz.zzj((byte[])byArray, (int)0, (int)byArray.length);
                        zzfw zzfw2 = new zzfw();
                        try {
                            zzfw2.zza((zzxz)string4);
                        }
                        catch (IOException iOException) {
                            object2.zzgt().zzjg().zze("Data loss. Failed to merge raw event metadata. appId", zzas.zzbw((String)object3), (Object)iOException);
                            if (cursor != null) {
                                cursor.close();
                            }
                            break block141;
                        }
                        if (cursor.moveToNext()) {
                            object2.zzgt().zzjj().zzg("Get multiple raw event metadata records, expected one. appId", zzas.zzbw((String)object3));
                        }
                        cursor.close();
                        zza3.zzb(zzfw2);
                        if (l2 != -1L) {
                            string2 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            stringArray = new String[]{object3, string3, String.valueOf(l2)};
                        } else {
                            string2 = "app_id = ? and metadata_fingerprint = ?";
                            stringArray = new String[]{object3, string3};
                        }
                        cursor = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string2, stringArray, null, null, "rowid", null);
                        if (!cursor.moveToFirst()) {
                            object2.zzgt().zzjj().zzg("Raw event data disappeared while in transaction. appId", zzas.zzbw((String)object3));
                            break block141;
                        }
                        do {
                            long l4 = cursor.getLong(0);
                            byArray = cursor.getBlob(3);
                            string4 = zzxz.zzj((byte[])byArray, (int)0, (int)byArray.length);
                            com.google.android.gms.internal.measurement.zzft zzft2 = new com.google.android.gms.internal.measurement.zzft();
                            try {
                                zzft2.zza((zzxz)string4);
                            }
                            catch (IOException iOException) {
                                object2.zzgt().zzjg().zze("Data loss. Failed to merge raw event. appId", zzas.zzbw((String)object3), (Object)iOException);
                                continue;
                            }
                            zzft2.name = cursor.getString(1);
                            zzft2.zzaxb = cursor.getLong(2);
                            if (!zza3.zza(l4, zzft2)) break;
                        } while (cursor.moveToNext());
                    }
                }
                object2 = zza2;
                if (((zza)object2).zzaui == null || ((zza)object2).zzaui.isEmpty()) break block143;
                boolean bl = false;
                zzfw zzfw3 = zza2.zzaug;
                zza2.zzaug.zzaxi = new com.google.android.gms.internal.measurement.zzft[zza2.zzaui.size()];
                int n4 = 0;
                long l5 = 0L;
                boolean bl2 = this.zzada.zzgv().zzau(zzfw3.zztt);
                boolean bl3 = this.zzada.zzgv().zze(zza2.zzaug.zztt, zzai.zzala);
                zzyc zzyc3 = null;
                zzyc zzyc4 = null;
                for (n3 = 0; n3 < zza2.zzaui.size(); ++n3) {
                    boolean bl4;
                    block145: {
                        int zzfuArray2;
                        boolean bl5;
                        block144: {
                            boolean bl6;
                            bl5 = bl;
                            zzyc2 = zza2.zzaui.get(n3);
                            if (this.zzls().zzo(zza2.zzaug.zztt, zzyc2.name)) {
                                this.zzada.zzgt().zzjj().zze("Dropping blacklisted raw event. appId", zzas.zzbw((String)zza2.zzaug.zztt), (Object)this.zzada.zzgq().zzbt(zzyc2.name));
                                if (this.zzls().zzcl(zza2.zzaug.zztt) || this.zzls().zzcm(zza2.zzaug.zztt) || "_err".equals(zzyc2.name)) continue;
                                this.zzada.zzgr().zza(zza2.zzaug.zztt, 11, "_ev", zzyc2.name, 0);
                                continue;
                            }
                            bl4 = this.zzls().zzp(zza2.zzaug.zztt, zzyc2.name);
                            if (bl4) break block144;
                            this.zzjr();
                            object2 = zzyc2.name;
                            Preconditions.checkNotEmpty((String)object2);
                            switch (object2) {
                                case "_in": 
                                case "_ui": 
                                case "_ug": {
                                    bl6 = true;
                                    break;
                                }
                                default: {
                                    bl6 = false;
                                }
                            }
                            if (!bl6) break block145;
                        }
                        boolean bl7 = false;
                        boolean n2 = false;
                        if (zzyc2.zzaxa == null) {
                            zzyc2.zzaxa = new com.google.android.gms.internal.measurement.zzfu[0];
                        }
                        com.google.android.gms.internal.measurement.zzfu[] i = zzyc2.zzaxa;
                        int zzfu3 = zzyc2.zzaxa.length;
                        for (zzfuArray2 = 0; zzfuArray2 < zzfu3; ++zzfuArray2) {
                            zzfu2 = i[zzfuArray2];
                            if ("_c".equals(zzfu2.name)) {
                                zzfu2.zzaxe = 1L;
                                bl7 = true;
                                continue;
                            }
                            if (!"_r".equals(zzfu2.name)) continue;
                            zzfu2.zzaxe = 1L;
                            n2 = true;
                        }
                        if (!bl7 && bl4) {
                            this.zzada.zzgt().zzjo().zzg("Marking event as conversion", (Object)this.zzada.zzgq().zzbt(zzyc2.name));
                            i = Arrays.copyOf(zzyc2.zzaxa, zzyc2.zzaxa.length + 1);
                            com.google.android.gms.internal.measurement.zzfu zzfu4 = new com.google.android.gms.internal.measurement.zzfu();
                            new com.google.android.gms.internal.measurement.zzfu().name = "_c";
                            zzfu4.zzaxe = 1L;
                            i[i.length - 1] = zzfu4;
                            zzyc2.zzaxa = i;
                        }
                        if (!n2) {
                            this.zzada.zzgt().zzjo().zzg("Marking event as real-time", (Object)this.zzada.zzgq().zzbt(zzyc2.name));
                            i = Arrays.copyOf(zzyc2.zzaxa, zzyc2.zzaxa.length + 1);
                            com.google.android.gms.internal.measurement.zzfu zzft4 = new com.google.android.gms.internal.measurement.zzfu();
                            new com.google.android.gms.internal.measurement.zzfu().name = "_r";
                            zzft4.zzaxe = 1L;
                            i[i.length - 1] = zzft4;
                            zzyc2.zzaxa = i;
                        }
                        bl = true;
                        if (this.zzjt().zza((long)this.zzly(), (String)zza2.zzaug.zztt, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zzahl > (long)this.zzada.zzgv().zzaq(zza2.zzaug.zztt)) {
                            for (zzfu3 = 0; zzfu3 < zzyc2.zzaxa.length; ++zzfu3) {
                                if (!"_r".equals(zzyc2.zzaxa[zzfu3].name)) continue;
                                com.google.android.gms.internal.measurement.zzfu[] string6 = new com.google.android.gms.internal.measurement.zzfu[zzyc2.zzaxa.length - 1];
                                if (zzfu3 > 0) {
                                    System.arraycopy(zzyc2.zzaxa, 0, string6, 0, zzfu3);
                                }
                                if (zzfu3 < string6.length) {
                                    System.arraycopy(zzyc2.zzaxa, zzfu3 + 1, string6, zzfu3, string6.length - zzfu3);
                                }
                                zzyc2.zzaxa = string6;
                                break;
                            }
                            bl = bl5;
                        }
                        if (zzfy.zzct((String)zzyc2.name) && bl4) {
                            object3 = zza2.zzaug.zztt;
                            if (this.zzjt().zza((long)this.zzly(), (String)zza2.zzaug.zztt, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zzahj > (long)this.zzada.zzgv().zzb((String)object3, zzai.zzajh)) {
                                this.zzada.zzgt().zzjj().zzg("Too many conversions. Not logging as conversion. appId", zzas.zzbw((String)zza2.zzaug.zztt));
                                zzfuArray2 = 0;
                                zzfu2 = null;
                                com.google.android.gms.internal.measurement.zzfu[] l9 = zzyc2.zzaxa;
                                int n5 = zzyc2.zzaxa.length;
                                for (n = 0; n < n5; ++n) {
                                    object = l9[n];
                                    if ("_c".equals(object.name)) {
                                        zzfu2 = object;
                                        continue;
                                    }
                                    if (!"_err".equals(object.name)) continue;
                                    zzfuArray2 = 1;
                                }
                                if (zzfuArray2 != 0 && zzfu2 != null) {
                                    zzyc2.zzaxa = (com.google.android.gms.internal.measurement.zzfu[])ArrayUtils.removeAll((Object[])zzyc2.zzaxa, (Object[])new com.google.android.gms.internal.measurement.zzfu[]{zzfu2});
                                } else if (zzfu2 != null) {
                                    zzfu2.name = "_err";
                                    zzfu2.zzaxe = 10L;
                                } else {
                                    this.zzada.zzgt().zzjg().zzg("Did not find conversion parameter. appId", zzas.zzbw((String)zza2.zzaug.zztt));
                                }
                            }
                        }
                    }
                    if (this.zzada.zzgv().zzbd(zza2.zzaug.zztt) && bl4) {
                        int n8;
                        object3 = zzyc2.zzaxa;
                        object2 = this;
                        int n9 = -1;
                        int zzftArray = -1;
                        for (n8 = 0; n8 < ((com.google.android.gms.internal.measurement.zzfu[])object3).length; ++n8) {
                            if ("value".equals(object3[n8].name)) {
                                n9 = n8;
                                continue;
                            }
                            if (!"currency".equals(object3[n8].name)) continue;
                            zzftArray = n8;
                        }
                        if (n9 != -1) {
                            if (object3[n9].zzaxe == null && object3[n9].zzaun == null) {
                                ((zzfo)object2).zzada.zzgt().zzjl().zzby("Value must be specified with a numeric type.");
                                object3 = zzfo.zza((com.google.android.gms.internal.measurement.zzfu[])object3, n9);
                                object3 = zzfo.zza(zzfo.zza((com.google.android.gms.internal.measurement.zzfu[])object3, "_c"), 18, "value");
                            } else {
                                n8 = 0;
                                if (zzftArray == -1) {
                                    n8 = 1;
                                } else {
                                    String n13 = object3[zzftArray].zzaml;
                                    if (n13 == null || n13.length() != 3) {
                                        n8 = 1;
                                    } else {
                                        int n11;
                                        for (int i = 0; i < n13.length(); i += Character.charCount(n11)) {
                                            n11 = n13.codePointAt(i);
                                            if (Character.isLetter(n11)) continue;
                                            n8 = 1;
                                            break;
                                        }
                                    }
                                }
                                if (n8 != 0) {
                                    ((zzfo)object2).zzada.zzgt().zzjl().zzby("Value parameter discarded. You must also supply a 3-letter ISO_4217 currency code in the currency parameter.");
                                    object3 = zzfo.zza((com.google.android.gms.internal.measurement.zzfu[])object3, n9);
                                    object3 = zzfo.zza(zzfo.zza((com.google.android.gms.internal.measurement.zzfu[])object3, "_c"), 19, "currency");
                                }
                            }
                        }
                        zzyc2.zzaxa = object3;
                    }
                    if (this.zzada.zzgv().zze(zza2.zzaug.zztt, zzai.zzakz)) {
                        if ("_e".equals(zzyc2.name)) {
                            this.zzjr();
                            if (zzfu.zza((com.google.android.gms.internal.measurement.zzft)zzyc2, "_fr") == null) {
                                if (zzyc4 != null && Math.abs(zzyc4.zzaxb - zzyc2.zzaxb) <= 1000L) {
                                    if (this.zza((com.google.android.gms.internal.measurement.zzft)zzyc2, (com.google.android.gms.internal.measurement.zzft)zzyc4)) {
                                        zzyc3 = null;
                                        zzyc4 = null;
                                    } else {
                                        zzyc3 = zzyc2;
                                    }
                                } else {
                                    zzyc3 = zzyc2;
                                }
                            }
                        } else if ("_vs".equals(zzyc2.name)) {
                            this.zzjr();
                            if (zzfu.zza((com.google.android.gms.internal.measurement.zzft)zzyc2, "_et") == null) {
                                if (zzyc3 != null && Math.abs(zzyc3.zzaxb - zzyc2.zzaxb) <= 1000L) {
                                    if (this.zza((com.google.android.gms.internal.measurement.zzft)zzyc3, (com.google.android.gms.internal.measurement.zzft)zzyc2)) {
                                        zzyc3 = null;
                                        zzyc4 = null;
                                    } else {
                                        zzyc4 = zzyc2;
                                    }
                                } else {
                                    zzyc4 = zzyc2;
                                }
                            }
                        }
                    }
                    if (bl2 && !bl3 && "_e".equals(zzyc2.name)) {
                        if (zzyc2.zzaxa == null || zzyc2.zzaxa.length == 0) {
                            this.zzada.zzgt().zzjj().zzg("Engagement event does not contain any parameters. appId", zzas.zzbw((String)zza2.zzaug.zztt));
                        } else {
                            this.zzjr();
                            Long l6 = (Long)zzfu.zzb((com.google.android.gms.internal.measurement.zzft)zzyc2, "_et");
                            if (l6 == null) {
                                this.zzada.zzgt().zzjj().zzg("Engagement event does not include duration. appId", zzas.zzbw((String)zza2.zzaug.zztt));
                            } else {
                                l5 += l6.longValue();
                            }
                        }
                    }
                    zzfw3.zzaxi[n4++] = zzyc2;
                }
                if (bl3) {
                    for (n3 = 0; n3 < n4; ++n3) {
                        Long l7;
                        com.google.android.gms.internal.measurement.zzft zzft3 = zzfw3.zzaxi[n3];
                        if ("_e".equals(zzft3.name)) {
                            this.zzjr();
                            if (zzfu.zza(zzft3, "_fr") != null) {
                                System.arraycopy(zzfw3.zzaxi, n3 + 1, zzfw3.zzaxi, n3, n4 - n3 - 1);
                                --n4;
                                --n3;
                                continue;
                            }
                        }
                        if (!bl2) continue;
                        this.zzjr();
                        zzyc2 = zzfu.zza(zzft3, "_et");
                        if (zzyc2 == null || (l7 = zzyc2.zzaxe) == null || l7 <= 0L) continue;
                        l5 += l7.longValue();
                    }
                }
                if (n4 < zza2.zzaui.size()) {
                    zzfw3.zzaxi = Arrays.copyOf(zzfw3.zzaxi, n4);
                }
                if (bl2) {
                    zzfx zzfx2 = this.zzjt().zzi(zzfw3.zztt, "_lte");
                    zzfx2 = zzfx2 == null || zzfx2.value == null ? new zzfx(zzfw3.zztt, "auto", "_lte", this.zzada.zzbx().currentTimeMillis(), (Object)l5) : new zzfx(zzfw3.zztt, "auto", "_lte", this.zzada.zzbx().currentTimeMillis(), (Object)((Long)zzfx2.value + l5));
                    zzfz zzfz2 = new zzfz();
                    new zzfz().name = "_lte";
                    zzfz2.zzayu = this.zzada.zzbx().currentTimeMillis();
                    zzfz2.zzaxe = (Long)zzfx2.value;
                    boolean bl8 = false;
                    for (int i = 0; i < zzfw3.zzaxj.length; ++i) {
                        if (!"_lte".equals(zzfw3.zzaxj[i].name)) continue;
                        zzfw3.zzaxj[i] = zzfz2;
                        bl8 = true;
                        break;
                    }
                    if (!bl8) {
                        zzfw3.zzaxj = Arrays.copyOf(zzfw3.zzaxj, zzfw3.zzaxj.length + 1);
                        zzfw3.zzaxj[zza2.zzaug.zzaxj.length - 1] = zzfz2;
                    }
                    if (l5 > 0L) {
                        this.zzjt().zza(zzfx2);
                        this.zzada.zzgt().zzjn().zzg("Updated lifetime engagement user property with value. Value", zzfx2.value);
                    }
                }
                com.google.android.gms.internal.measurement.zzft[] i = zzfw3.zzaxi;
                Object object4 = zzfw3.zzaxj;
                object3 = zzfw3.zztt;
                object2 = this;
                Preconditions.checkNotEmpty((String)object3);
                zzfw3.zzaya = ((zzfo)object2).zzjs().zza((String)object3, i, (zzfz[])object4);
                if (this.zzada.zzgv().zzat(zza2.zzaug.zztt)) {
                    HashMap<String, com.google.android.gms.internal.measurement.zzfu> hashMap = new HashMap<String, com.google.android.gms.internal.measurement.zzfu>();
                    com.google.android.gms.internal.measurement.zzft[] zzftArray2 = new com.google.android.gms.internal.measurement.zzft[zzfw3.zzaxi.length];
                    int n12 = 0;
                    SecureRandom secureRandom = this.zzada.zzgr().zzmk();
                    com.google.android.gms.internal.measurement.zzft[] zzftArray3 = zzfw3.zzaxi;
                    int n6 = zzfw3.zzaxi.length;
                    for (int j = 0; j < n6; ++j) {
                        boolean bl7;
                        long l2;
                        boolean bl8;
                        long l3;
                        long l4;
                        com.google.android.gms.internal.measurement.zzft zzft2;
                        block142: {
                            zzft2 = zzftArray3[j];
                            if (zzft2.name.equals("_ep")) {
                                this.zzjr();
                                String l10 = (String)zzfu.zzb(zzft2, "_en");
                                zzfu2 = (zzac)hashMap.get(l10);
                                if (zzfu2 == null) {
                                    zzfu2 = this.zzjt().zzg(zza2.zzaug.zztt, l10);
                                    hashMap.put(l10, zzfu2);
                                }
                                if (((zzac)zzfu2).zzaia != null) continue;
                                if (((zzac)zzfu2).zzaib > 1L) {
                                    this.zzjr();
                                    zzft2.zzaxa = zzfu.zza(zzft2.zzaxa, "_sr", ((zzac)zzfu2).zzaib);
                                }
                                if (((zzac)zzfu2).zzaic != null && ((zzac)zzfu2).zzaic.booleanValue()) {
                                    this.zzjr();
                                    zzft2.zzaxa = zzfu.zza(zzft2.zzaxa, "_efs", 1L);
                                }
                                zzftArray2[n12++] = zzft2;
                                continue;
                            }
                            l4 = this.zzls().zzck(zza2.zzaug.zztt);
                            this.zzada.zzgr();
                            l3 = zzfy.zzc((long)zzft2.zzaxb, (long)l4);
                            n = 1;
                            object4 = 1L;
                            object3 = "_dbg";
                            object2 = zzft2;
                            if (TextUtils.isEmpty((CharSequence)object3) || object4 == null) {
                                bl8 = false;
                            } else {
                                com.google.android.gms.internal.measurement.zzfu[] zzfuArray = ((com.google.android.gms.internal.measurement.zzft)((Object)((Object)object2))).zzaxa;
                                int n7 = ((com.google.android.gms.internal.measurement.zzft)((Object)((Object)object2))).zzaxa.length;
                                for (int j2 = 0; j2 < n7; ++j2) {
                                    com.google.android.gms.internal.measurement.zzfu zzfu5 = zzfuArray[j2];
                                    if (!((String)object3).equals(zzfu5.name)) continue;
                                    bl8 = object4 instanceof Long && object4.equals(zzfu5.zzaxe) || object4 instanceof String && object4.equals(zzfu5.zzaml) || object4 instanceof Double && object4.equals(zzfu5.zzaun);
                                    break block142;
                                }
                                bl8 = false;
                            }
                        }
                        if (!bl8) {
                            n = this.zzls().zzq(zza2.zzaug.zztt, zzft2.name);
                        }
                        if (n <= 0) {
                            this.zzada.zzgt().zzjj().zze("Sample rate must be positive. event, rate", (Object)zzft2.name, (Object)n);
                            zzftArray2[n12++] = zzft2;
                            continue;
                        }
                        object = (zzac)hashMap.get(zzft2.name);
                        if (object == null && (object = this.zzjt().zzg(zza2.zzaug.zztt, zzft2.name)) == null) {
                            this.zzada.zzgt().zzjj().zze("Event being bundled has no eventAggregate. appId, eventName", (Object)zza2.zzaug.zztt, (Object)zzft2.name);
                            object = new zzac(zza2.zzaug.zztt, zzft2.name, 1L, 1L, zzft2.zzaxb.longValue(), 0L, null, null, null, null);
                        }
                        this.zzjr();
                        Long l6 = (Long)zzfu.zzb(zzft2, "_eid");
                        Boolean bl9 = l6 != null;
                        if (n == 1) {
                            zzftArray2[n12++] = zzft2;
                            if (!bl9.booleanValue() || object.zzaia == null && object.zzaib == null && object.zzaic == null) continue;
                            object = object.zza(null, null, null);
                            hashMap.put(zzft2.name, (com.google.android.gms.internal.measurement.zzfu)((Object)object));
                            continue;
                        }
                        if (secureRandom.nextInt(n) == 0) {
                            this.zzjr();
                            zzft2.zzaxa = zzfu.zza(zzft2.zzaxa, "_sr", n);
                            zzftArray2[n12++] = zzft2;
                            if (bl9.booleanValue()) {
                                object = object.zza(null, Long.valueOf(n), null);
                            }
                            hashMap.put(zzft2.name, (com.google.android.gms.internal.measurement.zzfu)object.zza(zzft2.zzaxb.longValue(), l3));
                            continue;
                        }
                        if (this.zzada.zzgv().zzbf(zza2.zzaug.zztt)) {
                            if (object.zzahz != null) {
                                l2 = object.zzahz;
                            } else {
                                this.zzada.zzgr();
                                l2 = zzfy.zzc((long)zzft2.zzaxc, (long)l4);
                            }
                            bl7 = l2 != l3;
                        } else {
                            l2 = object.zzahy;
                            boolean bl10 = bl7 = Math.abs(zzft2.zzaxb - l2) >= 86400000L;
                        }
                        if (bl7) {
                            this.zzjr();
                            zzft2.zzaxa = zzfu.zza(zzft2.zzaxa, "_efs", 1L);
                            this.zzjr();
                            zzft2.zzaxa = zzfu.zza(zzft2.zzaxa, "_sr", n);
                            zzftArray2[n12++] = zzft2;
                            if (bl9.booleanValue()) {
                                object = object.zza(null, Long.valueOf(n), Boolean.valueOf(true));
                            }
                            hashMap.put(zzft2.name, (com.google.android.gms.internal.measurement.zzfu)object.zza(zzft2.zzaxb.longValue(), l3));
                            continue;
                        }
                        if (!bl9.booleanValue()) continue;
                        hashMap.put(zzft2.name, (com.google.android.gms.internal.measurement.zzfu)object.zza(l6, null, null));
                    }
                    if (n12 < zzfw3.zzaxi.length) {
                        zzfw3.zzaxi = Arrays.copyOf(zzftArray2, n12);
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        this.zzjt().zza((zzac)entry.getValue());
                    }
                }
                zzfw3.zzaxl = Long.MAX_VALUE;
                zzfw3.zzaxm = Long.MIN_VALUE;
                for (int i2 = 0; i2 < zzfw3.zzaxi.length; ++i2) {
                    com.google.android.gms.internal.measurement.zzft zzft5 = zzfw3.zzaxi[i2];
                    if (zzft5.zzaxb < zzfw3.zzaxl) {
                        zzfw3.zzaxl = zzft5.zzaxb;
                    }
                    if (zzft5.zzaxb <= zzfw3.zzaxm) continue;
                    zzfw3.zzaxm = zzft5.zzaxb;
                }
                String string7 = zza2.zzaug.zztt;
                zzg zzg2 = this.zzjt().zzbm(string7);
                if (zzg2 == null) {
                    this.zzada.zzgt().zzjg().zzg("Bundling raw events w/o app info. appId", zzas.zzbw((String)zza2.zzaug.zztt));
                } else if (zzfw3.zzaxi.length > 0) {
                    long l12 = zzg2.zzhe();
                    zzfw3.zzaxo = l12 != 0L ? Long.valueOf(l12) : null;
                    long l13 = zzg2.zzhd();
                    if (l13 == 0L) {
                        l13 = l12;
                    }
                    zzfw3.zzaxn = l13 != 0L ? Long.valueOf(l13) : null;
                    zzg2.zzhm();
                    zzfw3.zzaxy = (int)zzg2.zzhj();
                    zzg2.zzo(zzfw3.zzaxl.longValue());
                    zzg2.zzp(zzfw3.zzaxm.longValue());
                    zzfw3.zzagm = zzg2.zzhu();
                    this.zzjt().zza(zzg2);
                }
                if (zzfw3.zzaxi.length > 0) {
                    zzn zzn2 = this.zzada.zzgw();
                    com.google.android.gms.internal.measurement.zzfp zzfp2 = this.zzls().zzcg(zza2.zzaug.zztt);
                    if (zzfp2 == null || zzfp2.zzawk == null) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zzaug.zzafi)) {
                            zzfw3.zzayf = -1L;
                        } else {
                            this.zzada.zzgt().zzjj().zzg("Did not find measurement config or missing version info. appId", zzas.zzbw((String)zza2.zzaug.zztt));
                        }
                    } else {
                        zzfw3.zzayf = zzfp2.zzawk;
                    }
                    this.zzjt().zza(zzfw3, bl);
                }
                object3 = zza2.zzauh;
                object2 = this.zzjt();
                Preconditions.checkNotNull((Object)object3);
                object2.zzaf();
                object2.zzcl();
                object4 = new StringBuilder("rowid in (");
                for (int sQLiteException = 0; sQLiteException < object3.size(); ++sQLiteException) {
                    if (sQLiteException != 0) {
                        ((StringBuilder)object4).append(",");
                    }
                    ((StringBuilder)object4).append((Long)object3.get(sQLiteException));
                }
                ((StringBuilder)object4).append(")");
                int n14 = object2.getWritableDatabase().delete("raw_events", ((StringBuilder)object4).toString(), null);
                if (n14 != object3.size()) {
                    object2.zzgt().zzjg().zze("Deleted fewer rows from raw events table than expected", (Object)n14, (Object)object3.size());
                }
                object3 = string7;
                object2 = this.zzjt();
                object4 = object2.getWritableDatabase();
                try {
                    object4.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", (Object[])new String[]{object3, object3});
                }
                catch (SQLiteException sQLiteException) {
                    object2.zzgt().zzjg().zze("Failed to remove unused event metadata. appId", zzas.zzbw((String)object3), (Object)sQLiteException);
                }
                this.zzjt().setTransactionSuccessful();
                return true;
            }
            this.zzjt().setTransactionSuccessful();
            return false;
        }
        finally {
            this.zzjt().endTransaction();
        }
    }

    private final boolean zza(com.google.android.gms.internal.measurement.zzft zzft2, com.google.android.gms.internal.measurement.zzft zzft3) {
        Preconditions.checkArgument((boolean)"_e".equals(zzft2.name));
        this.zzjr();
        com.google.android.gms.internal.measurement.zzfu zzfu2 = zzfu.zza(zzft2, "_sc");
        String string = zzfu2 == null ? null : zzfu2.zzaml;
        this.zzjr();
        com.google.android.gms.internal.measurement.zzfu zzfu3 = zzfu.zza(zzft3, "_pc");
        String string2 = zzfu3 == null ? null : zzfu3.zzaml;
        if (string2 != null && string2.equals(string)) {
            this.zzjr();
            com.google.android.gms.internal.measurement.zzfu zzfu4 = zzfu.zza(zzft2, "_et");
            if (zzfu4.zzaxe == null || zzfu4.zzaxe <= 0L) {
                return true;
            }
            long l = zzfu4.zzaxe;
            this.zzjr();
            zzfu4 = zzfu.zza(zzft3, "_et");
            if (zzfu4 != null && zzfu4.zzaxe != null && zzfu4.zzaxe > 0L) {
                l += zzfu4.zzaxe.longValue();
            }
            this.zzjr();
            zzft3.zzaxa = zzfu.zza(zzft3.zzaxa, "_et", l);
            this.zzjr();
            zzft2.zzaxa = zzfu.zza(zzft2.zzaxa, "_fr", 1L);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    private static com.google.android.gms.internal.measurement.zzfu[] zza(com.google.android.gms.internal.measurement.zzfu[] zzfuArray, @NonNull String string) {
        int n = -1;
        for (int i = 0; i < zzfuArray.length; ++i) {
            if (!string.equals(zzfuArray[i].name)) continue;
            n = i;
            break;
        }
        if (n < 0) {
            return zzfuArray;
        }
        return zzfo.zza(zzfuArray, n);
    }

    @VisibleForTesting
    private static com.google.android.gms.internal.measurement.zzfu[] zza(com.google.android.gms.internal.measurement.zzfu[] zzfuArray, int n) {
        com.google.android.gms.internal.measurement.zzfu[] zzfuArray2 = new com.google.android.gms.internal.measurement.zzfu[zzfuArray.length - 1];
        if (n > 0) {
            System.arraycopy(zzfuArray, 0, zzfuArray2, 0, n);
        }
        if (n < zzfuArray2.length) {
            System.arraycopy(zzfuArray, n + 1, zzfuArray2, n, zzfuArray2.length - n);
        }
        return zzfuArray2;
    }

    @VisibleForTesting
    private static com.google.android.gms.internal.measurement.zzfu[] zza(com.google.android.gms.internal.measurement.zzfu[] zzfuArray, int n, String string) {
        for (int i = 0; i < zzfuArray.length; ++i) {
            if (!"_err".equals(zzfuArray[i].name)) continue;
            return zzfuArray;
        }
        com.google.android.gms.internal.measurement.zzfu[] zzfuArray2 = new com.google.android.gms.internal.measurement.zzfu[zzfuArray.length + 2];
        System.arraycopy(zzfuArray, 0, zzfuArray2, 0, zzfuArray.length);
        com.google.android.gms.internal.measurement.zzfu zzfu2 = new com.google.android.gms.internal.measurement.zzfu();
        new com.google.android.gms.internal.measurement.zzfu().name = "_err";
        zzfu2.zzaxe = n;
        com.google.android.gms.internal.measurement.zzfu zzfu3 = new com.google.android.gms.internal.measurement.zzfu();
        new com.google.android.gms.internal.measurement.zzfu().name = "_ev";
        zzfu3.zzaml = string;
        zzfuArray2[zzfuArray2.length - 2] = zzfu2;
        zzfuArray2[zzfuArray2.length - 1] = zzfu3;
        return zzfuArray2;
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(int n, Throwable throwable, byte[] byArray, String string) {
        this.zzaf();
        this.zzlx();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List<Long> list = this.zzaua;
            this.zzaua = null;
            if ((n == 200 || n == 204) && throwable == null) {
                try {
                    this.zzada.zzgu().zzana.set(this.zzada.zzbx().currentTimeMillis());
                    this.zzada.zzgu().zzanb.set(0L);
                    this.zzmb();
                    this.zzada.zzgt().zzjo().zze("Successful upload. Got network response. code, size", (Object)n, (Object)byArray.length);
                    this.zzjt().beginTransaction();
                    try {
                        for (Long l : list) {
                            try {
                                long l2 = l;
                                zzt zzt2 = this.zzjt();
                                zzt2.zzaf();
                                zzt2.zzcl();
                                SQLiteDatabase sQLiteDatabase = zzt2.getWritableDatabase();
                                String[] stringArray = new String[]{String.valueOf(l2)};
                                try {
                                    if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                    throw new SQLiteException("Deleted fewer rows from queue than expected");
                                }
                                catch (SQLiteException sQLiteException) {
                                    zzt2.zzgt().zzjg().zzg("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                    throw sQLiteException;
                                }
                            }
                            catch (SQLiteException sQLiteException) {
                                if (this.zzaub != null && this.zzaub.contains(l)) continue;
                                throw sQLiteException;
                            }
                        }
                        this.zzjt().setTransactionSuccessful();
                    }
                    finally {
                        this.zzjt().endTransaction();
                    }
                    this.zzaub = null;
                    if (this.zzlt().zzfb() && this.zzma()) {
                        this.zzlz();
                    } else {
                        this.zzauc = -1L;
                        this.zzmb();
                    }
                    this.zzatr = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzada.zzgt().zzjg().zzg("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzatr = this.zzada.zzbx().elapsedRealtime();
                    this.zzada.zzgt().zzjo().zzg("Disable upload, time", (Object)this.zzatr);
                }
            } else {
                this.zzada.zzgt().zzjo().zze("Network upload failed. Will retry later. code, error", (Object)n, (Object)throwable);
                this.zzada.zzgu().zzanb.set(this.zzada.zzbx().currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzada.zzgu().zzanc.set(this.zzada.zzbx().currentTimeMillis());
                }
                if (this.zzada.zzgv().zzaw(string)) {
                    this.zzjt().zzc(list);
                }
                this.zzmb();
            }
            return;
        }
        finally {
            this.zzatw = false;
            this.zzmc();
        }
    }

    private final boolean zzma() {
        this.zzaf();
        this.zzlx();
        return this.zzjt().zzim() || !TextUtils.isEmpty((CharSequence)this.zzjt().zzih());
    }

    @WorkerThread
    private final void zzb(zzg zzg2) {
        this.zzaf();
        if (TextUtils.isEmpty((CharSequence)zzg2.getGmpAppId()) && (!zzq.zzig() || TextUtils.isEmpty((CharSequence)zzg2.zzhb()))) {
            this.zzb(zzg2.zzal(), 204, null, null, null);
            return;
        }
        Object object = zzg2;
        Object object2 = this.zzada.zzgv();
        Object object3 = new Uri.Builder();
        String string = object.getGmpAppId();
        if (TextUtils.isEmpty((CharSequence)string) && zzq.zzig()) {
            string = object.zzhb();
        }
        String string2 = String.valueOf(string);
        object3.scheme((String)zzai.zzaiy.get()).encodedAuthority((String)zzai.zzaiz.get()).path(string2.length() != 0 ? "config/app/".concat(string2) : new String("config/app/")).appendQueryParameter("app_instance_id", object.getAppInstanceId()).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", String.valueOf(object2.zzhh()));
        String string3 = object3.build().toString();
        try {
            URL uRL = new URL(string3);
            this.zzada.zzgt().zzjo().zzg("Fetching remote configuration", (Object)zzg2.zzal());
            com.google.android.gms.internal.measurement.zzfp zzfp2 = this.zzls().zzcg(zzg2.zzal());
            ArrayMap arrayMap = null;
            String string4 = this.zzls().zzch(zzg2.zzal());
            if (zzfp2 != null && !TextUtils.isEmpty((CharSequence)string4)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string4);
            }
            this.zzatv = true;
            zzfr zzfr2 = new zzfr(this);
            string = arrayMap;
            object3 = uRL;
            object = zzg2.zzal();
            object2 = this.zzlt();
            object2.zzaf();
            ((zzfn)((Object)object2)).zzcl();
            Preconditions.checkNotNull((Object)object3);
            Preconditions.checkNotNull((Object)zzfr2);
            object2.zzgs().zzd((Runnable)new zzba((zzaw)((Object)object2), (String)object, (URL)object3, null, (Map)((Object)string), zzfr2));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzada.zzgt().zzjg().zze("Failed to parse config URL. Not fetching. appId", zzas.zzbw((String)zzg2.zzal()), (Object)string3);
            return;
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        this.zzaf();
        this.zzlx();
        Preconditions.checkNotEmpty((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzada.zzgt().zzjo().zzg("onConfigFetched. Response size", (Object)byArray.length);
            this.zzjt().beginTransaction();
            try {
                boolean bl;
                zzg zzg2 = this.zzjt().zzbm(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzg2 == null) {
                    this.zzada.zzgt().zzjj().zzg("App does not exist in onConfigFetched. appId", zzas.zzbw((String)string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzls().zzcg(string) == null && !this.zzls().zza(string, null, null) : !this.zzls().zza(string, byArray, string2)) {
                        return;
                    }
                    zzg2.zzu(this.zzada.zzbx().currentTimeMillis());
                    this.zzjt().zza(zzg2);
                    if (n == 404) {
                        this.zzada.zzgt().zzjl().zzg("Config not found. Using empty config. appId", (Object)string);
                    } else {
                        this.zzada.zzgt().zzjo().zze("Successfully fetched config. Got network response. code, size", (Object)n, (Object)byArray.length);
                    }
                    if (this.zzlt().zzfb() && this.zzma()) {
                        this.zzlz();
                    } else {
                        this.zzmb();
                    }
                } else {
                    zzg2.zzv(this.zzada.zzbx().currentTimeMillis());
                    this.zzjt().zza(zzg2);
                    this.zzada.zzgt().zzjo().zze("Fetching config failed. code, error", (Object)n, (Object)throwable);
                    this.zzls().zzci(string);
                    this.zzada.zzgu().zzanb.set(this.zzada.zzbx().currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzada.zzgu().zzanc.set(this.zzada.zzbx().currentTimeMillis());
                    }
                    this.zzmb();
                }
                this.zzjt().setTransactionSuccessful();
            }
            finally {
                this.zzjt().endTransaction();
            }
            return;
        }
        finally {
            this.zzatv = false;
            this.zzmc();
        }
    }

    @WorkerThread
    private final void zzmb() {
        long l;
        long l2;
        long l3;
        block15: {
            String string;
            this.zzaf();
            this.zzlx();
            if (!this.zzmf() && !this.zzada.zzgv().zza(zzai.zzald)) {
                return;
            }
            if (this.zzatr > 0L) {
                l3 = this.zzada.zzbx().elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzatr);
                if (l2 > 0L) {
                    this.zzada.zzgt().zzjo().zzg("Upload has been suspended. Will update scheduling later in approximately ms", (Object)l2);
                    this.zzlu().unregister();
                    this.zzlv().cancel();
                    return;
                }
                this.zzatr = 0L;
            }
            if (!this.zzada.zzkv() || !this.zzma()) {
                this.zzada.zzgt().zzjo().zzby("Nothing to upload or uploading impossible");
                this.zzlu().unregister();
                this.zzlv().cancel();
                return;
            }
            zzfo zzfo2 = this;
            long l4 = zzfo2.zzada.zzbx().currentTimeMillis();
            long l5 = Math.max(0L, (Long)zzai.zzaju.get());
            boolean bl = zzfo2.zzjt().zzin() || zzfo2.zzjt().zzii();
            long l6 = bl ? (!TextUtils.isEmpty((CharSequence)(string = zzfo2.zzada.zzgv().zzid())) && !".none.".equals(string) ? Math.max(0L, (Long)zzai.zzajp.get()) : Math.max(0L, (Long)zzai.zzajo.get())) : Math.max(0L, (Long)zzai.zzajn.get());
            long l7 = zzfo2.zzada.zzgu().zzana.get();
            long l8 = zzfo2.zzada.zzgu().zzanb.get();
            long l9 = zzfo2.zzjt().zzik();
            long l10 = zzfo2.zzjt().zzil();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l4 - Math.abs(l11 - l4);
                l7 = l4 - Math.abs(l7 - l4);
                l8 = l4 - Math.abs(l8 - l4);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l5;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l6;
                }
                if (!zzfo2.zzjr().zzb(l12, l6)) {
                    l13 = l12 + l6;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    for (int i = 0; i < Math.min(20, Math.max(0, (Integer)zzai.zzajw.get())); ++i) {
                        long l15 = 1L << i;
                        if ((l14 += Math.max(0L, (Long)zzai.zzajv.get()) * l15) <= l8) continue;
                        l = l14;
                        break block15;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzada.zzgt().zzjo().zzby("Next upload time is 0");
            this.zzlu().unregister();
            this.zzlv().cancel();
            return;
        }
        if (!this.zzlt().zzfb()) {
            this.zzada.zzgt().zzjo().zzby("No network");
            this.zzlu().zzey();
            this.zzlv().cancel();
            return;
        }
        l2 = this.zzada.zzgu().zzanc.get();
        long l16 = Math.max(0L, (Long)zzai.zzajl.get());
        if (!this.zzjr().zzb(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzlu().unregister();
        long l17 = l3 - this.zzada.zzbx().currentTimeMillis();
        if (l17 <= 0L) {
            l17 = Math.max(0L, (Long)zzai.zzajq.get());
            this.zzada.zzgu().zzana.set(this.zzada.zzbx().currentTimeMillis());
        }
        this.zzada.zzgt().zzjo().zzg("Upload scheduled in approximately ms", (Object)l17);
        this.zzlv().zzh(l17);
    }

    @WorkerThread
    final void zzg(Runnable runnable) {
        this.zzaf();
        if (this.zzats == null) {
            this.zzats = new ArrayList<Runnable>();
        }
        this.zzats.add(runnable);
    }

    @WorkerThread
    private final void zzmc() {
        this.zzaf();
        if (this.zzatv || this.zzatw || this.zzatx) {
            this.zzada.zzgt().zzjo().zzd("Not stopping services. fetch, network, upload", (Object)this.zzatv, (Object)this.zzatw, (Object)this.zzatx);
            return;
        }
        this.zzada.zzgt().zzjo().zzby("Stopping uploading service(s)");
        if (this.zzats == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzats.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.zzats.clear();
    }

    @WorkerThread
    private final Boolean zzc(zzg zzg2) {
        try {
            if (zzg2.zzhf() != Integer.MIN_VALUE) {
                int n = Wrappers.packageManager((Context)this.zzada.getContext()).getPackageInfo((String)zzg2.zzal(), (int)0).versionCode;
                if (zzg2.zzhf() == (long)n) {
                    return true;
                }
            } else {
                String string = Wrappers.packageManager((Context)this.zzada.getContext()).getPackageInfo((String)zzg2.zzal(), (int)0).versionName;
                if (zzg2.zzak() != null && zzg2.zzak().equals(string)) {
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zzmd() {
        this.zzaf();
        String string = "google_app_measurement.db";
        File file = this.zzada.getContext().getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzatz = new RandomAccessFile(file2, "rw").getChannel();
            this.zzaty = this.zzatz.tryLock();
            if (this.zzaty != null) {
                this.zzada.zzgt().zzjo().zzby("Storage concurrent access okay");
                return true;
            }
            this.zzada.zzgt().zzjg().zzby("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzada.zzgt().zzjg().zzg("Failed to acquire storage lock", (Object)fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzada.zzgt().zzjg().zzg("Failed to access storage lock file", (Object)iOException);
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final int zza(FileChannel fileChannel) {
        this.zzaf();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzada.zzgt().zzjg().zzby("Bad channel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzada.zzgt().zzjj().zzg("Unexpected data length. Bytes read", (Object)n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzada.zzgt().zzjg().zzg("Failed to read from channel", (Object)iOException);
        }
        return n;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zza(int n, FileChannel fileChannel) {
        this.zzaf();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzada.zzgt().zzjg().zzby("Bad channel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzada.zzgt().zzjg().zzg("Error writing to channel. Bytes written", (Object)fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzada.zzgt().zzjg().zzg("Failed to write to channel", (Object)iOException);
            return false;
        }
    }

    @WorkerThread
    final void zzme() {
        this.zzaf();
        this.zzlx();
        if (!this.zzatq) {
            this.zzatq = true;
            zzfo zzfo2 = this;
            zzfo2.zzaf();
            zzfo2.zzlx();
            if ((zzfo2.zzada.zzgv().zza(zzai.zzald) || zzfo2.zzmf()) && zzfo2.zzmd()) {
                int n;
                int n2 = zzfo2.zza(zzfo2.zzatz);
                int n3 = n = zzfo2.zzada.zzgk().zzjd();
                int n4 = n2;
                zzfo zzfo3 = zzfo2;
                zzfo3.zzaf();
                if (n4 > n3) {
                    zzfo3.zzada.zzgt().zzjg().zze("Panic: can't downgrade version. Previous, current version", (Object)n4, (Object)n3);
                } else if (n4 < n3) {
                    if (zzfo3.zza(n3, zzfo3.zzatz)) {
                        zzfo3.zzada.zzgt().zzjo().zze("Storage version upgraded. Previous, current version", (Object)n4, (Object)n3);
                    } else {
                        zzfo3.zzada.zzgt().zzjg().zze("Storage version upgrade failed. Previous, current version", (Object)n4, (Object)n3);
                    }
                }
            }
        }
        if (!this.zzatp && !this.zzada.zzgv().zza(zzai.zzald)) {
            this.zzada.zzgt().zzjm().zzby("This instance being marked as an uploader");
            this.zzatp = true;
            this.zzmb();
        }
    }

    @WorkerThread
    private final boolean zzmf() {
        this.zzaf();
        this.zzlx();
        return this.zzatp;
    }

    @VisibleForTesting
    @WorkerThread
    final void zzd(zzk zzk2) {
        if (this.zzaua != null) {
            this.zzaub = new ArrayList<Long>();
            this.zzaub.addAll(this.zzaua);
        }
        String string = zzk2.packageName;
        zzt zzt2 = this.zzjt();
        Preconditions.checkNotEmpty((String)string);
        zzt2.zzaf();
        zzt2.zzcl();
        try {
            SQLiteDatabase sQLiteDatabase = zzt2.getWritableDatabase();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray) + sQLiteDatabase.delete("main_event_params", "app_id=?", stringArray);
            if (n > 0) {
                zzt2.zzgt().zzjo().zze("Reset analytics data. app, records", (Object)string, (Object)n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzt2.zzgt().zzjg().zze("Error resetting analytics data. appId, error", zzas.zzbw((String)string), (Object)sQLiteException);
        }
        zzk zzk3 = this.zza(this.zzada.getContext(), zzk2.packageName, zzk2.zzafi, zzk2.zzafr, zzk2.zzaft, zzk2.zzafu, zzk2.zzago, zzk2.zzafv);
        if (!this.zzada.zzgv().zzba(zzk2.packageName) || zzk2.zzafr) {
            this.zzf(zzk3);
        }
    }

    private final zzk zza(Context context, String string, String string2, boolean bl, boolean bl2, boolean bl3, long l, String string3) {
        String string4 = "Unknown";
        String string5 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string6 = "Unknown";
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            this.zzada.zzgt().zzjg().zzby("PackageManager is null, can not log app install information");
            return null;
        }
        try {
            string4 = packageManager.getInstallerPackageName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzada.zzgt().zzjg().zzg("Error retrieving installer package name. appId", zzas.zzbw((String)string));
        }
        if (string4 == null) {
            string4 = "manual_install";
        } else if ("com.android.vending".equals(string4)) {
            string4 = "";
        }
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(string, 0);
            if (packageInfo != null) {
                CharSequence charSequence = Wrappers.packageManager((Context)context).getApplicationLabel(string);
                if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                    string6 = charSequence.toString();
                }
                string5 = packageInfo.versionName;
                n = packageInfo.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzada.zzgt().zzjg().zze("Error retrieving newly installed package info. appId, appName", zzas.zzbw((String)string), (Object)string6);
            return null;
        }
        long l2 = 0L;
        zzn zzn2 = this.zzada.zzgw();
        long l3 = 0L;
        if (this.zzada.zzgv().zzbc(string)) {
            l3 = l;
        }
        return new zzk(string, string2, string5, (long)n, string4, this.zzada.zzgv().zzhh(), this.zzada.zzgr().zzd(context, string), null, bl, false, "", l2, l3, 0, bl2, bl3, false, string3);
    }

    @WorkerThread
    final void zzb(zzfv zzfv2, zzk zzk2) {
        this.zzaf();
        this.zzlx();
        if (TextUtils.isEmpty((CharSequence)zzk2.zzafi) && TextUtils.isEmpty((CharSequence)zzk2.zzafv)) {
            return;
        }
        if (!zzk2.zzafr) {
            this.zzg(zzk2);
            return;
        }
        int n = this.zzada.zzgr().zzcv(zzfv2.name);
        if (n != 0) {
            this.zzada.zzgr();
            String string = zzfy.zza((String)zzfv2.name, (int)24, (boolean)true);
            int n2 = zzfv2.name != null ? zzfv2.name.length() : 0;
            this.zzada.zzgr().zza(zzk2.packageName, n, "_ev", string, n2);
            return;
        }
        n = this.zzada.zzgr().zzi(zzfv2.name, zzfv2.getValue());
        if (n != 0) {
            this.zzada.zzgr();
            String string = zzfy.zza((String)zzfv2.name, (int)24, (boolean)true);
            Object object = zzfv2.getValue();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzada.zzgr().zza(zzk2.packageName, n, "_ev", string, n3);
            return;
        }
        Object object = this.zzada.zzgr().zzj(zzfv2.name, zzfv2.getValue());
        if (object == null) {
            return;
        }
        if (this.zzada.zzgv().zzbh(zzk2.packageName) && "_sno".equals(zzfv2.name)) {
            long l = 0L;
            zzfx zzfx2 = this.zzjt().zzi(zzk2.packageName, "_sno");
            if (zzfx2 != null && zzfx2.value instanceof Long) {
                l = (Long)zzfx2.value;
            } else {
                zzac zzac2 = this.zzjt().zzg(zzk2.packageName, "_s");
                if (zzac2 != null) {
                    l = zzac2.zzahv;
                    this.zzada.zzgt().zzjo().zzg("Backfill the session number. Last used session number", (Object)l);
                }
            }
            object = l + 1L;
        }
        zzfx zzfx3 = new zzfx(zzk2.packageName, zzfv2.origin, zzfv2.name, zzfv2.zzauk, object);
        this.zzada.zzgt().zzjn().zze("Setting user property", (Object)this.zzada.zzgq().zzbv(zzfx3.name), object);
        this.zzjt().beginTransaction();
        try {
            this.zzg(zzk2);
            boolean bl = this.zzjt().zza(zzfx3);
            this.zzjt().setTransactionSuccessful();
            if (bl) {
                this.zzada.zzgt().zzjn().zze("User property set", (Object)this.zzada.zzgq().zzbv(zzfx3.name), zzfx3.value);
            } else {
                this.zzada.zzgt().zzjg().zze("Too many unique user properties are set. Ignoring user property", (Object)this.zzada.zzgq().zzbv(zzfx3.name), zzfx3.value);
                this.zzada.zzgr().zza(zzk2.packageName, 9, null, null, 0);
            }
            return;
        }
        finally {
            this.zzjt().endTransaction();
        }
    }

    @WorkerThread
    final void zzc(zzfv zzfv2, zzk zzk2) {
        this.zzaf();
        this.zzlx();
        if (TextUtils.isEmpty((CharSequence)zzk2.zzafi) && TextUtils.isEmpty((CharSequence)zzk2.zzafv)) {
            return;
        }
        if (!zzk2.zzafr) {
            this.zzg(zzk2);
            return;
        }
        this.zzada.zzgt().zzjn().zzg("Removing user property", (Object)this.zzada.zzgq().zzbv(zzfv2.name));
        this.zzjt().beginTransaction();
        try {
            this.zzg(zzk2);
            this.zzjt().zzh(zzk2.packageName, zzfv2.name);
            this.zzjt().setTransactionSuccessful();
            this.zzada.zzgt().zzjn().zzg("User property removed", (Object)this.zzada.zzgq().zzbv(zzfv2.name));
            return;
        }
        finally {
            this.zzjt().endTransaction();
        }
    }

    final void zzb(zzfn zzfn2) {
        ++this.zzatt;
    }

    final void zzmg() {
        ++this.zzatu;
    }

    final zzbw zzmh() {
        return this.zzada;
    }

    @WorkerThread
    final void zzf(zzk zzk2) {
        int n;
        this.zzaf();
        this.zzlx();
        Preconditions.checkNotNull((Object)zzk2);
        Preconditions.checkNotEmpty((String)zzk2.packageName);
        if (TextUtils.isEmpty((CharSequence)zzk2.zzafi) && TextUtils.isEmpty((CharSequence)zzk2.zzafv)) {
            return;
        }
        zzg zzg2 = this.zzjt().zzbm(zzk2.packageName);
        if (zzg2 != null && TextUtils.isEmpty((CharSequence)zzg2.getGmpAppId()) && !TextUtils.isEmpty((CharSequence)zzk2.zzafi)) {
            zzg2.zzu(0L);
            this.zzjt().zza(zzg2);
            this.zzls().zzcj(zzk2.packageName);
        }
        if (!zzk2.zzafr) {
            this.zzg(zzk2);
            return;
        }
        long l = zzk2.zzago;
        if (l == 0L) {
            l = this.zzada.zzbx().currentTimeMillis();
        }
        if ((n = zzk2.zzagp) != 0 && n != 1) {
            this.zzada.zzgt().zzjj().zze("Incorrect app type, assuming installed app. appId, appType", zzas.zzbw((String)zzk2.packageName), (Object)n);
            n = 0;
        }
        this.zzjt().beginTransaction();
        try {
            zzag zzag2;
            Bundle bundle;
            long l2 = l;
            zzk zzk3 = zzk2;
            zzfo zzfo2 = this;
            zzg zzg3 = zzfo2.zzjt().zzbm(zzk3.packageName);
            if (zzg3 != null) {
                zzfo2.zzada.zzgr();
                if (zzfy.zza((String)zzk3.zzafi, (String)zzg3.getGmpAppId(), (String)zzk3.zzafv, (String)zzg3.zzhb())) {
                    zzfo2.zzada.zzgt().zzjj().zzg("New GMP App Id passed in. Removing cached database data. appId", zzas.zzbw((String)zzg3.zzal()));
                    String string = zzg3.zzal();
                    zzt zzt2 = zzfo2.zzjt();
                    zzt2.zzcl();
                    zzt2.zzaf();
                    Preconditions.checkNotEmpty((String)string);
                    try {
                        SQLiteDatabase sQLiteDatabase = zzt2.getWritableDatabase();
                        String[] stringArray = new String[]{string};
                        int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("event_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("property_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
                        if (n2 > 0) {
                            zzt2.zzgt().zzjo().zze("Deleted application data. app, records", (Object)string, (Object)n2);
                        }
                    }
                    catch (SQLiteException sQLiteException) {
                        zzt2.zzgt().zzjg().zze("Error deleting application data. appId, error", zzas.zzbw((String)string), (Object)sQLiteException);
                    }
                    zzg3 = null;
                }
            }
            if (zzg3 != null) {
                if (zzg3.zzhf() != Integer.MIN_VALUE) {
                    if (zzg3.zzhf() != zzk3.zzafo) {
                        bundle = new Bundle();
                        bundle.putString("_pv", zzg3.zzak());
                        zzag2 = new zzag("_au", new zzad(bundle), "auto", l2);
                        zzfo2.zzc(zzag2, zzk3);
                    }
                } else if (zzg3.zzak() != null && !zzg3.zzak().equals(zzk3.zzts)) {
                    bundle = new Bundle();
                    bundle.putString("_pv", zzg3.zzak());
                    zzag2 = new zzag("_au", new zzad(bundle), "auto", l2);
                    zzfo2.zzc(zzag2, zzk3);
                }
            }
            this.zzg(zzk2);
            zzac zzac2 = null;
            if (n == 0) {
                zzac2 = this.zzjt().zzg(zzk2.packageName, "_f");
            } else if (n == 1) {
                zzac2 = this.zzjt().zzg(zzk2.packageName, "_v");
            }
            if (zzac2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    zzfv zzfv2;
                    zzfv zzfv3 = new zzfv("_fot", l, (Object)l3, "auto");
                    this.zzb(zzfv3, zzk2);
                    if (this.zzada.zzgv().zzbe(zzk2.zzafi)) {
                        zzk3 = zzk2;
                        zzfo2 = this;
                        zzfo2.zzaf();
                        zzfo2.zzada.zzkk().zzce(zzk3.packageName);
                    }
                    l2 = l;
                    zzk3 = zzk2;
                    zzfo2 = this;
                    zzfo2.zzaf();
                    zzfo2.zzlx();
                    zzg3 = new Bundle();
                    zzg3.putLong("_c", 1L);
                    zzg3.putLong("_r", 1L);
                    zzg3.putLong("_uwa", 0L);
                    zzg3.putLong("_pfo", 0L);
                    zzg3.putLong("_sys", 0L);
                    zzg3.putLong("_sysu", 0L);
                    if (zzfo2.zzada.zzgv().zzbk(zzk3.packageName)) {
                        zzg3.putLong("_et", 1L);
                    }
                    if (zzfo2.zzada.zzgv().zzba(zzk3.packageName) && zzk3.zzagq) {
                        zzg3.putLong("_dac", 1L);
                    }
                    if (zzfo2.zzada.getContext().getPackageManager() == null) {
                        zzfo2.zzada.zzgt().zzjg().zzg("PackageManager is null, first open report might be inaccurate. appId", zzas.zzbw((String)zzk3.packageName));
                    } else {
                        zzag2 = null;
                        try {
                            zzag2 = Wrappers.packageManager((Context)zzfo2.zzada.getContext()).getPackageInfo(zzk3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzfo2.zzada.zzgt().zzjg().zze("Package info is null, first open report might be inaccurate. appId", zzas.zzbw((String)zzk3.packageName), (Object)nameNotFoundException);
                        }
                        if (zzag2 != null && zzag2.firstInstallTime != 0L) {
                            boolean bl = false;
                            if (zzag2.firstInstallTime != zzag2.lastUpdateTime) {
                                zzg3.putLong("_uwa", 1L);
                            } else {
                                bl = true;
                            }
                            zzfv2 = new zzfv("_fi", l2, (Object)(bl ? 1L : 0L), "auto");
                            zzfo2.zzb(zzfv2, zzk3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = Wrappers.packageManager((Context)zzfo2.zzada.getContext()).getApplicationInfo(zzk3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzfo2.zzada.zzgt().zzjg().zze("Application info is null, first open report might be inaccurate. appId", zzas.zzbw((String)zzk3.packageName), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                zzg3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                zzg3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    String string = zzk3.packageName;
                    zzt zzt3 = zzfo2.zzjt();
                    Preconditions.checkNotEmpty((String)string);
                    zzt3.zzaf();
                    zzt3.zzcl();
                    long l4 = zzt3.zzn(string, "first_open_count");
                    if (l4 >= 0L) {
                        zzg3.putLong("_pfo", l4);
                    }
                    zzfv2 = new zzag("_f", new zzad((Bundle)zzg3), "auto", l2);
                    zzfo2.zzc((zzag)zzfv2, zzk3);
                } else if (n == 1) {
                    zzfv zzfv4 = new zzfv("_fvt", l, (Object)l3, "auto");
                    this.zzb(zzfv4, zzk2);
                    l2 = l;
                    zzk3 = zzk2;
                    zzfo2 = this;
                    zzfo2.zzaf();
                    zzfo2.zzlx();
                    zzg3 = new Bundle();
                    zzg3.putLong("_c", 1L);
                    zzg3.putLong("_r", 1L);
                    if (zzfo2.zzada.zzgv().zzbk(zzk3.packageName)) {
                        zzg3.putLong("_et", 1L);
                    }
                    if (zzfo2.zzada.zzgv().zzba(zzk3.packageName) && zzk3.zzagq) {
                        zzg3.putLong("_dac", 1L);
                    }
                    bundle = new zzag("_v", new zzad((Bundle)zzg3), "auto", l2);
                    zzfo2.zzc((zzag)bundle, zzk3);
                }
                if (!this.zzada.zzgv().zze(zzk2.packageName, zzai.zzala)) {
                    l2 = l;
                    zzk3 = zzk2;
                    zzfo2 = this;
                    zzg3 = new Bundle();
                    zzg3.putLong("_et", 1L);
                    if (zzfo2.zzada.zzgv().zzbk(zzk3.packageName)) {
                        zzg3.putLong("_fr", 1L);
                    }
                    bundle = new zzag("_e", new zzad((Bundle)zzg3), "auto", l2);
                    zzfo2.zzc((zzag)bundle, zzk3);
                }
            } else if (zzk2.zzagn) {
                l2 = l;
                zzk3 = zzk2;
                zzfo2 = this;
                zzg3 = new Bundle();
                bundle = new zzag("_cd", new zzad((Bundle)zzg3), "auto", l2);
                zzfo2.zzc((zzag)bundle, zzk3);
            }
            this.zzjt().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzjt().endTransaction();
        }
    }

    @WorkerThread
    private final zzk zzcr(String string) {
        zzg zzg2 = this.zzjt().zzbm(string);
        if (zzg2 == null || TextUtils.isEmpty((CharSequence)zzg2.zzak())) {
            this.zzada.zzgt().zzjn().zzg("No app data available; dropping", (Object)string);
            return null;
        }
        Boolean bl = this.zzc(zzg2);
        if (bl != null && !bl.booleanValue()) {
            this.zzada.zzgt().zzjg().zzg("App version does not match; dropping. appId", zzas.zzbw((String)string));
            return null;
        }
        return new zzk(string, zzg2.getGmpAppId(), zzg2.zzak(), zzg2.zzhf(), zzg2.zzhg(), zzg2.zzhh(), zzg2.zzhi(), null, zzg2.isMeasurementEnabled(), false, zzg2.getFirebaseInstanceId(), zzg2.zzhv(), 0L, 0, zzg2.zzhw(), zzg2.zzhx(), false, zzg2.zzhb());
    }

    @WorkerThread
    final void zze(zzo zzo2) {
        zzk zzk2 = this.zzcr(zzo2.packageName);
        if (zzk2 != null) {
            this.zzb(zzo2, zzk2);
        }
    }

    @WorkerThread
    final void zzb(zzo zzo2, zzk zzk2) {
        Preconditions.checkNotNull((Object)zzo2);
        Preconditions.checkNotEmpty((String)zzo2.packageName);
        Preconditions.checkNotNull((Object)zzo2.origin);
        Preconditions.checkNotNull((Object)zzo2.zzags);
        Preconditions.checkNotEmpty((String)zzo2.zzags.name);
        this.zzaf();
        this.zzlx();
        if (TextUtils.isEmpty((CharSequence)zzk2.zzafi) && TextUtils.isEmpty((CharSequence)zzk2.zzafv)) {
            return;
        }
        if (!zzk2.zzafr) {
            this.zzg(zzk2);
            return;
        }
        zzo zzo3 = new zzo(zzo2);
        new zzo(zzo2).active = false;
        this.zzjt().beginTransaction();
        try {
            boolean bl = false;
            zzo zzo4 = this.zzjt().zzj(zzo3.packageName, zzo3.zzags.name);
            if (zzo4 != null && !zzo4.origin.equals(zzo3.origin)) {
                this.zzada.zzgt().zzjj().zzd("Updating a conditional user property with different origin. name, origin, origin (from DB)", (Object)this.zzada.zzgq().zzbv(zzo3.zzags.name), (Object)zzo3.origin, (Object)zzo4.origin);
            }
            if (zzo4 != null && zzo4.active) {
                zzo3.origin = zzo4.origin;
                zzo3.creationTimestamp = zzo4.creationTimestamp;
                zzo3.triggerTimeout = zzo4.triggerTimeout;
                zzo3.triggerEventName = zzo4.triggerEventName;
                zzo3.zzagu = zzo4.zzagu;
                zzo3.active = zzo4.active;
                zzo3.zzags = new zzfv(zzo3.zzags.name, zzo4.zzags.zzauk, zzo3.zzags.getValue(), zzo4.zzags.origin);
            } else if (TextUtils.isEmpty((CharSequence)zzo3.triggerEventName)) {
                zzo3.zzags = new zzfv(zzo3.zzags.name, zzo3.creationTimestamp, zzo3.zzags.getValue(), zzo3.zzags.origin);
                zzo3.active = true;
                bl = true;
            }
            if (zzo3.active) {
                zzfv zzfv2 = zzo3.zzags;
                zzfx zzfx2 = new zzfx(zzo3.packageName, zzo3.origin, zzfv2.name, zzfv2.zzauk, zzfv2.getValue());
                if (this.zzjt().zza(zzfx2)) {
                    this.zzada.zzgt().zzjn().zzd("User property updated immediately", (Object)zzo3.packageName, (Object)this.zzada.zzgq().zzbv(zzfx2.name), zzfx2.value);
                } else {
                    this.zzada.zzgt().zzjg().zzd("(2)Too many active user properties, ignoring", zzas.zzbw((String)zzo3.packageName), (Object)this.zzada.zzgq().zzbv(zzfx2.name), zzfx2.value);
                }
                if (bl && zzo3.zzagu != null) {
                    zzag zzag2 = new zzag(zzo3.zzagu, zzo3.creationTimestamp);
                    this.zzd(zzag2, zzk2);
                }
            }
            if (this.zzjt().zza(zzo3)) {
                this.zzada.zzgt().zzjn().zzd("Conditional property added", (Object)zzo3.packageName, (Object)this.zzada.zzgq().zzbv(zzo3.zzags.name), zzo3.zzags.getValue());
            } else {
                this.zzada.zzgt().zzjg().zzd("Too many conditional properties, ignoring", zzas.zzbw((String)zzo3.packageName), (Object)this.zzada.zzgq().zzbv(zzo3.zzags.name), zzo3.zzags.getValue());
            }
            this.zzjt().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzjt().endTransaction();
        }
    }

    @WorkerThread
    final void zzf(zzo zzo2) {
        zzk zzk2 = this.zzcr(zzo2.packageName);
        if (zzk2 != null) {
            this.zzc(zzo2, zzk2);
        }
    }

    @WorkerThread
    final void zzc(zzo zzo2, zzk zzk2) {
        Preconditions.checkNotNull((Object)zzo2);
        Preconditions.checkNotEmpty((String)zzo2.packageName);
        Preconditions.checkNotNull((Object)zzo2.zzags);
        Preconditions.checkNotEmpty((String)zzo2.zzags.name);
        this.zzaf();
        this.zzlx();
        if (TextUtils.isEmpty((CharSequence)zzk2.zzafi) && TextUtils.isEmpty((CharSequence)zzk2.zzafv)) {
            return;
        }
        if (!zzk2.zzafr) {
            this.zzg(zzk2);
            return;
        }
        this.zzjt().beginTransaction();
        try {
            this.zzg(zzk2);
            zzo zzo3 = this.zzjt().zzj(zzo2.packageName, zzo2.zzags.name);
            if (zzo3 != null) {
                this.zzada.zzgt().zzjn().zze("Removing conditional user property", (Object)zzo2.packageName, (Object)this.zzada.zzgq().zzbv(zzo2.zzags.name));
                this.zzjt().zzk(zzo2.packageName, zzo2.zzags.name);
                if (zzo3.active) {
                    this.zzjt().zzh(zzo2.packageName, zzo2.zzags.name);
                }
                if (zzo2.zzagv != null) {
                    Bundle bundle = null;
                    if (zzo2.zzagv.zzahu != null) {
                        bundle = zzo2.zzagv.zzahu.zziy();
                    }
                    zzag zzag2 = this.zzada.zzgr().zza(zzo2.packageName, zzo2.zzagv.name, bundle, zzo3.origin, zzo2.zzagv.zzaig, true, false);
                    this.zzd(zzag2, zzk2);
                }
            } else {
                this.zzada.zzgt().zzjj().zze("Conditional user property doesn't exist", zzas.zzbw((String)zzo2.packageName), (Object)this.zzada.zzgq().zzbv(zzo2.zzags.name));
            }
            this.zzjt().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzjt().endTransaction();
        }
    }

    @WorkerThread
    private final zzg zzg(zzk zzk2) {
        this.zzaf();
        this.zzlx();
        Preconditions.checkNotNull((Object)zzk2);
        Preconditions.checkNotEmpty((String)zzk2.packageName);
        zzg zzg2 = this.zzjt().zzbm(zzk2.packageName);
        String string = this.zzada.zzgu().zzca(zzk2.packageName);
        boolean bl = false;
        if (zzg2 == null) {
            zzg2 = new zzg(this.zzada, zzk2.packageName);
            zzg2.zzaj(this.zzada.zzgr().zzmm());
            zzg2.zzam(string);
            bl = true;
        } else if (!string.equals(zzg2.zzhc())) {
            zzg2.zzam(string);
            zzg2.zzaj(this.zzada.zzgr().zzmm());
            bl = true;
        }
        if (!TextUtils.equals((CharSequence)zzk2.zzafi, (CharSequence)zzg2.getGmpAppId())) {
            zzg2.zzak(zzk2.zzafi);
            bl = true;
        }
        if (!TextUtils.equals((CharSequence)zzk2.zzafv, (CharSequence)zzg2.zzhb())) {
            zzg2.zzal(zzk2.zzafv);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzk2.zzafk) && !zzk2.zzafk.equals(zzg2.getFirebaseInstanceId())) {
            zzg2.zzan(zzk2.zzafk);
            bl = true;
        }
        if (zzk2.zzade != 0L && zzk2.zzade != zzg2.zzhh()) {
            zzg2.zzr(zzk2.zzade);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzk2.zzts) && !zzk2.zzts.equals(zzg2.zzak())) {
            zzg2.setAppVersion(zzk2.zzts);
            bl = true;
        }
        if (zzk2.zzafo != zzg2.zzhf()) {
            zzg2.zzq(zzk2.zzafo);
            bl = true;
        }
        if (zzk2.zzafp != null && !zzk2.zzafp.equals(zzg2.zzhg())) {
            zzg2.zzao(zzk2.zzafp);
            bl = true;
        }
        if (zzk2.zzafq != zzg2.zzhi()) {
            zzg2.zzs(zzk2.zzafq);
            bl = true;
        }
        if (zzk2.zzafr != zzg2.isMeasurementEnabled()) {
            zzg2.setMeasurementEnabled(zzk2.zzafr);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzk2.zzagm) && !zzk2.zzagm.equals(zzg2.zzht())) {
            zzg2.zzap(zzk2.zzagm);
            bl = true;
        }
        if (zzk2.zzafs != zzg2.zzhv()) {
            zzg2.zzac(zzk2.zzafs);
            bl = true;
        }
        if (zzk2.zzaft != zzg2.zzhw()) {
            zzg2.zze(zzk2.zzaft);
            bl = true;
        }
        if (zzk2.zzafu != zzg2.zzhx()) {
            zzg2.zzf(zzk2.zzafu);
            bl = true;
        }
        if (bl) {
            this.zzjt().zza(zzg2);
        }
        return zzg2;
    }

    final String zzh(zzk zzk2) {
        Future future = this.zzada.zzgs().zzb((Callable)new zzfs(this, zzk2));
        try {
            return (String)future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzada.zzgt().zzjg().zze("Failed to get app instance id. appId", zzas.zzbw((String)zzk2.packageName), (Object)exception);
            return null;
        }
    }

    final void zzm(boolean bl) {
        this.zzmb();
    }

    static /* synthetic */ void zza(zzfo zzfo2, zzft zzft2) {
        zzfo2.zza(zzft2);
    }

    static /* synthetic */ zzg zza(zzfo zzfo2, zzk zzk2) {
        return zzfo2.zzg(zzk2);
    }

    final class zza
    implements zzv {
        zzfw zzaug;
        List<Long> zzauh;
        List<com.google.android.gms.internal.measurement.zzft> zzaui;
        private long zzauj;

        private zza() {
        }

        @Override
        public final void zzb(zzfw zzfw2) {
            Preconditions.checkNotNull((Object)((Object)zzfw2));
            this.zzaug = zzfw2;
        }

        @Override
        public final boolean zza(long l, com.google.android.gms.internal.measurement.zzft zzft2) {
            Preconditions.checkNotNull((Object)((Object)zzft2));
            if (this.zzaui == null) {
                this.zzaui = new ArrayList<com.google.android.gms.internal.measurement.zzft>();
            }
            if (this.zzauh == null) {
                this.zzauh = new ArrayList<Long>();
            }
            if (this.zzaui.size() > 0 && zza.zza(this.zzaui.get(0)) != zza.zza(zzft2)) {
                return false;
            }
            long l2 = this.zzauj + (long)zzft2.zzvx();
            if (l2 >= (long)Math.max(0, (Integer)zzai.zzajc.get())) {
                return false;
            }
            this.zzauj = l2;
            this.zzaui.add(zzft2);
            this.zzauh.add(l);
            return this.zzaui.size() < Math.max(1, (Integer)zzai.zzajd.get());
        }

        private static long zza(com.google.android.gms.internal.measurement.zzft zzft2) {
            return zzft2.zzaxb / 1000L / 60L / 60L;
        }

        /* synthetic */ zza(zzfp zzfp2) {
            this();
        }
    }
}

