/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appcheck.debug.internal;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.appcheck.AppCheckProvider;
import com.google.firebase.appcheck.AppCheckToken;
import com.google.firebase.appcheck.debug.internal.ExchangeDebugTokenRequest;
import com.google.firebase.appcheck.debug.internal.StorageHelper;
import com.google.firebase.appcheck.internal.AppCheckTokenResponse;
import com.google.firebase.appcheck.internal.DefaultAppCheckToken;
import com.google.firebase.appcheck.internal.NetworkClient;
import com.google.firebase.appcheck.internal.RetryManager;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DebugAppCheckProvider
implements AppCheckProvider {
    private static final String TAG = DebugAppCheckProvider.class.getName();
    private static final String UTF_8 = "UTF-8";
    private final NetworkClient networkClient;
    private final ExecutorService backgroundExecutor;
    private final RetryManager retryManager;
    private final Task<String> debugSecretTask;

    public DebugAppCheckProvider(@NonNull FirebaseApp firebaseApp, @Nullable String debugSecret) {
        Preconditions.checkNotNull((Object)firebaseApp);
        this.networkClient = new NetworkClient(firebaseApp);
        this.backgroundExecutor = Executors.newCachedThreadPool();
        this.retryManager = new RetryManager();
        this.debugSecretTask = debugSecret == null ? DebugAppCheckProvider.determineDebugSecret(firebaseApp, this.backgroundExecutor) : Tasks.forResult((Object)debugSecret);
    }

    @VisibleForTesting
    DebugAppCheckProvider(@NonNull String debugSecret, @NonNull NetworkClient networkClient, @NonNull ExecutorService backgroundExecutor, @NonNull RetryManager retryManager) {
        this.networkClient = networkClient;
        this.backgroundExecutor = backgroundExecutor;
        this.retryManager = retryManager;
        this.debugSecretTask = Tasks.forResult((Object)debugSecret);
    }

    @VisibleForTesting
    @NonNull
    static Task<String> determineDebugSecret(@NonNull FirebaseApp firebaseApp, @NonNull ExecutorService executor) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        executor.execute(() -> {
            StorageHelper storageHelper = new StorageHelper(firebaseApp.getApplicationContext(), firebaseApp.getPersistenceKey());
            String debugSecret = storageHelper.retrieveDebugSecret();
            if (debugSecret == null) {
                debugSecret = UUID.randomUUID().toString();
                storageHelper.saveDebugSecret(debugSecret);
            }
            Log.d((String)TAG, (String)("Enter this debug secret into the allow list in the Firebase Console for your project: " + debugSecret));
            taskCompletionSource.setResult((Object)debugSecret);
        });
        return taskCompletionSource.getTask();
    }

    @NonNull
    public Task<AppCheckToken> getToken() {
        return this.debugSecretTask.continueWithTask((Continuation)new Continuation<String, Task<AppCheckTokenResponse>>(){

            public Task<AppCheckTokenResponse> then(@NonNull Task<String> task) throws Exception {
                ExchangeDebugTokenRequest request = new ExchangeDebugTokenRequest((String)task.getResult());
                return Tasks.call((Executor)DebugAppCheckProvider.this.backgroundExecutor, () -> DebugAppCheckProvider.this.networkClient.exchangeAttestationForAppCheckToken(request.toJsonString().getBytes(DebugAppCheckProvider.UTF_8), 2, DebugAppCheckProvider.this.retryManager));
            }
        }).continueWithTask((Continuation)new Continuation<AppCheckTokenResponse, Task<AppCheckToken>>(){

            public Task<AppCheckToken> then(@NonNull Task<AppCheckTokenResponse> task) {
                if (task.isSuccessful()) {
                    return Tasks.forResult((Object)DefaultAppCheckToken.constructFromAppCheckTokenResponse((AppCheckTokenResponse)((AppCheckTokenResponse)task.getResult())));
                }
                return Tasks.forException((Exception)task.getException());
            }
        });
    }
}

