/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appcheck.debug.internal;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.annotations.concurrent.Background;
import com.google.firebase.annotations.concurrent.Blocking;
import com.google.firebase.annotations.concurrent.Lightweight;
import com.google.firebase.appcheck.AppCheckProvider;
import com.google.firebase.appcheck.AppCheckToken;
import com.google.firebase.appcheck.debug.InternalDebugSecretProvider;
import com.google.firebase.appcheck.debug.internal.ExchangeDebugTokenRequest;
import com.google.firebase.appcheck.debug.internal.StorageHelper;
import com.google.firebase.appcheck.internal.AppCheckTokenResponse;
import com.google.firebase.appcheck.internal.DefaultAppCheckToken;
import com.google.firebase.appcheck.internal.NetworkClient;
import com.google.firebase.appcheck.internal.RetryManager;
import com.google.firebase.inject.Provider;
import java.util.UUID;
import java.util.concurrent.Executor;

public class DebugAppCheckProvider
implements AppCheckProvider {
    private static final String TAG = DebugAppCheckProvider.class.getName();
    private static final String UTF_8 = "UTF-8";
    private final NetworkClient networkClient;
    private final Executor liteExecutor;
    private final Executor blockingExecutor;
    private final RetryManager retryManager;
    private final Task<String> debugSecretTask;

    public DebugAppCheckProvider(@NonNull FirebaseApp firebaseApp, @NonNull Provider<InternalDebugSecretProvider> debugSecretProvider, @Lightweight Executor liteExecutor, @Background Executor backgroundExecutor, @Blocking Executor blockingExecutor) {
        Preconditions.checkNotNull((Object)firebaseApp);
        this.networkClient = new NetworkClient(firebaseApp);
        this.liteExecutor = liteExecutor;
        this.blockingExecutor = blockingExecutor;
        this.retryManager = new RetryManager();
        String debugSecret = null;
        if (debugSecretProvider.get() != null) {
            debugSecret = ((InternalDebugSecretProvider)debugSecretProvider.get()).getDebugSecret();
        }
        this.debugSecretTask = debugSecret == null ? DebugAppCheckProvider.determineDebugSecret(firebaseApp, backgroundExecutor) : Tasks.forResult((Object)debugSecret);
    }

    @VisibleForTesting
    DebugAppCheckProvider(@NonNull String debugSecret, @NonNull NetworkClient networkClient, @NonNull Executor liteExecutor, @NonNull Executor blockingExecutor, @NonNull RetryManager retryManager) {
        this.networkClient = networkClient;
        this.liteExecutor = liteExecutor;
        this.blockingExecutor = blockingExecutor;
        this.retryManager = retryManager;
        this.debugSecretTask = Tasks.forResult((Object)debugSecret);
    }

    @VisibleForTesting
    @NonNull
    static Task<String> determineDebugSecret(@NonNull FirebaseApp firebaseApp, @NonNull Executor executor) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        executor.execute(() -> {
            StorageHelper storageHelper = new StorageHelper(firebaseApp.getApplicationContext(), firebaseApp.getPersistenceKey());
            String debugSecret = storageHelper.retrieveDebugSecret();
            if (debugSecret == null) {
                debugSecret = UUID.randomUUID().toString();
                storageHelper.saveDebugSecret(debugSecret);
            }
            Log.d((String)TAG, (String)("Enter this debug secret into the allow list in the Firebase Console for your project: " + debugSecret));
            taskCompletionSource.setResult((Object)debugSecret);
        });
        return taskCompletionSource.getTask();
    }

    @NonNull
    public Task<AppCheckToken> getToken() {
        return this.debugSecretTask.onSuccessTask(this.liteExecutor, debugSecret -> {
            ExchangeDebugTokenRequest request = new ExchangeDebugTokenRequest((String)debugSecret);
            return Tasks.call((Executor)this.blockingExecutor, () -> this.networkClient.exchangeAttestationForAppCheckToken(request.toJsonString().getBytes(UTF_8), 2, this.retryManager));
        }).onSuccessTask(this.liteExecutor, response -> Tasks.forResult((Object)DefaultAppCheckToken.constructFromAppCheckTokenResponse((AppCheckTokenResponse)response)));
    }
}

