/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.icing;

import com.google.android.gms.internal.icing.zzch;
import com.google.android.gms.internal.icing.zzdq;
import com.google.android.gms.internal.icing.zzdx;
import com.google.android.gms.internal.icing.zzfg;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzcj
extends zzch<Boolean>
implements zzdx<Boolean>,
zzfg,
RandomAccess {
    private static final zzcj zzfv = new zzcj(new boolean[0], 0);
    private boolean[] zzfw;
    private int size;

    public static zzcj zzaj() {
        return zzfv;
    }

    zzcj() {
        this(new boolean[10], 0);
    }

    private zzcj(boolean[] blArray, int n) {
        this.zzfw = blArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzai();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzfw, n2, this.zzfw, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzcj)) {
            return super.equals(object);
        }
        zzcj zzcj2 = (zzcj)object;
        if (this.size != zzcj2.size) {
            return false;
        }
        boolean[] blArray = zzcj2.zzfw;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzfw[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzdq.zzg(this.zzfw[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.zzai();
        zzdq.checkNotNull(collection);
        if (!(collection instanceof zzcj)) {
            return super.addAll(collection);
        }
        zzcj zzcj2 = (zzcj)collection;
        if (zzcj2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzcj2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzcj2.size;
        if (n > this.zzfw.length) {
            this.zzfw = Arrays.copyOf(this.zzfw, n);
        }
        System.arraycopy(zzcj2.zzfw, 0, this.zzfw, this.size, zzcj2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzai();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzfw[i])) continue;
            System.arraycopy(this.zzfw, i + 1, this.zzfw, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzh(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
    }

    private final String zzi(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzcj zzcj2 = this;
        zzcj2.zzai();
        zzcj2.zzh(n);
        boolean bl3 = zzcj2.zzfw[n];
        zzcj2.zzfw[n] = bl2;
        return bl3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzcj zzcj2 = this;
        zzcj2.zzai();
        zzcj2.zzh(n);
        boolean bl = zzcj2.zzfw[n];
        if (n < zzcj2.size - 1) {
            System.arraycopy(zzcj2.zzfw, n + 1, zzcj2.zzfw, n, zzcj2.size - n - 1);
        }
        --zzcj2.size;
        ++zzcj2.modCount;
        return bl;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        int n2 = n;
        zzcj zzcj2 = this;
        zzcj2.zzai();
        if (n2 < 0 || n2 > zzcj2.size) {
            throw new IndexOutOfBoundsException(zzcj2.zzi(n2));
        }
        if (zzcj2.size < zzcj2.zzfw.length) {
            System.arraycopy(zzcj2.zzfw, n2, zzcj2.zzfw, n2 + 1, zzcj2.size - n2);
        } else {
            boolean[] blArray = new boolean[zzcj2.size * 3 / 2 + 1];
            System.arraycopy(zzcj2.zzfw, 0, blArray, 0, n2);
            System.arraycopy(zzcj2.zzfw, n2, blArray, n2 + 1, zzcj2.size - n2);
            zzcj2.zzfw = blArray;
        }
        zzcj2.zzfw[n2] = bl2;
        ++zzcj2.size;
        ++zzcj2.modCount;
    }

    @Override
    public final /* synthetic */ zzdx zzj(int n) {
        int n2 = n;
        zzcj zzcj2 = this;
        if (n2 < zzcj2.size) {
            throw new IllegalArgumentException();
        }
        return new zzcj(Arrays.copyOf(zzcj2.zzfw, n2), zzcj2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzcj zzcj2 = this;
        zzcj2.zzh(n);
        return zzcj2.zzfw[n];
    }

    static {
        zzfv.zzah();
    }
}

