/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.icing;

import com.google.android.gms.internal.icing.zzch;
import com.google.android.gms.internal.icing.zzdq;
import com.google.android.gms.internal.icing.zzdx;
import com.google.android.gms.internal.icing.zzfg;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdr
extends zzch<Integer>
implements zzdx<Integer>,
zzfg,
RandomAccess {
    private static final zzdr zzks = new zzdr(new int[0], 0);
    private int[] zzkt;
    private int size;

    zzdr() {
        this(new int[10], 0);
    }

    private zzdr(int[] nArray, int n) {
        this.zzkt = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzai();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzkt, n2, this.zzkt, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdr)) {
            return super.equals(object);
        }
        zzdr zzdr2 = (zzdr)object;
        if (this.size != zzdr2.size) {
            return false;
        }
        int[] nArray = zzdr2.zzkt;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzkt[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzkt[i];
        }
        return n;
    }

    public final int getInt(int n) {
        this.zzh(n);
        return this.zzkt[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzai();
        zzdq.checkNotNull(collection);
        if (!(collection instanceof zzdr)) {
            return super.addAll(collection);
        }
        zzdr zzdr2 = (zzdr)collection;
        if (zzdr2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdr2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdr2.size;
        if (n > this.zzkt.length) {
            this.zzkt = Arrays.copyOf(this.zzkt, n);
        }
        System.arraycopy(zzdr2.zzkt, 0, this.zzkt, this.size, zzdr2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzai();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzkt[i])) continue;
            System.arraycopy(this.zzkt, i + 1, this.zzkt, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzh(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
    }

    private final String zzi(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzdr zzdr2 = this;
        zzdr2.zzai();
        zzdr2.zzh(n);
        int n4 = zzdr2.zzkt[n];
        zzdr2.zzkt[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdr zzdr2 = this;
        zzdr2.zzai();
        zzdr2.zzh(n);
        int n2 = zzdr2.zzkt[n];
        if (n < zzdr2.size - 1) {
            System.arraycopy(zzdr2.zzkt, n + 1, zzdr2.zzkt, n, zzdr2.size - n - 1);
        }
        --zzdr2.size;
        ++zzdr2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        int n4 = n;
        zzdr zzdr2 = this;
        zzdr2.zzai();
        if (n4 < 0 || n4 > zzdr2.size) {
            throw new IndexOutOfBoundsException(zzdr2.zzi(n4));
        }
        if (zzdr2.size < zzdr2.zzkt.length) {
            System.arraycopy(zzdr2.zzkt, n4, zzdr2.zzkt, n4 + 1, zzdr2.size - n4);
        } else {
            int[] nArray = new int[zzdr2.size * 3 / 2 + 1];
            System.arraycopy(zzdr2.zzkt, 0, nArray, 0, n4);
            System.arraycopy(zzdr2.zzkt, n4, nArray, n4 + 1, zzdr2.size - n4);
            zzdr2.zzkt = nArray;
        }
        zzdr2.zzkt[n4] = n3;
        ++zzdr2.size;
        ++zzdr2.modCount;
    }

    @Override
    public final /* synthetic */ zzdx zzj(int n) {
        int n2 = n;
        zzdr zzdr2 = this;
        if (n2 < zzdr2.size) {
            throw new IllegalArgumentException();
        }
        return new zzdr(Arrays.copyOf(zzdr2.zzkt, n2), zzdr2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzks.zzah();
    }
}

