/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.icing;

import com.google.android.gms.internal.icing.zzch;
import com.google.android.gms.internal.icing.zzdq;
import com.google.android.gms.internal.icing.zzdx;
import com.google.android.gms.internal.icing.zzfg;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzek
extends zzch<Long>
implements zzdx<Long>,
zzfg,
RandomAccess {
    private static final zzek zzlu = new zzek(new long[0], 0);
    private long[] zzlv;
    private int size;

    public static zzek zzch() {
        return zzlu;
    }

    zzek() {
        this(new long[10], 0);
    }

    private zzek(long[] lArray, int n) {
        this.zzlv = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzai();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzlv, n2, this.zzlv, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzek)) {
            return super.equals(object);
        }
        zzek zzek2 = (zzek)object;
        if (this.size != zzek2.size) {
            return false;
        }
        long[] lArray = zzek2.zzlv;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzlv[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzdq.zzk(this.zzlv[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzh(n);
        return this.zzlv[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzai();
        zzdq.checkNotNull(collection);
        if (!(collection instanceof zzek)) {
            return super.addAll(collection);
        }
        zzek zzek2 = (zzek)collection;
        if (zzek2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzek2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzek2.size;
        if (n > this.zzlv.length) {
            this.zzlv = Arrays.copyOf(this.zzlv, n);
        }
        System.arraycopy(zzek2.zzlv, 0, this.zzlv, this.size, zzek2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzai();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzlv[i])) continue;
            System.arraycopy(this.zzlv, i + 1, this.zzlv, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzh(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
    }

    private final String zzi(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzek zzek2 = this;
        zzek2.zzai();
        zzek2.zzh(n);
        long l3 = zzek2.zzlv[n];
        zzek2.zzlv[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzek zzek2 = this;
        zzek2.zzai();
        zzek2.zzh(n);
        long l = zzek2.zzlv[n];
        if (n < zzek2.size - 1) {
            System.arraycopy(zzek2.zzlv, n + 1, zzek2.zzlv, n, zzek2.size - n - 1);
        }
        --zzek2.size;
        ++zzek2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        int n2 = n;
        zzek zzek2 = this;
        zzek2.zzai();
        if (n2 < 0 || n2 > zzek2.size) {
            throw new IndexOutOfBoundsException(zzek2.zzi(n2));
        }
        if (zzek2.size < zzek2.zzlv.length) {
            System.arraycopy(zzek2.zzlv, n2, zzek2.zzlv, n2 + 1, zzek2.size - n2);
        } else {
            long[] lArray = new long[zzek2.size * 3 / 2 + 1];
            System.arraycopy(zzek2.zzlv, 0, lArray, 0, n2);
            System.arraycopy(zzek2.zzlv, n2, lArray, n2 + 1, zzek2.size - n2);
            zzek2.zzlv = lArray;
        }
        zzek2.zzlv[n2] = l2;
        ++zzek2.size;
        ++zzek2.modCount;
    }

    @Override
    public final /* synthetic */ zzdx zzj(int n) {
        int n2 = n;
        zzek zzek2 = this;
        if (n2 < zzek2.size) {
            throw new IllegalArgumentException();
        }
        return new zzek(Arrays.copyOf(zzek2.zzlv, n2), zzek2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzlu.zzah();
    }
}

