/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appindexing;

import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.icing.zzgz;
import com.google.firebase.appindexing.builders.IndexableBuilder;
import com.google.firebase.appindexing.internal.Thing;

public interface Indexable {
    public static final int MAX_INDEXABLES_TO_BE_UPDATED_IN_ONE_CALL = 1000;
    public static final int MAX_URL_LENGTH = 256;
    public static final int MAX_NESTING_DEPTH = 5;
    public static final int MAX_NUMBER_OF_FIELDS = 20;
    public static final int MAX_REPEATED_SIZE = 100;
    public static final int MAX_STRING_LENGTH = 20000;
    public static final int MAX_BYTE_SIZE = 30000;

    public static class Builder
    extends IndexableBuilder<Builder> {
        public Builder() {
            this("Thing");
        }

        public Builder(@NonNull String string) {
            super(string);
        }
    }

    public static interface Metadata {

        public static final class Builder {
            private boolean zzed = zzgz.zza.zzdy().zzdw();
            private int score = zzgz.zza.zzdy().getScore();
            private String zzee = zzgz.zza.zzdy().zzdx();
            private final Bundle zzay = new Bundle();

            public final Builder setWorksOffline(boolean bl) {
                this.zzed = bl;
                return this;
            }

            public final Builder setScore(int n) {
                Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0, (Object)new StringBuilder(53).append("Negative score values are invalid. Value: ").append(n).toString());
                this.score = n;
                return this;
            }

            public final Builder setScope(int n) {
                Preconditions.checkArgument((n > 0 && n <= 3 ? 1 : 0) != 0, (Object)new StringBuilder(69).append("The scope of this indexable is not valid, scope value is ").append(n).append(".").toString());
                long[] lArray = new long[]{n};
                String string = "scope";
                Builder builder = this;
                IndexableBuilder.zza(builder.zzay, string, lArray);
                return builder;
            }

            public final Builder setSliceUri(@NonNull Uri uri) {
                Preconditions.checkNotNull((Object)uri);
                Object[] objectArray = new boolean[]{true};
                String string = "grantSlicePermission";
                IndexableBuilder.zza(this.zzay, string, objectArray);
                objectArray = new String[]{uri.toString()};
                string = "sliceUri";
                Builder builder = this;
                IndexableBuilder.zza(builder.zzay, string, (String[])objectArray);
                return builder;
            }

            public final Thing.zza zzy() {
                return new Thing.zza(this.zzed, this.score, this.zzee, this.zzay);
            }
        }
    }
}

