/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.icing;

import com.google.android.gms.internal.icing.zzcp;
import com.google.android.gms.internal.icing.zzeb;
import com.google.android.gms.internal.icing.zzee;
import com.google.android.gms.internal.icing.zzfq;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzev
extends zzcp<Long>
implements zzee<Long>,
zzfq,
RandomAccess {
    private static final zzev zzmf = new zzev(new long[0], 0);
    private long[] zzmg;
    private int size;

    public static zzev zzci() {
        return zzmf;
    }

    zzev() {
        this(new long[10], 0);
    }

    private zzev(long[] lArray, int n) {
        this.zzmg = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzaj();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzmg, n2, this.zzmg, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzev)) {
            return super.equals(object);
        }
        zzev zzev2 = (zzev)object;
        if (this.size != zzev2.size) {
            return false;
        }
        long[] lArray = zzev2.zzmg;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzmg[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzeb.zzk(this.zzmg[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzh(n);
        return this.zzmg[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzaj();
        zzeb.checkNotNull(collection);
        if (!(collection instanceof zzev)) {
            return super.addAll(collection);
        }
        zzev zzev2 = (zzev)collection;
        if (zzev2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzev2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzev2.size;
        if (n > this.zzmg.length) {
            this.zzmg = Arrays.copyOf(this.zzmg, n);
        }
        System.arraycopy(zzev2.zzmg, 0, this.zzmg, this.size, zzev2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzaj();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzmg[i])) continue;
            System.arraycopy(this.zzmg, i + 1, this.zzmg, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzh(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
    }

    private final String zzi(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzev zzev2 = this;
        zzev2.zzaj();
        zzev2.zzh(n);
        long l3 = zzev2.zzmg[n];
        zzev2.zzmg[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzev zzev2 = this;
        zzev2.zzaj();
        zzev2.zzh(n);
        long l = zzev2.zzmg[n];
        if (n < zzev2.size - 1) {
            System.arraycopy(zzev2.zzmg, n + 1, zzev2.zzmg, n, zzev2.size - n - 1);
        }
        --zzev2.size;
        ++zzev2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzev zzev2 = this;
        zzev2.zzaj();
        if (n < 0 || n > zzev2.size) {
            throw new IndexOutOfBoundsException(zzev2.zzi(n));
        }
        if (zzev2.size < zzev2.zzmg.length) {
            System.arraycopy(zzev2.zzmg, n, zzev2.zzmg, n + 1, zzev2.size - n);
        } else {
            long[] lArray = new long[zzev2.size * 3 / 2 + 1];
            System.arraycopy(zzev2.zzmg, 0, lArray, 0, n);
            System.arraycopy(zzev2.zzmg, n, lArray, n + 1, zzev2.size - n);
            zzev2.zzmg = lArray;
        }
        zzev2.zzmg[n] = l2;
        ++zzev2.size;
        ++zzev2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzev zzev2 = this;
        zzev2.zzaj();
        if (zzev2.size == zzev2.zzmg.length) {
            long[] lArray = new long[zzev2.size * 3 / 2 + 1];
            System.arraycopy(zzev2.zzmg, 0, lArray, 0, zzev2.size);
            zzev2.zzmg = lArray;
        }
        zzev2.zzmg[zzev2.size++] = l2;
        return true;
    }

    @Override
    public final /* synthetic */ zzee zzj(int n) {
        int n2 = n;
        zzev zzev2 = this;
        if (n2 < zzev2.size) {
            throw new IllegalArgumentException();
        }
        return new zzev(Arrays.copyOf(zzev2.zzmg, n2), zzev2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzmf.zzai();
    }
}

