/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.icing;

import android.content.ComponentName;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.appindexing.AppIndexApi;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.icing.zzal;
import com.google.android.gms.internal.icing.zzdx;
import com.google.android.gms.internal.icing.zzg;
import com.google.android.gms.internal.icing.zzh;
import com.google.android.gms.internal.icing.zzi;
import com.google.android.gms.internal.icing.zzk;
import com.google.android.gms.internal.icing.zzs;
import com.google.android.gms.internal.icing.zzy;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.zip.CRC32;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="UsageInfoCreator")
@ShowFirstParty
public final class zzw
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<zzw> CREATOR = new zzy();
    @SafeParcelable.Field(id=1)
    private final zzi zzaj;
    @SafeParcelable.Field(id=2)
    private final long zzak;
    @SafeParcelable.Field(id=3)
    private int zzal;
    @SafeParcelable.Field(id=4)
    private final String zzam;
    @SafeParcelable.Field(id=5)
    private final zzh zzan;
    @SafeParcelable.Field(id=6, defaultValue="false")
    private final boolean zzao;
    @SafeParcelable.Field(id=7, defaultValue="-1")
    private int zzap;
    @SafeParcelable.Field(id=8)
    private int zzaq;
    @SafeParcelable.Field(id=9)
    private final String zzar;

    @VisibleForTesting
    public zzw(String string, Intent intent, String string2, Uri uri, String string3, List<AppIndexApi.AppIndexingLink> list, int n) {
        this(zzw.zza(string, intent), System.currentTimeMillis(), 0, null, zzw.zza(intent, string2, uri, null, list).zzb(), false, -1, 1, null);
    }

    @SafeParcelable.Constructor
    zzw(@SafeParcelable.Param(id=1) zzi zzi2, @SafeParcelable.Param(id=2) long l, @SafeParcelable.Param(id=3) int n, @SafeParcelable.Param(id=4) String string, @SafeParcelable.Param(id=5) zzh zzh2, @SafeParcelable.Param(id=6) boolean bl, @SafeParcelable.Param(id=7) int n2, @SafeParcelable.Param(id=8) int n3, @SafeParcelable.Param(id=9) String string2) {
        this.zzaj = zzi2;
        this.zzak = l;
        this.zzal = n;
        this.zzam = string;
        this.zzan = zzh2;
        this.zzao = bl;
        this.zzap = n2;
        this.zzaq = n3;
        this.zzar = string2;
    }

    public static zzi zza(String string, Intent intent) {
        String string2 = zzw.zza(intent);
        String string3 = string;
        return new zzi(string3, "", string2);
    }

    private static zzk zza(String string, String string2) {
        return new zzk(string2, new zzs(string).zzb(true).zzc(), string);
    }

    private static String zza(Intent intent) {
        String string = intent.toUri(1);
        CRC32 cRC32 = new CRC32();
        try {
            cRC32.update(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
        return Long.toHexString(cRC32.getValue());
    }

    @VisibleForTesting
    public static zzg zza(Intent intent, String string, Uri uri, String string2, List<AppIndexApi.AppIndexingLink> list) {
        String string3;
        Bundle bundle;
        ComponentName componentName;
        String string4;
        String string5;
        zzg zzg2 = new zzg();
        Object object = string;
        zzg2.zza(new zzk((String)object, new zzs("title").zzc(true).zzd("name").zzc(), "text1"));
        if (uri != null) {
            object = uri;
            zzg2.zza(new zzk(object.toString(), new zzs("web_url").zzb(true).zzd("url").zzc()));
        }
        if (list != null) {
            object = list;
            zzal.zza.zza zza2 = zzal.zza.zzf();
            zzal.zza.zzb[] zzbArray = new zzal.zza.zzb[object.size()];
            for (int i = 0; i < zzbArray.length; ++i) {
                zzal.zza.zzb.zza zza3 = zzal.zza.zzb.zzh();
                AppIndexApi.AppIndexingLink appIndexingLink = (AppIndexApi.AppIndexingLink)object.get(i);
                zza3.zze(appIndexingLink.appIndexingUrl.toString()).zzd(appIndexingLink.viewId);
                if (appIndexingLink.webUrl != null) {
                    zza3.zzf(appIndexingLink.webUrl.toString());
                }
                zzbArray[i] = (zzal.zza.zzb)((zzdx)zza3.zzbx());
            }
            zza2.zza((Iterable<? extends zzal.zza.zzb>)Arrays.asList(zzbArray));
            zzg2.zza(new zzk(((zzal.zza)((zzdx)zza2.zzbx())).toByteArray(), new zzs("outlinks").zzb(true).zzd(".private:outLinks").zzc("blob").zzc()));
        }
        if ((string5 = intent.getAction()) != null) {
            zzg2.zza(zzw.zza("intent_action", string5));
        }
        if ((string4 = intent.getDataString()) != null) {
            zzg2.zza(zzw.zza("intent_data", string4));
        }
        if ((componentName = intent.getComponent()) != null) {
            zzg2.zza(zzw.zza("intent_activity", componentName.getClassName()));
        }
        if ((bundle = intent.getExtras()) != null && (string3 = bundle.getString("intent_extra_data_key")) != null) {
            zzg2.zza(zzw.zza("intent_extra_data", string3));
        }
        return zzg2.zza(string2).zza(true);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzw zzw2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)1, (Parcelable)zzw2.zzaj, (int)n, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)2, (long)zzw2.zzak);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)3, (int)zzw2.zzal);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)zzw2.zzam, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)5, (Parcelable)zzw2.zzan, (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)6, (boolean)zzw2.zzao);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)7, (int)zzw2.zzap);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)8, (int)zzw2.zzaq);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)9, (String)zzw2.zzar, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final String toString() {
        return String.format(Locale.US, "UsageInfo[documentId=%s, timestamp=%d, usageType=%d, status=%d]", new Object[]{this.zzaj, this.zzak, this.zzal, this.zzaq});
    }
}

