/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appindexing;

import android.os.Bundle;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.appindexing.FirebaseAppIndexingInvalidArgumentException;
import com.google.firebase.appindexing.Indexable;
import com.google.firebase.appindexing.builders.IndexableBuilder;
import com.google.firebase.appindexing.internal.zza;
import com.google.firebase.appindexing.internal.zzc;
import com.google.firebase.appindexing.internal.zzt;
import java.util.Arrays;

public interface Action {

    public static class Builder {
        public static final String ACTIVATE_ACTION = "ActivateAction";
        public static final String ADD_ACTION = "AddAction";
        public static final String BOOKMARK_ACTION = "BookmarkAction";
        public static final String COMMENT_ACTION = "CommentAction";
        public static final String LIKE_ACTION = "LikeAction";
        public static final String LISTEN_ACTION = "ListenAction";
        public static final String SEND_ACTION = "SendAction";
        public static final String SHARE_ACTION = "ShareAction";
        public static final String VIEW_ACTION = "ViewAction";
        public static final String WATCH_ACTION = "WatchAction";
        public static final String STATUS_TYPE_ACTIVE = "http://schema.org/ActiveActionStatus";
        public static final String STATUS_TYPE_COMPLETED = "http://schema.org/CompletedActionStatus";
        public static final String STATUS_TYPE_FAILED = "http://schema.org/FailedActionStatus";
        private final Bundle zzay = new Bundle();
        private final String zzar;
        private String zzeg;
        private String zzeh;
        private String zzei;
        private zzc zzej;
        private String zzek;

        public Builder(@NonNull String string) {
            this.zzar = string;
        }

        public Builder put(@NonNull String string, String ... stringArray) {
            IndexableBuilder.zza(this.zzay, string, stringArray);
            return this;
        }

        public Builder put(@NonNull String string, Indexable ... indexableArray) throws FirebaseAppIndexingInvalidArgumentException {
            IndexableBuilder.zza(this.zzay, string, indexableArray);
            return this;
        }

        public Builder put(@NonNull String string, boolean ... blArray) {
            IndexableBuilder.zza(this.zzay, string, blArray);
            return this;
        }

        public Builder put(@NonNull String string, long ... lArray) {
            IndexableBuilder.zza(this.zzay, string, lArray);
            return this;
        }

        public Builder put(@NonNull String string, double ... dArray) {
            double[] dArray2 = dArray;
            String string2 = string;
            Bundle bundle = this.zzay;
            Preconditions.checkNotNull((Object)string2);
            Preconditions.checkNotNull((Object)dArray2);
            if (dArray2.length > 0) {
                double[] dArray3;
                double[] dArray4 = dArray2;
                if (dArray2.length < 100) {
                    dArray3 = dArray4;
                } else {
                    zzt.zzn("Input Array of elements is too big, cutting off.");
                    dArray3 = Arrays.copyOf(dArray4, 100);
                }
                bundle.putDoubleArray(string2, dArray3);
            } else {
                zzt.zzn("Double array is empty and is ignored by put method.");
            }
            return this;
        }

        public final Builder setUrl(@NonNull String string) {
            Preconditions.checkNotNull((Object)string);
            this.zzeh = string;
            return this.put("url", string);
        }

        public Builder setResult(Indexable ... indexableArray) throws FirebaseAppIndexingInvalidArgumentException {
            return this.put("result", indexableArray);
        }

        public Builder setObject(@NonNull String string, @NonNull String string2) {
            Preconditions.checkNotNull((Object)string);
            Preconditions.checkNotNull((Object)string2);
            this.zzeg = string;
            this.zzeh = string2;
            return this;
        }

        public Builder setObject(@NonNull String string, @NonNull String string2, @NonNull String string3) {
            Preconditions.checkNotNull((Object)string);
            Preconditions.checkNotNull((Object)string2);
            Preconditions.checkNotNull((Object)string3);
            this.zzeg = string;
            this.zzeh = string2;
            this.zzei = string3;
            return this;
        }

        public final Builder setName(@NonNull String string) {
            Preconditions.checkNotNull((Object)string);
            this.zzeg = string;
            return this.put("name", string);
        }

        public Builder setMetadata(@NonNull Metadata.Builder builder) {
            Preconditions.checkNotNull((Object)builder);
            this.zzej = builder.zzz();
            return this;
        }

        public Builder setActionStatus(@NonNull String string) {
            Preconditions.checkNotNull((Object)string);
            this.zzek = string;
            return this;
        }

        public Action build() {
            Preconditions.checkNotNull((Object)this.zzeg, (Object)"setObject is required before calling build().");
            Preconditions.checkNotNull((Object)this.zzeh, (Object)"setObject is required before calling build().");
            return new zza(this.zzar, this.zzeg, this.zzeh, this.zzei, this.zzej == null ? new Metadata.Builder().zzz() : this.zzej, this.zzek, this.zzay);
        }

        protected final String getName() {
            if (this.zzeg == null) {
                return null;
            }
            return new String(this.zzeg);
        }

        protected final String getUrl() {
            if (this.zzeh == null) {
                return null;
            }
            return new String(this.zzeh);
        }

        protected final String zzy() {
            return new String(this.zzek);
        }
    }

    public static interface Metadata {

        public static class Builder {
            private boolean zzel = true;
            private boolean zzem = false;

            public Builder setUpload(boolean bl) {
                this.zzel = bl;
                return this;
            }

            public final zzc zzz() {
                return new zzc(this.zzel, null, null, null, false);
            }
        }
    }
}

