/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appindexing.builders;

import com.google.firebase.appindexing.builders.IndexableBuilder;
import com.google.firebase.appindexing.internal.zzad;
import java.util.Calendar;

public final class TimerBuilder
extends IndexableBuilder<TimerBuilder> {
    public static final String STARTED = "Started";
    public static final String PAUSED = "Paused";
    public static final String EXPIRED = "Expired";
    public static final String MISSED = "Missed";
    public static final String RESET = "Reset";
    public static final String UNKNOWN = "Unknown";

    TimerBuilder() {
        super("Timer");
    }

    public final TimerBuilder setRingtone(String string) {
        return (TimerBuilder)this.put("ringtone", string);
    }

    public final TimerBuilder setMessage(String string) {
        return (TimerBuilder)this.put("message", string);
    }

    public final TimerBuilder setLength(long l) {
        return (TimerBuilder)this.put("length", l);
    }

    public final TimerBuilder setVibrate(boolean bl) {
        return (TimerBuilder)this.put("vibrate", bl);
    }

    public final TimerBuilder setRemainingTime(long l) {
        return (TimerBuilder)this.put("remainingTime", l);
    }

    public final TimerBuilder setTimerStatus(String string) {
        if (!(STARTED.equals(string) || PAUSED.equals(string) || EXPIRED.equals(string) || MISSED.equals(string) || RESET.equals(string) || UNKNOWN.equals(string))) {
            String string2 = String.valueOf(string);
            throw new IllegalArgumentException(string2.length() != 0 ? "Invalid timer status ".concat(string2) : new String("Invalid timer status "));
        }
        return (TimerBuilder)this.put("timerStatus", string);
    }

    public final TimerBuilder setIdentifier(String string) {
        return (TimerBuilder)this.put("identifier", string);
    }

    public final TimerBuilder setExpireTime(Calendar calendar) {
        return (TimerBuilder)this.put("expireTime", zzad.zza(calendar));
    }
}

