/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appindexing.internal;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.firebase.appindexing.Indexable;
import com.google.firebase.appindexing.internal.zzac;
import com.google.firebase.appindexing.internal.zzae;
import com.google.firebase.appindexing.internal.zzw;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

@SafeParcelable.Class(creator="ThingCreator")
public final class Thing
extends AbstractSafeParcelable
implements ReflectedParcelable,
Indexable {
    public static final Parcelable.Creator<Thing> CREATOR = new zzae();
    @SafeParcelable.Field(id=1000, getter="getVersionCode")
    private final int zzfv;
    @SafeParcelable.Field(id=1, getter="getPropertyBundle")
    private final Bundle zzay;
    @SafeParcelable.Field(id=2, getter="getMetadata")
    private final zza zzer;
    @SafeParcelable.Field(id=3, getter="getUrl")
    private final String zzfw;
    @SafeParcelable.Field(id=4, getter="getType")
    private final String type;

    @SafeParcelable.Constructor
    public Thing(@SafeParcelable.Param(id=1000) int n, @SafeParcelable.Param(id=1) Bundle bundle, @SafeParcelable.Param(id=2) zza zza2, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) String string2) {
        this.zzfv = n;
        this.zzay = bundle;
        this.zzer = zza2;
        this.zzfw = string;
        this.type = string2;
        this.zzay.setClassLoader(this.getClass().getClassLoader());
    }

    public Thing(@NonNull Bundle bundle, @NonNull zza zza2, String string, @NonNull String string2) {
        this.zzfv = 10;
        this.zzay = bundle;
        this.zzer = zza2;
        this.zzfw = string;
        this.type = string2;
    }

    public final zza zzac() {
        return this.zzer;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Thing thing = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeBundle((Parcel)parcel2, (int)1, (Bundle)thing.zzay, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)thing.zzer, (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)thing.zzfw, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)thing.type, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1000, (int)thing.zzfv);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    private static void zza(@NonNull Bundle bundle, @NonNull StringBuilder stringBuilder) {
        try {
            Set set = bundle.keySet();
            String[] stringArray = set.toArray(new String[set.size()]);
            Arrays.sort(stringArray, zzac.zzfy);
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray2[i];
                stringBuilder.append("{ key: '").append(string).append("' value: ");
                Object object = bundle.get(string);
                if (object == null) {
                    stringBuilder.append("<null>");
                } else if (object.getClass().isArray()) {
                    stringBuilder.append("[ ");
                    for (int j = 0; j < Array.getLength(object); ++j) {
                        stringBuilder.append("'").append(Array.get(object, j)).append("' ");
                    }
                    stringBuilder.append("]");
                } else {
                    stringBuilder.append(object.toString());
                }
                stringBuilder.append(" } ");
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            stringBuilder.append("<error>");
            return;
        }
    }

    public final String toString() {
        Thing thing = this;
        StringBuilder stringBuilder = new StringBuilder().append(thing.type.equals("Thing") ? "Indexable" : thing.type).append(" { { id: ");
        if (this.zzfw == null) {
            stringBuilder.append("<null>");
        } else {
            stringBuilder.append("'").append(this.zzfw).append("'");
        }
        stringBuilder.append(" } Properties { ");
        Thing.zza(this.zzay, stringBuilder);
        stringBuilder.append("} ");
        stringBuilder.append("Metadata { ");
        stringBuilder.append(this.zzer.toString());
        stringBuilder.append(" } ");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Thing)) {
            return false;
        }
        Thing thing = (Thing)object;
        return Objects.equal((Object)this.zzfv, (Object)thing.zzfv) && Objects.equal((Object)this.zzfw, (Object)thing.zzfw) && Objects.equal((Object)this.type, (Object)thing.type) && Objects.equal((Object)this.zzer, (Object)thing.zzer) && Thing.zza(this.zzay, thing.zzay);
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzfv, this.zzfw, this.type, this.zzer.hashCode(), Thing.zzb(this.zzay)});
    }

    private static boolean zza(Bundle bundle, Bundle bundle2) {
        if (bundle.size() != bundle2.size()) {
            return false;
        }
        for (String string : bundle.keySet()) {
            Object object = bundle.get(string);
            Object object2 = bundle2.get(string);
            if (object instanceof Bundle && object2 instanceof Bundle && !Thing.zza((Bundle)object, (Bundle)object2)) {
                return false;
            }
            if (!(object != null || object2 == null && bundle2.containsKey(string))) {
                return false;
            }
            if (!(object instanceof boolean[] ? !(object2 instanceof boolean[]) || !Arrays.equals((boolean[])object, (boolean[])object2) : (object instanceof long[] ? !(object2 instanceof long[]) || !Arrays.equals((long[])object, (long[])object2) : (object instanceof double[] ? !(object2 instanceof double[]) || !Arrays.equals((double[])object, (double[])object2) : (object instanceof byte[] ? !(object2 instanceof byte[]) || !Arrays.equals((byte[])object, (byte[])object2) : object instanceof Object[] && (!(object2 instanceof Object[]) || !Arrays.equals((Object[])object, (Object[])object2))))))) continue;
            return false;
        }
        return true;
    }

    private static int zzb(Bundle bundle) {
        ArrayList arrayList = new ArrayList(bundle.keySet());
        Collections.sort(arrayList);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            Object e = arrayList3.get(i);
            String string = (String)e;
            Object object = bundle.get(string);
            if (object instanceof boolean[]) {
                arrayList2.add(Arrays.hashCode((boolean[])object));
                continue;
            }
            if (object instanceof long[]) {
                arrayList2.add(Arrays.hashCode((long[])object));
                continue;
            }
            if (object instanceof double[]) {
                arrayList2.add(Arrays.hashCode((double[])object));
                continue;
            }
            if (object instanceof byte[]) {
                arrayList2.add(Arrays.hashCode((byte[])object));
                continue;
            }
            if (object instanceof Object[]) {
                arrayList2.add(Arrays.hashCode((Object[])object));
                continue;
            }
            arrayList2.add(Objects.hashCode((Object[])new Object[]{object}));
        }
        return Objects.hashCode((Object[])arrayList2.toArray());
    }

    static final /* synthetic */ int zzb(String string, String string2) {
        if (string == null) {
            if (string2 == null) {
                return 0;
            }
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        return string.compareTo(string2);
    }

    @SafeParcelable.Reserved(value={1000})
    @SafeParcelable.Class(creator="MetadataCreator")
    public static final class zza
    extends AbstractSafeParcelable
    implements Indexable.Metadata {
        public static final Parcelable.Creator<zza> CREATOR = new zzw();
        @SafeParcelable.Field(id=1, getter="getWorksOffline")
        private final boolean zzeo;
        @SafeParcelable.Field(id=2, getter="getScore")
        private final int score;
        @SafeParcelable.Field(id=3, getter="getAccountEmail")
        private final String zzep;
        @SafeParcelable.Field(id=4, getter="getPropertyBundle")
        private final Bundle zzay;

        @SafeParcelable.Constructor
        public zza(@SafeParcelable.Param(id=1) boolean bl, @SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) Bundle bundle) {
            this.zzeo = bl;
            this.score = n;
            this.zzep = string;
            this.zzay = bundle == null ? new Bundle() : bundle;
        }

        public final Bundle zze() {
            return this.zzay;
        }

        public final void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            zza zza2 = this;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
            SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)1, (boolean)zza2.zzeo);
            SafeParcelWriter.writeInt((Parcel)parcel2, (int)2, (int)zza2.score);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)zza2.zzep, (boolean)false);
            SafeParcelWriter.writeBundle((Parcel)parcel2, (int)4, (Bundle)zza2.zzay, (boolean)false);
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder("worksOffline: ").append(this.zzeo).append(", score: ").append(this.score);
            if (!this.zzep.isEmpty()) {
                stringBuilder.append(", accountEmail: ").append(this.zzep);
            }
            if (this.zzay != null && !this.zzay.isEmpty()) {
                stringBuilder.append(", Properties { ");
                Thing.zza(this.zzay, stringBuilder);
                stringBuilder.append("}");
            }
            return stringBuilder.toString();
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof zza)) {
                return false;
            }
            zza zza2 = (zza)object;
            return Objects.equal((Object)this.zzeo, (Object)zza2.zzeo) && Objects.equal((Object)this.score, (Object)zza2.score) && Objects.equal((Object)this.zzep, (Object)zza2.zzep) && Thing.zza(this.zzay, zza2.zzay);
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.zzeo, this.score, this.zzep, Thing.zzb(this.zzay)});
        }
    }
}

