/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzbrn;
import com.google.android.gms.internal.zzbrs;
import com.google.android.gms.internal.zzbsp;
import com.google.android.gms.internal.zzbsq;
import com.google.android.gms.internal.zzbst;
import com.google.android.gms.internal.zzbth;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class zzbsl {
    private final Map<Type, zzbrn<?>> zzcmG;

    public zzbsl(Map<Type, zzbrn<?>> map) {
        this.zzcmG = map;
    }

    public <T> zzbsq<T> zzb(zzbth<T> zzbth2) {
        final Type type = zzbth2.zzacc();
        Class<T> clazz = zzbth2.zzacb();
        final zzbrn<?> zzbrn2 = this.zzcmG.get(type);
        if (zzbrn2 != null) {
            return new zzbsq<T>(){

                @Override
                public T zzabJ() {
                    return zzbrn2.zza(type);
                }
            };
        }
        final zzbrn<?> zzbrn3 = this.zzcmG.get(clazz);
        if (zzbrn3 != null) {
            return new zzbsq<T>(){

                @Override
                public T zzabJ() {
                    return zzbrn3.zza(type);
                }
            };
        }
        zzbsq<T> zzbsq2 = this.zzk(clazz);
        if (zzbsq2 != null) {
            return zzbsq2;
        }
        zzbsq<T> zzbsq3 = this.zzc(type, clazz);
        if (zzbsq3 != null) {
            return zzbsq3;
        }
        return this.zzd(type, clazz);
    }

    private <T> zzbsq<T> zzk(Class<? super T> clazz) {
        try {
            final Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return new zzbsq<T>(){

                @Override
                public T zzabJ() {
                    try {
                        return constructor.newInstance(null);
                    }
                    catch (InstantiationException instantiationException) {
                        String string = String.valueOf(constructor);
                        throw new RuntimeException(new StringBuilder(30 + String.valueOf(string).length()).append("Failed to invoke ").append(string).append(" with no args").toString(), instantiationException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        String string = String.valueOf(constructor);
                        throw new RuntimeException(new StringBuilder(30 + String.valueOf(string).length()).append("Failed to invoke ").append(string).append(" with no args").toString(), invocationTargetException.getTargetException());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new AssertionError((Object)illegalAccessException);
                    }
                }
            };
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private <T> zzbsq<T> zzc(final Type type, Class<? super T> clazz) {
        if (Collection.class.isAssignableFrom(clazz)) {
            if (SortedSet.class.isAssignableFrom(clazz)) {
                return new zzbsq<T>(){

                    @Override
                    public T zzabJ() {
                        return new TreeSet();
                    }
                };
            }
            if (EnumSet.class.isAssignableFrom(clazz)) {
                return new zzbsq<T>(){

                    @Override
                    public T zzabJ() {
                        if (type instanceof ParameterizedType) {
                            Type type2 = ((ParameterizedType)type).getActualTypeArguments()[0];
                            if (type2 instanceof Class) {
                                return EnumSet.noneOf((Class)type2);
                            }
                            String string = String.valueOf(type.toString());
                            throw new zzbrs(string.length() != 0 ? "Invalid EnumSet type: ".concat(string) : new String("Invalid EnumSet type: "));
                        }
                        String string = String.valueOf(type.toString());
                        throw new zzbrs(string.length() != 0 ? "Invalid EnumSet type: ".concat(string) : new String("Invalid EnumSet type: "));
                    }
                };
            }
            if (Set.class.isAssignableFrom(clazz)) {
                return new zzbsq<T>(){

                    @Override
                    public T zzabJ() {
                        return new LinkedHashSet();
                    }
                };
            }
            if (Queue.class.isAssignableFrom(clazz)) {
                return new zzbsq<T>(){

                    @Override
                    public T zzabJ() {
                        return new LinkedList();
                    }
                };
            }
            return new zzbsq<T>(){

                @Override
                public T zzabJ() {
                    return new ArrayList();
                }
            };
        }
        if (Map.class.isAssignableFrom(clazz)) {
            if (SortedMap.class.isAssignableFrom(clazz)) {
                return new zzbsq<T>(){

                    @Override
                    public T zzabJ() {
                        return new TreeMap();
                    }
                };
            }
            if (type instanceof ParameterizedType && !String.class.isAssignableFrom(zzbth.zzl(((ParameterizedType)type).getActualTypeArguments()[0]).zzacb())) {
                return new zzbsq<T>(){

                    @Override
                    public T zzabJ() {
                        return new LinkedHashMap();
                    }
                };
            }
            return new zzbsq<T>(){

                @Override
                public T zzabJ() {
                    return new zzbsp();
                }
            };
        }
        return null;
    }

    private <T> zzbsq<T> zzd(final Type type, final Class<? super T> clazz) {
        return new zzbsq<T>(){
            private final zzbst zzcnj = zzbst.zzabO();

            @Override
            public T zzabJ() {
                try {
                    Object t = this.zzcnj.zze(clazz);
                    return t;
                }
                catch (Exception exception) {
                    String string = String.valueOf(type);
                    throw new RuntimeException(new StringBuilder(116 + String.valueOf(string).length()).append("Unable to invoke no-args constructor for ").append(string).append(". ").append("Register an InstanceCreator with Gson for this type may fix this problem.").toString(), exception);
                }
            }
        };
    }

    public String toString() {
        return this.zzcmG.toString();
    }
}

