/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzabs;
import com.google.android.gms.internal.zzabv;
import com.google.android.gms.internal.zzblt;
import com.google.android.gms.internal.zzblv;
import com.google.android.gms.internal.zzbly;
import com.google.android.gms.internal.zzbma;
import com.google.android.gms.internal.zzbmc;
import com.google.android.gms.internal.zzbmd;
import com.google.android.gms.internal.zzbmj;
import com.google.android.gms.internal.zzbmp;
import com.google.android.gms.internal.zzbmx;
import com.google.android.gms.internal.zzbmz;
import com.google.android.gms.internal.zzbna;
import com.google.android.gms.internal.zzbnb;
import com.google.android.gms.internal.zzbnc;
import com.google.android.gms.internal.zzbnd;
import com.google.android.gms.internal.zzbnf;
import com.google.android.gms.internal.zzbng;
import com.google.android.gms.internal.zzbnh;
import com.google.android.gms.internal.zzbni;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import java.util.ArrayList;
import java.util.List;

public class zzbls
extends com.google.android.gms.common.api.zzc<zzbma.zza> {
    zzbls(@NonNull Context context, @NonNull zzbma.zza zza2) {
        super(context, zzbma.zzbYk, (Api.ApiOptions)zza2, (zzabs)new com.google.firebase.zza());
    }

    public Task<GetTokenResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzbmz zzbmz2) {
        return this.doRead(this.zza(new zzg(string).zze(firebaseApp).zze(firebaseUser).zzad(zzbmz2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull zzbmz zzbmz2) {
        return this.doWrite(this.zza(new zzr(string).zze(firebaseApp).zzad(zzbmz2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull AuthCredential authCredential, @NonNull zzbmz zzbmz2) {
        return this.doWrite(this.zza(new zzq(authCredential).zze(firebaseApp).zzad(zzbmz2)));
    }

    public Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential, @NonNull zzbmz zzbmz2) {
        return this.doWrite(this.zza(new zzk(authCredential).zze(firebaseApp).zze(firebaseUser).zzad(zzbmz2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull zzbmz zzbmz2) {
        return this.doWrite(this.zza(new zzp().zze(firebaseApp).zzad(zzbmz2)));
    }

    public Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest, @NonNull zzbmz zzbmz2) {
        return this.doWrite(this.zza(new zzx(userProfileChangeRequest).zze(firebaseApp).zze(firebaseUser).zzad(zzbmz2)));
    }

    public Task<Void> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzbmz zzbmz2) {
        return this.doWrite(this.zza(new zzv(string).zze(firebaseApp).zze(firebaseUser).zzad(zzbmz2)));
    }

    public Task<Void> zzc(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzbmz zzbmz2) {
        return this.doWrite(this.zza(new zzw(string).zze(firebaseApp).zze(firebaseUser).zzad(zzbmz2)));
    }

    public Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull String string2, @NonNull zzbmz zzbmz2) {
        return this.doWrite(this.zza(new zzd(string, string2).zze(firebaseApp).zzad(zzbmz2)));
    }

    public Task<AuthResult> zzb(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull String string2, @NonNull zzbmz zzbmz2) {
        return this.doWrite(this.zza(new zzs(string, string2).zze(firebaseApp).zzad(zzbmz2)));
    }

    public Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull String string2, @NonNull zzbmz zzbmz2) {
        return this.doWrite(this.zza(new zzl(string, string2).zze(firebaseApp).zze(firebaseUser).zzad(zzbmz2)));
    }

    public Task<ProviderQueryResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.doRead(this.zza(new zzf(string).zze(firebaseApp)));
    }

    public Task<Void> zzb(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.doWrite(this.zza(new zzo(string).zze(firebaseApp)));
    }

    public Task<Void> zzc(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.doWrite(this.zza(new zzn(string).zze(firebaseApp)));
    }

    public Task<ActionCodeResult> zzd(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.doWrite(this.zza(new zzb(string).zze(firebaseApp)));
    }

    public Task<Void> zze(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.doWrite(this.zza(new zza(string).zze(firebaseApp)));
    }

    public Task<String> zzf(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.doWrite(this.zza(new zzy(string).zze(firebaseApp)));
    }

    public Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull String string2) {
        return this.doWrite(this.zza(new zzc(string, string2).zze(firebaseApp)));
    }

    public Task<AuthResult> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential, @NonNull zzbmz zzbmz2) {
        zzac.zzw((Object)firebaseApp);
        zzac.zzw((Object)authCredential);
        zzac.zzw((Object)firebaseUser);
        zzac.zzw((Object)zzbmz2);
        if (EmailAuthCredential.class.isAssignableFrom(authCredential.getClass())) {
            return this.zza(firebaseApp, (EmailAuthCredential)authCredential, firebaseUser, zzbmz2);
        }
        return this.zza(firebaseApp, authCredential, firebaseUser, zzbmz2);
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull EmailAuthCredential emailAuthCredential, @NonNull FirebaseUser firebaseUser, @NonNull zzbmz zzbmz2) {
        return this.doWrite(this.zza(new zzh(emailAuthCredential).zze(firebaseApp).zze(firebaseUser).zzad(zzbmz2)));
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull AuthCredential authCredential, @NonNull FirebaseUser firebaseUser, @NonNull zzbmz zzbmz2) {
        zzac.zzw((Object)firebaseApp);
        zzac.zzw((Object)authCredential);
        zzac.zzw((Object)firebaseUser);
        zzac.zzw((Object)zzbmz2);
        List<String> list = firebaseUser.getProviders();
        if (list != null && list.contains(authCredential.getProvider())) {
            return Tasks.forException((Exception)zzblv.zzce(new Status(17015)));
        }
        return this.doWrite(this.zza(new zzi(authCredential).zze(firebaseApp).zze(firebaseUser).zzad(zzbmz2)));
    }

    public Task<AuthResult> zzd(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzbmz zzbmz2) {
        zzac.zzw((Object)firebaseApp);
        zzac.zzdr((String)string);
        zzac.zzw((Object)firebaseUser);
        zzac.zzw((Object)zzbmz2);
        List<String> list = firebaseUser.getProviders();
        if (list != null && !list.contains(string) || firebaseUser.isAnonymous()) {
            return Tasks.forException((Exception)zzblv.zzce(new Status(17016, string)));
        }
        switch (string) {
            case "password": {
                return this.zza(firebaseApp, firebaseUser, zzbmz2);
            }
        }
        return this.zza(firebaseApp, string, firebaseUser, zzbmz2);
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull zzbmz zzbmz2) {
        return this.doWrite(this.zza(new zzt().zze(firebaseApp).zze(firebaseUser).zzad(zzbmz2)));
    }

    @NonNull
    private Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull FirebaseUser firebaseUser, @NonNull zzbmz zzbmz2) {
        return this.doWrite(this.zza(new zzu(string).zze(firebaseApp).zze(firebaseUser).zzad(zzbmz2)));
    }

    @NonNull
    public Task<Void> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull zzbmz zzbmz2) {
        return this.doRead(this.zza(new zzm().zze(firebaseApp).zze(firebaseUser).zzad(zzbmz2)));
    }

    @NonNull
    public Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull zzbni zzbni2) {
        return this.doWrite(this.zza(new zze().zze(firebaseUser).zzad(zzbni2)));
    }

    @NonNull
    private static zzbnf zza(@NonNull FirebaseApp firebaseApp, @NonNull zzbmj zzbmj2) {
        return zzbls.zza(firebaseApp, zzbmj2, false);
    }

    @NonNull
    private static zzbnf zza(@NonNull FirebaseApp firebaseApp, @NonNull zzbmj zzbmj2, boolean bl) {
        zzac.zzw((Object)firebaseApp);
        zzac.zzw((Object)((Object)zzbmj2));
        ArrayList<zzbnd> arrayList = new ArrayList<zzbnd>();
        zzbnd zzbnd2 = new zzbnd(zzbmj2, "firebase");
        arrayList.add(zzbnd2);
        List<zzbmp> list = zzbmj2.zzVY();
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add(new zzbnd(list.get(i)));
            }
        }
        zzbnf zzbnf2 = new zzbnf(firebaseApp, arrayList);
        zzbnf2.zzaY(bl);
        return zzbnf2;
    }

    private <ResultT, CallbackT> zzj<ResultT, CallbackT> zza(zzbmd<ResultT, CallbackT> zzbmd2) {
        return new zzj<ResultT, CallbackT>(zzbmd2);
    }

    private static class zzj<ResultT, CallbackT>
    extends zzabv<zzblt, ResultT>
    implements zzbmc<ResultT> {
        private zzbmd<ResultT, CallbackT> zzbYd;
        private TaskCompletionSource<ResultT> zzazE;

        public zzj(zzbmd<ResultT, CallbackT> zzbmd2) {
            this.zzbYd = zzbmd2;
            this.zzbYd.zza(this);
        }

        protected void zza(zzblt zzblt2, TaskCompletionSource<ResultT> taskCompletionSource) throws RemoteException {
            this.zzazE = taskCompletionSource;
            this.zzbYd.zza(zzblt2.zzVO());
        }

        @Override
        public final void zza(ResultT ResultT, Status status) {
            zzac.zzb(this.zzazE, (Object)"doExecute must be called before onComplete");
            if (status != null) {
                this.zzazE.setException((Exception)zzblv.zzce(status));
            } else {
                this.zzazE.setResult(ResultT);
            }
        }
    }

    static final class zze
    extends zzbmd<Void, zzbni> {
        public zze() {
            super(5);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYo.zzg(this.zzbYn.zzVG(), this.zzbYm);
        }

        @Override
        public void zzVN() {
            ((zzbni)this.zzbYp).zzVD();
            this.zzae(null);
        }
    }

    static final class zzm
    extends zzbmd<Void, zzbmz> {
        public zzm() {
            super(2);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYo.zzf(this.zzbYn.zzVG(), this.zzbYm);
        }

        @Override
        public void zzVN() {
            zzbnf zzbnf2 = zzbls.zza(this.zzbXJ, this.zzbYs, this.zzbYn.isAnonymous());
            ((zzbmz)this.zzbYp).zza(this.zzbYr, zzbnf2);
            this.zzae(null);
        }
    }

    static final class zzu
    extends zzbmd<AuthResult, zzbmz> {
        @NonNull
        private String zzbYe;

        public zzu(@NonNull String string) {
            super(2);
            this.zzbYe = zzac.zzh((String)string, (Object)"provider cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYo.zze(this.zzbYe, this.zzbYn.zzVG(), this.zzbYm);
        }

        @Override
        public void zzVN() {
            zzbnf zzbnf2 = zzbls.zza(this.zzbXJ, this.zzbYs);
            ((zzbmz)this.zzbYp).zza(this.zzbYr, zzbnf2);
            this.zzae(new zzbnc(zzbnf2));
        }
    }

    static final class zzt
    extends zzbmd<AuthResult, zzbmz> {
        public zzt() {
            super(2);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYo.zze(this.zzbYn.zzVG(), this.zzbYm);
        }

        @Override
        public void zzVN() {
            zzbnf zzbnf2 = zzbls.zza(this.zzbXJ, this.zzbYs);
            ((zzbmz)this.zzbYp).zza(this.zzbYr, zzbnf2);
            this.zzae(new zzbnc(zzbnf2));
        }
    }

    static final class zzi
    extends zzbmd<AuthResult, zzbmz> {
        @NonNull
        private final zzbmx zzbYc;

        public zzi(@NonNull AuthCredential authCredential) {
            super(2);
            zzac.zzb((Object)authCredential, (Object)"credential cannot be null");
            this.zzbYc = zzbna.zza(authCredential);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYo.zza(this.zzbYn.zzVG(), this.zzbYc, (zzbly)this.zzbYm);
        }

        @Override
        public void zzVN() {
            zzbnf zzbnf2 = zzbls.zza(this.zzbXJ, this.zzbYs);
            ((zzbmz)this.zzbYp).zza(this.zzbYr, zzbnf2);
            this.zzae(new zzbnc(zzbnf2));
        }
    }

    static final class zzh
    extends zzbmd<AuthResult, zzbmz> {
        @NonNull
        private final EmailAuthCredential zzbYb;

        public zzh(@NonNull EmailAuthCredential emailAuthCredential) {
            super(2);
            this.zzbYb = (EmailAuthCredential)zzac.zzb((Object)emailAuthCredential, (Object)"credential cannot be null");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYo.zza(this.zzbYb.getEmail(), this.zzbYb.getPassword(), this.zzbYn.zzVG(), this.zzbYm);
        }

        @Override
        public void zzVN() {
            zzbnf zzbnf2 = zzbls.zza(this.zzbXJ, this.zzbYs);
            ((zzbmz)this.zzbYp).zza(this.zzbYr, zzbnf2);
            this.zzae(new zzbnc(zzbnf2));
        }
    }

    static final class zzc
    extends zzbmd<Void, zzbmz> {
        @NonNull
        private final String zzaZU;
        @NonNull
        private final String zzbXZ;

        public zzc(@NonNull String string, @NonNull String string2) {
            super(4);
            this.zzaZU = zzac.zzh((String)string, (Object)"code cannot be null or empty");
            this.zzbXZ = zzac.zzh((String)string2, (Object)"new password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYo.zzf(this.zzaZU, this.zzbXZ, this.zzbYm);
        }

        @Override
        public void zzVN() {
            this.zzVT();
        }
    }

    static final class zzy
    extends zzbmd<String, zzbmz> {
        @NonNull
        private final String zzaZU;

        public zzy(@NonNull String string) {
            super(4);
            this.zzaZU = zzac.zzh((String)string, (Object)"code cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYo.zzi(this.zzaZU, this.zzbYm);
        }

        @Override
        public void zzVN() {
            zzbnb zzbnb2 = new zzbnb(this.zzbYu);
            if (0 != zzbnb2.getOperation()) {
                this.zzcf(new Status(17499));
            } else {
                this.zzae(this.zzbYu.getEmail());
            }
        }
    }

    static final class zza
    extends zzbmd<Void, zzbmz> {
        @NonNull
        private final String zzaZU;

        public zza(@NonNull String string) {
            super(7);
            this.zzaZU = zzac.zzh((String)string, (Object)"code cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYo.zzj(this.zzaZU, this.zzbYm);
        }

        @Override
        public void zzVN() {
            this.zzVT();
        }
    }

    static final class zzb
    extends zzbmd<ActionCodeResult, zzbmz> {
        @NonNull
        private final String zzaZU;

        public zzb(@NonNull String string) {
            super(4);
            this.zzaZU = zzac.zzh((String)string, (Object)"code cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYo.zzi(this.zzaZU, this.zzbYm);
        }

        @Override
        public void zzVN() {
            this.zzae(new zzbnb(this.zzbYu));
        }
    }

    static final class zzn
    extends zzbmd<Void, zzbmz> {
        @NonNull
        private String zzaiJ;

        public zzn(@NonNull String string) {
            super(6);
            this.zzaiJ = zzac.zzh((String)string, (Object)"token cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYo.zzh(this.zzaiJ, this.zzbYm);
        }

        @Override
        public void zzVN() {
            this.zzVT();
        }
    }

    static final class zzo
    extends zzbmd<Void, zzbmz> {
        @NonNull
        private String zzaka;

        public zzo(@NonNull String string) {
            super(4);
            this.zzaka = zzac.zzh((String)string, (Object)"email cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYo.zzd(this.zzaka, this.zzbYm);
        }

        @Override
        public void zzVN() {
            this.zzVT();
        }
    }

    static final class zzf
    extends zzbmd<ProviderQueryResult, zzbmz> {
        @NonNull
        private final String zzaka;

        public zzf(@NonNull String string) {
            super(3);
            this.zzaka = zzac.zzh((String)string, (Object)"email cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYo.zzc(this.zzaka, this.zzbYm);
        }

        @Override
        public void zzVN() {
            this.zzae(new zzbng(this.zzbYt));
        }
    }

    static final class zzl
    extends zzbmd<Void, zzbmz> {
        @NonNull
        private final String zzaka;
        @NonNull
        private final String zzajh;

        public zzl(@NonNull String string, @NonNull String string2) {
            super(2);
            this.zzaka = zzac.zzh((String)string, (Object)"email cannot be null or empty");
            this.zzajh = zzac.zzh((String)string2, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYo.zzd(this.zzaka, this.zzajh, this.zzbYm);
        }

        @Override
        public void zzVN() {
            zzbnf zzbnf2 = zzbls.zza(this.zzbXJ, this.zzbYs);
            if (this.zzbYn.getUid().equalsIgnoreCase(zzbnf2.getUid())) {
                ((zzbmz)this.zzbYp).zza(this.zzbYr, zzbnf2);
                this.zzVT();
            } else {
                this.zzcf(zzbnh.zzWq());
            }
        }
    }

    static final class zzs
    extends zzbmd<AuthResult, zzbmz> {
        @NonNull
        private String zzaka;
        @NonNull
        private String zzajh;

        public zzs(String string, String string2) {
            super(2);
            this.zzaka = zzac.zzh((String)string, (Object)"email cannot be null or empty");
            this.zzajh = zzac.zzh((String)string2, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYo.zzd(this.zzaka, this.zzajh, this.zzbYm);
        }

        @Override
        public void zzVN() {
            zzbnf zzbnf2 = zzbls.zza(this.zzbXJ, this.zzbYs);
            ((zzbmz)this.zzbYp).zza(this.zzbYr, zzbnf2);
            this.zzae(new zzbnc(zzbnf2));
        }
    }

    static final class zzd
    extends zzbmd<AuthResult, zzbmz> {
        @NonNull
        private String zzaka;
        @NonNull
        private String zzajh;

        public zzd(@NonNull String string, @NonNull String string2) {
            super(2);
            this.zzaka = zzac.zzh((String)string, (Object)"email cannot be null or empty");
            this.zzajh = zzac.zzh((String)string2, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYo.zzc(this.zzaka, this.zzajh, this.zzbYm);
        }

        @Override
        public void zzVN() {
            zzbnf zzbnf2 = zzbls.zza(this.zzbXJ, this.zzbYs);
            ((zzbmz)this.zzbYp).zza(this.zzbYr, zzbnf2);
            this.zzae(new zzbnc(zzbnf2));
        }
    }

    static final class zzw
    extends zzbmd<Void, zzbmz> {
        @NonNull
        private final String zzajh;

        public zzw(@NonNull String string) {
            super(2);
            this.zzajh = zzac.zzh((String)string, (Object)"password cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYo.zzb(this.zzbYn.zzVG(), this.zzajh, this.zzbYm);
        }

        @Override
        public void zzVN() {
            ((zzbmz)this.zzbYp).zza(this.zzbYr, zzbls.zza(this.zzbXJ, this.zzbYs));
            this.zzVT();
        }
    }

    static final class zzv
    extends zzbmd<Void, zzbmz> {
        @NonNull
        private final String zzaka;

        public zzv(String string) {
            super(2);
            this.zzaka = zzac.zzh((String)string, (Object)"email cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYo.zza(this.zzbYn.zzVG(), this.zzaka, (zzbly)this.zzbYm);
        }

        @Override
        public void zzVN() {
            ((zzbmz)this.zzbYp).zza(this.zzbYr, zzbls.zza(this.zzbXJ, this.zzbYs));
            this.zzVT();
        }
    }

    static final class zzx
    extends zzbmd<Void, zzbmz> {
        @NonNull
        private final UserProfileChangeRequest zzbYf;

        public zzx(UserProfileChangeRequest userProfileChangeRequest) {
            super(2);
            this.zzbYf = (UserProfileChangeRequest)((Object)zzac.zzb((Object)((Object)userProfileChangeRequest), (Object)"request cannot be null"));
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYo.zza(this.zzbYn.zzVG(), this.zzbYf, (zzbly)this.zzbYm);
        }

        @Override
        public void zzVN() {
            ((zzbmz)this.zzbYp).zza(this.zzbYr, zzbls.zza(this.zzbXJ, this.zzbYs));
            this.zzVT();
        }
    }

    static final class zzp
    extends zzbmd<AuthResult, zzbmz> {
        public zzp() {
            super(2);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYo.zza(this.zzbYm);
        }

        @Override
        public void zzVN() {
            zzbnf zzbnf2 = zzbls.zza(this.zzbXJ, this.zzbYs, true);
            ((zzbmz)this.zzbYp).zza(this.zzbYr, zzbnf2);
            this.zzae(new zzbnc(zzbnf2));
        }
    }

    static final class zzk
    extends zzbmd<Void, zzbmz> {
        @NonNull
        private final zzbmx zzbYc;

        public zzk(@NonNull AuthCredential authCredential) {
            super(2);
            zzac.zzb((Object)authCredential, (Object)"credential cannot be null");
            this.zzbYc = zzbna.zza(authCredential);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYo.zza(this.zzbYc, (zzbly)this.zzbYm);
        }

        @Override
        public void zzVN() {
            zzbnf zzbnf2 = zzbls.zza(this.zzbXJ, this.zzbYs);
            if (this.zzbYn.getUid().equalsIgnoreCase(zzbnf2.getUid())) {
                ((zzbmz)this.zzbYp).zza(this.zzbYr, zzbnf2);
                this.zzVT();
            } else {
                this.zzcf(zzbnh.zzWq());
            }
        }
    }

    static final class zzq
    extends zzbmd<AuthResult, zzbmz> {
        @NonNull
        private final zzbmx zzbYc;

        public zzq(@NonNull AuthCredential authCredential) {
            super(2);
            zzac.zzb((Object)authCredential, (Object)"credential cannot be null");
            this.zzbYc = zzbna.zza(authCredential);
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYo.zza(this.zzbYc, (zzbly)this.zzbYm);
        }

        @Override
        public void zzVN() {
            zzbnf zzbnf2 = zzbls.zza(this.zzbXJ, this.zzbYs);
            ((zzbmz)this.zzbYp).zza(this.zzbYr, zzbnf2);
            this.zzae(new zzbnc(zzbnf2));
        }
    }

    static final class zzr
    extends zzbmd<AuthResult, zzbmz> {
        @NonNull
        private final String zzaiJ;

        public zzr(@NonNull String string) {
            super(2);
            this.zzaiJ = zzac.zzh((String)string, (Object)"token cannot be null or empty");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYo.zzb(this.zzaiJ, this.zzbYm);
        }

        @Override
        public void zzVN() {
            zzbnf zzbnf2 = zzbls.zza(this.zzbXJ, this.zzbYs);
            ((zzbmz)this.zzbYp).zza(this.zzbYr, zzbnf2);
            this.zzae(new zzbnc(zzbnf2));
        }
    }

    static final class zzg
    extends zzbmd<GetTokenResult, zzbmz> {
        @NonNull
        private final String zzbYa;

        public zzg(@NonNull String string) {
            super(1);
            this.zzbYa = zzac.zzh((String)string, (Object)"refresh token cannot be null");
        }

        @Override
        public void dispatch() throws RemoteException {
            this.zzbYo.zza(this.zzbYa, (zzbly)this.zzbYm);
        }

        @Override
        public void zzVN() {
            this.zzbYr.zziy(this.zzbYa);
            ((zzbmz)this.zzbYp).zza(this.zzbYr, this.zzbYn);
            this.zzae(new GetTokenResult(this.zzbYr.getAccessToken()));
        }
    }
}

