/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzbuo;
import com.google.android.gms.internal.zzbup;
import com.google.android.gms.internal.zzbuq;
import com.google.android.gms.internal.zzbuu;
import com.google.android.gms.internal.zzbuw;
import com.google.android.gms.internal.zzbux;
import com.google.android.gms.internal.zzbuy;
import com.google.android.gms.internal.zzbuz;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class zzbuf
implements zzbup<Date>,
zzbuy<Date> {
    private final DateFormat zzcoP;
    private final DateFormat zzcoQ;
    private final DateFormat zzcoR;

    zzbuf() {
        this(DateFormat.getDateTimeInstance(2, 2, Locale.US), DateFormat.getDateTimeInstance(2, 2));
    }

    zzbuf(String string) {
        this(new SimpleDateFormat(string, Locale.US), new SimpleDateFormat(string));
    }

    public zzbuf(int n, int n2) {
        this(DateFormat.getDateTimeInstance(n, n2, Locale.US), DateFormat.getDateTimeInstance(n, n2));
    }

    zzbuf(DateFormat dateFormat, DateFormat dateFormat2) {
        this.zzcoP = dateFormat;
        this.zzcoQ = dateFormat2;
        this.zzcoR = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        this.zzcoR.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzbuq zza(Date date, Type type, zzbux zzbux2) {
        DateFormat dateFormat = this.zzcoQ;
        synchronized (dateFormat) {
            String string = this.zzcoP.format(date);
            return new zzbuw(string);
        }
    }

    public Date zza(zzbuq zzbuq2, Type type, zzbuo zzbuo2) throws zzbuu {
        if (!(zzbuq2 instanceof zzbuw)) {
            throw new zzbuu("The date should be a string value");
        }
        Date date = this.zza(zzbuq2);
        if (type == Date.class) {
            return date;
        }
        if (type == Timestamp.class) {
            return new Timestamp(date.getTime());
        }
        if (type == java.sql.Date.class) {
            return new java.sql.Date(date.getTime());
        }
        String string = String.valueOf(this.getClass());
        String string2 = String.valueOf(type);
        throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" cannot deserialize to ").append(string2).toString());
    }

    private Date zza(zzbuq zzbuq2) {
        DateFormat dateFormat = this.zzcoQ;
        synchronized (dateFormat) {
            try {
                return this.zzcoQ.parse(zzbuq2.zzadj());
            }
            catch (ParseException parseException) {
                try {
                    return this.zzcoP.parse(zzbuq2.zzadj());
                }
                catch (ParseException parseException2) {
                    try {
                        return this.zzcoR.parse(zzbuq2.zzadj());
                    }
                    catch (ParseException parseException3) {
                        throw new zzbuz(zzbuq2.zzadj(), parseException3);
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(zzbuf.class.getSimpleName());
        stringBuilder.append('(').append(this.zzcoQ.getClass().getSimpleName()).append(')');
        return stringBuilder.toString();
    }

    @Override
    public /* synthetic */ Object zzb(zzbuq zzbuq2, Type type, zzbuo zzbuo2) throws zzbuu {
        return this.zza(zzbuq2, type, zzbuo2);
    }
}

