/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzbls;
import com.google.android.gms.internal.zzblv;
import com.google.android.gms.internal.zzblx;
import com.google.android.gms.internal.zzbma;
import com.google.android.gms.internal.zzbmn;
import com.google.android.gms.internal.zzbmz;
import com.google.android.gms.internal.zzbnc;
import com.google.android.gms.internal.zzbne;
import com.google.android.gms.internal.zzbnf;
import com.google.android.gms.internal.zzbni;
import com.google.android.gms.internal.zzbnj;
import com.google.android.gms.internal.zzbnk;
import com.google.android.gms.internal.zzbti;
import com.google.android.gms.internal.zzbtj;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class FirebaseAuth
implements zzbti {
    private FirebaseApp zzbXF;
    private List<AuthStateListener> mListeners;
    private zzbls zzbXG;
    private FirebaseUser zzbXH;
    private zzbnj zzbXI;
    private zzbnk zzbXJ;
    private static Map<String, FirebaseAuth> zzbhH = new ArrayMap();
    private static FirebaseAuth zzbXK;

    public static FirebaseAuth getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        return FirebaseAuth.zzc(firebaseApp);
    }

    @Keep
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return FirebaseAuth.zzc(firebaseApp);
    }

    public FirebaseAuth(FirebaseApp firebaseApp) {
        this(firebaseApp, FirebaseAuth.zzb(firebaseApp), new zzbnj(firebaseApp.getApplicationContext(), firebaseApp.zzUW(), zzblx.zzVQ()));
    }

    FirebaseAuth(FirebaseApp firebaseApp, zzbls zzbls2, zzbnj zzbnj2) {
        this.zzbXF = (FirebaseApp)zzac.zzw((Object)firebaseApp);
        this.zzbXG = (zzbls)((Object)zzac.zzw((Object)((Object)zzbls2)));
        this.zzbXI = (zzbnj)zzac.zzw((Object)zzbnj2);
        this.mListeners = new CopyOnWriteArrayList<AuthStateListener>();
        this.zzbXJ = zzbnk.zzWu();
        this.zzVD();
    }

    static zzbls zzb(FirebaseApp firebaseApp) {
        zzbma.zza zza2 = new zzbma.zza.zza(firebaseApp.getOptions().getApiKey()).zzVT();
        return zzbma.zza(firebaseApp.getApplicationContext(), zza2);
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.zzbXH;
    }

    public void zza(@NonNull FirebaseUser firebaseUser, boolean bl, boolean bl2) {
        zzac.zzw((Object)firebaseUser);
        if (this.zzbXH == null) {
            this.zzbXH = firebaseUser;
        } else {
            this.zzbXH.zzaY(firebaseUser.isAnonymous());
            this.zzbXH.zzU(firebaseUser.getProviderData());
        }
        if (bl) {
            this.zzbXI.zzf(this.zzbXH);
        }
        if (bl2) {
            this.zza(this.zzbXH);
        }
    }

    public void zza(@NonNull FirebaseUser firebaseUser, @NonNull zzbmn zzbmn2, boolean bl) {
        boolean bl2;
        zzac.zzw((Object)firebaseUser);
        zzac.zzw((Object)((Object)zzbmn2));
        if (this.zzbXH == null) {
            bl2 = true;
        } else {
            String string;
            zzbmn zzbmn3 = this.zzbXH.zzVG();
            String string2 = zzbmn3.getAccessToken();
            boolean bl3 = !string2.equals(string = zzbmn2.getAccessToken());
            boolean bl4 = this.zzbXH.getUid().equals(firebaseUser.getUid());
            bl2 = !bl4 || bl3;
        }
        this.zza(firebaseUser, bl, false);
        if (bl2) {
            if (this.zzbXH != null) {
                this.zzbXH.zza(zzbmn2);
            }
            this.zza(this.zzbXH);
        }
        if (bl) {
            this.zzbXI.zza(firebaseUser, zzbmn2);
        }
    }

    public void zzVC() {
        if (this.zzbXH != null) {
            this.zzbXI.zzh(this.zzbXH);
            this.zzbXH = null;
        }
        this.zzbXI.zzWt();
        this.zza(null);
    }

    private static FirebaseAuth zzc(@NonNull FirebaseApp firebaseApp) {
        return FirebaseAuth.zzd(firebaseApp);
    }

    private static synchronized FirebaseAuth zzd(@NonNull FirebaseApp firebaseApp) {
        FirebaseAuth firebaseAuth = zzbhH.get(firebaseApp.zzUW());
        if (firebaseAuth == null) {
            firebaseAuth = new zzbne(firebaseApp);
            firebaseApp.zza((zzbti)firebaseAuth);
            if (zzbXK == null) {
                zzbXK = firebaseAuth;
            }
            zzbhH.put(firebaseApp.zzUW(), firebaseAuth);
            return firebaseAuth;
        }
        return firebaseAuth;
    }

    public void addAuthStateListener(final @NonNull AuthStateListener authStateListener) {
        this.mListeners.add(authStateListener);
        this.zzbXJ.execute(new Runnable(){

            @Override
            public void run() {
                authStateListener.onAuthStateChanged(FirebaseAuth.this);
            }
        });
    }

    public void removeAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.mListeners.remove(authStateListener);
    }

    public void zza(@Nullable FirebaseUser firebaseUser) {
        String string;
        if (firebaseUser != null) {
            string = String.valueOf(firebaseUser.getUid());
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(36 + String.valueOf(string).length()).append("Notifying listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying listeners about a sign-out event.");
        }
        string = firebaseUser != null ? firebaseUser.zzVI() : null;
        final zzbtj zzbtj2 = new zzbtj(string);
        this.zzbXJ.execute(new Runnable(){

            @Override
            public void run() {
                FirebaseAuth.this.zzbXF.zza(zzbtj2);
                for (AuthStateListener authStateListener : FirebaseAuth.this.mListeners) {
                    authStateListener.onAuthStateChanged(FirebaseAuth.this);
                }
            }
        });
    }

    @NonNull
    public Task<GetTokenResult> zzaX(boolean bl) {
        return this.zza(this.zzbXH, bl);
    }

    @NonNull
    public Task<GetTokenResult> zza(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            return Tasks.forException((Exception)zzblv.zzce(new Status(17495)));
        }
        zzbmn zzbmn2 = this.zzbXH.zzVG();
        if (zzbmn2.isValid() && !bl) {
            return Tasks.forResult((Object)new GetTokenResult(zzbmn2.getAccessToken()));
        }
        return this.zzbXG.zza(this.zzbXF, firebaseUser, zzbmn2.zzWc(), new zzbmz(){

            @Override
            public void zza(@NonNull zzbmn zzbmn2, @NonNull FirebaseUser firebaseUser) {
                FirebaseAuth.this.zza(firebaseUser, zzbmn2, true);
            }
        });
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential authCredential) {
        zzac.zzw((Object)authCredential);
        if (EmailAuthCredential.class.isAssignableFrom(authCredential.getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzbXG.zzb(this.zzbXF, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzbmz)new zza());
        }
        return this.zzbXG.zza(this.zzbXF, authCredential, (zzbmz)new zza());
    }

    @NonNull
    public Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzac.zzw((Object)firebaseUser);
        zzac.zzw((Object)authCredential);
        if (EmailAuthCredential.class.isAssignableFrom(authCredential.getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzbXG.zza(this.zzbXF, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), new zza());
        }
        return this.zzbXG.zza(this.zzbXF, firebaseUser, authCredential, (zzbmz)new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String string) {
        zzac.zzdr((String)string);
        return this.zzbXG.zza(this.zzbXF, string, (zzbmz)new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzac.zzdr((String)string);
        zzac.zzdr((String)string2);
        return this.zzbXG.zzb(this.zzbXF, string, string2, (zzbmz)new zza());
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        if (this.zzbXH != null && this.zzbXH.isAnonymous()) {
            zzbnf zzbnf2 = (zzbnf)this.zzbXH;
            zzbnc zzbnc2 = new zzbnc(zzbnf2);
            return Tasks.forResult((Object)zzbnc2);
        }
        return this.zzbXG.zza(this.zzbXF, new zza());
    }

    @NonNull
    public Task<Void> zzb(@NonNull FirebaseUser firebaseUser) {
        zzac.zzw((Object)firebaseUser);
        return this.zzbXG.zzb(this.zzbXF, firebaseUser, new zza());
    }

    @NonNull
    public Task<AuthResult> zzb(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzac.zzw((Object)authCredential);
        zzac.zzw((Object)firebaseUser);
        return this.zzbXG.zzb(this.zzbXF, firebaseUser, authCredential, (zzbmz)new zza());
    }

    @NonNull
    public Task<AuthResult> zza(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzac.zzdr((String)string);
        zzac.zzw((Object)firebaseUser);
        return this.zzbXG.zzd(this.zzbXF, firebaseUser, string, new zza());
    }

    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzac.zzdr((String)string);
        zzac.zzdr((String)string2);
        return this.zzbXG.zza(this.zzbXF, string, string2, (zzbmz)new zza());
    }

    @NonNull
    public Task<ProviderQueryResult> fetchProvidersForEmail(@NonNull String string) {
        zzac.zzdr((String)string);
        return this.zzbXG.zza(this.zzbXF, string);
    }

    @NonNull
    public Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        zzac.zzw((Object)firebaseUser);
        zzac.zzw((Object)((Object)userProfileChangeRequest));
        return this.zzbXG.zza(this.zzbXF, firebaseUser, userProfileChangeRequest, (zzbmz)new zza());
    }

    @NonNull
    public Task<Void> zzb(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzac.zzw((Object)firebaseUser);
        zzac.zzdr((String)string);
        return this.zzbXG.zzb(this.zzbXF, firebaseUser, string, (zzbmz)new zza());
    }

    @NonNull
    public Task<Void> zzc(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzac.zzw((Object)firebaseUser);
        zzac.zzdr((String)string);
        return this.zzbXG.zzc(this.zzbXF, firebaseUser, string, new zza());
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string) {
        zzac.zzdr((String)string);
        return this.zzbXG.zzb(this.zzbXF, string);
    }

    @NonNull
    public Task<Void> zziw(@NonNull String string) {
        zzac.zzdr((String)string);
        return this.zzbXG.zzc(this.zzbXF, string);
    }

    @NonNull
    public Task<ActionCodeResult> checkActionCode(@NonNull String string) {
        zzac.zzdr((String)string);
        return this.zzbXG.zzd(this.zzbXF, string);
    }

    @NonNull
    public Task<Void> applyActionCode(@NonNull String string) {
        zzac.zzdr((String)string);
        return this.zzbXG.zze(this.zzbXF, string);
    }

    @NonNull
    public Task<String> verifyPasswordResetCode(@NonNull String string) {
        zzac.zzdr((String)string);
        return this.zzbXG.zzf(this.zzbXF, string);
    }

    @NonNull
    public Task<Void> confirmPasswordReset(@NonNull String string, @NonNull String string2) {
        zzac.zzdr((String)string);
        zzac.zzdr((String)string2);
        return this.zzbXG.zza(this.zzbXF, string, string2);
    }

    @NonNull
    public Task<Void> zzc(final @NonNull FirebaseUser firebaseUser) {
        zzac.zzw((Object)firebaseUser);
        return this.zzbXG.zza(firebaseUser, new zzbni(){

            @Override
            public void zzVE() {
                if (FirebaseAuth.this.zzbXH.getUid().equalsIgnoreCase(firebaseUser.getUid())) {
                    FirebaseAuth.this.zzVC();
                }
            }
        });
    }

    public void signOut() {
        this.zzVC();
    }

    protected void zzVD() {
        zzbmn zzbmn2;
        this.zzbXH = this.zzbXI.zzWs();
        if (this.zzbXH != null && (zzbmn2 = this.zzbXI.zzg(this.zzbXH)) != null) {
            this.zza(this.zzbXH, zzbmn2, false);
        }
    }

    class zza
    implements zzbmz {
        zza() {
        }

        @Override
        public void zza(@NonNull zzbmn zzbmn2, @NonNull FirebaseUser firebaseUser) {
            zzac.zzw((Object)((Object)zzbmn2));
            zzac.zzw((Object)firebaseUser);
            firebaseUser.zza(zzbmn2);
            FirebaseAuth.this.zza(firebaseUser, zzbmn2, true);
        }
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }
}

