/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzbve;
import com.google.android.gms.internal.zzbvf;
import com.google.android.gms.internal.zzbvg;
import com.google.android.gms.internal.zzbvk;
import com.google.android.gms.internal.zzbvm;
import com.google.android.gms.internal.zzbvn;
import com.google.android.gms.internal.zzbvo;
import com.google.android.gms.internal.zzbvp;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class zzbuv
implements zzbvf<Date>,
zzbvo<Date> {
    private final DateFormat zzcqJ;
    private final DateFormat zzcqK;
    private final DateFormat zzcqL;

    zzbuv() {
        this(DateFormat.getDateTimeInstance(2, 2, Locale.US), DateFormat.getDateTimeInstance(2, 2));
    }

    zzbuv(String string) {
        this(new SimpleDateFormat(string, Locale.US), new SimpleDateFormat(string));
    }

    public zzbuv(int n, int n2) {
        this(DateFormat.getDateTimeInstance(n, n2, Locale.US), DateFormat.getDateTimeInstance(n, n2));
    }

    zzbuv(DateFormat dateFormat, DateFormat dateFormat2) {
        this.zzcqJ = dateFormat;
        this.zzcqK = dateFormat2;
        this.zzcqL = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        this.zzcqL.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzbvg zza(Date date, Type type, zzbvn zzbvn2) {
        DateFormat dateFormat = this.zzcqK;
        synchronized (dateFormat) {
            String string = this.zzcqJ.format(date);
            return new zzbvm(string);
        }
    }

    public Date zza(zzbvg zzbvg2, Type type, zzbve zzbve2) throws zzbvk {
        if (!(zzbvg2 instanceof zzbvm)) {
            throw new zzbvk("The date should be a string value");
        }
        Date date = this.zza(zzbvg2);
        if (type == Date.class) {
            return date;
        }
        if (type == Timestamp.class) {
            return new Timestamp(date.getTime());
        }
        if (type == java.sql.Date.class) {
            return new java.sql.Date(date.getTime());
        }
        String string = String.valueOf(this.getClass());
        String string2 = String.valueOf(type);
        throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" cannot deserialize to ").append(string2).toString());
    }

    private Date zza(zzbvg zzbvg2) {
        DateFormat dateFormat = this.zzcqK;
        synchronized (dateFormat) {
            try {
                return this.zzcqK.parse(zzbvg2.zzadR());
            }
            catch (ParseException parseException) {
                try {
                    return this.zzcqJ.parse(zzbvg2.zzadR());
                }
                catch (ParseException parseException2) {
                    try {
                        return this.zzcqL.parse(zzbvg2.zzadR());
                    }
                    catch (ParseException parseException3) {
                        throw new zzbvp(zzbvg2.zzadR(), parseException3);
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(zzbuv.class.getSimpleName());
        stringBuilder.append('(').append(this.zzcqK.getClass().getSimpleName()).append(')');
        return stringBuilder.toString();
    }

    @Override
    public /* synthetic */ Object zzb(zzbvg zzbvg2, Type type, zzbve zzbve2) throws zzbvk {
        return this.zza(zzbvg2, type, zzbve2);
    }
}

