/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzbls;
import com.google.android.gms.internal.zzblv;
import com.google.android.gms.internal.zzblx;
import com.google.android.gms.internal.zzbma;
import com.google.android.gms.internal.zzbmn;
import com.google.android.gms.internal.zzbmz;
import com.google.android.gms.internal.zzbnc;
import com.google.android.gms.internal.zzbne;
import com.google.android.gms.internal.zzbnf;
import com.google.android.gms.internal.zzbni;
import com.google.android.gms.internal.zzbnj;
import com.google.android.gms.internal.zzbnk;
import com.google.android.gms.internal.zzbti;
import com.google.android.gms.internal.zzbtj;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class FirebaseAuth
implements zzbti {
    private FirebaseApp zzbXI;
    private List<AuthStateListener> mListeners;
    private zzbls zzbXJ;
    private FirebaseUser zzbXK;
    private zzbnj zzbXL;
    private zzbnk zzbXM;
    private static Map<String, FirebaseAuth> zzbhH = new ArrayMap();
    private static FirebaseAuth zzbXN;

    public static FirebaseAuth getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        return FirebaseAuth.zzc(firebaseApp);
    }

    @Keep
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return FirebaseAuth.zzc(firebaseApp);
    }

    public FirebaseAuth(FirebaseApp firebaseApp) {
        this(firebaseApp, FirebaseAuth.zzb(firebaseApp), new zzbnj(firebaseApp.getApplicationContext(), firebaseApp.zzUY(), zzblx.zzVS()));
    }

    FirebaseAuth(FirebaseApp firebaseApp, zzbls zzbls2, zzbnj zzbnj2) {
        this.zzbXI = (FirebaseApp)zzac.zzw((Object)firebaseApp);
        this.zzbXJ = (zzbls)((Object)zzac.zzw((Object)((Object)zzbls2)));
        this.zzbXL = (zzbnj)zzac.zzw((Object)zzbnj2);
        this.mListeners = new CopyOnWriteArrayList<AuthStateListener>();
        this.zzbXM = zzbnk.zzWw();
        this.zzVF();
    }

    static zzbls zzb(FirebaseApp firebaseApp) {
        zzbma.zza zza2 = new zzbma.zza.zza(firebaseApp.getOptions().getApiKey()).zzVV();
        return zzbma.zza(firebaseApp.getApplicationContext(), zza2);
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.zzbXK;
    }

    public void zza(@NonNull FirebaseUser firebaseUser, boolean bl, boolean bl2) {
        zzac.zzw((Object)firebaseUser);
        if (this.zzbXK == null) {
            this.zzbXK = firebaseUser;
        } else {
            this.zzbXK.zzaX(firebaseUser.isAnonymous());
            this.zzbXK.zzU(firebaseUser.getProviderData());
        }
        if (bl) {
            this.zzbXL.zzf(this.zzbXK);
        }
        if (bl2) {
            this.zza(this.zzbXK);
        }
    }

    public void zza(@NonNull FirebaseUser firebaseUser, @NonNull zzbmn zzbmn2, boolean bl) {
        boolean bl2;
        zzac.zzw((Object)firebaseUser);
        zzac.zzw((Object)((Object)zzbmn2));
        if (this.zzbXK == null) {
            bl2 = true;
        } else {
            String string;
            zzbmn zzbmn3 = this.zzbXK.zzVI();
            String string2 = zzbmn3.getAccessToken();
            boolean bl3 = !string2.equals(string = zzbmn2.getAccessToken());
            boolean bl4 = this.zzbXK.getUid().equals(firebaseUser.getUid());
            bl2 = !bl4 || bl3;
        }
        this.zza(firebaseUser, bl, false);
        if (bl2) {
            if (this.zzbXK != null) {
                this.zzbXK.zza(zzbmn2);
            }
            this.zza(this.zzbXK);
        }
        if (bl) {
            this.zzbXL.zza(firebaseUser, zzbmn2);
        }
    }

    public void zzVE() {
        if (this.zzbXK != null) {
            this.zzbXL.zzh(this.zzbXK);
            this.zzbXK = null;
        }
        this.zzbXL.zzWv();
        this.zza(null);
    }

    private static FirebaseAuth zzc(@NonNull FirebaseApp firebaseApp) {
        return FirebaseAuth.zzd(firebaseApp);
    }

    private static synchronized FirebaseAuth zzd(@NonNull FirebaseApp firebaseApp) {
        FirebaseAuth firebaseAuth = zzbhH.get(firebaseApp.zzUY());
        if (firebaseAuth == null) {
            firebaseAuth = new zzbne(firebaseApp);
            firebaseApp.zza((zzbti)firebaseAuth);
            if (zzbXN == null) {
                zzbXN = firebaseAuth;
            }
            zzbhH.put(firebaseApp.zzUY(), firebaseAuth);
            return firebaseAuth;
        }
        return firebaseAuth;
    }

    public void addAuthStateListener(final @NonNull AuthStateListener authStateListener) {
        this.mListeners.add(authStateListener);
        this.zzbXM.execute(new Runnable(){

            @Override
            public void run() {
                authStateListener.onAuthStateChanged(FirebaseAuth.this);
            }
        });
    }

    public void removeAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.mListeners.remove(authStateListener);
    }

    public void zza(@Nullable FirebaseUser firebaseUser) {
        String string;
        if (firebaseUser != null) {
            string = String.valueOf(firebaseUser.getUid());
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(36 + String.valueOf(string).length()).append("Notifying listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying listeners about a sign-out event.");
        }
        string = firebaseUser != null ? firebaseUser.zzVK() : null;
        final zzbtj zzbtj2 = new zzbtj(string);
        this.zzbXM.execute(new Runnable(){

            @Override
            public void run() {
                FirebaseAuth.this.zzbXI.zza(zzbtj2);
                for (AuthStateListener authStateListener : FirebaseAuth.this.mListeners) {
                    authStateListener.onAuthStateChanged(FirebaseAuth.this);
                }
            }
        });
    }

    @NonNull
    public Task<GetTokenResult> zzaW(boolean bl) {
        return this.zza(this.zzbXK, bl);
    }

    @NonNull
    public Task<GetTokenResult> zza(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            return Tasks.forException((Exception)zzblv.zzce(new Status(17495)));
        }
        zzbmn zzbmn2 = this.zzbXK.zzVI();
        if (zzbmn2.isValid() && !bl) {
            return Tasks.forResult((Object)new GetTokenResult(zzbmn2.getAccessToken()));
        }
        return this.zzbXJ.zza(this.zzbXI, firebaseUser, zzbmn2.zzWe(), new zzbmz(){

            @Override
            public void zza(@NonNull zzbmn zzbmn2, @NonNull FirebaseUser firebaseUser) {
                FirebaseAuth.this.zza(firebaseUser, zzbmn2, true);
            }
        });
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential authCredential) {
        zzac.zzw((Object)authCredential);
        if (EmailAuthCredential.class.isAssignableFrom(authCredential.getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzbXJ.zzb(this.zzbXI, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzbmz)new zza());
        }
        return this.zzbXJ.zza(this.zzbXI, authCredential, (zzbmz)new zza());
    }

    @NonNull
    public Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzac.zzw((Object)firebaseUser);
        zzac.zzw((Object)authCredential);
        if (EmailAuthCredential.class.isAssignableFrom(authCredential.getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzbXJ.zza(this.zzbXI, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), new zza());
        }
        return this.zzbXJ.zza(this.zzbXI, firebaseUser, authCredential, (zzbmz)new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String string) {
        zzac.zzdr((String)string);
        return this.zzbXJ.zza(this.zzbXI, string, (zzbmz)new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzac.zzdr((String)string);
        zzac.zzdr((String)string2);
        return this.zzbXJ.zzb(this.zzbXI, string, string2, (zzbmz)new zza());
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        if (this.zzbXK != null && this.zzbXK.isAnonymous()) {
            zzbnf zzbnf2 = (zzbnf)this.zzbXK;
            zzbnc zzbnc2 = new zzbnc(zzbnf2);
            return Tasks.forResult((Object)zzbnc2);
        }
        return this.zzbXJ.zza(this.zzbXI, new zza());
    }

    @NonNull
    public Task<Void> zzb(@NonNull FirebaseUser firebaseUser) {
        zzac.zzw((Object)firebaseUser);
        return this.zzbXJ.zzb(this.zzbXI, firebaseUser, new zza());
    }

    @NonNull
    public Task<AuthResult> zzb(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzac.zzw((Object)authCredential);
        zzac.zzw((Object)firebaseUser);
        return this.zzbXJ.zzb(this.zzbXI, firebaseUser, authCredential, (zzbmz)new zza());
    }

    @NonNull
    public Task<AuthResult> zza(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzac.zzdr((String)string);
        zzac.zzw((Object)firebaseUser);
        return this.zzbXJ.zzd(this.zzbXI, firebaseUser, string, new zza());
    }

    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzac.zzdr((String)string);
        zzac.zzdr((String)string2);
        return this.zzbXJ.zza(this.zzbXI, string, string2, (zzbmz)new zza());
    }

    @NonNull
    public Task<ProviderQueryResult> fetchProvidersForEmail(@NonNull String string) {
        zzac.zzdr((String)string);
        return this.zzbXJ.zza(this.zzbXI, string);
    }

    @NonNull
    public Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        zzac.zzw((Object)firebaseUser);
        zzac.zzw((Object)((Object)userProfileChangeRequest));
        return this.zzbXJ.zza(this.zzbXI, firebaseUser, userProfileChangeRequest, (zzbmz)new zza());
    }

    @NonNull
    public Task<Void> zzb(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzac.zzw((Object)firebaseUser);
        zzac.zzdr((String)string);
        return this.zzbXJ.zzb(this.zzbXI, firebaseUser, string, (zzbmz)new zza());
    }

    @NonNull
    public Task<Void> zzc(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzac.zzw((Object)firebaseUser);
        zzac.zzdr((String)string);
        return this.zzbXJ.zzc(this.zzbXI, firebaseUser, string, new zza());
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string) {
        zzac.zzdr((String)string);
        return this.zzbXJ.zzb(this.zzbXI, string);
    }

    @NonNull
    public Task<Void> zziw(@NonNull String string) {
        zzac.zzdr((String)string);
        return this.zzbXJ.zzc(this.zzbXI, string);
    }

    @NonNull
    public Task<ActionCodeResult> checkActionCode(@NonNull String string) {
        zzac.zzdr((String)string);
        return this.zzbXJ.zzd(this.zzbXI, string);
    }

    @NonNull
    public Task<Void> applyActionCode(@NonNull String string) {
        zzac.zzdr((String)string);
        return this.zzbXJ.zze(this.zzbXI, string);
    }

    @NonNull
    public Task<String> verifyPasswordResetCode(@NonNull String string) {
        zzac.zzdr((String)string);
        return this.zzbXJ.zzf(this.zzbXI, string);
    }

    @NonNull
    public Task<Void> confirmPasswordReset(@NonNull String string, @NonNull String string2) {
        zzac.zzdr((String)string);
        zzac.zzdr((String)string2);
        return this.zzbXJ.zza(this.zzbXI, string, string2);
    }

    @NonNull
    public Task<Void> zzc(final @NonNull FirebaseUser firebaseUser) {
        zzac.zzw((Object)firebaseUser);
        return this.zzbXJ.zza(firebaseUser, new zzbni(){

            @Override
            public void zzVG() {
                if (FirebaseAuth.this.zzbXK.getUid().equalsIgnoreCase(firebaseUser.getUid())) {
                    FirebaseAuth.this.zzVE();
                }
            }
        });
    }

    public void signOut() {
        this.zzVE();
    }

    protected void zzVF() {
        zzbmn zzbmn2;
        this.zzbXK = this.zzbXL.zzWu();
        if (this.zzbXK != null && (zzbmn2 = this.zzbXL.zzg(this.zzbXK)) != null) {
            this.zza(this.zzbXK, zzbmn2, false);
        }
    }

    class zza
    implements zzbmz {
        zza() {
        }

        @Override
        public void zza(@NonNull zzbmn zzbmn2, @NonNull FirebaseUser firebaseUser) {
            zzac.zzw((Object)((Object)zzbmn2));
            zzac.zzw((Object)firebaseUser);
            firebaseUser.zza(zzbmn2);
            FirebaseAuth.this.zza(firebaseUser, zzbmn2, true);
        }
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }
}

