/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.telephony.PhoneNumberUtils;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.ip;
import com.google.android.gms.internal.jy;
import com.google.android.gms.internal.kd;
import com.google.android.gms.internal.kf;
import com.google.android.gms.internal.kg;
import com.google.android.gms.internal.kw;
import com.google.android.gms.internal.le;
import com.google.android.gms.internal.lk;
import com.google.android.gms.internal.lo;
import com.google.android.gms.internal.lq;
import com.google.android.gms.internal.lr;
import com.google.android.gms.internal.lv;
import com.google.android.gms.internal.lx;
import com.google.android.gms.internal.ly;
import com.google.android.gms.internal.lz;
import com.google.android.gms.internal.zu;
import com.google.android.gms.internal.zv;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.zzf;
import com.google.firebase.auth.zzg;
import com.google.firebase.auth.zzh;
import com.google.firebase.auth.zzi;
import com.google.firebase.auth.zzj;
import com.google.firebase.auth.zzk;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class FirebaseAuth
implements zu {
    private FirebaseApp zzbVX;
    private List<IdTokenListener> zzbVY;
    private List<AuthStateListener> zzbVb;
    private ip zzbVZ;
    private FirebaseUser zzbWa;
    private lx zzbWb;
    private ly zzbWc;
    private static Map<String, FirebaseAuth> zzbgQ = new ArrayMap();
    private static FirebaseAuth zzbWd;

    @Keep
    public static FirebaseAuth getInstance() {
        return FirebaseAuth.zzb(FirebaseApp.getInstance());
    }

    @Keep
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return FirebaseAuth.zzb(firebaseApp);
    }

    public FirebaseAuth(FirebaseApp firebaseApp) {
        FirebaseApp firebaseApp2 = firebaseApp;
        kf kf2 = new kg(firebaseApp2.getOptions().getApiKey()).zzEO();
        this(firebaseApp, kd.zza(firebaseApp2.getApplicationContext(), kf2), new lx(firebaseApp.getApplicationContext(), firebaseApp.zzEq()));
    }

    private FirebaseAuth(FirebaseApp firebaseApp, ip ip2, lx lx2) {
        kw kw2;
        this.zzbVX = (FirebaseApp)zzbo.zzu((Object)firebaseApp);
        this.zzbVZ = (ip)((Object)zzbo.zzu((Object)((Object)ip2)));
        this.zzbWb = (lx)zzbo.zzu((Object)lx2);
        this.zzbVY = new CopyOnWriteArrayList<IdTokenListener>();
        this.zzbVb = new CopyOnWriteArrayList<AuthStateListener>();
        this.zzbWc = ly.zzFa();
        FirebaseAuth firebaseAuth = this;
        firebaseAuth.zzbWa = firebaseAuth.zzbWb.zzEZ();
        if (firebaseAuth.zzbWa != null && (kw2 = firebaseAuth.zzbWb.zzh(firebaseAuth.zzbWa)) != null) {
            firebaseAuth.zza(firebaseAuth.zzbWa, kw2, false);
        }
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.zzbWa;
    }

    public final void zza(@NonNull FirebaseUser firebaseUser, @NonNull kw kw2, boolean bl) {
        boolean bl2;
        boolean bl3;
        zzbo.zzu((Object)firebaseUser);
        zzbo.zzu((Object)((Object)kw2));
        if (this.zzbWa == null) {
            bl3 = true;
            bl2 = true;
        } else {
            String string;
            String string2 = this.zzbWa.zzEF().getAccessToken();
            boolean bl4 = !string2.equals(string = kw2.getAccessToken());
            boolean bl5 = this.zzbWa.getUid().equals(firebaseUser.getUid());
            bl3 = !bl5 || bl4;
            bl2 = !bl5;
        }
        boolean bl6 = bl2;
        boolean bl7 = bl;
        FirebaseUser firebaseUser2 = firebaseUser;
        FirebaseAuth firebaseAuth = this;
        zzbo.zzu((Object)firebaseUser2);
        if (firebaseAuth.zzbWa == null) {
            firebaseAuth.zzbWa = firebaseUser2;
        } else {
            firebaseAuth.zzbWa.zzax(firebaseUser2.isAnonymous());
            firebaseAuth.zzbWa.zzP(firebaseUser2.getProviderData());
        }
        if (bl7) {
            firebaseAuth.zzbWb.zzg(firebaseAuth.zzbWa);
        }
        if (bl3) {
            if (this.zzbWa != null) {
                this.zzbWa.zza(kw2);
            }
            this.zza(this.zzbWa);
        }
        if (bl6) {
            this.zzb(this.zzbWa);
        }
        if (bl) {
            this.zzbWb.zza(firebaseUser, kw2);
        }
    }

    public final void zzEC() {
        if (this.zzbWa != null) {
            FirebaseUser firebaseUser = this.zzbWa;
            lx lx2 = this.zzbWb;
            zzbo.zzu((Object)firebaseUser);
            lx2.clear(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()));
            this.zzbWa = null;
        }
        this.zzbWb.clear("com.google.firebase.auth.FIREBASE_USER");
        this.zza(null);
        this.zzb(null);
    }

    private static synchronized FirebaseAuth zzb(@NonNull FirebaseApp firebaseApp) {
        FirebaseAuth firebaseAuth = zzbgQ.get(firebaseApp.zzEq());
        if (firebaseAuth == null) {
            firebaseAuth = new lq(firebaseApp);
            firebaseApp.zza((zu)firebaseAuth);
            if (zzbWd == null) {
                zzbWd = firebaseAuth;
            }
            zzbgQ.put(firebaseApp.zzEq(), firebaseAuth);
            return firebaseAuth;
        }
        return firebaseAuth;
    }

    public void addIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzbVY.add(idTokenListener);
        this.zzbWc.execute(new zzf(this, idTokenListener));
    }

    public void removeIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzbVY.remove(idTokenListener);
    }

    public void addAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzbVb.add(authStateListener);
        this.zzbWc.execute(new zzg(this, authStateListener));
    }

    public void removeAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzbVb.remove(authStateListener);
    }

    private final void zza(@Nullable FirebaseUser firebaseUser) {
        String string;
        if (firebaseUser != null) {
            string = String.valueOf(firebaseUser.getUid());
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(45 + String.valueOf(string).length()).append("Notifying id token listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying id token listeners about a sign-out event.");
        }
        string = firebaseUser != null ? firebaseUser.zzEH() : null;
        zv zv2 = new zv(string);
        this.zzbWc.execute(new zzh(this, zv2));
    }

    private final void zzb(@Nullable FirebaseUser firebaseUser) {
        if (firebaseUser != null) {
            String string = String.valueOf(firebaseUser.getUid());
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(47 + String.valueOf(string).length()).append("Notifying auth state listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying auth state listeners about a sign-out event.");
        }
        this.zzbWc.execute(new zzi(this));
    }

    @NonNull
    public final Task<GetTokenResult> zzaw(boolean bl) {
        return this.zza(this.zzbWa, bl);
    }

    @NonNull
    public final Task<GetTokenResult> zza(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            return Tasks.forException((Exception)jy.zzK(new Status(17495)));
        }
        kw kw2 = this.zzbWa.zzEF();
        if (kw2.isValid() && !bl) {
            return Tasks.forResult((Object)new GetTokenResult(kw2.getAccessToken()));
        }
        return this.zzbVZ.zza(this.zzbVX, firebaseUser, kw2.zzER(), (lk)new zzj(this));
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential authCredential) {
        zzbo.zzu((Object)((Object)authCredential));
        if (authCredential instanceof EmailAuthCredential) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzbVZ.zzb(this.zzbVX, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), new zza(this));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            PhoneAuthCredential phoneAuthCredential = (PhoneAuthCredential)authCredential;
            return this.zzbVZ.zza(this.zzbVX, phoneAuthCredential, (lk)new zza(this));
        }
        return this.zzbVZ.zza(this.zzbVX, authCredential, (lk)new zza(this));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbo.zzu((Object)firebaseUser);
        zzbo.zzu((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzbVZ.zza(this.zzbVX, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (lz)((Object)new zzb(this)));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzbVZ.zzb(this.zzbVX, firebaseUser, (PhoneAuthCredential)authCredential, (lz)((Object)new zzb(this)));
        }
        return this.zzbVZ.zza(this.zzbVX, firebaseUser, authCredential, (lz)((Object)new zzb(this)));
    }

    public final Task<AuthResult> zzb(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbo.zzu((Object)firebaseUser);
        zzbo.zzu((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzbVZ.zzb(this.zzbVX, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (lz)((Object)new zzb(this)));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzbVZ.zzc(this.zzbVX, firebaseUser, authCredential, (lz)((Object)new zzb(this)));
        }
        return this.zzbVZ.zzb(this.zzbVX, firebaseUser, authCredential, (lz)((Object)new zzb(this)));
    }

    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String string) {
        zzbo.zzcF((String)string);
        return this.zzbVZ.zza(this.zzbVX, string, (lk)new zza(this));
    }

    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzbo.zzcF((String)string);
        zzbo.zzcF((String)string2);
        return this.zzbVZ.zzb(this.zzbVX, string, string2, new zza(this));
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        if (this.zzbWa != null && this.zzbWa.isAnonymous()) {
            lr lr2 = (lr)this.zzbWa;
            return Tasks.forResult((Object)new lo(lr2));
        }
        return this.zzbVZ.zza(this.zzbVX, new zza(this));
    }

    /*
     * Unable to fully structure code
     */
    @NonNull
    public final void zza(@NonNull String var1_1, long var2_2, TimeUnit var4_3, @NonNull PhoneAuthProvider.OnVerificationStateChangedCallbacks var5_4, @Nullable Activity var6_5, @NonNull Executor var7_6, boolean var8_7) {
        block8: {
            block9: {
                block10: {
                    block7: {
                        var14_8 = var1_1;
                        var13_9 = this.zzbVX.getApplicationContext();
                        zzbo.zzu((Object)var13_9);
                        zzbo.zzcF((String)var14_8);
                        var21_10 = (TelephonyManager)var13_9.getSystemService("phone");
                        var19_11 = var21_10 != null ? var21_10.getSimCountryIso() : null;
                        if (TextUtils.isEmpty((CharSequence)var19_11)) {
                            var20_13 = Locale.getDefault();
                            var19_11 = var20_13 != null ? var20_13.getCountry() : null;
                        }
                        var15_14 = TextUtils.isEmpty((CharSequence)var19_11) != false ? "US" : var19_11.toUpperCase(Locale.US);
                        var17_16 = var16_15 = PhoneNumberUtils.stripSeparators((String)var14_8);
                        if (!zzq.zzse()) break block7;
                        if (!TextUtils.isEmpty((CharSequence)(var17_16 = PhoneNumberUtils.formatNumberToE164((String)var17_16, (String)var15_14)))) break block8;
                        v0 = var16_15;
                        break block9;
                    }
                    if (!"US".equals(var15_14)) break block8;
                    var18_17 = var17_16;
                    if (var18_17 != null) break block10;
                    v0 = null;
                    break block9;
                }
                var19_12 = var18_17.length();
                if (var18_17.startsWith("+")) ** GOTO lbl-1000
                if (var19_12 == 11 && var18_17.startsWith("1")) {
                    v0 = "+".concat(var18_17);
                } else if (var19_12 == 10) {
                    v0 = "+1".concat(var18_17);
                } else lbl-1000:
                // 2 sources

                {
                    v0 = var18_17;
                }
            }
            var17_16 = v0;
        }
        var9_18 = var17_16;
        var10_19 = TimeUnit.SECONDS.convert(var2_2, var4_3);
        if (var10_19 < 0L || var10_19 > 120L) {
            throw new IllegalArgumentException("We only support 0-120 seconds for sms-auto-retrieval timeout");
        }
        if (var10_19 < 30L) {
            var10_19 = 30L;
        }
        var12_20 = new le(var9_18, var10_19, var8_7);
        this.zzbVZ.zza(this.zzbVX, var12_20, var5_4, var6_5, var7_6);
    }

    @NonNull
    public final Task<Void> zzc(@NonNull FirebaseUser firebaseUser) {
        zzbo.zzu((Object)firebaseUser);
        return this.zzbVZ.zza(this.zzbVX, firebaseUser, (lz)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<AuthResult> zzc(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbo.zzu((Object)((Object)authCredential));
        zzbo.zzu((Object)firebaseUser);
        return this.zzbVZ.zzd(this.zzbVX, firebaseUser, authCredential, (lz)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<AuthResult> zza(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbo.zzcF((String)string);
        zzbo.zzu((Object)firebaseUser);
        return this.zzbVZ.zzc(this.zzbVX, firebaseUser, string, (lz)((Object)new zzb(this)));
    }

    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzbo.zzcF((String)string);
        zzbo.zzcF((String)string2);
        return this.zzbVZ.zza(this.zzbVX, string, string2, (lk)new zza(this));
    }

    @NonNull
    public Task<ProviderQueryResult> fetchProvidersForEmail(@NonNull String string) {
        zzbo.zzcF((String)string);
        return this.zzbVZ.zza(this.zzbVX, string);
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        zzbo.zzu((Object)firebaseUser);
        zzbo.zzu((Object)((Object)userProfileChangeRequest));
        return this.zzbVZ.zza(this.zzbVX, firebaseUser, userProfileChangeRequest, (lz)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<Void> zzb(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbo.zzu((Object)firebaseUser);
        zzbo.zzcF((String)string);
        return this.zzbVZ.zza(this.zzbVX, firebaseUser, string, (lz)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull PhoneAuthCredential phoneAuthCredential) {
        zzbo.zzu((Object)firebaseUser);
        zzbo.zzu((Object)((Object)phoneAuthCredential));
        return this.zzbVZ.zza(this.zzbVX, firebaseUser, phoneAuthCredential, (lz)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<Void> zzc(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbo.zzu((Object)firebaseUser);
        zzbo.zzcF((String)string);
        return this.zzbVZ.zzb(this.zzbVX, firebaseUser, string, (lz)((Object)new zzb(this)));
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string) {
        zzbo.zzcF((String)string);
        return this.zzbVZ.zzb(this.zzbVX, string);
    }

    @NonNull
    public final Task<Void> zzgp(@NonNull String string) {
        zzbo.zzcF((String)string);
        return this.zzbVZ.zzc(this.zzbVX, string);
    }

    @NonNull
    public Task<ActionCodeResult> checkActionCode(@NonNull String string) {
        zzbo.zzcF((String)string);
        return this.zzbVZ.zzd(this.zzbVX, string);
    }

    @NonNull
    public Task<Void> applyActionCode(@NonNull String string) {
        zzbo.zzcF((String)string);
        return this.zzbVZ.zze(this.zzbVX, string);
    }

    @NonNull
    public Task<String> verifyPasswordResetCode(@NonNull String string) {
        zzbo.zzcF((String)string);
        return this.zzbVZ.zzf(this.zzbVX, string);
    }

    @NonNull
    public Task<Void> confirmPasswordReset(@NonNull String string, @NonNull String string2) {
        zzbo.zzcF((String)string);
        zzbo.zzcF((String)string2);
        return this.zzbVZ.zza(this.zzbVX, string, string2);
    }

    @NonNull
    public final Task<Void> zzd(@NonNull FirebaseUser firebaseUser) {
        zzbo.zzu((Object)firebaseUser);
        return this.zzbVZ.zza(firebaseUser, new zzk(this, firebaseUser));
    }

    public void signOut() {
        this.zzEC();
    }

    static /* synthetic */ FirebaseApp zza(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzbVX;
    }

    static /* synthetic */ List zzb(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzbVY;
    }

    static /* synthetic */ List zzc(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzbVb;
    }

    static /* synthetic */ FirebaseUser zzd(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzbWa;
    }

    final class zzb
    extends zza
    implements lk,
    lv {
        private /* synthetic */ FirebaseAuth zzbWf;

        zzb(FirebaseAuth firebaseAuth) {
            this.zzbWf = firebaseAuth;
            super(firebaseAuth);
        }

        @Override
        public final void onError(Status status) {
            if (status.getStatusCode() == 17011 || status.getStatusCode() == 17021 || status.getStatusCode() == 17005) {
                this.zzbWf.signOut();
            }
        }
    }

    class zza
    implements lk {
        private /* synthetic */ FirebaseAuth zzbWf;

        zza(FirebaseAuth firebaseAuth) {
            this.zzbWf = firebaseAuth;
        }

        @Override
        public final void zza(@NonNull kw kw2, @NonNull FirebaseUser firebaseUser) {
            zzbo.zzu((Object)((Object)kw2));
            zzbo.zzu((Object)firebaseUser);
            firebaseUser.zza(kw2);
            this.zzbWf.zza(firebaseUser, kw2, true);
        }
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }

    public static interface IdTokenListener {
        public void onIdTokenChanged(@NonNull FirebaseAuth var1);
    }
}

