/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzbde;
import com.google.android.gms.internal.zzdiz;
import com.google.android.gms.internal.zzdli;
import com.google.android.gms.internal.zzdmb;
import com.google.android.gms.internal.zzdmd;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseUser;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzdmj {
    private Context mContext;
    private String zzlme;
    private SharedPreferences zzbfk;
    private zzbde zzecs;

    public zzdmj(@NonNull Context context, @NonNull String string) {
        zzbp.zzu((Object)context);
        this.zzlme = zzbp.zzgg((String)string);
        this.mContext = context.getApplicationContext();
        String string2 = String.format("com.google.firebase.auth.api.Store.%s", this.zzlme);
        this.zzbfk = this.mContext.getSharedPreferences(string2, 0);
        this.zzecs = new zzbde("StorageHelpers", new String[0]);
    }

    public final void zzf(@NonNull FirebaseUser firebaseUser) {
        zzbp.zzu((Object)firebaseUser);
        String string = this.zzh(firebaseUser);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            String string2 = string;
            String string3 = "com.google.firebase.auth.FIREBASE_USER";
            this.zzbfk.edit().putString(string3, string2).apply();
        }
    }

    @Nullable
    public final FirebaseUser zzbox() {
        String string = "com.google.firebase.auth.FIREBASE_USER";
        String string2 = this.zzbfk.getString(string, null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        try {
            String string3;
            JSONObject jSONObject = new JSONObject(string2);
            if (jSONObject.has("type") && "com.google.firebase.auth.internal.DefaultFirebaseUser".equalsIgnoreCase(string3 = jSONObject.optString("type"))) {
                return this.zzr(jSONObject);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public final void zza(@NonNull FirebaseUser firebaseUser, @NonNull zzdli zzdli2) {
        zzbp.zzu((Object)firebaseUser);
        zzbp.zzu((Object)((Object)zzdli2));
        this.zzbfk.edit().putString(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()), zzdli2.zzaai()).apply();
    }

    public final zzdli zzg(@NonNull FirebaseUser firebaseUser) {
        zzbp.zzu((Object)firebaseUser);
        String string = this.zzbfk.getString(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()), null);
        if (string != null) {
            return zzdli.zzop(string);
        }
        return null;
    }

    public final void clear(String string) {
        this.zzbfk.edit().remove(string).apply();
    }

    @Nullable
    private final String zzh(@NonNull FirebaseUser firebaseUser) {
        JSONObject jSONObject = new JSONObject();
        if (zzdmd.class.isAssignableFrom(firebaseUser.getClass())) {
            zzdmd zzdmd2 = (zzdmd)firebaseUser;
            try {
                jSONObject.put("cachedTokenState", (Object)((FirebaseUser)zzdmd2).zzboe());
                jSONObject.put("applicationName", (Object)((FirebaseUser)zzdmd2).zzboc().getName());
                jSONObject.put("type", (Object)"com.google.firebase.auth.internal.DefaultFirebaseUser");
                if (zzdmd2.zzbov() != null) {
                    JSONArray jSONArray = new JSONArray();
                    List<zzdmb> list = zzdmd2.zzbov();
                    for (int i = 0; i < list.size(); ++i) {
                        zzdmb zzdmb2 = list.get(i);
                        jSONArray.put((Object)zzdmb2.zzaai());
                    }
                    jSONObject.put("userInfos", (Object)jSONArray);
                }
                jSONObject.put("anonymous", ((FirebaseUser)zzdmd2).isAnonymous());
                jSONObject.put("version", (Object)"2");
                return jSONObject.toString();
            }
            catch (Exception exception) {
                this.zzecs.zza("Failed to turn object into JSON", (Throwable)exception, new Object[0]);
                throw new zzdiz(exception);
            }
        }
        return null;
    }

    private final zzdmd zzr(@NonNull JSONObject jSONObject) {
        try {
            String string = jSONObject.getString("cachedTokenState");
            String string2 = jSONObject.getString("applicationName");
            boolean bl = jSONObject.getBoolean("anonymous");
            String string3 = "2";
            String string4 = jSONObject.getString("version");
            if (string4 != null) {
                string3 = string4;
            }
            JSONArray jSONArray = jSONObject.getJSONArray("userInfos");
            int n = jSONArray.length();
            ArrayList<zzdmb> arrayList = new ArrayList<zzdmb>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(zzdmb.zzoq(jSONArray.getString(i)));
            }
            FirebaseApp firebaseApp = FirebaseApp.getInstance((String)string2);
            zzdmd zzdmd2 = new zzdmd(firebaseApp, arrayList);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                zzdli zzdli2 = zzdli.zzop(string);
                ((FirebaseUser)zzdmd2).zza(zzdli2);
            }
            ((zzdmd)((FirebaseUser)zzdmd2).zzcb(bl)).zzor(string3);
            return zzdmd2;
        }
        catch (zzdiz | ArrayIndexOutOfBoundsException | IllegalArgumentException | JSONException throwable) {
            this.zzecs.zzc(throwable);
            return null;
        }
    }
}

