/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzbde;
import com.google.android.gms.internal.zzdjz;
import com.google.android.gms.internal.zzdmi;
import com.google.android.gms.internal.zzdnb;
import com.google.android.gms.internal.zzdnd;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseUser;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzdnj {
    private Context mContext;
    private String zzloh;
    private SharedPreferences zzbfl;
    private zzbde zzect;

    public zzdnj(@NonNull Context context, @NonNull String string) {
        zzbp.zzu((Object)context);
        this.zzloh = zzbp.zzgg((String)string);
        this.mContext = context.getApplicationContext();
        String string2 = String.format("com.google.firebase.auth.api.Store.%s", this.zzloh);
        this.zzbfl = this.mContext.getSharedPreferences(string2, 0);
        this.zzect = new zzbde("StorageHelpers", new String[0]);
    }

    public final void zzf(@NonNull FirebaseUser firebaseUser) {
        zzbp.zzu((Object)firebaseUser);
        String string = this.zzh(firebaseUser);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            String string2 = string;
            String string3 = "com.google.firebase.auth.FIREBASE_USER";
            this.zzbfl.edit().putString(string3, string2).apply();
        }
    }

    @Nullable
    public final FirebaseUser zzbpg() {
        String string = "com.google.firebase.auth.FIREBASE_USER";
        String string2 = this.zzbfl.getString(string, null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        try {
            String string3;
            JSONObject jSONObject = new JSONObject(string2);
            if (jSONObject.has("type") && "com.google.firebase.auth.internal.DefaultFirebaseUser".equalsIgnoreCase(string3 = jSONObject.optString("type"))) {
                return this.zzr(jSONObject);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public final void zza(@NonNull FirebaseUser firebaseUser, @NonNull zzdmi zzdmi2) {
        zzbp.zzu((Object)firebaseUser);
        zzbp.zzu((Object)((Object)zzdmi2));
        this.zzbfl.edit().putString(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()), zzdmi2.zzaai()).apply();
    }

    public final zzdmi zzg(@NonNull FirebaseUser firebaseUser) {
        zzbp.zzu((Object)firebaseUser);
        String string = this.zzbfl.getString(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()), null);
        if (string != null) {
            return zzdmi.zzor(string);
        }
        return null;
    }

    public final void clear(String string) {
        this.zzbfl.edit().remove(string).apply();
    }

    @Nullable
    private final String zzh(@NonNull FirebaseUser firebaseUser) {
        JSONObject jSONObject = new JSONObject();
        if (zzdnd.class.isAssignableFrom(firebaseUser.getClass())) {
            zzdnd zzdnd2 = (zzdnd)firebaseUser;
            try {
                jSONObject.put("cachedTokenState", (Object)((FirebaseUser)zzdnd2).zzbon());
                jSONObject.put("applicationName", (Object)((FirebaseUser)zzdnd2).zzbol().getName());
                jSONObject.put("type", (Object)"com.google.firebase.auth.internal.DefaultFirebaseUser");
                if (zzdnd2.zzbpe() != null) {
                    JSONArray jSONArray = new JSONArray();
                    List<zzdnb> list = zzdnd2.zzbpe();
                    for (int i = 0; i < list.size(); ++i) {
                        zzdnb zzdnb2 = list.get(i);
                        jSONArray.put((Object)zzdnb2.zzaai());
                    }
                    jSONObject.put("userInfos", (Object)jSONArray);
                }
                jSONObject.put("anonymous", ((FirebaseUser)zzdnd2).isAnonymous());
                jSONObject.put("version", (Object)"2");
                return jSONObject.toString();
            }
            catch (Exception exception) {
                this.zzect.zza("Failed to turn object into JSON", (Throwable)exception, new Object[0]);
                throw new zzdjz(exception);
            }
        }
        return null;
    }

    private final zzdnd zzr(@NonNull JSONObject jSONObject) {
        try {
            String string = jSONObject.getString("cachedTokenState");
            String string2 = jSONObject.getString("applicationName");
            boolean bl = jSONObject.getBoolean("anonymous");
            String string3 = "2";
            String string4 = jSONObject.getString("version");
            if (string4 != null) {
                string3 = string4;
            }
            JSONArray jSONArray = jSONObject.getJSONArray("userInfos");
            int n = jSONArray.length();
            ArrayList<zzdnb> arrayList = new ArrayList<zzdnb>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(zzdnb.zzos(jSONArray.getString(i)));
            }
            FirebaseApp firebaseApp = FirebaseApp.getInstance((String)string2);
            zzdnd zzdnd2 = new zzdnd(firebaseApp, arrayList);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                zzdmi zzdmi2 = zzdmi.zzor(string);
                ((FirebaseUser)zzdnd2).zza(zzdmi2);
            }
            ((zzdnd)((FirebaseUser)zzdnd2).zzcd(bl)).zzot(string3);
            return zzdnd2;
        }
        catch (zzdjz | ArrayIndexOutOfBoundsException | IllegalArgumentException | JSONException throwable) {
            this.zzect.zzc(throwable);
            return null;
        }
    }
}

