/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbfd;
import com.google.android.gms.internal.zzdto;
import com.google.android.gms.internal.zzdwf;
import com.google.android.gms.internal.zzdwy;
import com.google.android.gms.internal.zzdxa;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseUser;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzdxh {
    private Context mContext;
    private String zzmdp;
    private SharedPreferences zzbfu;
    private zzbfd zzedl;

    public zzdxh(@NonNull Context context, @NonNull String string) {
        zzbq.checkNotNull((Object)context);
        this.zzmdp = zzbq.zzgi((String)string);
        this.mContext = context.getApplicationContext();
        String string2 = String.format("com.google.firebase.auth.api.Store.%s", this.zzmdp);
        this.zzbfu = this.mContext.getSharedPreferences(string2, 0);
        this.zzedl = new zzbfd("StorageHelpers", new String[0]);
    }

    public final void zzf(@NonNull FirebaseUser firebaseUser) {
        zzbq.checkNotNull((Object)firebaseUser);
        String string = this.zzh(firebaseUser);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            String string2 = string;
            String string3 = "com.google.firebase.auth.FIREBASE_USER";
            this.zzbfu.edit().putString(string3, string2).apply();
        }
    }

    @Nullable
    public final FirebaseUser zzbql() {
        String string = "com.google.firebase.auth.FIREBASE_USER";
        String string2 = this.zzbfu.getString(string, null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        try {
            String string3;
            JSONObject jSONObject = new JSONObject(string2);
            if (jSONObject.has("type") && "com.google.firebase.auth.internal.DefaultFirebaseUser".equalsIgnoreCase(string3 = jSONObject.optString("type"))) {
                return this.zzaa(jSONObject);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public final void zza(@NonNull FirebaseUser firebaseUser, @NonNull zzdwf zzdwf2) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.checkNotNull((Object)((Object)zzdwf2));
        this.zzbfu.edit().putString(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()), zzdwf2.zzaau()).apply();
    }

    public final zzdwf zzg(@NonNull FirebaseUser firebaseUser) {
        zzbq.checkNotNull((Object)firebaseUser);
        String string = this.zzbfu.getString(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()), null);
        if (string != null) {
            return zzdwf.zzol(string);
        }
        return null;
    }

    public final void clear(String string) {
        this.zzbfu.edit().remove(string).apply();
    }

    @Nullable
    private final String zzh(@NonNull FirebaseUser firebaseUser) {
        JSONObject jSONObject = new JSONObject();
        if (zzdxa.class.isAssignableFrom(firebaseUser.getClass())) {
            zzdxa zzdxa2 = (zzdxa)firebaseUser;
            try {
                jSONObject.put("cachedTokenState", (Object)((FirebaseUser)zzdxa2).zzbpp());
                jSONObject.put("applicationName", (Object)((FirebaseUser)zzdxa2).zzbpn().getName());
                jSONObject.put("type", (Object)"com.google.firebase.auth.internal.DefaultFirebaseUser");
                if (zzdxa2.zzbqj() != null) {
                    JSONArray jSONArray = new JSONArray();
                    List<zzdwy> list = zzdxa2.zzbqj();
                    for (int i = 0; i < list.size(); ++i) {
                        zzdwy zzdwy2 = list.get(i);
                        jSONArray.put((Object)zzdwy2.zzaau());
                    }
                    jSONObject.put("userInfos", (Object)jSONArray);
                }
                jSONObject.put("anonymous", ((FirebaseUser)zzdxa2).isAnonymous());
                jSONObject.put("version", (Object)"2");
                return jSONObject.toString();
            }
            catch (Exception exception) {
                this.zzedl.zza("Failed to turn object into JSON", (Throwable)exception, new Object[0]);
                throw new zzdto(exception);
            }
        }
        return null;
    }

    private final zzdxa zzaa(@NonNull JSONObject jSONObject) {
        try {
            String string = jSONObject.getString("cachedTokenState");
            String string2 = jSONObject.getString("applicationName");
            boolean bl = jSONObject.getBoolean("anonymous");
            String string3 = "2";
            String string4 = jSONObject.getString("version");
            if (string4 != null) {
                string3 = string4;
            }
            JSONArray jSONArray = jSONObject.getJSONArray("userInfos");
            int n = jSONArray.length();
            ArrayList<zzdwy> arrayList = new ArrayList<zzdwy>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(zzdwy.zzom(jSONArray.getString(i)));
            }
            FirebaseApp firebaseApp = FirebaseApp.getInstance((String)string2);
            zzdxa zzdxa2 = new zzdxa(firebaseApp, arrayList);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                zzdwf zzdwf2 = zzdwf.zzol(string);
                ((FirebaseUser)zzdxa2).zza(zzdwf2);
            }
            ((zzdxa)((FirebaseUser)zzdxa2).zzcc(bl)).zzon(string3);
            return zzdxa2;
        }
        catch (zzdto | ArrayIndexOutOfBoundsException | IllegalArgumentException | JSONException throwable) {
            this.zzedl.zze(throwable);
            return null;
        }
    }
}

