/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbfd;
import com.google.android.gms.internal.zzdto;
import com.google.android.gms.internal.zzdwg;
import com.google.android.gms.internal.zzdwz;
import com.google.android.gms.internal.zzdxb;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseUser;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzdxi {
    private Context mContext;
    private String zzmdg;
    private SharedPreferences zzbfu;
    private zzbfd zzeez;

    public zzdxi(@NonNull Context context, @NonNull String string) {
        zzbq.checkNotNull((Object)context);
        this.zzmdg = zzbq.zzgh((String)string);
        this.mContext = context.getApplicationContext();
        String string2 = String.format("com.google.firebase.auth.api.Store.%s", this.zzmdg);
        this.zzbfu = this.mContext.getSharedPreferences(string2, 0);
        this.zzeez = new zzbfd("StorageHelpers", new String[0]);
    }

    public final void zzf(@NonNull FirebaseUser firebaseUser) {
        zzbq.checkNotNull((Object)firebaseUser);
        String string = this.zzh(firebaseUser);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            String string2 = string;
            String string3 = "com.google.firebase.auth.FIREBASE_USER";
            this.zzbfu.edit().putString(string3, string2).apply();
        }
    }

    @Nullable
    public final FirebaseUser zzbqk() {
        String string = "com.google.firebase.auth.FIREBASE_USER";
        String string2 = this.zzbfu.getString(string, null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        try {
            String string3;
            JSONObject jSONObject = new JSONObject(string2);
            if (jSONObject.has("type") && "com.google.firebase.auth.internal.DefaultFirebaseUser".equalsIgnoreCase(string3 = jSONObject.optString("type"))) {
                return this.zzaa(jSONObject);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public final void zza(@NonNull FirebaseUser firebaseUser, @NonNull zzdwg zzdwg2) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.checkNotNull((Object)((Object)zzdwg2));
        this.zzbfu.edit().putString(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()), zzdwg2.zzaat()).apply();
    }

    public final zzdwg zzg(@NonNull FirebaseUser firebaseUser) {
        zzbq.checkNotNull((Object)firebaseUser);
        String string = this.zzbfu.getString(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()), null);
        if (string != null) {
            return zzdwg.zzok(string);
        }
        return null;
    }

    public final void clear(String string) {
        this.zzbfu.edit().remove(string).apply();
    }

    @Nullable
    private final String zzh(@NonNull FirebaseUser firebaseUser) {
        JSONObject jSONObject = new JSONObject();
        if (zzdxb.class.isAssignableFrom(firebaseUser.getClass())) {
            zzdxb zzdxb2 = (zzdxb)firebaseUser;
            try {
                jSONObject.put("cachedTokenState", (Object)((FirebaseUser)zzdxb2).zzbpo());
                jSONObject.put("applicationName", (Object)((FirebaseUser)zzdxb2).zzbpm().getName());
                jSONObject.put("type", (Object)"com.google.firebase.auth.internal.DefaultFirebaseUser");
                if (zzdxb2.zzbqi() != null) {
                    JSONArray jSONArray = new JSONArray();
                    List<zzdwz> list = zzdxb2.zzbqi();
                    for (int i = 0; i < list.size(); ++i) {
                        zzdwz zzdwz2 = list.get(i);
                        jSONArray.put((Object)zzdwz2.zzaat());
                    }
                    jSONObject.put("userInfos", (Object)jSONArray);
                }
                jSONObject.put("anonymous", ((FirebaseUser)zzdxb2).isAnonymous());
                jSONObject.put("version", (Object)"2");
                return jSONObject.toString();
            }
            catch (Exception exception) {
                this.zzeez.zza("Failed to turn object into JSON", (Throwable)exception, new Object[0]);
                throw new zzdto(exception);
            }
        }
        return null;
    }

    private final zzdxb zzaa(@NonNull JSONObject jSONObject) {
        try {
            String string = jSONObject.getString("cachedTokenState");
            String string2 = jSONObject.getString("applicationName");
            boolean bl = jSONObject.getBoolean("anonymous");
            String string3 = "2";
            String string4 = jSONObject.getString("version");
            if (string4 != null) {
                string3 = string4;
            }
            JSONArray jSONArray = jSONObject.getJSONArray("userInfos");
            int n = jSONArray.length();
            ArrayList<zzdwz> arrayList = new ArrayList<zzdwz>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(zzdwz.zzol(jSONArray.getString(i)));
            }
            FirebaseApp firebaseApp = FirebaseApp.getInstance((String)string2);
            zzdxb zzdxb2 = new zzdxb(firebaseApp, arrayList);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                zzdwg zzdwg2 = zzdwg.zzok(string);
                ((FirebaseUser)zzdxb2).zza(zzdwg2);
            }
            ((zzdxb)((FirebaseUser)zzdxb2).zzcc(bl)).zzom(string3);
            return zzdxb2;
        }
        catch (zzdto | ArrayIndexOutOfBoundsException | IllegalArgumentException | JSONException throwable) {
            this.zzeez.zze(throwable);
            return null;
        }
    }
}

