/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.telephony.PhoneNumberUtils;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzdtw;
import com.google.android.gms.internal.zzdvg;
import com.google.android.gms.internal.zzdvl;
import com.google.android.gms.internal.zzdvn;
import com.google.android.gms.internal.zzdvo;
import com.google.android.gms.internal.zzdvp;
import com.google.android.gms.internal.zzdwg;
import com.google.android.gms.internal.zzdwo;
import com.google.android.gms.internal.zzdwu;
import com.google.android.gms.internal.zzdwy;
import com.google.android.gms.internal.zzdxa;
import com.google.android.gms.internal.zzdxb;
import com.google.android.gms.internal.zzdxg;
import com.google.android.gms.internal.zzdxi;
import com.google.android.gms.internal.zzdxj;
import com.google.android.gms.internal.zzdxk;
import com.google.android.gms.internal.zzeui;
import com.google.android.gms.internal.zzeuj;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.zzh;
import com.google.firebase.auth.zzi;
import com.google.firebase.auth.zzj;
import com.google.firebase.auth.zzk;
import com.google.firebase.auth.zzl;
import com.google.firebase.auth.zzm;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class FirebaseAuth
implements zzeui {
    private FirebaseApp zzlyo;
    private List<IdTokenListener> zzlwn;
    private List<AuthStateListener> zzlyp;
    private zzdtw zzlyq;
    private FirebaseUser zzlyr;
    private final Object zzlys;
    private String zzlyt;
    private zzdxi zzlyu;
    private zzdxj zzlyv;
    private static Map<String, FirebaseAuth> zzick = new ArrayMap();
    private static FirebaseAuth zzlyw;

    @Keep
    public static FirebaseAuth getInstance() {
        return FirebaseAuth.zzb(FirebaseApp.getInstance());
    }

    @Keep
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return FirebaseAuth.zzb(firebaseApp);
    }

    public FirebaseAuth(FirebaseApp firebaseApp) {
        FirebaseApp firebaseApp2 = firebaseApp;
        zzdvn zzdvn2 = new zzdvo(firebaseApp2.getOptions().getApiKey()).zzbpy();
        this(firebaseApp, zzdvl.zza(firebaseApp2.getApplicationContext(), zzdvn2), new zzdxi(firebaseApp.getApplicationContext(), firebaseApp.zzboy()));
    }

    private FirebaseAuth(FirebaseApp firebaseApp, zzdtw zzdtw2, zzdxi zzdxi2) {
        zzdwg zzdwg2;
        this.zzlys = new Object();
        this.zzlyo = (FirebaseApp)zzbq.checkNotNull((Object)firebaseApp);
        this.zzlyq = (zzdtw)zzbq.checkNotNull((Object)zzdtw2);
        this.zzlyu = (zzdxi)zzbq.checkNotNull((Object)zzdxi2);
        this.zzlwn = new CopyOnWriteArrayList<IdTokenListener>();
        this.zzlyp = new CopyOnWriteArrayList<AuthStateListener>();
        this.zzlyv = zzdxj.zzbql();
        FirebaseAuth firebaseAuth = this;
        firebaseAuth.zzlyr = firebaseAuth.zzlyu.zzbqk();
        if (firebaseAuth.zzlyr != null && (zzdwg2 = firebaseAuth.zzlyu.zzg(firebaseAuth.zzlyr)) != null) {
            firebaseAuth.zza(firebaseAuth.zzlyr, zzdwg2, false);
        }
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.zzlyr;
    }

    @Nullable
    public final String getUid() {
        if (this.zzlyr == null) {
            return null;
        }
        return this.zzlyr.getUid();
    }

    public final void zza(@NonNull FirebaseUser firebaseUser, @NonNull zzdwg zzdwg2, boolean bl) {
        boolean bl2;
        boolean bl3;
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.checkNotNull((Object)((Object)zzdwg2));
        if (this.zzlyr == null) {
            bl3 = true;
            bl2 = true;
        } else {
            String string;
            String string2 = this.zzlyr.zzbpn().getAccessToken();
            boolean bl4 = !string2.equals(string = zzdwg2.getAccessToken());
            boolean bl5 = this.zzlyr.getUid().equals(firebaseUser.getUid());
            bl3 = !bl5 || bl4;
            bl2 = !bl5;
        }
        boolean bl6 = bl2;
        boolean bl7 = bl;
        FirebaseUser firebaseUser2 = firebaseUser;
        FirebaseAuth firebaseAuth = this;
        zzbq.checkNotNull((Object)firebaseUser2);
        if (firebaseAuth.zzlyr == null) {
            firebaseAuth.zzlyr = firebaseUser2;
        } else {
            firebaseAuth.zzlyr.zzcc(firebaseUser2.isAnonymous());
            firebaseAuth.zzlyr.zzap(firebaseUser2.getProviderData());
        }
        if (bl7) {
            firebaseAuth.zzlyu.zzf(firebaseAuth.zzlyr);
        }
        if (bl3) {
            if (this.zzlyr != null) {
                this.zzlyr.zza(zzdwg2);
            }
            this.zza(this.zzlyr);
        }
        if (bl6) {
            this.zzb(this.zzlyr);
        }
        if (bl) {
            this.zzlyu.zza(firebaseUser, zzdwg2);
        }
    }

    public final void zzbpk() {
        if (this.zzlyr != null) {
            FirebaseUser firebaseUser = this.zzlyr;
            zzdxi zzdxi2 = this.zzlyu;
            zzbq.checkNotNull((Object)firebaseUser);
            zzdxi2.clear(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()));
            this.zzlyr = null;
        }
        this.zzlyu.clear("com.google.firebase.auth.FIREBASE_USER");
        this.zza(null);
        this.zzb(null);
    }

    private static synchronized FirebaseAuth zzb(@NonNull FirebaseApp firebaseApp) {
        FirebaseAuth firebaseAuth = zzick.get(firebaseApp.zzboy());
        if (firebaseAuth == null) {
            firebaseAuth = new zzdxa(firebaseApp);
            firebaseApp.zza((zzeui)firebaseAuth);
            if (zzlyw == null) {
                zzlyw = firebaseAuth;
            }
            zzick.put(firebaseApp.zzboy(), firebaseAuth);
            return firebaseAuth;
        }
        return firebaseAuth;
    }

    public void addIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzlwn.add(idTokenListener);
        this.zzlyv.execute(new zzh(this, idTokenListener));
    }

    public void removeIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzlwn.remove(idTokenListener);
    }

    public void addAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzlyp.add(authStateListener);
        this.zzlyv.execute(new zzi(this, authStateListener));
    }

    public void removeAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzlyp.remove(authStateListener);
    }

    private final void zza(@Nullable FirebaseUser firebaseUser) {
        String string;
        if (firebaseUser != null) {
            string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(45 + String.valueOf(string).length()).append("Notifying id token listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying id token listeners about a sign-out event.");
        }
        string = firebaseUser != null ? firebaseUser.zzbpp() : null;
        zzeuj zzeuj2 = new zzeuj(string);
        this.zzlyv.execute(new zzj(this, zzeuj2));
    }

    private final void zzb(@Nullable FirebaseUser firebaseUser) {
        if (firebaseUser != null) {
            String string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(47 + String.valueOf(string).length()).append("Notifying auth state listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying auth state listeners about a sign-out event.");
        }
        this.zzlyv.execute(new zzk(this));
    }

    @NonNull
    public final Task<GetTokenResult> zzcb(boolean bl) {
        return this.zza(this.zzlyr, bl);
    }

    @NonNull
    public final Task<GetTokenResult> zza(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            return Tasks.forException((Exception)zzdvg.zzao(new Status(17495)));
        }
        zzdwg zzdwg2 = this.zzlyr.zzbpn();
        if (zzdwg2.isValid() && !bl) {
            return Tasks.forResult((Object)new GetTokenResult(zzdwg2.getAccessToken()));
        }
        return this.zzlyq.zza(this.zzlyo, firebaseUser, zzdwg2.zzbqc(), (zzdwu)new zzl(this));
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential authCredential) {
        zzbq.checkNotNull((Object)((Object)authCredential));
        if (authCredential instanceof EmailAuthCredential) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzlyq.zzb(this.zzlyo, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), new zza(this));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            PhoneAuthCredential phoneAuthCredential = (PhoneAuthCredential)authCredential;
            return this.zzlyq.zza(this.zzlyo, phoneAuthCredential, (zzdwu)new zza(this));
        }
        return this.zzlyq.zza(this.zzlyo, authCredential, (zzdwu)new zza(this));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.checkNotNull((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzlyq.zza(this.zzlyo, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzdxk)((Object)new zzb(this)));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzlyq.zzb(this.zzlyo, firebaseUser, (PhoneAuthCredential)authCredential, (zzdxk)((Object)new zzb(this)));
        }
        return this.zzlyq.zza(this.zzlyo, firebaseUser, authCredential, (zzdxk)((Object)new zzb(this)));
    }

    public final Task<AuthResult> zzb(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.checkNotNull((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzlyq.zzb(this.zzlyo, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzdxk)((Object)new zzb(this)));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzlyq.zzc(this.zzlyo, firebaseUser, authCredential, (zzdxk)((Object)new zzb(this)));
        }
        return this.zzlyq.zzb(this.zzlyo, firebaseUser, authCredential, (zzdxk)((Object)new zzb(this)));
    }

    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String string) {
        zzbq.zzgh((String)string);
        return this.zzlyq.zza(this.zzlyo, string, (zzdwu)new zza(this));
    }

    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzbq.zzgh((String)string);
        zzbq.zzgh((String)string2);
        return this.zzlyq.zzb(this.zzlyo, string, string2, new zza(this));
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        if (this.zzlyr != null && this.zzlyr.isAnonymous()) {
            zzdxb zzdxb2 = (zzdxb)this.zzlyr;
            zzdxb2.zzcf(false);
            return Tasks.forResult((Object)new zzdwy(zzdxb2));
        }
        return this.zzlyq.zza(this.zzlyo, new zza(this));
    }

    /*
     * Unable to fully structure code
     */
    @NonNull
    public final void zza(@NonNull String var1_1, long var2_2, TimeUnit var4_3, @NonNull PhoneAuthProvider.OnVerificationStateChangedCallbacks var5_4, @Nullable Activity var6_5, @NonNull Executor var7_6, boolean var8_7) {
        block7: {
            block8: {
                block9: {
                    block6: {
                        var14_8 = var1_1;
                        var13_9 = this.zzlyo.getApplicationContext();
                        zzbq.checkNotNull((Object)var13_9);
                        zzbq.zzgh((String)var14_8);
                        var21_10 = (TelephonyManager)var13_9.getSystemService("phone");
                        var19_11 = var21_10 != null ? var21_10.getSimCountryIso() : null;
                        if (TextUtils.isEmpty((CharSequence)var19_11)) {
                            var20_13 = Locale.getDefault();
                            var19_11 = var20_13 != null ? var20_13.getCountry() : null;
                        }
                        var15_14 = TextUtils.isEmpty((CharSequence)var19_11) != false ? "US" : var19_11.toUpperCase(Locale.US);
                        var17_16 = var16_15 = PhoneNumberUtils.stripSeparators((String)var14_8);
                        if (!zzq.zzamb()) break block6;
                        if (!TextUtils.isEmpty((CharSequence)(var17_16 = PhoneNumberUtils.formatNumberToE164((String)var17_16, (String)var15_14)))) break block7;
                        v0 = var16_15;
                        break block8;
                    }
                    if (!"US".equals(var15_14)) break block7;
                    var18_17 = var17_16;
                    if (var18_17 != null) break block9;
                    v0 = null;
                    break block8;
                }
                var19_12 = var18_17.length();
                if (var18_17.startsWith("+")) ** GOTO lbl-1000
                if (var19_12 == 11 && var18_17.startsWith("1")) {
                    v0 = "+".concat(var18_17);
                } else if (var19_12 == 10) {
                    v0 = "+1".concat(var18_17);
                } else lbl-1000:
                // 2 sources

                {
                    v0 = var18_17;
                }
            }
            var17_16 = v0;
        }
        var9_18 = var17_16;
        var10_19 = TimeUnit.SECONDS.convert(var2_2, var4_3);
        if (var10_19 < 0L || var10_19 > 120L) {
            throw new IllegalArgumentException("We only support 0-120 seconds for sms-auto-retrieval timeout");
        }
        var12_20 = new zzdwo(var9_18, var10_19, var8_7, this.zzlyt);
        this.zzlyq.zza(this.zzlyo, var12_20, var5_4, var6_5, var7_6);
    }

    @NonNull
    public final Task<Void> zzc(@NonNull FirebaseUser firebaseUser) {
        zzbq.checkNotNull((Object)firebaseUser);
        return this.zzlyq.zza(this.zzlyo, firebaseUser, (zzdxk)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<AuthResult> zzc(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbq.checkNotNull((Object)((Object)authCredential));
        zzbq.checkNotNull((Object)firebaseUser);
        return this.zzlyq.zzd(this.zzlyo, firebaseUser, authCredential, (zzdxk)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<AuthResult> zza(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbq.zzgh((String)string);
        zzbq.checkNotNull((Object)firebaseUser);
        return this.zzlyq.zzc(this.zzlyo, firebaseUser, string, (zzdxk)((Object)new zzb(this)));
    }

    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzbq.zzgh((String)string);
        zzbq.zzgh((String)string2);
        return this.zzlyq.zza(this.zzlyo, string, string2, (zzdwu)new zza(this));
    }

    @NonNull
    public Task<ProviderQueryResult> fetchProvidersForEmail(@NonNull String string) {
        zzbq.zzgh((String)string);
        return this.zzlyq.zza(this.zzlyo, string);
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.checkNotNull((Object)((Object)userProfileChangeRequest));
        return this.zzlyq.zza(this.zzlyo, firebaseUser, userProfileChangeRequest, (zzdxk)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<Void> zzb(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.zzgh((String)string);
        return this.zzlyq.zza(this.zzlyo, firebaseUser, string, (zzdxk)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull PhoneAuthCredential phoneAuthCredential) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.checkNotNull((Object)phoneAuthCredential);
        return this.zzlyq.zza(this.zzlyo, firebaseUser, phoneAuthCredential, (zzdxk)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<Void> zzc(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.zzgh((String)string);
        return this.zzlyq.zzb(this.zzlyo, firebaseUser, string, (zzdxk)((Object)new zzb(this)));
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string) {
        zzbq.zzgh((String)string);
        return this.sendPasswordResetEmail(string, null);
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string, @Nullable ActionCodeSettings actionCodeSettings) {
        zzbq.zzgh((String)string);
        if (this.zzlyt != null) {
            if (actionCodeSettings == null) {
                actionCodeSettings = ActionCodeSettings.newBuilder().build();
            }
            actionCodeSettings.zzoe(this.zzlyt);
        }
        return this.zzlyq.zza(this.zzlyo, string, actionCodeSettings);
    }

    @NonNull
    public final Task<Void> zzof(@NonNull String string) {
        zzbq.zzgh((String)string);
        String string2 = string;
        FirebaseApp firebaseApp = this.zzlyo;
        return this.zzlyq.zza(firebaseApp, (ActionCodeSettings)null, string2);
    }

    @NonNull
    public final Task<Void> zza(@NonNull ActionCodeSettings actionCodeSettings, @NonNull String string) {
        zzbq.zzgh((String)string);
        if (this.zzlyt != null) {
            if (actionCodeSettings == null) {
                actionCodeSettings = ActionCodeSettings.newBuilder().build();
            }
            actionCodeSettings.zzoe(this.zzlyt);
        }
        return this.zzlyq.zza(this.zzlyo, actionCodeSettings, string);
    }

    @NonNull
    public Task<ActionCodeResult> checkActionCode(@NonNull String string) {
        zzbq.zzgh((String)string);
        return this.zzlyq.zzb(this.zzlyo, string);
    }

    @NonNull
    public Task<Void> applyActionCode(@NonNull String string) {
        zzbq.zzgh((String)string);
        return this.zzlyq.zzc(this.zzlyo, string);
    }

    @NonNull
    public Task<String> verifyPasswordResetCode(@NonNull String string) {
        zzbq.zzgh((String)string);
        return this.zzlyq.zzd(this.zzlyo, string);
    }

    @NonNull
    public Task<Void> confirmPasswordReset(@NonNull String string, @NonNull String string2) {
        zzbq.zzgh((String)string);
        zzbq.zzgh((String)string2);
        return this.zzlyq.zza(this.zzlyo, string, string2);
    }

    @NonNull
    public final Task<Void> zzd(@NonNull FirebaseUser firebaseUser) {
        zzbq.checkNotNull((Object)firebaseUser);
        return this.zzlyq.zza(firebaseUser, new zzm(this, firebaseUser));
    }

    public void signOut() {
        this.zzbpk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLanguageCode(@NonNull String string) {
        zzbq.zzgh((String)string);
        Object object = this.zzlys;
        synchronized (object) {
            this.zzlyt = string;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getLanguageCode() {
        Object object = this.zzlys;
        synchronized (object) {
            return this.zzlyt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useAppLanguage() {
        Object object = this.zzlys;
        synchronized (object) {
            this.zzlyt = zzdvp.zzbpz();
            return;
        }
    }

    public Task<Void> setFirebaseUIVersion(@Nullable String string) {
        return this.zzlyq.setFirebaseUIVersion(string);
    }

    static /* synthetic */ FirebaseApp zza(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzlyo;
    }

    static /* synthetic */ List zzb(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzlwn;
    }

    static /* synthetic */ List zzc(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzlyp;
    }

    static /* synthetic */ FirebaseUser zzd(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzlyr;
    }

    final class zzb
    extends zza
    implements zzdwu,
    zzdxg {
        private /* synthetic */ FirebaseAuth zzlyy;

        zzb(FirebaseAuth firebaseAuth) {
            this.zzlyy = firebaseAuth;
            super(firebaseAuth);
        }

        @Override
        public final void onError(Status status) {
            if (status.getStatusCode() == 17011 || status.getStatusCode() == 17021 || status.getStatusCode() == 17005) {
                this.zzlyy.signOut();
            }
        }
    }

    class zza
    implements zzdwu {
        private /* synthetic */ FirebaseAuth zzlyy;

        zza(FirebaseAuth firebaseAuth) {
            this.zzlyy = firebaseAuth;
        }

        @Override
        public final void zza(@NonNull zzdwg zzdwg2, @NonNull FirebaseUser firebaseUser) {
            zzbq.checkNotNull((Object)((Object)zzdwg2));
            zzbq.checkNotNull((Object)firebaseUser);
            firebaseUser.zza(zzdwg2);
            this.zzlyy.zza(firebaseUser, zzdwg2, true);
        }
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }

    public static interface IdTokenListener {
        public void onIdTokenChanged(@NonNull FirebaseAuth var1);
    }
}

