/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.telephony.PhoneNumberUtils;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzdwc;
import com.google.android.gms.internal.zzdxm;
import com.google.android.gms.internal.zzdxr;
import com.google.android.gms.internal.zzdxt;
import com.google.android.gms.internal.zzdxu;
import com.google.android.gms.internal.zzdxv;
import com.google.android.gms.internal.zzdym;
import com.google.android.gms.internal.zzdyu;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.internal.zze;
import com.google.firebase.auth.internal.zzg;
import com.google.firebase.auth.internal.zzp;
import com.google.firebase.auth.internal.zzr;
import com.google.firebase.auth.internal.zzs;
import com.google.firebase.auth.internal.zzu;
import com.google.firebase.auth.internal.zzv;
import com.google.firebase.auth.zzh;
import com.google.firebase.auth.zzi;
import com.google.firebase.auth.zzj;
import com.google.firebase.auth.zzk;
import com.google.firebase.auth.zzl;
import com.google.firebase.auth.zzm;
import com.google.firebase.internal.InternalTokenProvider;
import com.google.firebase.internal.zzc;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class FirebaseAuth
implements InternalTokenProvider {
    private FirebaseApp zzmcx;
    private List<IdTokenListener> zzmav;
    private List<AuthStateListener> zzmcy;
    private zzdwc zzmcz;
    private FirebaseUser zzmda;
    private final Object zzmdb;
    private String zzmdc;
    private zzr zzmdd;
    private zzs zzmde;
    private zzu zzmdf;
    private static Map<String, FirebaseAuth> zzifg = new ArrayMap();
    private static FirebaseAuth zzmdg;

    @Keep
    public static FirebaseAuth getInstance() {
        return FirebaseAuth.zzb(FirebaseApp.getInstance());
    }

    @Keep
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return FirebaseAuth.zzb(firebaseApp);
    }

    public FirebaseAuth(FirebaseApp firebaseApp) {
        FirebaseApp firebaseApp2 = firebaseApp;
        zzdxt zzdxt2 = new zzdxu(firebaseApp2.getOptions().getApiKey()).zzbrq();
        this(firebaseApp, zzdxr.zza(firebaseApp2.getApplicationContext(), zzdxt2), new zzr(firebaseApp.getApplicationContext(), firebaseApp.zzbqp()));
    }

    private FirebaseAuth(FirebaseApp firebaseApp, zzdwc zzdwc2, zzr zzr2) {
        zzdym zzdym2;
        this.zzmdb = new Object();
        this.zzmcx = (FirebaseApp)zzbq.checkNotNull((Object)firebaseApp);
        this.zzmcz = (zzdwc)zzbq.checkNotNull((Object)zzdwc2);
        this.zzmdd = (zzr)zzbq.checkNotNull((Object)zzr2);
        this.zzmav = new CopyOnWriteArrayList<IdTokenListener>();
        this.zzmcy = new CopyOnWriteArrayList<AuthStateListener>();
        this.zzmdf = zzu.zzbsj();
        FirebaseAuth firebaseAuth = this;
        firebaseAuth.zzmda = firebaseAuth.zzmdd.zzbsh();
        if (firebaseAuth.zzmda != null && (zzdym2 = firebaseAuth.zzmdd.zzg(firebaseAuth.zzmda)) != null) {
            firebaseAuth.zza(firebaseAuth.zzmda, zzdym2, false);
        }
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.zzmda;
    }

    @Nullable
    public final String getUid() {
        if (this.zzmda == null) {
            return null;
        }
        return this.zzmda.getUid();
    }

    public final void zza(@NonNull FirebaseUser firebaseUser, @NonNull zzdym zzdym2, boolean bl) {
        boolean bl2;
        boolean bl3;
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.checkNotNull((Object)((Object)zzdym2));
        if (this.zzmda == null) {
            bl3 = true;
            bl2 = true;
        } else {
            String string;
            String string2 = this.zzmda.zzbrf().getAccessToken();
            boolean bl4 = !string2.equals(string = zzdym2.getAccessToken());
            boolean bl5 = this.zzmda.getUid().equals(firebaseUser.getUid());
            bl3 = !bl5 || bl4;
            bl2 = !bl5;
        }
        boolean bl6 = bl2;
        boolean bl7 = bl;
        FirebaseUser firebaseUser2 = firebaseUser;
        FirebaseAuth firebaseAuth = this;
        zzbq.checkNotNull((Object)firebaseUser2);
        if (firebaseAuth.zzmda == null) {
            firebaseAuth.zzmda = firebaseUser2;
        } else {
            firebaseAuth.zzmda.zzcf(firebaseUser2.isAnonymous());
            firebaseAuth.zzmda.zzaq(firebaseUser2.getProviderData());
        }
        if (bl7) {
            firebaseAuth.zzmdd.zzf(firebaseAuth.zzmda);
        }
        if (bl3) {
            if (this.zzmda != null) {
                this.zzmda.zza(zzdym2);
            }
            this.zza(this.zzmda);
        }
        if (bl6) {
            this.zzb(this.zzmda);
        }
        if (bl) {
            this.zzmdd.zza(firebaseUser, zzdym2);
        }
        firebaseAuth = this;
        firebaseAuth.zzbrc().zzc(firebaseAuth.zzmda.zzbrf());
    }

    public final void zzbrb() {
        if (this.zzmda != null) {
            FirebaseUser firebaseUser = this.zzmda;
            zzr zzr2 = this.zzmdd;
            zzbq.checkNotNull((Object)firebaseUser);
            zzr2.clear(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()));
            this.zzmda = null;
        }
        this.zzmdd.clear("com.google.firebase.auth.FIREBASE_USER");
        this.zza((FirebaseUser)null);
        this.zzb(null);
    }

    private final synchronized void zza(zzs zzs2) {
        this.zzmde = zzs2;
        this.zzmcx.zza((FirebaseApp.zzb)zzs2);
    }

    private final synchronized zzs zzbrc() {
        if (this.zzmde == null) {
            this.zza(new zzs(this.zzmcx));
        }
        return this.zzmde;
    }

    private static synchronized FirebaseAuth zzb(@NonNull FirebaseApp firebaseApp) {
        FirebaseAuth firebaseAuth = zzifg.get(firebaseApp.zzbqp());
        if (firebaseAuth == null) {
            firebaseAuth = new zzg(firebaseApp);
            firebaseApp.zza((InternalTokenProvider)firebaseAuth);
            if (zzmdg == null) {
                zzmdg = firebaseAuth;
            }
            zzifg.put(firebaseApp.zzbqp(), firebaseAuth);
            return firebaseAuth;
        }
        return firebaseAuth;
    }

    public void addIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzmav.add(idTokenListener);
        this.zzmdf.execute(new zzh(this, idTokenListener));
    }

    public void removeIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzmav.remove(idTokenListener);
    }

    public void addAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzmcy.add(authStateListener);
        this.zzmdf.execute(new zzi(this, authStateListener));
    }

    public void removeAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzmcy.remove(authStateListener);
    }

    private final void zza(@Nullable FirebaseUser firebaseUser) {
        String string;
        if (firebaseUser != null) {
            string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(45 + String.valueOf(string).length()).append("Notifying id token listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying id token listeners about a sign-out event.");
        }
        string = firebaseUser != null ? firebaseUser.zzbrh() : null;
        zzc zzc2 = new zzc(string);
        this.zzmdf.execute(new zzj(this, zzc2));
    }

    private final void zzb(@Nullable FirebaseUser firebaseUser) {
        if (firebaseUser != null) {
            String string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(47 + String.valueOf(string).length()).append("Notifying auth state listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying auth state listeners about a sign-out event.");
        }
        this.zzmdf.execute(new zzk(this));
    }

    @NonNull
    public final Task<GetTokenResult> zzce(boolean bl) {
        return this.zza(this.zzmda, bl);
    }

    @NonNull
    public final Task<GetTokenResult> zza(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            return Tasks.forException((Exception)zzdxm.zzao(new Status(17495)));
        }
        zzdym zzdym2 = this.zzmda.zzbrf();
        if (zzdym2.isValid() && !bl) {
            return Tasks.forResult((Object)new GetTokenResult(zzdym2.getAccessToken()));
        }
        return this.zzmcz.zza(this.zzmcx, firebaseUser, zzdym2.zzbru(), (zzv)((Object)new zzl(this)));
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential authCredential) {
        zzbq.checkNotNull((Object)((Object)authCredential));
        if (authCredential instanceof EmailAuthCredential) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzmcz.zzb(this.zzmcx, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), new zza(this));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            PhoneAuthCredential phoneAuthCredential = (PhoneAuthCredential)authCredential;
            return this.zzmcz.zza(this.zzmcx, phoneAuthCredential, (com.google.firebase.auth.internal.zza)new zza(this));
        }
        return this.zzmcz.zza(this.zzmcx, authCredential, (com.google.firebase.auth.internal.zza)new zza(this));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.checkNotNull((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzmcz.zza(this.zzmcx, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzv)((Object)new zzb(this)));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzmcz.zzb(this.zzmcx, firebaseUser, (PhoneAuthCredential)authCredential, (zzv)((Object)new zzb(this)));
        }
        return this.zzmcz.zza(this.zzmcx, firebaseUser, authCredential, (zzv)((Object)new zzb(this)));
    }

    public final Task<AuthResult> zzb(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.checkNotNull((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            return this.zzmcz.zzb(this.zzmcx, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzv)((Object)new zzb(this)));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzmcz.zzc(this.zzmcx, firebaseUser, authCredential, (zzv)((Object)new zzb(this)));
        }
        return this.zzmcz.zzb(this.zzmcx, firebaseUser, authCredential, (zzv)((Object)new zzb(this)));
    }

    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String string) {
        zzbq.zzgm((String)string);
        return this.zzmcz.zza(this.zzmcx, string, (com.google.firebase.auth.internal.zza)new zza(this));
    }

    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzbq.zzgm((String)string);
        zzbq.zzgm((String)string2);
        return this.zzmcz.zzb(this.zzmcx, string, string2, new zza(this));
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        if (this.zzmda != null && this.zzmda.isAnonymous()) {
            com.google.firebase.auth.internal.zzh zzh2 = (com.google.firebase.auth.internal.zzh)this.zzmda;
            zzh2.zzci(false);
            return Tasks.forResult((Object)new zze(zzh2));
        }
        return this.zzmcz.zza(this.zzmcx, new zza(this));
    }

    /*
     * Unable to fully structure code
     */
    @NonNull
    public final void zza(@NonNull String var1_1, long var2_2, TimeUnit var4_3, @NonNull PhoneAuthProvider.OnVerificationStateChangedCallbacks var5_4, @Nullable Activity var6_5, @NonNull Executor var7_6, boolean var8_7) {
        block7: {
            block8: {
                block9: {
                    block6: {
                        var14_8 = var1_1;
                        var13_9 = this.zzmcx.getApplicationContext();
                        zzbq.checkNotNull((Object)var13_9);
                        zzbq.zzgm((String)var14_8);
                        var21_10 = (TelephonyManager)var13_9.getSystemService("phone");
                        var19_11 = var21_10 != null ? var21_10.getSimCountryIso() : null;
                        if (TextUtils.isEmpty((CharSequence)var19_11)) {
                            var20_13 = Locale.getDefault();
                            var19_11 = var20_13 != null ? var20_13.getCountry() : null;
                        }
                        var15_14 = TextUtils.isEmpty((CharSequence)var19_11) != false ? "US" : var19_11.toUpperCase(Locale.US);
                        var17_16 = var16_15 = PhoneNumberUtils.stripSeparators((String)var14_8);
                        if (!zzq.zzamn()) break block6;
                        if (!TextUtils.isEmpty((CharSequence)(var17_16 = PhoneNumberUtils.formatNumberToE164((String)var17_16, (String)var15_14)))) break block7;
                        v0 = var16_15;
                        break block8;
                    }
                    if (!"US".equals(var15_14)) break block7;
                    var18_17 = var17_16;
                    if (var18_17 != null) break block9;
                    v0 = null;
                    break block8;
                }
                var19_12 = var18_17.length();
                if (var18_17.startsWith("+")) ** GOTO lbl-1000
                if (var19_12 == 11 && var18_17.startsWith("1")) {
                    v0 = "+".concat(var18_17);
                } else if (var19_12 == 10) {
                    v0 = "+1".concat(var18_17);
                } else lbl-1000:
                // 2 sources

                {
                    v0 = var18_17;
                }
            }
            var17_16 = v0;
        }
        var9_18 = var17_16;
        var10_19 = TimeUnit.SECONDS.convert(var2_2, var4_3);
        if (var10_19 < 0L || var10_19 > 120L) {
            throw new IllegalArgumentException("We only support 0-120 seconds for sms-auto-retrieval timeout");
        }
        var12_20 = new zzdyu(var9_18, var10_19, var8_7, this.zzmdc);
        this.zzmcz.zza(this.zzmcx, var12_20, var5_4, var6_5, var7_6);
    }

    @NonNull
    public final Task<Void> zzc(@NonNull FirebaseUser firebaseUser) {
        zzbq.checkNotNull((Object)firebaseUser);
        return this.zzmcz.zza(this.zzmcx, firebaseUser, (zzv)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<AuthResult> zzc(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbq.checkNotNull((Object)((Object)authCredential));
        zzbq.checkNotNull((Object)firebaseUser);
        return this.zzmcz.zzd(this.zzmcx, firebaseUser, authCredential, (zzv)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<AuthResult> zza(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbq.zzgm((String)string);
        zzbq.checkNotNull((Object)firebaseUser);
        return this.zzmcz.zzd(this.zzmcx, firebaseUser, string, (zzv)((Object)new zzb(this)));
    }

    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzbq.zzgm((String)string);
        zzbq.zzgm((String)string2);
        return this.zzmcz.zza(this.zzmcx, string, string2, new zza(this));
    }

    @NonNull
    public Task<ProviderQueryResult> fetchProvidersForEmail(@NonNull String string) {
        zzbq.zzgm((String)string);
        return this.zzmcz.zza(this.zzmcx, string);
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.checkNotNull((Object)((Object)userProfileChangeRequest));
        return this.zzmcz.zza(this.zzmcx, firebaseUser, userProfileChangeRequest, (zzv)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<Void> zzb(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.zzgm((String)string);
        return this.zzmcz.zzb(this.zzmcx, firebaseUser, string, (zzv)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull PhoneAuthCredential phoneAuthCredential) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.checkNotNull((Object)phoneAuthCredential);
        return this.zzmcz.zza(this.zzmcx, firebaseUser, phoneAuthCredential, (zzv)((Object)new zzb(this)));
    }

    @NonNull
    public final Task<Void> zzc(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.zzgm((String)string);
        return this.zzmcz.zzc(this.zzmcx, firebaseUser, string, (zzv)((Object)new zzb(this)));
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string) {
        zzbq.zzgm((String)string);
        return this.sendPasswordResetEmail(string, null);
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string, @Nullable ActionCodeSettings actionCodeSettings) {
        zzbq.zzgm((String)string);
        if (actionCodeSettings == null) {
            actionCodeSettings = ActionCodeSettings.newBuilder().build();
        }
        if (this.zzmdc != null) {
            actionCodeSettings.zzou(this.zzmdc);
        }
        actionCodeSettings.zzgl(1);
        return this.zzmcz.zza(this.zzmcx, string, actionCodeSettings);
    }

    @NonNull
    public final Task<Void> zzov(@NonNull String string) {
        zzbq.zzgm((String)string);
        String string2 = string;
        FirebaseApp firebaseApp = this.zzmcx;
        return this.zzmcz.zza(firebaseApp, (ActionCodeSettings)null, string2);
    }

    @NonNull
    public final Task<Void> zza(@NonNull ActionCodeSettings actionCodeSettings, @NonNull String string) {
        zzbq.zzgm((String)string);
        if (this.zzmdc != null) {
            if (actionCodeSettings == null) {
                actionCodeSettings = ActionCodeSettings.newBuilder().build();
            }
            actionCodeSettings.zzou(this.zzmdc);
        }
        return this.zzmcz.zza(this.zzmcx, actionCodeSettings, string);
    }

    @NonNull
    public Task<ActionCodeResult> checkActionCode(@NonNull String string) {
        zzbq.zzgm((String)string);
        return this.zzmcz.zzb(this.zzmcx, string);
    }

    @NonNull
    public Task<Void> applyActionCode(@NonNull String string) {
        zzbq.zzgm((String)string);
        return this.zzmcz.zzc(this.zzmcx, string);
    }

    @NonNull
    public Task<String> verifyPasswordResetCode(@NonNull String string) {
        zzbq.zzgm((String)string);
        return this.zzmcz.zzd(this.zzmcx, string);
    }

    @NonNull
    public Task<Void> confirmPasswordReset(@NonNull String string, @NonNull String string2) {
        zzbq.zzgm((String)string);
        zzbq.zzgm((String)string2);
        return this.zzmcz.zza(this.zzmcx, string, string2);
    }

    @NonNull
    public final Task<Void> zzd(@NonNull FirebaseUser firebaseUser) {
        zzbq.checkNotNull((Object)firebaseUser);
        return this.zzmcz.zza(firebaseUser, new zzm(this, firebaseUser));
    }

    public void signOut() {
        this.zzbrb();
        if (this.zzmde != null) {
            this.zzmde.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLanguageCode(@NonNull String string) {
        zzbq.zzgm((String)string);
        Object object = this.zzmdb;
        synchronized (object) {
            this.zzmdc = string;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getLanguageCode() {
        Object object = this.zzmdb;
        synchronized (object) {
            return this.zzmdc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useAppLanguage() {
        Object object = this.zzmdb;
        synchronized (object) {
            this.zzmdc = zzdxv.zzbrr();
            return;
        }
    }

    public Task<Void> setFirebaseUIVersion(@Nullable String string) {
        return this.zzmcz.setFirebaseUIVersion(string);
    }

    static /* synthetic */ FirebaseApp zza(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzmcx;
    }

    static /* synthetic */ List zzb(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzmav;
    }

    static /* synthetic */ List zzc(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzmcy;
    }

    static /* synthetic */ FirebaseUser zzd(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzmda;
    }

    final class zzb
    extends zza
    implements com.google.firebase.auth.internal.zza,
    zzp {
        private /* synthetic */ FirebaseAuth zzmdi;

        zzb(FirebaseAuth firebaseAuth) {
            this.zzmdi = firebaseAuth;
            super(firebaseAuth);
        }

        @Override
        public final void onError(Status status) {
            if (status.getStatusCode() == 17011 || status.getStatusCode() == 17021 || status.getStatusCode() == 17005) {
                this.zzmdi.signOut();
            }
        }
    }

    class zza
    implements com.google.firebase.auth.internal.zza {
        private /* synthetic */ FirebaseAuth zzmdi;

        zza(FirebaseAuth firebaseAuth) {
            this.zzmdi = firebaseAuth;
        }

        @Override
        public final void zza(@NonNull zzdym zzdym2, @NonNull FirebaseUser firebaseUser) {
            zzbq.checkNotNull((Object)((Object)zzdym2));
            zzbq.checkNotNull((Object)firebaseUser);
            firebaseUser.zza(zzdym2);
            this.zzmdi.zza(firebaseUser, zzdym2, true);
        }
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }

    public static interface IdTokenListener {
        public void onIdTokenChanged(@NonNull FirebaseAuth var1);
    }
}

