/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbgg;
import com.google.android.gms.internal.zzdvu;
import com.google.android.gms.internal.zzdym;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.internal.zzf;
import com.google.firebase.auth.internal.zzh;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzr {
    private Context mContext;
    private String zzmhz;
    private SharedPreferences zzbhh;
    private zzbgg zzehz;

    public zzr(@NonNull Context context, @NonNull String string) {
        zzbq.checkNotNull((Object)context);
        this.zzmhz = zzbq.zzgm((String)string);
        this.mContext = context.getApplicationContext();
        String string2 = String.format("com.google.firebase.auth.api.Store.%s", this.zzmhz);
        this.zzbhh = this.mContext.getSharedPreferences(string2, 0);
        this.zzehz = new zzbgg("StorageHelpers", new String[0]);
    }

    public final void zzf(@NonNull FirebaseUser firebaseUser) {
        zzbq.checkNotNull((Object)firebaseUser);
        String string = this.zzh(firebaseUser);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            String string2 = string;
            String string3 = "com.google.firebase.auth.FIREBASE_USER";
            this.zzbhh.edit().putString(string3, string2).apply();
        }
    }

    @Nullable
    public final FirebaseUser zzbsh() {
        String string = "com.google.firebase.auth.FIREBASE_USER";
        String string2 = this.zzbhh.getString(string, null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        try {
            String string3;
            JSONObject jSONObject = new JSONObject(string2);
            if (jSONObject.has("type") && "com.google.firebase.auth.internal.DefaultFirebaseUser".equalsIgnoreCase(string3 = jSONObject.optString("type"))) {
                return this.zzaa(jSONObject);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public final void zza(@NonNull FirebaseUser firebaseUser, @NonNull zzdym zzdym2) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.checkNotNull((Object)((Object)zzdym2));
        this.zzbhh.edit().putString(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()), zzdym2.zzabg()).apply();
    }

    public final zzdym zzg(@NonNull FirebaseUser firebaseUser) {
        zzbq.checkNotNull((Object)firebaseUser);
        String string = this.zzbhh.getString(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()), null);
        if (string != null) {
            return zzdym.zzpa(string);
        }
        return null;
    }

    public final void clear(String string) {
        this.zzbhh.edit().remove(string).apply();
    }

    @Nullable
    private final String zzh(@NonNull FirebaseUser firebaseUser) {
        JSONObject jSONObject = new JSONObject();
        if (zzh.class.isAssignableFrom(firebaseUser.getClass())) {
            zzh zzh2 = (zzh)firebaseUser;
            try {
                jSONObject.put("cachedTokenState", (Object)((FirebaseUser)zzh2).zzbrg());
                jSONObject.put("applicationName", (Object)((FirebaseUser)zzh2).zzbre().getName());
                jSONObject.put("type", (Object)"com.google.firebase.auth.internal.DefaultFirebaseUser");
                if (zzh2.zzbsc() != null) {
                    JSONArray jSONArray = new JSONArray();
                    List<zzf> list = zzh2.zzbsc();
                    for (int i = 0; i < list.size(); ++i) {
                        zzf zzf2 = list.get(i);
                        jSONArray.put((Object)zzf2.zzabg());
                    }
                    jSONObject.put("userInfos", (Object)jSONArray);
                }
                jSONObject.put("anonymous", ((FirebaseUser)zzh2).isAnonymous());
                jSONObject.put("version", (Object)"2");
                return jSONObject.toString();
            }
            catch (Exception exception) {
                this.zzehz.zza("Failed to turn object into JSON", (Throwable)exception, new Object[0]);
                throw new zzdvu(exception);
            }
        }
        return null;
    }

    private final zzh zzaa(@NonNull JSONObject jSONObject) {
        try {
            String string = jSONObject.getString("cachedTokenState");
            String string2 = jSONObject.getString("applicationName");
            boolean bl = jSONObject.getBoolean("anonymous");
            String string3 = "2";
            String string4 = jSONObject.getString("version");
            if (string4 != null) {
                string3 = string4;
            }
            JSONArray jSONArray = jSONObject.getJSONArray("userInfos");
            int n = jSONArray.length();
            ArrayList<zzf> arrayList = new ArrayList<zzf>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(zzf.zzpb(jSONArray.getString(i)));
            }
            FirebaseApp firebaseApp = FirebaseApp.getInstance((String)string2);
            zzh zzh2 = new zzh(firebaseApp, arrayList);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                zzdym zzdym2 = zzdym.zzpa(string);
                ((FirebaseUser)zzh2).zza(zzdym2);
            }
            ((zzh)((FirebaseUser)zzh2).zzcf(bl)).zzpc(string3);
            return zzh2;
        }
        catch (zzdvu | ArrayIndexOutOfBoundsException | IllegalArgumentException | JSONException throwable) {
            this.zzehz.zze(throwable);
            return null;
        }
    }
}

