/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbhf;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.zzf;

public class EmailAuthCredential
extends AuthCredential {
    public static final Parcelable.Creator<EmailAuthCredential> CREATOR = new zzf();
    private static final zzbhf zzehr = new zzbhf("EmailAuthCredential", new String[0]);
    private String zzemh;
    private String zzekn;
    private final String zzmoy;
    private String zzmoz;
    private boolean zzmpa;

    @Hide
    EmailAuthCredential(@NonNull String string, @NonNull String string2, @NonNull String string3, @NonNull String string4, @NonNull boolean bl) {
        this.zzemh = zzbq.zzgv((String)string);
        if (TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("Cannot create an EmailAuthCredential without a password or emailLink.");
        }
        this.zzekn = string2;
        this.zzmoy = string3;
        this.zzmoz = string4;
        this.zzmpa = bl;
    }

    @Hide
    EmailAuthCredential(String string, String string2) {
        this(string, string2, null, null, false);
    }

    @Hide
    @NonNull
    public final String getEmail() {
        return this.zzemh;
    }

    @Hide
    @NonNull
    public final String getPassword() {
        return this.zzekn;
    }

    @Hide
    public final EmailAuthCredential zza(@Nullable FirebaseUser firebaseUser) {
        this.zzmoz = firebaseUser.zzbtn();
        this.zzmpa = true;
        return this;
    }

    @Override
    @NonNull
    public String getProvider() {
        return "password";
    }

    @Override
    public String getSignInMethod() {
        if (!TextUtils.isEmpty((CharSequence)this.zzekn)) {
            return "password";
        }
        return "emailLink";
    }

    @Hide
    public final boolean zzbth() {
        return !TextUtils.isEmpty((CharSequence)this.zzmoy);
    }

    @Hide
    public static boolean isSignInWithEmailLink(@NonNull String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        try {
            if (EmailAuthCredential.zzpb(string)) {
                return true;
            }
            return EmailAuthCredential.zzpb(Uri.parse((String)string).getQueryParameter("link"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Object[] objectArray = new Object[1];
            String string2 = String.valueOf(unsupportedOperationException.getMessage());
            objectArray[0] = string2.length() != 0 ? "isSignInWithEmailLink returned an UnsupportedOperationException: ".concat(string2) : new String("isSignInWithEmailLink returned an UnsupportedOperationException: ");
            zzehr.zza("EmailAuthCredential", objectArray);
            return false;
        }
    }

    private static boolean zzpb(@NonNull String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        Uri uri = Uri.parse((String)string);
        String string2 = uri.getQueryParameter("oobCode");
        String string3 = uri.getQueryParameter("mode");
        return !TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3) && string3.equals("signIn");
    }

    @Hide
    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        EmailAuthCredential emailAuthCredential = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (String)emailAuthCredential.zzemh, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)emailAuthCredential.zzekn, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (String)emailAuthCredential.zzmoy, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (String)emailAuthCredential.zzmoz, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (boolean)emailAuthCredential.zzmpa);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }
}

