/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_auth;

import com.google.android.gms.internal.firebase_auth.zzbq;
import com.google.android.gms.internal.firebase_auth.zzdd;
import com.google.android.gms.internal.firebase_auth.zzdg;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzcl
extends zzbq<Double>
implements zzdg<Double>,
RandomAccess {
    private static final zzcl zznk = new zzcl();
    private double[] zznl;
    private int size;

    zzcl() {
        this(new double[10], 0);
    }

    private zzcl(double[] dArray, int n) {
        this.zznl = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzbq();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zznl, n2, this.zznl, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzcl)) {
            return super.equals(object);
        }
        zzcl zzcl2 = (zzcl)object;
        if (this.size != zzcl2.size) {
            return false;
        }
        double[] dArray = zzcl2.zznl;
        for (int i = 0; i < this.size; ++i) {
            if (this.zznl[i] == dArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zznl[i]);
            n = n * 31 + zzdd.zzk(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzc(double d) {
        this.zzc(this.size, d);
    }

    private final void zzc(int n, double d) {
        this.zzbq();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzh(n));
        }
        if (this.size < this.zznl.length) {
            System.arraycopy(this.zznl, n, this.zznl, n + 1, this.size - n);
        } else {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zznl, 0, dArray, 0, n);
            System.arraycopy(this.zznl, n, dArray, n + 1, this.size - n);
            this.zznl = dArray;
        }
        this.zznl[n] = d;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzbq();
        zzdd.checkNotNull(collection);
        if (!(collection instanceof zzcl)) {
            return super.addAll(collection);
        }
        zzcl zzcl2 = (zzcl)collection;
        if (zzcl2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzcl2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzcl2.size;
        if (n > this.zznl.length) {
            this.zznl = Arrays.copyOf(this.zznl, n);
        }
        System.arraycopy(zzcl2.zznl, 0, this.zznl, this.size, zzcl2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzbq();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zznl[i])) continue;
            System.arraycopy(this.zznl, i + 1, this.zznl, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzg(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzh(n));
        }
    }

    private final String zzh(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzcl zzcl2 = this;
        zzcl2.zzbq();
        zzcl2.zzg(n);
        double d3 = zzcl2.zznl[n];
        zzcl2.zznl[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzcl zzcl2 = this;
        zzcl2.zzbq();
        zzcl2.zzg(n);
        double d = zzcl2.zznl[n];
        if (n < zzcl2.size - 1) {
            System.arraycopy(zzcl2.zznl, n + 1, zzcl2.zznl, n, zzcl2.size - n);
        }
        --zzcl2.size;
        ++zzcl2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        this.zzc(n, d);
    }

    @Override
    public final /* synthetic */ zzdg zzi(int n) {
        int n2 = n;
        zzcl zzcl2 = this;
        if (n2 < zzcl2.size) {
            throw new IllegalArgumentException();
        }
        return new zzcl(Arrays.copyOf(zzcl2.zznl, n2), zzcl2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzcl zzcl2 = this;
        zzcl2.zzg(n);
        return zzcl2.zznl[n];
    }

    static {
        zznk.zzbp();
    }
}

