/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_auth;

import com.google.android.gms.internal.firebase_auth.zzbq;
import com.google.android.gms.internal.firebase_auth.zzdd;
import com.google.android.gms.internal.firebase_auth.zzdg;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdv
extends zzbq<Long>
implements zzdg<Long>,
RandomAccess {
    private static final zzdv zzsq = new zzdv();
    private long[] zzsr;
    private int size;

    zzdv() {
        this(new long[10], 0);
    }

    private zzdv(long[] lArray, int n) {
        this.zzsr = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzbq();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzsr, n2, this.zzsr, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdv)) {
            return super.equals(object);
        }
        zzdv zzdv2 = (zzdv)object;
        if (this.size != zzdv2.size) {
            return false;
        }
        long[] lArray = zzdv2.zzsr;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzsr[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzdd.zzk(this.zzsr[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzg(n);
        return this.zzsr[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzl(long l) {
        this.zzk(this.size, l);
    }

    private final void zzk(int n, long l) {
        this.zzbq();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzh(n));
        }
        if (this.size < this.zzsr.length) {
            System.arraycopy(this.zzsr, n, this.zzsr, n + 1, this.size - n);
        } else {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzsr, 0, lArray, 0, n);
            System.arraycopy(this.zzsr, n, lArray, n + 1, this.size - n);
            this.zzsr = lArray;
        }
        this.zzsr[n] = l;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzbq();
        zzdd.checkNotNull(collection);
        if (!(collection instanceof zzdv)) {
            return super.addAll(collection);
        }
        zzdv zzdv2 = (zzdv)collection;
        if (zzdv2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdv2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdv2.size;
        if (n > this.zzsr.length) {
            this.zzsr = Arrays.copyOf(this.zzsr, n);
        }
        System.arraycopy(zzdv2.zzsr, 0, this.zzsr, this.size, zzdv2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzbq();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzsr[i])) continue;
            System.arraycopy(this.zzsr, i + 1, this.zzsr, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzg(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzh(n));
        }
    }

    private final String zzh(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzdv zzdv2 = this;
        zzdv2.zzbq();
        zzdv2.zzg(n);
        long l3 = zzdv2.zzsr[n];
        zzdv2.zzsr[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdv zzdv2 = this;
        zzdv2.zzbq();
        zzdv2.zzg(n);
        long l = zzdv2.zzsr[n];
        if (n < zzdv2.size - 1) {
            System.arraycopy(zzdv2.zzsr, n + 1, zzdv2.zzsr, n, zzdv2.size - n);
        }
        --zzdv2.size;
        ++zzdv2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        this.zzk(n, l);
    }

    @Override
    public final /* synthetic */ zzdg zzi(int n) {
        int n2 = n;
        zzdv zzdv2 = this;
        if (n2 < zzdv2.size) {
            throw new IllegalArgumentException();
        }
        return new zzdv(Arrays.copyOf(zzdv2.zzsr, n2), zzdv2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzsq.zzbp();
    }
}

