/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.logging.Logger;
import com.google.android.gms.internal.firebase_auth.zzao;
import com.google.android.gms.internal.firebase_auth.zzv;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.internal.zzh;
import com.google.firebase.auth.internal.zzk;
import com.google.firebase.auth.internal.zzm;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzz {
    private Context zzgo;
    private String zzlm;
    private SharedPreferences zzln;
    private Logger zzdv;

    public zzz(@NonNull Context context, @NonNull String string) {
        Preconditions.checkNotNull((Object)context);
        this.zzlm = Preconditions.checkNotEmpty((String)string);
        this.zzgo = context.getApplicationContext();
        String string2 = String.format("com.google.firebase.auth.api.Store.%s", this.zzlm);
        this.zzln = this.zzgo.getSharedPreferences(string2, 0);
        this.zzdv = new Logger("StorageHelpers", new String[0]);
    }

    public final void zzg(@NonNull FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)firebaseUser);
        String string = this.zzi(firebaseUser);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            String string2 = string;
            String string3 = "com.google.firebase.auth.FIREBASE_USER";
            this.zzln.edit().putString(string3, string2).apply();
        }
    }

    @Nullable
    public final FirebaseUser zzbi() {
        String string = "com.google.firebase.auth.FIREBASE_USER";
        String string2 = this.zzln.getString(string, null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        try {
            String string3;
            JSONObject jSONObject = new JSONObject(string2);
            if (jSONObject.has("type") && "com.google.firebase.auth.internal.DefaultFirebaseUser".equalsIgnoreCase(string3 = jSONObject.optString("type"))) {
                return this.zzc(jSONObject);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public final void zza(@NonNull FirebaseUser firebaseUser, @NonNull zzao zzao2) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)zzao2);
        this.zzln.edit().putString(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()), zzao2.toJson()).apply();
    }

    public final zzao zzh(@NonNull FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)firebaseUser);
        String string = this.zzln.getString(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()), null);
        if (string != null) {
            return zzao.zzs(string);
        }
        return null;
    }

    public final void clear(String string) {
        this.zzln.edit().remove(string).apply();
    }

    @Nullable
    private final String zzi(@NonNull FirebaseUser firebaseUser) {
        JSONObject jSONObject = new JSONObject();
        if (zzk.class.isAssignableFrom(firebaseUser.getClass())) {
            zzk zzk2 = (zzk)firebaseUser;
            try {
                jSONObject.put("cachedTokenState", (Object)((FirebaseUser)zzk2).zzo());
                jSONObject.put("applicationName", (Object)((FirebaseUser)zzk2).zzm().getName());
                jSONObject.put("type", (Object)"com.google.firebase.auth.internal.DefaultFirebaseUser");
                if (zzk2.zzbd() != null) {
                    JSONArray jSONArray = new JSONArray();
                    List<zzh> list = zzk2.zzbd();
                    for (int i = 0; i < list.size(); ++i) {
                        zzh zzh2 = list.get(i);
                        jSONArray.put((Object)zzh2.toJson());
                    }
                    jSONObject.put("userInfos", (Object)jSONArray);
                }
                jSONObject.put("anonymous", ((FirebaseUser)zzk2).isAnonymous());
                jSONObject.put("version", (Object)"2");
                jSONObject.put("userMetadata", (Object)((zzm)((FirebaseUser)zzk2).getMetadata()).zzbe());
                return jSONObject.toString();
            }
            catch (Exception exception) {
                this.zzdv.wtf("Failed to turn object into JSON", (Throwable)exception, new Object[0]);
                throw new zzv(exception);
            }
        }
        return null;
    }

    private final zzk zzc(@NonNull JSONObject jSONObject) {
        try {
            String string = jSONObject.getString("cachedTokenState");
            String string2 = jSONObject.getString("applicationName");
            boolean bl = jSONObject.getBoolean("anonymous");
            String string3 = "2";
            String string4 = jSONObject.getString("version");
            if (string4 != null) {
                string3 = string4;
            }
            JSONArray jSONArray = jSONObject.getJSONArray("userInfos");
            int n = jSONArray.length();
            ArrayList<zzh> arrayList = new ArrayList<zzh>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(zzh.zzad(jSONArray.getString(i)));
            }
            FirebaseApp firebaseApp = FirebaseApp.getInstance((String)string2);
            zzk zzk2 = new zzk(firebaseApp, arrayList);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                zzao zzao2 = zzao.zzs(string);
                ((FirebaseUser)zzk2).zza(zzao2);
            }
            ((zzk)((FirebaseUser)zzk2).zza(bl)).zzae(string3);
            zzm zzm2 = zzm.zza(jSONObject.getJSONObject("userMetadata"));
            if (zzm2 != null) {
                zzk2.zza(zzm2);
            }
            return zzk2;
        }
        catch (zzv | ArrayIndexOutOfBoundsException | IllegalArgumentException | JSONException throwable) {
            this.zzdv.wtf(throwable);
            return null;
        }
    }
}

