/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_auth;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.internal.firebase_auth.zzap;
import com.google.android.gms.internal.firebase_auth.zzgt;
import com.google.android.gms.internal.firebase_auth.zzgy;
import com.google.android.gms.internal.firebase_auth.zzv;
import com.google.firebase.auth.api.internal.zzcg;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="GetTokenResponseCreator")
public final class zzao
extends AbstractSafeParcelable
implements zzcg<zzao, zzgy.zza> {
    public static final Parcelable.Creator<zzao> CREATOR = new zzap();
    @SafeParcelable.Field(id=2, getter="getRefreshToken")
    private String zzai;
    @SafeParcelable.Field(id=3, getter="getAccessToken")
    private String zzdv;
    @SafeParcelable.Field(id=4, getter="getExpiresIn")
    private Long zzjx;
    @SafeParcelable.Field(id=5, getter="getTokenType")
    private String zzjy;
    @SafeParcelable.Field(id=6, getter="getIssuedAt")
    private Long zzjz;

    public zzao() {
        this.zzjz = System.currentTimeMillis();
    }

    public zzao(String string, String string2, Long l, String string3) {
        this(string, string2, l, string3, System.currentTimeMillis());
    }

    @SafeParcelable.Constructor
    zzao(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) Long l, @SafeParcelable.Param(id=5) String string3, @SafeParcelable.Param(id=6) Long l2) {
        this.zzai = string;
        this.zzdv = string2;
        this.zzjx = l;
        this.zzjy = string3;
        this.zzjz = l2;
    }

    public final boolean isValid() {
        long l = this.zzjz + this.zzjx * 1000L;
        return DefaultClock.getInstance().currentTimeMillis() + 300000L < l;
    }

    public final void zzr(@NonNull String string) {
        this.zzai = Preconditions.checkNotEmpty((String)string);
    }

    public final String zzap() {
        return this.zzai;
    }

    public final String zzaw() {
        return this.zzdv;
    }

    public final long zzaq() {
        if (this.zzjx == null) {
            return 0L;
        }
        return this.zzjx;
    }

    @Nullable
    public final String zzax() {
        return this.zzjy;
    }

    public final long zzay() {
        return this.zzjz;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzao zzao2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)zzao2.zzai, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)zzao2.zzdv, (boolean)false);
        SafeParcelWriter.writeLongObject((Parcel)parcel2, (int)4, (Long)zzao2.zzaq(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)zzao2.zzjy, (boolean)false);
        SafeParcelWriter.writeLongObject((Parcel)parcel2, (int)6, (Long)zzao2.zzjz, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Override
    public final Class<zzgy.zza> zzag() {
        return zzgy.zza.class;
    }

    public final String toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("refresh_token", (Object)this.zzai);
            jSONObject.put("access_token", (Object)this.zzdv);
            jSONObject.put("expires_in", (Object)this.zzjx);
            jSONObject.put("token_type", (Object)this.zzjy);
            jSONObject.put("issued_at", (Object)this.zzjz);
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            Log.d((String)"GetTokenResponse", (String)"Failed to convert GetTokenResponse to JSON");
            throw new zzv(jSONException);
        }
    }

    public static zzao zzs(@NonNull String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            zzao zzao2 = new zzao();
            new zzao().zzai = jSONObject.optString("refresh_token", null);
            zzao2.zzdv = jSONObject.optString("access_token", null);
            zzao2.zzjx = jSONObject.optLong("expires_in");
            zzao2.zzjy = jSONObject.optString("token_type", null);
            zzao2.zzjz = jSONObject.optLong("issued_at");
            return zzao2;
        }
        catch (JSONException jSONException) {
            Log.d((String)"GetTokenResponse", (String)"Failed to read GetTokenResponse from JSONObject");
            throw new zzv(jSONException);
        }
    }

    @Override
    public final /* synthetic */ zzcg zza(zzgt zzgt2) {
        zzgy.zza zza2 = (zzgy.zza)zzgt2;
        zzao zzao2 = this;
        this.zzai = Strings.emptyToNull((String)zza2.zzai);
        zzao2.zzdv = Strings.emptyToNull((String)zza2.zzdv);
        zzao2.zzjx = zza2.zzaj;
        zzao2.zzjy = Strings.emptyToNull((String)zza2.zzjy);
        zzao2.zzjz = System.currentTimeMillis();
        return zzao2;
    }
}

