/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_auth;

import com.google.android.gms.internal.firebase_auth.zzbq;
import com.google.android.gms.internal.firebase_auth.zzdd;
import com.google.android.gms.internal.firebase_auth.zzdg;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzbs
extends zzbq<Boolean>
implements zzdg<Boolean>,
RandomAccess {
    private static final zzbs zzmg = new zzbs();
    private boolean[] zzmh;
    private int size;

    zzbs() {
        this(new boolean[10], 0);
    }

    private zzbs(boolean[] blArray, int n) {
        this.zzmh = blArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzbt();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzmh, n2, this.zzmh, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzbs)) {
            return super.equals(object);
        }
        zzbs zzbs2 = (zzbs)object;
        if (this.size != zzbs2.size) {
            return false;
        }
        boolean[] blArray = zzbs2.zzmh;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzmh[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzdd.zzh(this.zzmh[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void addBoolean(boolean bl) {
        this.zza(this.size, bl);
    }

    private final void zza(int n, boolean bl) {
        this.zzbt();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
        if (this.size < this.zzmh.length) {
            System.arraycopy(this.zzmh, n, this.zzmh, n + 1, this.size - n);
        } else {
            boolean[] blArray = new boolean[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzmh, 0, blArray, 0, n);
            System.arraycopy(this.zzmh, n, blArray, n + 1, this.size - n);
            this.zzmh = blArray;
        }
        this.zzmh[n] = bl;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.zzbt();
        zzdd.checkNotNull(collection);
        if (!(collection instanceof zzbs)) {
            return super.addAll(collection);
        }
        zzbs zzbs2 = (zzbs)collection;
        if (zzbs2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzbs2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzbs2.size;
        if (n > this.zzmh.length) {
            this.zzmh = Arrays.copyOf(this.zzmh, n);
        }
        System.arraycopy(zzbs2.zzmh, 0, this.zzmh, this.size, zzbs2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzbt();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzmh[i])) continue;
            System.arraycopy(this.zzmh, i + 1, this.zzmh, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzh(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
    }

    private final String zzi(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzbs zzbs2 = this;
        zzbs2.zzbt();
        zzbs2.zzh(n);
        boolean bl3 = zzbs2.zzmh[n];
        zzbs2.zzmh[n] = bl2;
        return bl3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzbs zzbs2 = this;
        zzbs2.zzbt();
        zzbs2.zzh(n);
        boolean bl = zzbs2.zzmh[n];
        if (n < zzbs2.size - 1) {
            System.arraycopy(zzbs2.zzmh, n + 1, zzbs2.zzmh, n, zzbs2.size - n);
        }
        --zzbs2.size;
        ++zzbs2.modCount;
        return bl;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Boolean bl = (Boolean)object;
        this.zza(n, bl);
    }

    @Override
    public final /* synthetic */ zzdg zzj(int n) {
        int n2 = n;
        zzbs zzbs2 = this;
        if (n2 < zzbs2.size) {
            throw new IllegalArgumentException();
        }
        return new zzbs(Arrays.copyOf(zzbs2.zzmh, n2), zzbs2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzbs zzbs2 = this;
        zzbs2.zzh(n);
        return zzbs2.zzmh[n];
    }

    static {
        zzmg.zzbs();
    }
}

