/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.firebase_auth.zzax;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.EmailAuthProvider;
import com.google.firebase.auth.FirebaseAuthSettings;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.SignInMethodQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.api.internal.zzao;
import com.google.firebase.auth.api.internal.zzce;
import com.google.firebase.auth.api.internal.zzcn;
import com.google.firebase.auth.api.internal.zzcp;
import com.google.firebase.auth.api.internal.zzcq;
import com.google.firebase.auth.api.internal.zzcw;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.auth.internal.zzaa;
import com.google.firebase.auth.internal.zzab;
import com.google.firebase.auth.internal.zzad;
import com.google.firebase.auth.internal.zzae;
import com.google.firebase.auth.internal.zzf;
import com.google.firebase.auth.internal.zzk;
import com.google.firebase.auth.internal.zzl;
import com.google.firebase.auth.internal.zzw;
import com.google.firebase.auth.internal.zzy;
import com.google.firebase.auth.zzi;
import com.google.firebase.auth.zzj;
import com.google.firebase.auth.zzm;
import com.google.firebase.auth.zzn;
import com.google.firebase.auth.zzo;
import com.google.firebase.internal.InternalTokenResult;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class FirebaseAuth
implements InternalAuthProvider {
    private FirebaseApp zzeb;
    private final List<IdTokenListener> zzec;
    private final List<com.google.firebase.auth.internal.IdTokenListener> zzed;
    private List<AuthStateListener> zzee;
    private zzao zzef;
    private FirebaseUser zzeg;
    private zzk zzeh;
    private final Object zzei;
    private String zzej;
    private zzaa zzek;
    private zzab zzel;
    private zzad zzem;

    @Keep
    public static FirebaseAuth getInstance() {
        return (FirebaseAuth)FirebaseApp.getInstance().get(FirebaseAuth.class);
    }

    @Keep
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return (FirebaseAuth)firebaseApp.get(FirebaseAuth.class);
    }

    public FirebaseAuth(FirebaseApp firebaseApp) {
        FirebaseApp firebaseApp2 = firebaseApp;
        zzcp zzcp2 = new zzcq(firebaseApp2.getOptions().getApiKey()).zzah();
        this(firebaseApp, zzcn.zza(firebaseApp2.getApplicationContext(), zzcp2), new zzaa(firebaseApp.getApplicationContext(), firebaseApp.getPersistenceKey()));
    }

    @VisibleForTesting
    private FirebaseAuth(FirebaseApp firebaseApp, zzao zzao2, zzaa zzaa2) {
        com.google.android.gms.internal.firebase_auth.zzao zzao3;
        this.zzei = new Object();
        this.zzeb = (FirebaseApp)Preconditions.checkNotNull((Object)firebaseApp);
        this.zzef = (zzao)Preconditions.checkNotNull((Object)zzao2);
        this.zzek = (zzaa)Preconditions.checkNotNull((Object)zzaa2);
        this.zzeh = new zzk();
        this.zzec = new CopyOnWriteArrayList<IdTokenListener>();
        this.zzed = new CopyOnWriteArrayList<com.google.firebase.auth.internal.IdTokenListener>();
        this.zzee = new CopyOnWriteArrayList<AuthStateListener>();
        this.zzem = zzad.zzbn();
        FirebaseAuth firebaseAuth = this;
        firebaseAuth.zzeg = firebaseAuth.zzek.zzbl();
        if (firebaseAuth.zzeg != null && (zzao3 = firebaseAuth.zzek.zzh(firebaseAuth.zzeg)) != null) {
            firebaseAuth.zza(firebaseAuth.zzeg, zzao3, false);
        }
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.zzeg;
    }

    @Nullable
    public String getUid() {
        if (this.zzeg == null) {
            return null;
        }
        return this.zzeg.getUid();
    }

    public final void zza(@NonNull FirebaseUser firebaseUser, @NonNull com.google.android.gms.internal.firebase_auth.zzao zzao2, boolean bl) {
        boolean bl2;
        boolean bl3;
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)zzao2);
        if (this.zzeg == null) {
            bl3 = true;
            bl2 = true;
        } else {
            String string;
            String string2 = this.zzeg.zzp().zzaw();
            boolean bl4 = !string2.equals(string = zzao2.zzaw());
            boolean bl5 = this.zzeg.getUid().equals(firebaseUser.getUid());
            bl3 = !bl5 || bl4;
            bl2 = !bl5;
        }
        boolean bl6 = bl2;
        boolean bl7 = bl;
        FirebaseUser firebaseUser2 = firebaseUser;
        FirebaseAuth firebaseAuth = this;
        Preconditions.checkNotNull((Object)firebaseUser2);
        if (firebaseAuth.zzeg == null) {
            firebaseAuth.zzeg = firebaseUser2;
        } else {
            firebaseAuth.zzeg.zza(firebaseUser2.getProviderData());
            if (!firebaseUser2.isAnonymous()) {
                firebaseAuth.zzeg.zzn();
            }
        }
        if (bl7) {
            firebaseAuth.zzek.zzg(firebaseAuth.zzeg);
        }
        if (bl3) {
            if (this.zzeg != null) {
                this.zzeg.zza(zzao2);
            }
            this.zzb(this.zzeg);
        }
        if (bl6) {
            this.zzc(this.zzeg);
        }
        if (bl) {
            this.zzek.zza(firebaseUser, zzao2);
        }
        firebaseAuth = this;
        firebaseAuth.zzl().zzc(firebaseAuth.zzeg.zzp());
    }

    public final void zzk() {
        if (this.zzeg != null) {
            FirebaseUser firebaseUser = this.zzeg;
            zzaa zzaa2 = this.zzek;
            Preconditions.checkNotNull((Object)firebaseUser);
            zzaa2.clear(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()));
            this.zzeg = null;
        }
        this.zzek.clear("com.google.firebase.auth.FIREBASE_USER");
        this.zzb(null);
        this.zzc(null);
    }

    @VisibleForTesting
    private final synchronized void zza(zzab zzab2) {
        this.zzel = zzab2;
        this.zzeb.setIdTokenListenersCountChangedListener((FirebaseApp.IdTokenListenersCountChangedListener)zzab2);
    }

    @VisibleForTesting
    private final synchronized zzab zzl() {
        if (this.zzel == null) {
            this.zza(new zzab(this.zzeb));
        }
        return this.zzel;
    }

    public FirebaseApp getApp() {
        return this.zzeb;
    }

    public void addIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzec.add(idTokenListener);
        this.zzem.execute(new zzi(this, idTokenListener));
    }

    @KeepForSdk
    public void addIdTokenListener(@NonNull com.google.firebase.auth.internal.IdTokenListener idTokenListener) {
        Preconditions.checkNotNull((Object)idTokenListener);
        this.zzed.add(idTokenListener);
        this.zzel.zzf(this.zzed.size());
    }

    public void removeIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzec.remove(idTokenListener);
    }

    @KeepForSdk
    public void removeIdTokenListener(@NonNull com.google.firebase.auth.internal.IdTokenListener idTokenListener) {
        Preconditions.checkNotNull((Object)idTokenListener);
        this.zzed.remove(idTokenListener);
        this.zzel.zzf(this.zzed.size());
    }

    public void addAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzee.add(authStateListener);
        this.zzem.execute(new zzj(this, authStateListener));
    }

    public void removeAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzee.remove(authStateListener);
    }

    private final void zzb(@Nullable FirebaseUser firebaseUser) {
        String string;
        if (firebaseUser != null) {
            string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(45 + String.valueOf(string).length()).append("Notifying id token listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying id token listeners about a sign-out event.");
        }
        string = firebaseUser != null ? firebaseUser.zzr() : null;
        InternalTokenResult internalTokenResult = new InternalTokenResult(string);
        this.zzem.execute(new com.google.firebase.auth.zzk(this, internalTokenResult));
    }

    private final void zzc(@Nullable FirebaseUser firebaseUser) {
        if (firebaseUser != null) {
            String string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(47 + String.valueOf(string).length()).append("Notifying auth state listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying auth state listeners about a sign-out event.");
        }
        this.zzem.execute(new com.google.firebase.auth.zzl(this));
    }

    @NonNull
    public Task<GetTokenResult> getAccessToken(boolean bl) {
        return this.zza(this.zzeg, bl);
    }

    @NonNull
    public final Task<GetTokenResult> zza(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            return Tasks.forException((Exception)zzce.zzb(new Status(17495)));
        }
        com.google.android.gms.internal.firebase_auth.zzao zzao2 = this.zzeg.zzp();
        if (zzao2.isValid() && !bl) {
            return Tasks.forResult((Object)zzy.zzag(zzao2.zzaw()));
        }
        return this.zzef.zza(this.zzeb, firebaseUser, zzao2.zzap(), (zzae)((Object)new zzm(this)));
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        if (authCredential instanceof EmailAuthCredential) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            if (!emailAuthCredential.zzj()) {
                return this.zzef.zzb(this.zzeb, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), new zza());
            }
            return this.zzef.zza(this.zzeb, emailAuthCredential, (com.google.firebase.auth.internal.zza)new zza());
        }
        if (authCredential instanceof PhoneAuthCredential) {
            PhoneAuthCredential phoneAuthCredential = (PhoneAuthCredential)authCredential;
            return this.zzef.zza(this.zzeb, phoneAuthCredential, (com.google.firebase.auth.internal.zza)new zza());
        }
        return this.zzef.zza(this.zzeb, authCredential, (com.google.firebase.auth.internal.zza)new zza());
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            if ("password".equals(((AuthCredential)emailAuthCredential).getSignInMethod())) {
                return this.zzef.zza(this.zzeb, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzae)((Object)new zzb()));
            }
            return this.zzef.zza(this.zzeb, firebaseUser, emailAuthCredential, (zzae)((Object)new zzb()));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzef.zzb(this.zzeb, firebaseUser, (PhoneAuthCredential)authCredential, (zzae)((Object)new zzb()));
        }
        return this.zzef.zza(this.zzeb, firebaseUser, authCredential, (zzae)((Object)new zzb()));
    }

    public final Task<AuthResult> zzb(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            if ("password".equals(((AuthCredential)emailAuthCredential).getSignInMethod())) {
                return this.zzef.zzb(this.zzeb, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzae)((Object)new zzb()));
            }
            return this.zzef.zzb(this.zzeb, firebaseUser, emailAuthCredential, (zzae)((Object)new zzb()));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzef.zzc(this.zzeb, firebaseUser, authCredential, (zzae)((Object)new zzb()));
        }
        return this.zzef.zzb(this.zzeb, firebaseUser, authCredential, (zzae)((Object)new zzb()));
    }

    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzef.zza(this.zzeb, string, (com.google.firebase.auth.internal.zza)new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        return this.zzef.zzb(this.zzeb, string, string2, new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithEmailLink(@NonNull String string, @NonNull String string2) {
        return this.signInWithCredential(EmailAuthProvider.getCredentialWithLink(string, string2));
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        if (this.zzeg != null && this.zzeg.isAnonymous()) {
            zzl zzl2 = (zzl)this.zzeg;
            zzl2.zze(false);
            return Tasks.forResult((Object)new zzf(zzl2));
        }
        return this.zzef.zza(this.zzeb, new zza());
    }

    @NonNull
    public final void zza(@NonNull String string, long l, TimeUnit timeUnit, @NonNull PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks, @Nullable Activity activity, @NonNull Executor executor, boolean bl) {
        long l2 = TimeUnit.SECONDS.convert(l, timeUnit);
        if (l2 < 0L || l2 > 120L) {
            throw new IllegalArgumentException("We only support 0-120 seconds for sms-auto-retrieval timeout");
        }
        zzax zzax2 = new zzax(string, l2, bl, this.zzej);
        if (this.zzeh.zzbf() && string.equals(this.zzeh.getPhoneNumber())) {
            PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks2 = onVerificationStateChangedCallbacks;
            FirebaseAuth firebaseAuth = this;
            onVerificationStateChangedCallbacks = new zzn(firebaseAuth, onVerificationStateChangedCallbacks2);
        }
        this.zzef.zza(this.zzeb, zzax2, onVerificationStateChangedCallbacks, activity, executor);
    }

    public Task<Void> updateCurrentUser(@NonNull FirebaseUser firebaseUser) {
        if (firebaseUser == null) {
            throw new IllegalArgumentException("Cannot update current user with null user!");
        }
        String string = firebaseUser.zzo().getOptions().getApiKey();
        String string2 = this.zzeb.getOptions().getApiKey();
        if (firebaseUser.zzp().isValid() && string2.equals(string)) {
            FirebaseUser firebaseUser2 = zzl.zza(this.zzeb, firebaseUser);
            this.zza(firebaseUser2, firebaseUser.zzp(), true);
            return Tasks.forResult(null);
        }
        return this.zza(firebaseUser, (zzae)((Object)new zzc(this)));
    }

    public final Task<Void> zzd(@NonNull FirebaseUser firebaseUser) {
        return this.zza(firebaseUser, (zzae)((Object)new zzb()));
    }

    @NonNull
    private final Task<Void> zza(@NonNull FirebaseUser firebaseUser, zzae zzae2) {
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zzef.zza(this.zzeb, firebaseUser, zzae2);
    }

    @NonNull
    public final Task<AuthResult> zzc(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zzef.zzd(this.zzeb, firebaseUser, authCredential, (zzae)((Object)new zzb()));
    }

    @NonNull
    public final Task<AuthResult> zza(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zzef.zzd(this.zzeb, firebaseUser, string, (zzae)((Object)new zzb()));
    }

    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        return this.zzef.zza(this.zzeb, string, string2, new zza());
    }

    @Deprecated
    @NonNull
    public Task<ProviderQueryResult> fetchProvidersForEmail(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzef.zza(this.zzeb, string);
    }

    @NonNull
    public Task<SignInMethodQueryResult> fetchSignInMethodsForEmail(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzef.zzb(this.zzeb, string);
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)((Object)userProfileChangeRequest));
        return this.zzef.zza(this.zzeb, firebaseUser, userProfileChangeRequest, (zzae)((Object)new zzb()));
    }

    @NonNull
    public final Task<Void> zzb(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotEmpty((String)string);
        return this.zzef.zzb(this.zzeb, firebaseUser, string, (zzae)((Object)new zzb()));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull PhoneAuthCredential phoneAuthCredential) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)phoneAuthCredential);
        return this.zzef.zza(this.zzeb, firebaseUser, phoneAuthCredential, (zzae)((Object)new zzb()));
    }

    @NonNull
    public final Task<Void> zzc(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotEmpty((String)string);
        return this.zzef.zzc(this.zzeb, firebaseUser, string, (zzae)((Object)new zzb()));
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.sendPasswordResetEmail(string, null);
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string, @Nullable ActionCodeSettings actionCodeSettings) {
        Preconditions.checkNotEmpty((String)string);
        if (actionCodeSettings == null) {
            actionCodeSettings = ActionCodeSettings.zze();
        }
        if (this.zzej != null) {
            actionCodeSettings.zza(this.zzej);
        }
        actionCodeSettings.zzb(1);
        return this.zzef.zza(this.zzeb, string, actionCodeSettings);
    }

    public Task<Void> sendSignInLinkToEmail(@NonNull String string, @NonNull ActionCodeSettings actionCodeSettings) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)actionCodeSettings));
        if (!actionCodeSettings.canHandleCodeInApp()) {
            throw new IllegalArgumentException("You must set canHandleCodeInApp in your ActionCodeSettings to true for Email-Link Sign-in.");
        }
        if (this.zzej != null) {
            actionCodeSettings.zza(this.zzej);
        }
        return this.zzef.zzb(this.zzeb, string, actionCodeSettings);
    }

    public boolean isSignInWithEmailLink(@NonNull String string) {
        return EmailAuthCredential.isSignInWithEmailLink(string);
    }

    @NonNull
    public final Task<Void> zza(@Nullable ActionCodeSettings actionCodeSettings, @NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        if (this.zzej != null) {
            if (actionCodeSettings == null) {
                actionCodeSettings = ActionCodeSettings.zze();
            }
            actionCodeSettings.zza(this.zzej);
        }
        return this.zzef.zza(this.zzeb, actionCodeSettings, string);
    }

    @NonNull
    public Task<ActionCodeResult> checkActionCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzef.zzc(this.zzeb, string);
    }

    @NonNull
    public Task<Void> applyActionCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzef.zzd(this.zzeb, string);
    }

    @NonNull
    public Task<String> verifyPasswordResetCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzef.zze(this.zzeb, string);
    }

    @NonNull
    public Task<Void> confirmPasswordReset(@NonNull String string, @NonNull String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        return this.zzef.zza(this.zzeb, string, string2);
    }

    @NonNull
    public final Task<Void> zze(@NonNull FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zzef.zza(firebaseUser, new zzo(this, firebaseUser));
    }

    public void signOut() {
        this.zzk();
        if (this.zzel != null) {
            this.zzel.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLanguageCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        Object object = this.zzei;
        synchronized (object) {
            this.zzej = string;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getLanguageCode() {
        Object object = this.zzei;
        synchronized (object) {
            return this.zzej;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useAppLanguage() {
        Object object = this.zzei;
        synchronized (object) {
            this.zzej = zzcw.zzal();
            return;
        }
    }

    public FirebaseAuthSettings getFirebaseAuthSettings() {
        return this.zzeh;
    }

    public Task<Void> setFirebaseUIVersion(@Nullable String string) {
        return this.zzef.setFirebaseUIVersion(string);
    }

    static /* synthetic */ FirebaseApp zza(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzeb;
    }

    static /* synthetic */ List zzb(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzed;
    }

    static /* synthetic */ List zzc(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzec;
    }

    static /* synthetic */ List zzd(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzee;
    }

    static /* synthetic */ zzk zze(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzeh;
    }

    static /* synthetic */ FirebaseUser zzf(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzeg;
    }

    final class zzc
    extends zza
    implements com.google.firebase.auth.internal.zza,
    zzw {
        zzc(FirebaseAuth firebaseAuth) {
        }

        @Override
        public final void zza(Status status) {
        }
    }

    @VisibleForTesting
    final class zzb
    extends zza
    implements com.google.firebase.auth.internal.zza,
    zzw {
        zzb() {
        }

        @Override
        public final void zza(Status status) {
            if (status.getStatusCode() == 17011 || status.getStatusCode() == 17021 || status.getStatusCode() == 17005) {
                FirebaseAuth.this.signOut();
            }
        }
    }

    @VisibleForTesting
    class zza
    implements com.google.firebase.auth.internal.zza {
        zza() {
        }

        @Override
        public final void zza(@NonNull com.google.android.gms.internal.firebase_auth.zzao zzao2, @NonNull FirebaseUser firebaseUser) {
            Preconditions.checkNotNull((Object)zzao2);
            Preconditions.checkNotNull((Object)firebaseUser);
            firebaseUser.zza(zzao2);
            FirebaseAuth.this.zza(firebaseUser, zzao2, true);
        }
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }

    public static interface IdTokenListener {
        public void onIdTokenChanged(@NonNull FirebaseAuth var1);
    }
}

