/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.api.internal;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseExceptionMapper;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.SignInMethodQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.api.internal.zzah;
import com.google.firebase.auth.api.internal.zzai;
import com.google.firebase.auth.api.internal.zzaj;
import com.google.firebase.auth.api.internal.zzak;
import com.google.firebase.auth.api.internal.zzal;
import com.google.firebase.auth.api.internal.zzap;
import com.google.firebase.auth.api.internal.zzaq;
import com.google.firebase.auth.api.internal.zzar;
import com.google.firebase.auth.api.internal.zzas;
import com.google.firebase.auth.api.internal.zzat;
import com.google.firebase.auth.api.internal.zzau;
import com.google.firebase.auth.api.internal.zzav;
import com.google.firebase.auth.api.internal.zzaw;
import com.google.firebase.auth.api.internal.zzax;
import com.google.firebase.auth.api.internal.zzay;
import com.google.firebase.auth.api.internal.zzaz;
import com.google.firebase.auth.api.internal.zzba;
import com.google.firebase.auth.api.internal.zzbb;
import com.google.firebase.auth.api.internal.zzbc;
import com.google.firebase.auth.api.internal.zzbd;
import com.google.firebase.auth.api.internal.zzbe;
import com.google.firebase.auth.api.internal.zzbf;
import com.google.firebase.auth.api.internal.zzbg;
import com.google.firebase.auth.api.internal.zzbh;
import com.google.firebase.auth.api.internal.zzbi;
import com.google.firebase.auth.api.internal.zzbj;
import com.google.firebase.auth.api.internal.zzbk;
import com.google.firebase.auth.api.internal.zzbl;
import com.google.firebase.auth.api.internal.zzbm;
import com.google.firebase.auth.api.internal.zzbn;
import com.google.firebase.auth.api.internal.zzbo;
import com.google.firebase.auth.api.internal.zzbp;
import com.google.firebase.auth.api.internal.zzbq;
import com.google.firebase.auth.api.internal.zzbr;
import com.google.firebase.auth.api.internal.zzbs;
import com.google.firebase.auth.api.internal.zzbt;
import com.google.firebase.auth.api.internal.zzbu;
import com.google.firebase.auth.api.internal.zzbv;
import com.google.firebase.auth.api.internal.zzbw;
import com.google.firebase.auth.api.internal.zzbx;
import com.google.firebase.auth.api.internal.zzby;
import com.google.firebase.auth.api.internal.zzbz;
import com.google.firebase.auth.api.internal.zzca;
import com.google.firebase.auth.api.internal.zzce;
import com.google.firebase.auth.api.internal.zzcn;
import com.google.firebase.auth.api.internal.zzcp;
import com.google.firebase.auth.api.internal.zzcy;
import com.google.firebase.auth.internal.zza;
import com.google.firebase.auth.internal.zzae;
import com.google.firebase.auth.internal.zzh;
import com.google.firebase.auth.internal.zzl;
import com.google.firebase.auth.internal.zzn;
import com.google.firebase.auth.internal.zzv;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;

public final class zzao
extends zzah {
    @NonNull
    private final Context zzgs;
    @NonNull
    private final zzcp zzgt;

    zzao(@NonNull Context context, @NonNull zzcp zzcp2) {
        this.zzgs = context;
        this.zzgt = zzcp2;
    }

    @Override
    final zzai zzw() {
        int n = DynamiteModule.getRemoteVersion((Context)this.zzgs, (String)"com.google.android.gms.firebase_auth");
        GoogleApi<zzcp> googleApi = this.zzb(false);
        int n2 = DynamiteModule.getLocalVersion((Context)this.zzgs, (String)"com.google.firebase.auth");
        GoogleApi<zzcp> googleApi2 = n2 != 0 ? this.zzb(true) : null;
        zzak zzak2 = new zzak(n, n2, Collections.emptyMap(), true);
        return new zzai<zzcp>(googleApi, googleApi2, zzak2);
    }

    @NonNull
    private final GoogleApi<zzcp> zzb(boolean bl) {
        boolean bl2;
        zzcp zzcp2 = (zzcp)((zzaj)this.zzgt).clone();
        ((zzcp)((zzaj)this.zzgt).clone()).zzgn = bl2 = bl;
        return new zzal<zzcp>(this.zzgs, zzcn.zzhn, zzcp2, (StatusExceptionMapper)new FirebaseExceptionMapper());
    }

    public final Task<GetTokenResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzae zzae2) {
        return this.zza(zzao.zza(new zzaw(string).zza(firebaseApp).zzf(firebaseUser).zza((FirebaseApp)zzae2).zza(zzae2), "getAccessToken"));
    }

    public final Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull zza zza2) {
        return this.zzb(zzao.zza(new zzbp(string).zza(firebaseApp).zza((FirebaseApp)zza2), "signInWithCustomToken"));
    }

    public final Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull AuthCredential authCredential, @NonNull zza zza2) {
        return this.zzb(zzao.zza(new zzbo(authCredential).zza(firebaseApp).zza((FirebaseApp)zza2), "signInWithCredential"));
    }

    public final Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential, @NonNull zzae zzae2) {
        return this.zzb(zzao.zza(new zzbc(authCredential).zza(firebaseApp).zzf(firebaseUser).zza((FirebaseApp)zzae2).zza(zzae2), "reauthenticateWithCredential"));
    }

    public final Task<AuthResult> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential, @NonNull zzae zzae2) {
        return this.zzb(zzao.zza(new zzbd(authCredential).zza(firebaseApp).zzf(firebaseUser).zza((FirebaseApp)zzae2).zza(zzae2), "reauthenticateWithCredentialWithData"));
    }

    public final Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull zza zza2) {
        return this.zzb(zzao.zza(new zzbn().zza(firebaseApp).zza((FirebaseApp)zza2), "signInAnonymously"));
    }

    public final void zza(@NonNull FirebaseApp firebaseApp, @NonNull com.google.android.gms.internal.firebase_auth.zzax zzax2, @NonNull PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks, @Nullable Activity activity, @NonNull Executor executor) {
        this.zzb(zzao.zza(new zzca(zzax2).zza(firebaseApp).zza(onVerificationStateChangedCallbacks, activity, executor), "verifyPhoneNumber"));
    }

    public final Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest, @NonNull zzae zzae2) {
        return this.zzb(zzao.zza(new zzby(userProfileChangeRequest).zza(firebaseApp).zzf(firebaseUser).zza((FirebaseApp)zzae2).zza(zzae2), "updateProfile"));
    }

    public final Task<Void> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzae zzae2) {
        return this.zzb(zzao.zza(new zzbv(string).zza(firebaseApp).zzf(firebaseUser).zza((FirebaseApp)zzae2).zza(zzae2), "updateEmail"));
    }

    public final Task<Void> zzc(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzae zzae2) {
        return this.zzb(zzao.zza(new zzbw(string).zza(firebaseApp).zzf(firebaseUser).zza((FirebaseApp)zzae2).zza(zzae2), "updatePassword"));
    }

    public final Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull PhoneAuthCredential phoneAuthCredential, @NonNull zzae zzae2) {
        return this.zzb(zzao.zza(new zzbx(phoneAuthCredential).zza(firebaseApp).zzf(firebaseUser).zza((FirebaseApp)zzae2).zza(zzae2), "updatePhoneNumber"));
    }

    public final Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull String string2, @NonNull zza zza2) {
        return this.zzb(zzao.zza(new zzas(string, string2).zza(firebaseApp).zza((FirebaseApp)zza2), "createUserWithEmailAndPassword"));
    }

    public final Task<AuthResult> zzb(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull String string2, @NonNull zza zza2) {
        return this.zzb(zzao.zza(new zzbq(string, string2).zza(firebaseApp).zza((FirebaseApp)zza2), "signInWithEmailAndPassword"));
    }

    public final Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull EmailAuthCredential emailAuthCredential, @NonNull zza zza2) {
        return this.zzb(zzao.zza(new zzbr(emailAuthCredential).zza(firebaseApp).zza((FirebaseApp)zza2), "sendSignInLinkToEmail"));
    }

    public final Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull String string2, @NonNull zzae zzae2) {
        return this.zzb(zzao.zza(new zzbg(string, string2).zza(firebaseApp).zzf(firebaseUser).zza((FirebaseApp)zzae2).zza(zzae2), "reauthenticateWithEmailPassword"));
    }

    public final Task<AuthResult> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull String string2, @NonNull zzae zzae2) {
        return this.zzb(zzao.zza(new zzbh(string, string2).zza(firebaseApp).zzf(firebaseUser).zza((FirebaseApp)zzae2).zza(zzae2), "reauthenticateWithEmailPasswordWithData"));
    }

    public final Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull EmailAuthCredential emailAuthCredential, @NonNull zzae zzae2) {
        return this.zzb(zzao.zza(new zzbe(emailAuthCredential).zza(firebaseApp).zzf(firebaseUser).zza((FirebaseApp)zzae2).zza(zzae2), "reauthenticateWithEmailLink"));
    }

    public final Task<AuthResult> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull EmailAuthCredential emailAuthCredential, @NonNull zzae zzae2) {
        return this.zzb(zzao.zza(new zzbf(emailAuthCredential).zza(firebaseApp).zzf(firebaseUser).zza((FirebaseApp)zzae2).zza(zzae2), "reauthenticateWithEmailLinkWithData"));
    }

    public final Task<AuthResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull PhoneAuthCredential phoneAuthCredential, @NonNull zza zza2) {
        return this.zzb(zzao.zza(new zzbs(phoneAuthCredential).zza(firebaseApp).zza((FirebaseApp)zza2), "signInWithPhoneNumber"));
    }

    public final Task<Void> zzb(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull PhoneAuthCredential phoneAuthCredential, @NonNull zzae zzae2) {
        return this.zzb(zzao.zza(new zzbi(phoneAuthCredential).zza(firebaseApp).zzf(firebaseUser).zza((FirebaseApp)zzae2).zza(zzae2), "reauthenticateWithPhoneCredential"));
    }

    public final Task<AuthResult> zzc(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential, @NonNull zzae zzae2) {
        return this.zzb(zzao.zza(new zzbd(authCredential).zza(firebaseApp).zzf(firebaseUser).zza((FirebaseApp)zzae2).zza(zzae2), "reauthenticateWithPhoneCredentialWithData"));
    }

    public final Task<ProviderQueryResult> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.zza(zzao.zza(new zzau(string).zza(firebaseApp), "fetchProvidersForEmail"));
    }

    public final Task<SignInMethodQueryResult> zzb(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.zza(zzao.zza(new zzav(string).zza(firebaseApp), "fetchSignInMethodsForEmail"));
    }

    public final Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull ActionCodeSettings actionCodeSettings) {
        actionCodeSettings.zzb(1);
        return this.zzb(zzao.zza(new zzbl(string, actionCodeSettings).zza(firebaseApp), "sendPasswordResetEmail"));
    }

    public final Task<Void> zzb(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull ActionCodeSettings actionCodeSettings) {
        actionCodeSettings.zzb(6);
        return this.zzb(zzao.zza(new zzbl(string, actionCodeSettings).zza(firebaseApp), "sendSignInLinkToEmail"));
    }

    public final Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull ActionCodeSettings actionCodeSettings, @NonNull String string) {
        return this.zzb(zzao.zza(new zzbk(string, actionCodeSettings).zza(firebaseApp), "sendEmailVerification"));
    }

    public final Task<ActionCodeResult> zzc(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.zzb(zzao.zza(new zzaq(string).zza(firebaseApp), "checkActionCode"));
    }

    public final Task<Void> zzd(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.zzb(zzao.zza(new zzap(string).zza(firebaseApp), "applyActionCode"));
    }

    public final Task<String> zze(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        return this.zzb(zzao.zza(new zzbz(string).zza(firebaseApp), "verifyPasswordResetCode"));
    }

    public final Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull String string, @NonNull String string2) {
        return this.zzb(zzao.zza(new zzar(string, string2).zza(firebaseApp), "confirmPasswordReset"));
    }

    public final Task<AuthResult> zzd(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential, @NonNull zzae zzae2) {
        Preconditions.checkNotNull((Object)firebaseApp);
        Preconditions.checkNotNull((Object)((Object)authCredential));
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)zzae2);
        List<String> list = firebaseUser.getProviders();
        if (list != null && list.contains(authCredential.getProvider())) {
            return Tasks.forException((Exception)zzce.zzb(new Status(17015)));
        }
        if (authCredential instanceof EmailAuthCredential) {
            if (!((EmailAuthCredential)authCredential).zzj()) {
                zzae zzae3 = zzae2;
                FirebaseUser firebaseUser2 = firebaseUser;
                EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
                FirebaseApp firebaseApp2 = firebaseApp;
                return this.zzb(zzao.zza(new zzax(emailAuthCredential).zza(firebaseApp2).zzf(firebaseUser2).zza((FirebaseApp)zzae3).zza(zzae3), "linkEmailAuthCredential"));
            }
            zzae zzae4 = zzae2;
            FirebaseUser firebaseUser3 = firebaseUser;
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            FirebaseApp firebaseApp3 = firebaseApp;
            return this.zzb(zzao.zza(new zzba(emailAuthCredential).zza(firebaseApp3).zzf(firebaseUser3).zza((FirebaseApp)zzae4).zza(zzae4), "linkEmailAuthCredential"));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            zzae zzae5 = zzae2;
            FirebaseUser firebaseUser4 = firebaseUser;
            PhoneAuthCredential phoneAuthCredential = (PhoneAuthCredential)authCredential;
            FirebaseApp firebaseApp4 = firebaseApp;
            return this.zzb(zzao.zza(new zzaz(phoneAuthCredential).zza(firebaseApp4).zzf(firebaseUser4).zza((FirebaseApp)zzae5).zza(zzae5), "linkPhoneAuthCredential"));
        }
        zzae zzae6 = zzae2;
        FirebaseUser firebaseUser5 = firebaseUser;
        AuthCredential authCredential2 = authCredential;
        FirebaseApp firebaseApp5 = firebaseApp;
        zzao zzao2 = this;
        Preconditions.checkNotNull((Object)firebaseApp5);
        Preconditions.checkNotNull((Object)((Object)authCredential2));
        Preconditions.checkNotNull((Object)firebaseUser5);
        Preconditions.checkNotNull((Object)zzae6);
        return zzao2.zzb(zzao.zza(new zzay(authCredential2).zza(firebaseApp5).zzf(firebaseUser5).zza((FirebaseApp)zzae6).zza(zzae6), "linkFederatedCredential"));
    }

    public final Task<AuthResult> zzd(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull String string, @NonNull zzae zzae2) {
        Preconditions.checkNotNull((Object)firebaseApp);
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)zzae2);
        List<String> list = firebaseUser.getProviders();
        if (list != null && !list.contains(string) || firebaseUser.isAnonymous()) {
            return Tasks.forException((Exception)zzce.zzb(new Status(17016, string)));
        }
        switch (string) {
            case "password": {
                zzae zzae3 = zzae2;
                FirebaseUser firebaseUser2 = firebaseUser;
                FirebaseApp firebaseApp2 = firebaseApp;
                return this.zzb(zzao.zza(new zzbt().zza(firebaseApp2).zzf(firebaseUser2).zza((FirebaseApp)zzae3).zza(zzae3), "unlinkEmailCredential"));
            }
        }
        zzae zzae4 = zzae2;
        FirebaseUser firebaseUser3 = firebaseUser;
        String string2 = string;
        FirebaseApp firebaseApp3 = firebaseApp;
        return this.zzb(zzao.zza(new zzbu(string2).zza(firebaseApp3).zzf(firebaseUser3).zza((FirebaseApp)zzae4).zza(zzae4), "unlinkFederatedCredential"));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseApp firebaseApp, @NonNull FirebaseUser firebaseUser, @NonNull zzae zzae2) {
        return this.zza(zzao.zza(new zzbj().zza(firebaseApp).zzf(firebaseUser).zza((FirebaseApp)zzae2).zza(zzae2), "reload"));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull zzv zzv2) {
        return this.zzb(zzao.zza(new zzat().zzf(firebaseUser).zza(zzv2).zza(zzv2), "delete"));
    }

    @NonNull
    public final Task<Void> setFirebaseUIVersion(@NonNull String string) {
        return this.zzb(zzao.zza(new zzbm(string), "setFirebaseUIVersion"));
    }

    @NonNull
    @VisibleForTesting
    static zzl zza(@NonNull FirebaseApp firebaseApp, @NonNull com.google.android.gms.internal.firebase_auth.zzaj zzaj2) {
        Preconditions.checkNotNull((Object)firebaseApp);
        Preconditions.checkNotNull((Object)((Object)zzaj2));
        ArrayList<zzh> arrayList = new ArrayList<zzh>();
        zzh zzh2 = new zzh(zzaj2, "firebase");
        arrayList.add(zzh2);
        List<com.google.android.gms.internal.firebase_auth.zzaq> list = zzaj2.zzat();
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add(new zzh(list.get(i)));
            }
        }
        zzl zzl2 = new zzl(firebaseApp, arrayList);
        zzn zzn2 = new zzn(zzaj2.getLastSignInTimestamp(), zzaj2.getCreationTimestamp());
        zzl2.zza(zzn2);
        zzl2.zze(zzaj2.isNewUser());
        zzl2.zzc(zzaj2.zzav());
        return zzl2;
    }

    private static <ResultT, CallbackT> zzbb<ResultT, CallbackT> zza(zzcy<ResultT, CallbackT> zzcy2, String string) {
        return new zzbb<ResultT, CallbackT>(zzcy2, string);
    }
}

