/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.firebase_auth.zzap;
import com.google.android.gms.internal.firebase_auth.zzay;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.EmailAuthProvider;
import com.google.firebase.auth.FirebaseAuthSettings;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.SignInMethodQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.api.internal.zzao;
import com.google.firebase.auth.api.internal.zzcf;
import com.google.firebase.auth.api.internal.zzco;
import com.google.firebase.auth.api.internal.zzcq;
import com.google.firebase.auth.api.internal.zzcr;
import com.google.firebase.auth.api.internal.zzcx;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.auth.internal.zzaa;
import com.google.firebase.auth.internal.zzab;
import com.google.firebase.auth.internal.zzad;
import com.google.firebase.auth.internal.zzae;
import com.google.firebase.auth.internal.zzf;
import com.google.firebase.auth.internal.zzk;
import com.google.firebase.auth.internal.zzl;
import com.google.firebase.auth.internal.zzw;
import com.google.firebase.auth.internal.zzy;
import com.google.firebase.auth.zzi;
import com.google.firebase.auth.zzj;
import com.google.firebase.auth.zzm;
import com.google.firebase.auth.zzn;
import com.google.firebase.auth.zzo;
import com.google.firebase.internal.InternalTokenResult;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class FirebaseAuth
implements InternalAuthProvider {
    private FirebaseApp zzef;
    private final List<IdTokenListener> zzeg;
    private final List<com.google.firebase.auth.internal.IdTokenListener> zzeh;
    private List<AuthStateListener> zzei;
    private zzao zzej;
    private FirebaseUser zzek;
    private zzk zzel;
    private final Object zzem;
    private String zzen;
    private zzaa zzeo;
    private zzab zzep;
    private zzad zzeq;

    @Keep
    public static FirebaseAuth getInstance() {
        return (FirebaseAuth)FirebaseApp.getInstance().get(FirebaseAuth.class);
    }

    @Keep
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return (FirebaseAuth)firebaseApp.get(FirebaseAuth.class);
    }

    public FirebaseAuth(FirebaseApp firebaseApp) {
        FirebaseApp firebaseApp2 = firebaseApp;
        zzcq zzcq2 = new zzcr(firebaseApp2.getOptions().getApiKey()).zzaj();
        this(firebaseApp, zzco.zza(firebaseApp2.getApplicationContext(), zzcq2), new zzaa(firebaseApp.getApplicationContext(), firebaseApp.getPersistenceKey()));
    }

    @VisibleForTesting
    private FirebaseAuth(FirebaseApp firebaseApp, zzao zzao2, zzaa zzaa2) {
        zzap zzap2;
        this.zzem = new Object();
        this.zzef = (FirebaseApp)Preconditions.checkNotNull((Object)firebaseApp);
        this.zzej = (zzao)Preconditions.checkNotNull((Object)zzao2);
        this.zzeo = (zzaa)Preconditions.checkNotNull((Object)zzaa2);
        this.zzel = new zzk();
        this.zzeg = new CopyOnWriteArrayList<IdTokenListener>();
        this.zzeh = new CopyOnWriteArrayList<com.google.firebase.auth.internal.IdTokenListener>();
        this.zzei = new CopyOnWriteArrayList<AuthStateListener>();
        this.zzeq = zzad.zzbq();
        FirebaseAuth firebaseAuth = this;
        firebaseAuth.zzek = firebaseAuth.zzeo.zzbo();
        if (firebaseAuth.zzek != null && (zzap2 = firebaseAuth.zzeo.zzh(firebaseAuth.zzek)) != null) {
            firebaseAuth.zza(firebaseAuth.zzek, zzap2, false);
        }
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.zzek;
    }

    @Nullable
    public String getUid() {
        if (this.zzek == null) {
            return null;
        }
        return this.zzek.getUid();
    }

    public final void zza(@NonNull FirebaseUser firebaseUser, @NonNull zzap zzap2, boolean bl) {
        boolean bl2;
        boolean bl3;
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)zzap2);
        if (this.zzek == null) {
            bl3 = true;
            bl2 = true;
        } else {
            String string;
            String string2 = this.zzek.zzr().zzaz();
            boolean bl4 = !string2.equals(string = zzap2.zzaz());
            boolean bl5 = this.zzek.getUid().equals(firebaseUser.getUid());
            bl3 = !bl5 || bl4;
            bl2 = !bl5;
        }
        boolean bl6 = bl2;
        boolean bl7 = bl;
        FirebaseUser firebaseUser2 = firebaseUser;
        FirebaseAuth firebaseAuth = this;
        Preconditions.checkNotNull((Object)firebaseUser2);
        if (firebaseAuth.zzek == null) {
            firebaseAuth.zzek = firebaseUser2;
        } else {
            firebaseAuth.zzek.zza(firebaseUser2.getProviderData());
            if (!firebaseUser2.isAnonymous()) {
                firebaseAuth.zzek.zzp();
            }
        }
        if (bl7) {
            firebaseAuth.zzeo.zzg(firebaseAuth.zzek);
        }
        if (bl3) {
            if (this.zzek != null) {
                this.zzek.zza(zzap2);
            }
            this.zzb(this.zzek);
        }
        if (bl6) {
            this.zzc(this.zzek);
        }
        if (bl) {
            this.zzeo.zza(firebaseUser, zzap2);
        }
        firebaseAuth = this;
        firebaseAuth.zzn().zzc(firebaseAuth.zzek.zzr());
    }

    public final void zzm() {
        if (this.zzek != null) {
            FirebaseUser firebaseUser = this.zzek;
            zzaa zzaa2 = this.zzeo;
            Preconditions.checkNotNull((Object)firebaseUser);
            zzaa2.clear(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()));
            this.zzek = null;
        }
        this.zzeo.clear("com.google.firebase.auth.FIREBASE_USER");
        this.zzb(null);
        this.zzc(null);
    }

    @VisibleForTesting
    private final synchronized void zza(zzab zzab2) {
        this.zzep = zzab2;
        this.zzef.setIdTokenListenersCountChangedListener((FirebaseApp.IdTokenListenersCountChangedListener)zzab2);
    }

    @VisibleForTesting
    private final synchronized zzab zzn() {
        if (this.zzep == null) {
            this.zza(new zzab(this.zzef));
        }
        return this.zzep;
    }

    public FirebaseApp getApp() {
        return this.zzef;
    }

    public void addIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzeg.add(idTokenListener);
        this.zzeq.execute(new zzi(this, idTokenListener));
    }

    @KeepForSdk
    public void addIdTokenListener(@NonNull com.google.firebase.auth.internal.IdTokenListener idTokenListener) {
        Preconditions.checkNotNull((Object)idTokenListener);
        this.zzeh.add(idTokenListener);
        this.zzn().zzf(this.zzeh.size());
    }

    public void removeIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzeg.remove(idTokenListener);
    }

    @KeepForSdk
    public void removeIdTokenListener(@NonNull com.google.firebase.auth.internal.IdTokenListener idTokenListener) {
        Preconditions.checkNotNull((Object)idTokenListener);
        this.zzeh.remove(idTokenListener);
        this.zzn().zzf(this.zzeh.size());
    }

    public void addAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzei.add(authStateListener);
        this.zzeq.execute(new zzj(this, authStateListener));
    }

    public void removeAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzei.remove(authStateListener);
    }

    private final void zzb(@Nullable FirebaseUser firebaseUser) {
        String string;
        if (firebaseUser != null) {
            string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(45 + String.valueOf(string).length()).append("Notifying id token listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying id token listeners about a sign-out event.");
        }
        string = firebaseUser != null ? firebaseUser.zzt() : null;
        InternalTokenResult internalTokenResult = new InternalTokenResult(string);
        this.zzeq.execute(new com.google.firebase.auth.zzk(this, internalTokenResult));
    }

    private final void zzc(@Nullable FirebaseUser firebaseUser) {
        if (firebaseUser != null) {
            String string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(47 + String.valueOf(string).length()).append("Notifying auth state listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying auth state listeners about a sign-out event.");
        }
        this.zzeq.execute(new com.google.firebase.auth.zzl(this));
    }

    @NonNull
    public Task<GetTokenResult> getAccessToken(boolean bl) {
        return this.zza(this.zzek, bl);
    }

    @NonNull
    public final Task<GetTokenResult> zza(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            return Tasks.forException((Exception)zzcf.zzb(new Status(17495)));
        }
        zzap zzap2 = firebaseUser.zzr();
        if (zzap2.isValid() && !bl) {
            return Tasks.forResult((Object)zzy.zzag(zzap2.zzaz()));
        }
        return this.zzej.zza(this.zzef, firebaseUser, zzap2.zzar(), (zzae)((Object)new zzm(this)));
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        if (authCredential instanceof EmailAuthCredential) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            if (!emailAuthCredential.zzl()) {
                return this.zzej.zzb(this.zzef, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), new zza());
            }
            return this.zzej.zza(this.zzef, emailAuthCredential, (com.google.firebase.auth.internal.zza)new zza());
        }
        if (authCredential instanceof PhoneAuthCredential) {
            PhoneAuthCredential phoneAuthCredential = (PhoneAuthCredential)authCredential;
            return this.zzej.zza(this.zzef, phoneAuthCredential, (com.google.firebase.auth.internal.zza)new zza());
        }
        return this.zzej.zza(this.zzef, authCredential, (com.google.firebase.auth.internal.zza)new zza());
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            if ("password".equals(((AuthCredential)emailAuthCredential).getSignInMethod())) {
                return this.zzej.zza(this.zzef, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzae)((Object)new zzb()));
            }
            return this.zzej.zza(this.zzef, firebaseUser, emailAuthCredential, (zzae)((Object)new zzb()));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzej.zzb(this.zzef, firebaseUser, (PhoneAuthCredential)authCredential, (zzae)((Object)new zzb()));
        }
        return this.zzej.zza(this.zzef, firebaseUser, authCredential, (zzae)((Object)new zzb()));
    }

    public final Task<AuthResult> zzb(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            if ("password".equals(((AuthCredential)emailAuthCredential).getSignInMethod())) {
                return this.zzej.zzb(this.zzef, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzae)((Object)new zzb()));
            }
            return this.zzej.zzb(this.zzef, firebaseUser, emailAuthCredential, (zzae)((Object)new zzb()));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzej.zzc(this.zzef, firebaseUser, authCredential, (zzae)((Object)new zzb()));
        }
        return this.zzej.zzb(this.zzef, firebaseUser, authCredential, (zzae)((Object)new zzb()));
    }

    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzej.zza(this.zzef, string, (com.google.firebase.auth.internal.zza)new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        return this.zzej.zzb(this.zzef, string, string2, new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithEmailLink(@NonNull String string, @NonNull String string2) {
        return this.signInWithCredential(EmailAuthProvider.getCredentialWithLink(string, string2));
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        if (this.zzek != null && this.zzek.isAnonymous()) {
            zzl zzl2 = (zzl)this.zzek;
            zzl2.zzd(false);
            return Tasks.forResult((Object)new zzf(zzl2));
        }
        return this.zzej.zza(this.zzef, new zza());
    }

    @NonNull
    public final void zza(@NonNull String string, long l, TimeUnit timeUnit, @NonNull PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks, @Nullable Activity activity, @NonNull Executor executor, boolean bl) {
        long l2 = TimeUnit.SECONDS.convert(l, timeUnit);
        if (l2 < 0L || l2 > 120L) {
            throw new IllegalArgumentException("We only support 0-120 seconds for sms-auto-retrieval timeout");
        }
        zzay zzay2 = new zzay(string, l2, bl, this.zzen);
        if (this.zzel.zzbi() && string.equals(this.zzel.getPhoneNumber())) {
            PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks2 = onVerificationStateChangedCallbacks;
            FirebaseAuth firebaseAuth = this;
            onVerificationStateChangedCallbacks = new zzn(firebaseAuth, onVerificationStateChangedCallbacks2);
        }
        this.zzej.zza(this.zzef, zzay2, onVerificationStateChangedCallbacks, activity, executor);
    }

    public Task<Void> updateCurrentUser(@NonNull FirebaseUser firebaseUser) {
        if (firebaseUser == null) {
            throw new IllegalArgumentException("Cannot update current user with null user!");
        }
        String string = firebaseUser.zzq().getOptions().getApiKey();
        String string2 = this.zzef.getOptions().getApiKey();
        if (firebaseUser.zzr().isValid() && string2.equals(string)) {
            FirebaseUser firebaseUser2 = zzl.zza(this.zzef, firebaseUser);
            this.zza(firebaseUser2, firebaseUser.zzr(), true);
            return Tasks.forResult(null);
        }
        return this.zza(firebaseUser, (zzae)((Object)new zzc(this)));
    }

    public final Task<Void> zzd(@NonNull FirebaseUser firebaseUser) {
        return this.zza(firebaseUser, (zzae)((Object)new zzb()));
    }

    @NonNull
    private final Task<Void> zza(@NonNull FirebaseUser firebaseUser, zzae zzae2) {
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zzej.zza(this.zzef, firebaseUser, zzae2);
    }

    @NonNull
    public final Task<AuthResult> zzc(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zzej.zzd(this.zzef, firebaseUser, authCredential, (zzae)((Object)new zzb()));
    }

    @NonNull
    public final Task<AuthResult> zza(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zzej.zzd(this.zzef, firebaseUser, string, (zzae)((Object)new zzb()));
    }

    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        return this.zzej.zza(this.zzef, string, string2, new zza());
    }

    @Deprecated
    @NonNull
    public Task<ProviderQueryResult> fetchProvidersForEmail(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzej.zza(this.zzef, string);
    }

    @NonNull
    public Task<SignInMethodQueryResult> fetchSignInMethodsForEmail(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzej.zzb(this.zzef, string);
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)((Object)userProfileChangeRequest));
        return this.zzej.zza(this.zzef, firebaseUser, userProfileChangeRequest, (zzae)((Object)new zzb()));
    }

    @NonNull
    public final Task<Void> zzb(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotEmpty((String)string);
        return this.zzej.zzb(this.zzef, firebaseUser, string, (zzae)((Object)new zzb()));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull PhoneAuthCredential phoneAuthCredential) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)phoneAuthCredential);
        return this.zzej.zza(this.zzef, firebaseUser, phoneAuthCredential, (zzae)((Object)new zzb()));
    }

    @NonNull
    public final Task<Void> zzc(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotEmpty((String)string);
        return this.zzej.zzc(this.zzef, firebaseUser, string, (zzae)((Object)new zzb()));
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.sendPasswordResetEmail(string, null);
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string, @Nullable ActionCodeSettings actionCodeSettings) {
        Preconditions.checkNotEmpty((String)string);
        if (actionCodeSettings == null) {
            actionCodeSettings = ActionCodeSettings.zzf();
        }
        if (this.zzen != null) {
            actionCodeSettings.zza(this.zzen);
        }
        actionCodeSettings.zzb(1);
        return this.zzej.zza(this.zzef, string, actionCodeSettings);
    }

    public Task<Void> sendSignInLinkToEmail(@NonNull String string, @NonNull ActionCodeSettings actionCodeSettings) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)actionCodeSettings));
        if (!actionCodeSettings.canHandleCodeInApp()) {
            throw new IllegalArgumentException("You must set canHandleCodeInApp in your ActionCodeSettings to true for Email-Link Sign-in.");
        }
        if (this.zzen != null) {
            actionCodeSettings.zza(this.zzen);
        }
        return this.zzej.zzb(this.zzef, string, actionCodeSettings);
    }

    public boolean isSignInWithEmailLink(@NonNull String string) {
        return EmailAuthCredential.isSignInWithEmailLink(string);
    }

    @NonNull
    public final Task<Void> zza(@Nullable ActionCodeSettings actionCodeSettings, @NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        if (this.zzen != null) {
            if (actionCodeSettings == null) {
                actionCodeSettings = ActionCodeSettings.zzf();
            }
            actionCodeSettings.zza(this.zzen);
        }
        return this.zzej.zza(this.zzef, actionCodeSettings, string);
    }

    @NonNull
    public Task<ActionCodeResult> checkActionCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzej.zzc(this.zzef, string);
    }

    @NonNull
    public Task<Void> applyActionCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzej.zzd(this.zzef, string);
    }

    @NonNull
    public Task<String> verifyPasswordResetCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzej.zze(this.zzef, string);
    }

    @NonNull
    public Task<Void> confirmPasswordReset(@NonNull String string, @NonNull String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        return this.zzej.zza(this.zzef, string, string2);
    }

    @NonNull
    public final Task<Void> zze(@NonNull FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zzej.zza(firebaseUser, new zzo(this, firebaseUser));
    }

    public void signOut() {
        this.zzm();
        if (this.zzep != null) {
            this.zzep.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLanguageCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        Object object = this.zzem;
        synchronized (object) {
            this.zzen = string;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getLanguageCode() {
        Object object = this.zzem;
        synchronized (object) {
            return this.zzen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useAppLanguage() {
        Object object = this.zzem;
        synchronized (object) {
            this.zzen = zzcx.zzan();
            return;
        }
    }

    public FirebaseAuthSettings getFirebaseAuthSettings() {
        return this.zzel;
    }

    public Task<Void> setFirebaseUIVersion(@Nullable String string) {
        return this.zzej.setFirebaseUIVersion(string);
    }

    static /* synthetic */ FirebaseApp zza(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzef;
    }

    static /* synthetic */ List zzb(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzeh;
    }

    static /* synthetic */ List zzc(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzeg;
    }

    static /* synthetic */ List zzd(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzei;
    }

    static /* synthetic */ zzk zze(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzel;
    }

    static /* synthetic */ FirebaseUser zzf(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzek;
    }

    final class zzc
    extends zza
    implements com.google.firebase.auth.internal.zza,
    zzw {
        zzc(FirebaseAuth firebaseAuth) {
        }

        @Override
        public final void zza(Status status) {
        }
    }

    @VisibleForTesting
    final class zzb
    extends zza
    implements com.google.firebase.auth.internal.zza,
    zzw {
        zzb() {
        }

        @Override
        public final void zza(Status status) {
            if (status.getStatusCode() == 17011 || status.getStatusCode() == 17021 || status.getStatusCode() == 17005) {
                FirebaseAuth.this.signOut();
            }
        }
    }

    @VisibleForTesting
    class zza
    implements com.google.firebase.auth.internal.zza {
        zza() {
        }

        @Override
        public final void zza(@NonNull zzap zzap2, @NonNull FirebaseUser firebaseUser) {
            Preconditions.checkNotNull((Object)zzap2);
            Preconditions.checkNotNull((Object)firebaseUser);
            firebaseUser.zza(zzap2);
            FirebaseAuth.this.zza(firebaseUser, zzap2, true);
        }
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }

    public static interface IdTokenListener {
        public void onIdTokenChanged(@NonNull FirebaseAuth var1);
    }
}

