/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.logging.Logger;
import com.google.android.gms.internal.firebase_auth.zzap;
import com.google.android.gms.internal.firebase_auth.zzw;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.internal.zzh;
import com.google.firebase.auth.internal.zzl;
import com.google.firebase.auth.internal.zzn;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzaa {
    private Context zzgv;
    private String zzlv;
    private SharedPreferences zzlw;
    private Logger zzeb;

    public zzaa(@NonNull Context context, @NonNull String string) {
        Preconditions.checkNotNull((Object)context);
        this.zzlv = Preconditions.checkNotEmpty((String)string);
        this.zzgv = context.getApplicationContext();
        String string2 = String.format("com.google.firebase.auth.api.Store.%s", this.zzlv);
        this.zzlw = this.zzgv.getSharedPreferences(string2, 0);
        this.zzeb = new Logger("StorageHelpers", new String[0]);
    }

    public final void zzg(@NonNull FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)firebaseUser);
        String string = this.zzi(firebaseUser);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            String string2 = string;
            String string3 = "com.google.firebase.auth.FIREBASE_USER";
            this.zzlw.edit().putString(string3, string2).apply();
        }
    }

    @Nullable
    public final FirebaseUser zzbo() {
        String string = "com.google.firebase.auth.FIREBASE_USER";
        String string2 = this.zzlw.getString(string, null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        try {
            String string3;
            JSONObject jSONObject = new JSONObject(string2);
            if (jSONObject.has("type") && "com.google.firebase.auth.internal.DefaultFirebaseUser".equalsIgnoreCase(string3 = jSONObject.optString("type"))) {
                return this.zzc(jSONObject);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public final void zza(@NonNull FirebaseUser firebaseUser, @NonNull zzap zzap2) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)zzap2);
        this.zzlw.edit().putString(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()), zzap2.toJson()).apply();
    }

    public final zzap zzh(@NonNull FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)firebaseUser);
        String string = this.zzlw.getString(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()), null);
        if (string != null) {
            return zzap.zzs(string);
        }
        return null;
    }

    public final void clear(String string) {
        this.zzlw.edit().remove(string).apply();
    }

    @Nullable
    private final String zzi(@NonNull FirebaseUser firebaseUser) {
        JSONObject jSONObject = new JSONObject();
        if (zzl.class.isAssignableFrom(firebaseUser.getClass())) {
            zzl zzl2 = (zzl)firebaseUser;
            try {
                jSONObject.put("cachedTokenState", (Object)((FirebaseUser)zzl2).zzs());
                jSONObject.put("applicationName", (Object)((FirebaseUser)zzl2).zzq().getName());
                jSONObject.put("type", (Object)"com.google.firebase.auth.internal.DefaultFirebaseUser");
                if (zzl2.zzbj() != null) {
                    JSONArray jSONArray = new JSONArray();
                    List<zzh> list = zzl2.zzbj();
                    for (int i = 0; i < list.size(); ++i) {
                        zzh zzh2 = list.get(i);
                        jSONArray.put((Object)zzh2.toJson());
                    }
                    jSONObject.put("userInfos", (Object)jSONArray);
                }
                jSONObject.put("anonymous", ((FirebaseUser)zzl2).isAnonymous());
                jSONObject.put("version", (Object)"2");
                if (((FirebaseUser)zzl2).getMetadata() != null) {
                    jSONObject.put("userMetadata", (Object)((zzn)((FirebaseUser)zzl2).getMetadata()).zzbk());
                }
                return jSONObject.toString();
            }
            catch (Exception exception) {
                this.zzeb.wtf("Failed to turn object into JSON", (Throwable)exception, new Object[0]);
                throw new zzw(exception);
            }
        }
        return null;
    }

    private final zzl zzc(@NonNull JSONObject jSONObject) {
        try {
            zzn zzn2;
            String string = jSONObject.getString("cachedTokenState");
            String string2 = jSONObject.getString("applicationName");
            boolean bl = jSONObject.getBoolean("anonymous");
            String string3 = "2";
            String string4 = jSONObject.getString("version");
            if (string4 != null) {
                string3 = string4;
            }
            JSONArray jSONArray = jSONObject.getJSONArray("userInfos");
            int n = jSONArray.length();
            ArrayList<zzh> arrayList = new ArrayList<zzh>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(zzh.zzad(jSONArray.getString(i)));
            }
            FirebaseApp firebaseApp = FirebaseApp.getInstance((String)string2);
            zzl zzl2 = new zzl(firebaseApp, arrayList);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                zzap zzap2 = zzap.zzs(string);
                ((FirebaseUser)zzl2).zza(zzap2);
            }
            if (!bl) {
                ((FirebaseUser)zzl2).zzp();
            }
            zzl2.zzae(string3);
            if (jSONObject.has("userMetadata") && (zzn2 = zzn.zza(jSONObject.getJSONObject("userMetadata"))) != null) {
                zzl2.zza(zzn2);
            }
            return zzl2;
        }
        catch (zzw | ArrayIndexOutOfBoundsException | IllegalArgumentException | JSONException throwable) {
            this.zzeb.wtf(throwable);
            return null;
        }
    }
}

