/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.internal.firebase_auth.zzaz;
import com.google.android.gms.internal.firebase_auth.zzfr;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.api.internal.zzdw;
import com.google.firebase.auth.zzg;

public final class zzas {
    @VisibleForTesting
    private static long zza = 3600000L;
    private static final zzaz<String> zzb = zzaz.zza("firebaseAppName", "firebaseUserUid", "operation", "tenantId", "verifyAssertionRequest", "statusCode", "statusMessage", "timestamp");
    private static final zzas zzc = new zzas();
    private Task<AuthResult> zzd;
    private long zze = 0L;

    private zzas() {
    }

    public static zzas zza() {
        return zzc;
    }

    public static void zza(Context context, FirebaseAuth firebaseAuth) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)firebaseAuth);
        SharedPreferences.Editor editor = context.getSharedPreferences("com.google.firebase.auth.internal.ProcessDeathHelper", 0).edit();
        editor.putString("firebaseAppName", firebaseAuth.zzb().getName());
        editor.commit();
    }

    public static void zza(Context context, FirebaseAuth firebaseAuth, FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)firebaseAuth);
        Preconditions.checkNotNull((Object)firebaseUser);
        SharedPreferences.Editor editor = context.getSharedPreferences("com.google.firebase.auth.internal.ProcessDeathHelper", 0).edit();
        editor.putString("firebaseAppName", firebaseAuth.zzb().getName());
        editor.putString("firebaseUserUid", firebaseUser.getUid());
        editor.commit();
    }

    public static void zza(Context context, zzfr zzfr2, String string, @Nullable String string2) {
        SharedPreferences.Editor editor = context.getSharedPreferences("com.google.firebase.auth.internal.ProcessDeathHelper", 0).edit();
        editor.putString("verifyAssertionRequest", SafeParcelableSerializer.serializeToString((SafeParcelable)zzfr2));
        editor.putString("operation", string);
        editor.putString("tenantId", string2);
        editor.putLong("timestamp", DefaultClock.getInstance().currentTimeMillis());
        editor.commit();
    }

    public static void zza(Context context, Status status) {
        SharedPreferences.Editor editor = context.getSharedPreferences("com.google.firebase.auth.internal.ProcessDeathHelper", 0).edit();
        editor.putInt("statusCode", status.getStatusCode());
        editor.putString("statusMessage", status.getStatusMessage());
        editor.putLong("timestamp", DefaultClock.getInstance().currentTimeMillis());
        editor.commit();
    }

    public final void zza(FirebaseAuth firebaseAuth) {
        Preconditions.checkNotNull((Object)firebaseAuth);
        SharedPreferences sharedPreferences = firebaseAuth.zzb().getApplicationContext().getSharedPreferences("com.google.firebase.auth.internal.ProcessDeathHelper", 0);
        String string = sharedPreferences.getString("firebaseAppName", "");
        if (!firebaseAuth.zzb().getName().equals(string)) {
            return;
        }
        if (sharedPreferences.contains("verifyAssertionRequest")) {
            zzfr zzfr2 = (zzfr)SafeParcelableSerializer.deserializeFromString((String)sharedPreferences.getString("verifyAssertionRequest", ""), zzfr.CREATOR);
            String string2 = sharedPreferences.getString("operation", "");
            String string3 = sharedPreferences.getString("tenantId", null);
            String string4 = sharedPreferences.getString("firebaseUserUid", "");
            this.zze = sharedPreferences.getLong("timestamp", 0L);
            if (string3 != null) {
                firebaseAuth.zza(string3);
                zzfr2.zzb(string3);
            }
            switch (string2) {
                case "com.google.firebase.auth.internal.SIGN_IN": {
                    this.zzd = firebaseAuth.signInWithCredential(zzg.zza(zzfr2));
                    break;
                }
                case "com.google.firebase.auth.internal.LINK": {
                    if (firebaseAuth.getCurrentUser().getUid().equals(string4)) {
                        this.zzd = firebaseAuth.getCurrentUser().linkWithCredential(zzg.zza(zzfr2));
                        break;
                    }
                    this.zzd = null;
                    break;
                }
                case "com.google.firebase.auth.internal.REAUTHENTICATE": {
                    if (firebaseAuth.getCurrentUser().getUid().equals(string4)) {
                        this.zzd = firebaseAuth.getCurrentUser().reauthenticateAndRetrieveData(zzg.zza(zzfr2));
                        break;
                    }
                    this.zzd = null;
                    break;
                }
                default: {
                    this.zzd = null;
                }
            }
            zzas.zza(sharedPreferences);
            return;
        }
        if (sharedPreferences.contains("statusCode")) {
            int n = sharedPreferences.getInt("statusCode", 17062);
            String string5 = sharedPreferences.getString("statusMessage", "");
            Status status = new Status(n, string5);
            this.zze = sharedPreferences.getLong("timestamp", 0L);
            zzas.zza(sharedPreferences);
            this.zzd = Tasks.forException((Exception)zzdw.zza(status));
            return;
        }
    }

    public final Task<AuthResult> zzb() {
        if (DefaultClock.getInstance().currentTimeMillis() - this.zze < zza) {
            return this.zzd;
        }
        return null;
    }

    public final void zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        zzas.zza(context.getSharedPreferences("com.google.firebase.auth.internal.ProcessDeathHelper", 0));
        this.zzd = null;
        this.zze = 0L;
    }

    private static void zza(SharedPreferences sharedPreferences) {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        zzaz<String> zzaz2 = zzb;
        int n = zzaz2.size();
        for (int i = 0; i < n; ++i) {
            Object e = zzaz2.get(i);
            String string = (String)e;
            editor.remove(string);
        }
        editor.commit();
    }
}

