/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.TaskExecutors;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.MultiFactorSession;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.PhoneMultiFactorInfo;
import com.google.firebase.auth.internal.zzy;
import com.google.firebase.auth.zzx;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public final class PhoneAuthOptions {
    private final FirebaseAuth zza;
    private Long zzb;
    private PhoneAuthProvider.OnVerificationStateChangedCallbacks zzc;
    private Executor zzd;
    @Nullable
    private String zze;
    @Nullable
    private Activity zzf;
    @Nullable
    private PhoneAuthProvider.ForceResendingToken zzg;
    @Nullable
    private MultiFactorSession zzh;
    @Nullable
    private PhoneMultiFactorInfo zzi;
    @Nullable
    private String zzj;
    private boolean zzk;

    private PhoneAuthOptions(FirebaseAuth firebaseAuth, Long l, PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks, Executor executor, @Nullable String string, @Nullable Activity activity, @Nullable PhoneAuthProvider.ForceResendingToken forceResendingToken, @Nullable MultiFactorSession multiFactorSession, @Nullable PhoneMultiFactorInfo phoneMultiFactorInfo, @Nullable String string2, boolean bl) {
        this.zza = firebaseAuth;
        this.zze = string;
        this.zzb = l;
        this.zzc = onVerificationStateChangedCallbacks;
        this.zzf = activity;
        this.zzd = executor;
        this.zzg = forceResendingToken;
        this.zzh = multiFactorSession;
        this.zzi = phoneMultiFactorInfo;
        this.zzj = string2;
        this.zzk = bl;
    }

    @NonNull
    public final FirebaseAuth zza() {
        return this.zza;
    }

    public final String zzb() {
        return this.zze;
    }

    public final Long zzc() {
        return this.zzb;
    }

    public final PhoneAuthProvider.OnVerificationStateChangedCallbacks zzd() {
        return this.zzc;
    }

    public final Executor zze() {
        return this.zzd;
    }

    @Nullable
    public final PhoneAuthProvider.ForceResendingToken zzf() {
        return this.zzg;
    }

    @Nullable
    public final MultiFactorSession zzg() {
        return this.zzh;
    }

    @Nullable
    public final String zzh() {
        return this.zzj;
    }

    public final boolean zzi() {
        return this.zzk;
    }

    @Nullable
    public final Activity zzj() {
        return this.zzf;
    }

    @Nullable
    public final PhoneMultiFactorInfo zzk() {
        return this.zzi;
    }

    public final boolean zzl() {
        return this.zzh != null;
    }

    @NonNull
    public static Builder newBuilder() {
        return new Builder(FirebaseAuth.getInstance());
    }

    @NonNull
    public static Builder newBuilder(@NonNull FirebaseAuth firebaseAuth) {
        return new Builder(firebaseAuth);
    }

    /* synthetic */ PhoneAuthOptions(FirebaseAuth firebaseAuth, Long l, PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks, Executor executor, String string, Activity activity, PhoneAuthProvider.ForceResendingToken forceResendingToken, MultiFactorSession multiFactorSession, PhoneMultiFactorInfo phoneMultiFactorInfo, String string2, boolean bl, zzx zzx2) {
        this(firebaseAuth, l, onVerificationStateChangedCallbacks, executor, string, activity, forceResendingToken, multiFactorSession, phoneMultiFactorInfo, null, bl);
    }

    public static final class Builder {
        private final FirebaseAuth zza;
        private String zzb;
        private Long zzc;
        private PhoneAuthProvider.OnVerificationStateChangedCallbacks zzd;
        private Executor zze;
        private Activity zzf;
        private PhoneAuthProvider.ForceResendingToken zzg;
        private MultiFactorSession zzh;
        private PhoneMultiFactorInfo zzi;
        private boolean zzj;

        public Builder(@NonNull FirebaseAuth firebaseAuth) {
            this.zza = (FirebaseAuth)Preconditions.checkNotNull((Object)firebaseAuth);
        }

        @NonNull
        public final Builder setPhoneNumber(@NonNull String string) {
            this.zzb = string;
            return this;
        }

        @NonNull
        public final Builder setMultiFactorHint(@NonNull PhoneMultiFactorInfo phoneMultiFactorInfo) {
            this.zzi = phoneMultiFactorInfo;
            return this;
        }

        @NonNull
        public final Builder setTimeout(@NonNull Long l, @NonNull TimeUnit timeUnit) {
            this.zzc = TimeUnit.SECONDS.convert(l, timeUnit);
            return this;
        }

        @NonNull
        public final Builder setCallbacks(@NonNull PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks) {
            this.zzd = onVerificationStateChangedCallbacks;
            return this;
        }

        @NonNull
        public final Builder setActivity(@NonNull Activity activity) {
            this.zzf = activity;
            return this;
        }

        @NonNull
        public final Builder setExecutor(@NonNull Executor executor) {
            this.zze = executor;
            return this;
        }

        @NonNull
        public final Builder setForceResendingToken(@NonNull PhoneAuthProvider.ForceResendingToken forceResendingToken) {
            this.zzg = forceResendingToken;
            return this;
        }

        @NonNull
        public final Builder setMultiFactorSession(@NonNull MultiFactorSession multiFactorSession) {
            this.zzh = multiFactorSession;
            return this;
        }

        @NonNull
        public final Builder requireSmsValidation(boolean bl) {
            this.zzj = bl;
            return this;
        }

        @NonNull
        public final PhoneAuthOptions build() {
            Preconditions.checkNotNull((Object)this.zza);
            Preconditions.checkNotNull((Object)this.zzc);
            Preconditions.checkNotNull((Object)this.zzd);
            if (this.zze == null) {
                this.zze = TaskExecutors.MAIN_THREAD;
            }
            if (this.zze != TaskExecutors.MAIN_THREAD && this.zzf != null) {
                throw new IllegalArgumentException("You cannot specify both an executor and an activity.");
            }
            if (this.zzc < 0L || this.zzc > 120L) {
                throw new IllegalArgumentException("We only support 0-120 seconds for sms-auto-retrieval timeout");
            }
            if (this.zzh == null) {
                Preconditions.checkNotEmpty((String)this.zzb);
                Preconditions.checkArgument((!this.zzj ? 1 : 0) != 0, (Object)"You cannot require sms validation without setting a multi-factor session.");
                Preconditions.checkArgument((this.zzi == null ? 1 : 0) != 0, (Object)"A phoneMultiFactorInfo must be set for second factor sign-in.");
            } else {
                Builder builder = this;
                if (builder.zzh != null && ((zzy)builder.zzh).zzc()) {
                    Preconditions.checkNotEmpty((String)this.zzb);
                    Preconditions.checkArgument((this.zzi == null ? 1 : 0) != 0, (Object)"Invalid MultiFactorSession - use the getSession method in MultiFactorResolver to get a valid sign-in session.");
                } else {
                    Preconditions.checkArgument((this.zzi != null ? 1 : 0) != 0, (Object)"A phoneMultiFactorInfo must be set for second factor sign-in.");
                    Preconditions.checkArgument((this.zzb == null ? 1 : 0) != 0, (Object)"A phone number must not be set for MFA sign-in. A PhoneMultiFactorInfo should be set instead.");
                }
            }
            return new PhoneAuthOptions(this.zza, this.zzc, this.zzd, this.zze, this.zzb, this.zzf, this.zzg, this.zzh, this.zzi, null, this.zzj, null);
        }
    }
}

