/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.api.internal.zzeh;
import com.google.firebase.auth.internal.zzaa;
import com.google.firebase.auth.internal.zzaf;
import com.google.firebase.auth.internal.zzbc;
import java.lang.ref.WeakReference;

final class zzan
extends BroadcastReceiver {
    private final WeakReference<Activity> zza;
    private final TaskCompletionSource<AuthResult> zzb;
    private final FirebaseAuth zzc;
    private final FirebaseUser zzd;
    private final /* synthetic */ zzaf zze;

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    zzan(zzaf zzaf2, Activity activity, TaskCompletionSource taskCompletionSource, FirebaseAuth firebaseAuth, FirebaseUser firebaseUser) {
        this.zze = zzaf2;
        this.zza = new WeakReference<Activity>(activity);
        this.zzb = taskCompletionSource;
        this.zzc = firebaseAuth;
        this.zzd = firebaseUser;
    }

    public final void onReceive(Context context, Intent intent) {
        Activity activity = (Activity)this.zza.get();
        if (activity == null) {
            Log.e((String)"FederatedAuthReceiver", (String)"Failed to unregister BroadcastReceiver because the Activity that launched this flow has been garbage collected; please do not finish() your Activity while performing a FederatedAuthProvider operation.");
            this.zzb.setException((Exception)zzeh.zza(new Status(17499, "Activity that started the web operation is no longer alive; see logcat for details")));
            zzaf.zzb();
            return;
        }
        LocalBroadcastManager.getInstance((Context)activity).unregisterReceiver((BroadcastReceiver)this);
        if (intent.hasExtra("com.google.firebase.auth.internal.OPERATION")) {
            String string = intent.getStringExtra("com.google.firebase.auth.internal.OPERATION");
            if ("com.google.firebase.auth.internal.SIGN_IN".equals(string)) {
                zzaf.zza(this.zze, intent, this.zzb, this.zzc);
                return;
            }
            if ("com.google.firebase.auth.internal.LINK".equals(string)) {
                zzaf.zza(this.zze, intent, this.zzb, this.zzd);
                return;
            }
            if ("com.google.firebase.auth.internal.REAUTHENTICATE".equals(string)) {
                zzaf.zzb(this.zze, intent, this.zzb, this.zzd);
                return;
            }
            this.zzb.setException((Exception)zzeh.zza(zzaa.zza(new StringBuilder(50 + String.valueOf(string).length()).append("WEB_CONTEXT_CANCELED:Unknown operation received (").append(string).append(")").toString())));
            return;
        }
        if (zzbc.zza(intent)) {
            Status status = zzbc.zzb(intent);
            this.zzb.setException((Exception)zzeh.zza(status));
            zzaf.zzb();
            return;
        }
        if (intent.hasExtra("com.google.firebase.auth.internal.EXTRA_CANCELED")) {
            this.zzb.setException((Exception)zzeh.zza(zzaa.zza("WEB_CONTEXT_CANCELED")));
            zzaf.zzb();
        }
    }
}

