/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzei;
import com.google.android.gms.internal.firebase-auth-api.zzla;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;

public final class zzlb
implements zzei {
    private final ThreadLocal<Mac> zza;
    private final String zzb;
    private final Key zzc;
    private final int zzd;

    /*
     * Enabled aggressive block sorting
     */
    public zzlb(String string, Key key) throws GeneralSecurityException {
        block17: {
            Object object;
            block16: {
                int n;
                block15: {
                    zzla zzla2;
                    ((zzlb)object).zza = zzla2 = new zzla((zzlb)object);
                    ((zzlb)object).zzb = string;
                    ((zzlb)object).zzc = key;
                    if (key.getEncoded().length < 16) {
                        object = new InvalidAlgorithmParameterException("key size too small, need at least 16 bytes");
                        throw object;
                    }
                    switch (string.hashCode()) {
                        case 392317873: {
                            if (!string.equals("HMACSHA512")) break;
                            n = 4;
                            break block15;
                        }
                        case 392316170: {
                            if (!string.equals("HMACSHA384")) break;
                            n = 3;
                            break block15;
                        }
                        case 392315118: {
                            if (!string.equals("HMACSHA256")) break;
                            n = 2;
                            break block15;
                        }
                        case 392315023: {
                            if (!string.equals("HMACSHA224")) break;
                            n = 1;
                            break block15;
                        }
                        case -1823053428: {
                            if (!string.equals("HMACSHA1")) break;
                            n = 0;
                            break block15;
                        }
                    }
                    n = -1;
                }
                switch (n) {
                    default: {
                        object = "unknown Hmac algorithm: ";
                        if (string.length() == 0) break block16;
                        object = ((String)object).concat(string);
                        break block17;
                    }
                    case 4: {
                        ((zzlb)object).zzd = 64;
                        break;
                    }
                    case 3: {
                        ((zzlb)object).zzd = 48;
                        break;
                    }
                    case 2: {
                        ((zzlb)object).zzd = 32;
                        break;
                    }
                    case 1: {
                        ((zzlb)object).zzd = 28;
                        break;
                    }
                    case 0: {
                        ((zzlb)object).zzd = 20;
                        break;
                    }
                }
                ((zzlb)object).zza.get();
                return;
            }
            string = new String((String)object);
            object = string;
        }
        NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException((String)object);
        throw noSuchAlgorithmException;
    }

    @Override
    public final byte[] zza(byte[] byArray, int n) throws GeneralSecurityException {
        if (n > ((zzlb)object).zzd) {
            Object object = new InvalidAlgorithmParameterException("tag size too big");
            throw object;
        }
        ((zzlb)object).zza.get().update(byArray);
        return Arrays.copyOf(((zzlb)object).zza.get().doFinal(), n);
    }

    static /* synthetic */ String zzb(zzlb zzlb2) {
        return zzlb2.zzb;
    }

    static /* synthetic */ Key zzc(zzlb zzlb2) {
        return zzlb2.zzc;
    }
}

