/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.internal.firebase-auth-api.zzwv;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FederatedAuthProvider;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUserMetadata;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.MultiFactor;
import com.google.firebase.auth.MultiFactorInfo;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.UserInfo;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.zzt;
import com.google.firebase.auth.zzw;
import com.google.firebase.auth.zzx;
import com.google.firebase.auth.zzy;
import java.util.List;

public abstract class FirebaseUser
extends AbstractSafeParcelable
implements UserInfo {
    @Override
    @NonNull
    public abstract String getUid();

    @Override
    @NonNull
    public abstract String getProviderId();

    public abstract boolean isAnonymous();

    @NonNull
    public abstract List<? extends UserInfo> getProviderData();

    @Override
    @RecentlyNullable
    public abstract String getDisplayName();

    @Override
    @RecentlyNullable
    public abstract Uri getPhotoUrl();

    @Override
    @RecentlyNullable
    public abstract String getEmail();

    @Override
    @RecentlyNullable
    public abstract String getPhoneNumber();

    @RecentlyNullable
    public abstract String getTenantId();

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<GetTokenResult> getIdToken(boolean forceRefresh) {
        void var1_1;
        return FirebaseAuth.getInstance(this.zzd()).zzh(this, (boolean)var1_1);
    }

    @NonNull
    public Task<Void> reload() {
        FirebaseAuth firebaseAuth = FirebaseAuth.getInstance(this.zzd());
        zzt zzt2 = new zzt(firebaseAuth);
        return firebaseAuth.zzm(this, zzt2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> reauthenticate(@RecentlyNonNull AuthCredential credential) {
        void var1_1;
        Preconditions.checkNotNull((Object)((Object)credential));
        return FirebaseAuth.getInstance(this.zzd()).zzi(this, (AuthCredential)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<AuthResult> reauthenticateAndRetrieveData(@RecentlyNonNull AuthCredential credential) {
        void var1_1;
        Preconditions.checkNotNull((Object)((Object)credential));
        return FirebaseAuth.getInstance(this.zzd()).zzj(this, (AuthCredential)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<AuthResult> startActivityForReauthenticateWithProvider(@RecentlyNonNull Activity activity, @RecentlyNonNull FederatedAuthProvider federatedAuthProvider) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull((Object)activity);
        Preconditions.checkNotNull((Object)var2_2);
        return FirebaseAuth.getInstance(this.zzd()).zzx((Activity)var1_1, (FederatedAuthProvider)var2_2, this);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<AuthResult> linkWithCredential(@RecentlyNonNull AuthCredential credential) {
        void var1_1;
        Preconditions.checkNotNull((Object)((Object)credential));
        return FirebaseAuth.getInstance(this.zzd()).zzn(this, (AuthCredential)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<AuthResult> startActivityForLinkWithProvider(@RecentlyNonNull Activity activity, @RecentlyNonNull FederatedAuthProvider federatedAuthProvider) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull((Object)activity);
        Preconditions.checkNotNull((Object)var2_2);
        return FirebaseAuth.getInstance(this.zzd()).zzw((Activity)var1_1, (FederatedAuthProvider)var2_2, this);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<AuthResult> unlink(@RecentlyNonNull String provider) {
        void var1_1;
        Preconditions.checkNotEmpty((String)provider);
        return FirebaseAuth.getInstance(this.zzd()).zzo(this, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> updateProfile(@RecentlyNonNull UserProfileChangeRequest request) {
        void var1_1;
        Preconditions.checkNotNull((Object)((Object)request));
        return FirebaseAuth.getInstance(this.zzd()).zzp(this, (UserProfileChangeRequest)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> updateEmail(@RecentlyNonNull String email) {
        void var1_1;
        Preconditions.checkNotEmpty((String)email);
        return FirebaseAuth.getInstance(this.zzd()).zzq(this, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> updatePhoneNumber(@RecentlyNonNull PhoneAuthCredential credential) {
        void var1_1;
        return FirebaseAuth.getInstance(this.zzd()).zzr(this, (PhoneAuthCredential)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> updatePassword(@RecentlyNonNull String password) {
        void var1_1;
        Preconditions.checkNotEmpty((String)password);
        return FirebaseAuth.getInstance(this.zzd()).zzs(this, (String)var1_1);
    }

    @NonNull
    public Task<Void> delete() {
        return FirebaseAuth.getInstance(this.zzd()).zzy(this);
    }

    @NonNull
    public Task<Void> sendEmailVerification() {
        Object object = this.zzd();
        object = FirebaseAuth.getInstance((FirebaseApp)object);
        object = ((FirebaseAuth)object).zzh(this, false);
        zzw zzw2 = new zzw(this);
        return object.continueWithTask((Continuation)zzw2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> sendEmailVerification(@RecentlyNonNull ActionCodeSettings actionCodeSettings) {
        void var1_1;
        Object object = this.zzd();
        object = FirebaseAuth.getInstance((FirebaseApp)object);
        object = ((FirebaseAuth)object).zzh(this, false);
        zzx zzx2 = new zzx(this, (ActionCodeSettings)var1_1);
        return object.continueWithTask((Continuation)zzx2);
    }

    @RecentlyNullable
    public abstract FirebaseUserMetadata getMetadata();

    @NonNull
    public abstract MultiFactor getMultiFactor();

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> verifyBeforeUpdateEmail(@RecentlyNonNull String newEmail) {
        void var1_1;
        return this.verifyBeforeUpdateEmail((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Task<Void> verifyBeforeUpdateEmail(@RecentlyNonNull String newEmail, @Nullable ActionCodeSettings actionCodeSettings) {
        void var2_2;
        void var1_1;
        Object object = this.zzd();
        object = FirebaseAuth.getInstance((FirebaseApp)object);
        object = ((FirebaseAuth)object).zzh(this, false);
        zzy zzy2 = new zzy(this, (String)var1_1, (ActionCodeSettings)var2_2);
        return object.continueWithTask((Continuation)zzy2);
    }

    @RecentlyNullable
    public abstract List<String> zza();

    @NonNull
    public abstract FirebaseUser zzb(@RecentlyNonNull List<? extends UserInfo> var1);

    @RecentlyNonNull
    public abstract FirebaseUser zzc();

    @NonNull
    public abstract FirebaseApp zzd();

    @NonNull
    public abstract zzwv zze();

    public abstract void zzf(@NonNull zzwv var1);

    @RecentlyNonNull
    public abstract String zzg();

    @RecentlyNonNull
    public abstract String zzh();

    public abstract void zzi(@RecentlyNonNull List<MultiFactorInfo> var1);
}

